/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.AxisAngle32;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.matrix.LinearTransform3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.Vector2D32;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.Vector4D32;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public class EuclidCoreRandomTools {
    private EuclidCoreRandomTools() {
    }

    public static <T> T nextElementIn(Random random, T[] array) {
        return array[random.nextInt(array.length)];
    }

    public static Axis2D nextAxis2D(Random random) {
        return EuclidCoreRandomTools.nextElementIn(random, Axis2D.values);
    }

    public static Axis3D nextAxis3D(Random random) {
        return EuclidCoreRandomTools.nextElementIn(random, Axis3D.values);
    }

    public static YawPitchRoll nextYawPitchRoll(Random random) {
        return EuclidCoreRandomTools.nextYawPitchRoll(random, Math.PI, YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE, Math.PI);
    }

    public static YawPitchRoll nextYawPitchRoll(Random random, double minMaxYaw, double minMaxPitch, double minMaxRoll) {
        double yaw = EuclidCoreRandomTools.nextDouble(random, minMaxYaw);
        double pitch = EuclidCoreRandomTools.nextDouble(random, minMaxPitch);
        double roll = EuclidCoreRandomTools.nextDouble(random, minMaxRoll);
        return new YawPitchRoll(yaw, pitch, roll);
    }

    public static YawPitchRoll nextYawPitchRollUniform(Random random, double minMaxAngle) {
        return new YawPitchRoll(EuclidCoreRandomTools.nextAxisAngle(random, minMaxAngle));
    }

    public static Vector3D nextRotationVector(Random random) {
        return EuclidCoreRandomTools.nextRotationVector(random, Math.PI);
    }

    public static Vector3D nextRotationVector(Random random, double minMaxAngle) {
        Vector3D rotationVector = new Vector3D();
        AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle(random, minMaxAngle);
        axisAngle.getRotationVector(rotationVector);
        return rotationVector;
    }

    public static AxisAngle nextAxisAngle(Random random) {
        AxisAngle axisAngle = new AxisAngle();
        EuclidCoreRandomTools.randomizeAxisAngle(random, axisAngle);
        return axisAngle;
    }

    public static AxisAngle nextAxisAngle(Random random, double minMaxAngle) {
        AxisAngle axisAngle = new AxisAngle();
        EuclidCoreRandomTools.randomizeAxisAngle(random, minMaxAngle, axisAngle);
        return axisAngle;
    }

    public static AxisAngle32 nextAxisAngle32(Random random) {
        AxisAngle32 axisAngle = new AxisAngle32();
        EuclidCoreRandomTools.randomizeAxisAngle(random, axisAngle);
        return axisAngle;
    }

    public static AxisAngle32 nextAxisAngle32(Random random, double minMaxAngle) {
        AxisAngle32 axisAngle = new AxisAngle32();
        EuclidCoreRandomTools.randomizeAxisAngle(random, minMaxAngle, axisAngle);
        return axisAngle;
    }

    public static CommonMatrix3DBasics nextCommonMatrix3DBasics(Random random) {
        switch (random.nextInt(3)) {
            case 0: {
                switch (random.nextInt(3)) {
                    case 0: {
                        return EuclidCoreRandomTools.nextDiagonalMatrix3D(random);
                    }
                    case 1: {
                        return EuclidCoreRandomTools.nextSymmetricMatrix3D(random);
                    }
                }
                return EuclidCoreRandomTools.nextMatrix3D(random);
            }
            case 1: {
                return EuclidCoreRandomTools.nextRotationMatrix(random);
            }
        }
        return EuclidCoreRandomTools.nextNonSingularLinearTransform3D(random);
    }

    public static Matrix3D nextDiagonalMatrix3D(Random random) {
        return EuclidCoreRandomTools.nextDiagonalMatrix3D(random, 1.0);
    }

    public static Matrix3D nextDiagonalMatrix3D(Random random, double minMaxValue) {
        return EuclidCoreRandomTools.nextDiagonalMatrix3D(random, -minMaxValue, minMaxValue);
    }

    public static Matrix3D nextDiagonalMatrix3D(Random random, double minValue, double maxValue) {
        Matrix3D matrix3D = new Matrix3D();
        for (int i = 0; i < 3; ++i) {
            matrix3D.setElement(i, i, EuclidCoreRandomTools.nextDouble(random, minValue, maxValue));
        }
        return matrix3D;
    }

    public static Matrix3D nextSymmetricMatrix3D(Random random) {
        return EuclidCoreRandomTools.nextSymmetricMatrix3D(random, 1.0);
    }

    public static Matrix3D nextSymmetricMatrix3D(Random random, double minMaxValue) {
        return EuclidCoreRandomTools.nextSymmetricMatrix3D(random, -minMaxValue, minMaxValue);
    }

    public static Matrix3D nextSymmetricMatrix3D(Random random, double minValue, double maxValue) {
        Matrix3D matrix3D = new Matrix3D();
        for (int row = 0; row < 3; ++row) {
            double value = EuclidCoreRandomTools.nextDouble(random, minValue, maxValue);
            matrix3D.setElement(row, row, value);
            for (int col = row + 1; col < 3; ++col) {
                value = EuclidCoreRandomTools.nextDouble(random, minValue, maxValue);
                matrix3D.setElement(row, col, value);
                matrix3D.setElement(col, row, value);
            }
        }
        return matrix3D;
    }

    public static double nextDouble(Random random) {
        return EuclidCoreRandomTools.nextDouble(random, 1.0);
    }

    public static double nextDouble(Random random, double minMaxValue) {
        return EuclidCoreRandomTools.nextDouble(random, -minMaxValue, minMaxValue);
    }

    public static double nextDouble(Random random, double minValue, double maxValue) {
        if (minValue > maxValue) {
            throw new RuntimeException("Min is greater than max: min = " + minValue + ", max = " + maxValue);
        }
        return minValue + random.nextDouble() * (maxValue - minValue);
    }

    public static Matrix3D nextMatrix3D(Random random) {
        return EuclidCoreRandomTools.nextMatrix3D(random, 1.0);
    }

    public static Matrix3D nextMatrix3D(Random random, double minMaxValue) {
        return EuclidCoreRandomTools.nextMatrix3D(random, -minMaxValue, minMaxValue);
    }

    public static Matrix3D nextMatrix3D(Random random, double minValue, double maxValue) {
        Matrix3D matrix3D = new Matrix3D();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                matrix3D.setElement(row, column, EuclidCoreRandomTools.nextDouble(random, minValue, maxValue));
            }
        }
        return matrix3D;
    }

    public static LinearTransform3D nextLinearTransform3D(Random random) {
        return EuclidCoreRandomTools.nextLinearTransform3D(random, 1.0);
    }

    public static LinearTransform3D nextLinearTransform3D(Random random, double minMaxValue) {
        return EuclidCoreRandomTools.nextLinearTransform3D(random, -minMaxValue, minMaxValue);
    }

    public static LinearTransform3D nextLinearTransform3D(Random random, double minValue, double maxValue) {
        return new LinearTransform3D(EuclidCoreRandomTools.nextMatrix3D(random, minValue, maxValue));
    }

    public static LinearTransform3D nextNonSingularLinearTransform3D(Random random) {
        return EuclidCoreRandomTools.nextNonSingularLinearTransform3D(random, 0.25, 10.0);
    }

    public static LinearTransform3D nextNonSingularLinearTransform3D(Random random, double minAbsScale, double maxAbsScale) {
        LinearTransform3D next = new LinearTransform3D();
        next.appendRotation(EuclidCoreRandomTools.nextQuaternion(random));
        Vector3D scale = EuclidCoreRandomTools.nextVector3D(random, maxAbsScale);
        for (int i = 0; i < 3; ++i) {
            if (scale.getElement(i) >= 0.0) {
                scale.setElement(i, Math.max(minAbsScale, scale.getElement(i)));
                continue;
            }
            scale.setElement(i, Math.min(-minAbsScale, scale.getElement(i)));
        }
        next.appendScale(scale);
        next.appendRotation(EuclidCoreRandomTools.nextQuaternion(random));
        return next;
    }

    public static Quaternion nextQuaternion(Random random) {
        return new Quaternion(EuclidCoreRandomTools.nextAxisAngle(random));
    }

    public static Quaternion nextQuaternion(Random random, double minMaxAngle) {
        return new Quaternion(EuclidCoreRandomTools.nextAxisAngle(random, minMaxAngle));
    }

    public static Quaternion32 nextQuaternion32(Random random) {
        return new Quaternion32(EuclidCoreRandomTools.nextAxisAngle(random));
    }

    public static Quaternion32 nextQuaternion32(Random random, double minMaxAngleRange) {
        return new Quaternion32(EuclidCoreRandomTools.nextAxisAngle(random, minMaxAngleRange));
    }

    public static Orientation3DBasics nextOrientation3D(Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                return EuclidCoreRandomTools.nextAxisAngle(random);
            }
            case 1: {
                return EuclidCoreRandomTools.nextQuaternion(random);
            }
            case 2: {
                return EuclidCoreRandomTools.nextRotationMatrix(random);
            }
        }
        return EuclidCoreRandomTools.nextYawPitchRoll(random);
    }

    public static Orientation2D nextOrientation2D(Random random) {
        return new Orientation2D(EuclidCoreRandomTools.nextDouble(random, Math.PI));
    }

    public static Orientation2D nextOrientation2D(Random random, double minMax) {
        return new Orientation2D(EuclidCoreRandomTools.nextDouble(random, minMax));
    }

    public static RigidBodyTransform nextRigidBodyTransform(Random random) {
        return new RigidBodyTransform(EuclidCoreRandomTools.nextAxisAngle(random), EuclidCoreRandomTools.nextVector3D(random));
    }

    public static RigidBodyTransform nextRigidBodyTransform2D(Random random) {
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        rigidBodyTransform.getTranslation().set(EuclidCoreRandomTools.nextPoint3D(random));
        rigidBodyTransform.getRotation().setToYawOrientation(EuclidCoreRandomTools.nextDouble(random, Math.PI));
        return rigidBodyTransform;
    }

    public static QuaternionBasedTransform nextQuaternionBasedTransform(Random random) {
        return new QuaternionBasedTransform(EuclidCoreRandomTools.nextQuaternion(random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D(random));
    }

    public static AffineTransform nextAffineTransform(Random random) {
        return new AffineTransform(EuclidCoreRandomTools.nextMatrix3D(random, 10.0), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D(random));
    }

    public static AffineTransform nextNonSingularAffineTransform(Random random) {
        return new AffineTransform(EuclidCoreRandomTools.nextNonSingularLinearTransform3D(random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D(random));
    }

    public static RotationMatrix nextRotationMatrix(Random random) {
        return EuclidCoreRandomTools.nextRotationMatrix(random, Math.PI);
    }

    public static RotationMatrix nextRotationMatrix(Random random, double minMaxAngle) {
        AxisAngle randomRotation = EuclidCoreRandomTools.nextAxisAngle(random, minMaxAngle);
        return new RotationMatrix(randomRotation);
    }

    public static Point3D nextPoint3D(Random random) {
        Point3D point = new Point3D();
        EuclidCoreRandomTools.randomizeTuple3D(random, point);
        return point;
    }

    public static Point3D nextPoint3D(Random random, double minMax) {
        double x = EuclidCoreRandomTools.nextDouble(random, -minMax, minMax);
        double y = EuclidCoreRandomTools.nextDouble(random, -minMax, minMax);
        double z = EuclidCoreRandomTools.nextDouble(random, -minMax, minMax);
        return new Point3D(x, y, z);
    }

    public static Point3D nextPoint3D(Random random, double min, double max) {
        double x = EuclidCoreRandomTools.nextDouble(random, min, max);
        double y = EuclidCoreRandomTools.nextDouble(random, min, max);
        double z = EuclidCoreRandomTools.nextDouble(random, min, max);
        return new Point3D(x, y, z);
    }

    public static Point3D nextPoint3D(Random random, double maxAbsoluteX, double maxAbsoluteY, double maxAbsoluteZ) {
        double x = EuclidCoreRandomTools.nextDouble(random, -maxAbsoluteX, maxAbsoluteX);
        double y = EuclidCoreRandomTools.nextDouble(random, -maxAbsoluteY, maxAbsoluteY);
        double z = EuclidCoreRandomTools.nextDouble(random, -maxAbsoluteZ, maxAbsoluteZ);
        return new Point3D(x, y, z);
    }

    public static Point3D nextPoint3D(Random random, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        double x = EuclidCoreRandomTools.nextDouble(random, minX, maxX);
        double y = EuclidCoreRandomTools.nextDouble(random, minY, maxY);
        double z = EuclidCoreRandomTools.nextDouble(random, minZ, maxZ);
        return new Point3D(x, y, z);
    }

    public static Vector3D nextVector3D(Random random) {
        Vector3D vector = new Vector3D();
        EuclidCoreRandomTools.randomizeTuple3D(random, vector);
        return vector;
    }

    public static UnitVector3D nextUnitVector3D(Random random) {
        return new UnitVector3D(EuclidCoreRandomTools.nextVector3D(random));
    }

    public static Vector3D nextVector3D(Random random, Tuple3DReadOnly minMax) {
        Vector3D vector = new Vector3D();
        EuclidCoreRandomTools.randomizeTuple3D(random, minMax, vector);
        return vector;
    }

    public static Vector3D nextVector3D(Random random, Tuple3DReadOnly min, Tuple3DReadOnly max) {
        Vector3D vector = new Vector3D();
        EuclidCoreRandomTools.randomizeTuple3D(random, min, max, vector);
        return vector;
    }

    public static Vector3D nextVector3D(Random random, double minMax) {
        return EuclidCoreRandomTools.nextVector3D(random, -minMax, minMax);
    }

    public static Vector3D nextVector3D(Random random, double min, double max) {
        Vector3D vector = new Vector3D();
        EuclidCoreRandomTools.randomizeTuple3D(random, new Point3D(min, min, min), new Point3D(max, max, max), vector);
        return vector;
    }

    public static Vector3D nextVector3D(Random random, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        double x = EuclidCoreRandomTools.nextDouble(random, minX, maxX);
        double y = EuclidCoreRandomTools.nextDouble(random, minY, maxY);
        double z = EuclidCoreRandomTools.nextDouble(random, minZ, maxZ);
        return new Vector3D(x, y, z);
    }

    public static Vector3D nextVector3DWithFixedLength(Random random, double length) {
        Vector3D vector = EuclidCoreRandomTools.nextVector3D(random);
        vector.normalize();
        vector.scale(length);
        return vector;
    }

    public static Vector3D nextOrthogonalVector3D(Random random, Vector3DReadOnly vectorToBeOrthogonalTo, boolean normalize) {
        Vector3D v1 = new Vector3D(vectorToBeOrthogonalTo.getY(), -vectorToBeOrthogonalTo.getX(), 0.0);
        Vector3D v2 = new Vector3D(-vectorToBeOrthogonalTo.getZ(), 0.0, vectorToBeOrthogonalTo.getX());
        if (v1.normSquared() < 1.0E-12) {
            v1.cross(vectorToBeOrthogonalTo, v2);
        }
        if (v2.normSquared() < 1.0E-12) {
            v2.cross(v1, vectorToBeOrthogonalTo);
        }
        Vector3D randomPerpendicular = new Vector3D();
        double a = EuclidCoreRandomTools.nextDouble(random, 1.0);
        double b = EuclidCoreRandomTools.nextDouble(random, 1.0);
        randomPerpendicular.scaleAdd(a, v1, randomPerpendicular);
        randomPerpendicular.scaleAdd(b, v2, randomPerpendicular);
        if (normalize) {
            randomPerpendicular.normalize();
        }
        return randomPerpendicular;
    }

    public static Point2D nextPoint2D(Random random) {
        Point2D point = new Point2D();
        EuclidCoreRandomTools.randomizeTuple2D(random, point);
        return point;
    }

    public static Point2D nextPoint2D(Random random, double minMax) {
        double x = EuclidCoreRandomTools.nextDouble(random, -minMax, minMax);
        double y = EuclidCoreRandomTools.nextDouble(random, -minMax, minMax);
        return new Point2D(x, y);
    }

    public static Point2D nextPoint2D(Random random, double min, double max) {
        double x = EuclidCoreRandomTools.nextDouble(random, min, max);
        double y = EuclidCoreRandomTools.nextDouble(random, min, max);
        return new Point2D(x, y);
    }

    public static Point2D nextPoint2D(Random random, double minX, double maxX, double minY, double maxY) {
        double x = EuclidCoreRandomTools.nextDouble(random, minX, maxX);
        double y = EuclidCoreRandomTools.nextDouble(random, minY, maxY);
        return new Point2D(x, y);
    }

    public static Vector2D nextVector2D(Random random) {
        Vector2D vector = new Vector2D();
        EuclidCoreRandomTools.randomizeTuple2D(random, vector);
        return vector;
    }

    public static UnitVector2D nextUnitVector2D(Random random) {
        return new UnitVector2D(EuclidCoreRandomTools.nextVector2D(random));
    }

    public static Vector2D nextVector2D(Random random, double min, double max) {
        Vector2D vector = new Vector2D();
        EuclidCoreRandomTools.randomizeTuple2D(random, new Point2D(min, min), new Point2D(max, max), vector);
        return vector;
    }

    public static Vector2D nextVector2DWithFixedLength(Random random, double length) {
        Vector2D vector = EuclidCoreRandomTools.nextVector2D(random);
        vector.normalize();
        vector.scale(length);
        return vector;
    }

    public static Vector2D nextVector2D(Random random, Tuple2DReadOnly minMax) {
        Vector2D vector = new Vector2D();
        EuclidCoreRandomTools.randomizeTuple2D(random, minMax, vector);
        return vector;
    }

    public static Vector2D nextVector2D(Random random, Tuple2DReadOnly min, Tuple2DReadOnly max) {
        Vector2D vector = new Vector2D();
        EuclidCoreRandomTools.randomizeTuple2D(random, min, max, vector);
        return vector;
    }

    public static Vector4D nextVector4D(Random random) {
        Vector4D vector = new Vector4D();
        for (int i = 0; i < 4; ++i) {
            vector.setElement(i, EuclidCoreRandomTools.nextDouble(random));
        }
        return vector;
    }

    public static Vector3D32 nextVector3D32(Random random) {
        Vector3D32 vector = new Vector3D32();
        EuclidCoreRandomTools.randomizeTuple3D(random, vector);
        return vector;
    }

    public static Point3D32 nextPoint3D32(Random random) {
        Point3D32 point = new Point3D32();
        EuclidCoreRandomTools.randomizeTuple3D(random, point);
        return point;
    }

    public static Vector2D32 nextVector2D32(Random random) {
        Vector2D32 vector = new Vector2D32();
        EuclidCoreRandomTools.randomizeTuple2D(random, vector);
        return vector;
    }

    public static Point2D32 nextPoint2D32(Random random) {
        Point2D32 point = new Point2D32();
        EuclidCoreRandomTools.randomizeTuple2D(random, point);
        return point;
    }

    public static Vector4D32 nextVector4D32(Random random) {
        Vector4D32 vector = new Vector4D32();
        for (int i = 0; i < 4; ++i) {
            vector.setElement(i, EuclidCoreRandomTools.nextDouble(random));
        }
        return vector;
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns) {
        return EuclidCoreRandomTools.nextDMatrixRMaj(random, numberOfRows, numberOfColumns, 1.0);
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns, double minMax) {
        return EuclidCoreRandomTools.nextDMatrixRMaj(random, numberOfRows, numberOfColumns, -minMax, minMax);
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns, double min, double max) {
        DMatrixRMaj next = new DMatrixRMaj(numberOfRows, numberOfColumns);
        for (int row = 0; row < numberOfRows; ++row) {
            for (int col = 0; col < numberOfColumns; ++col) {
                next.set(row, col, EuclidCoreRandomTools.nextDouble(random, min, max));
            }
        }
        return next;
    }

    public static void randomizeAxisAngle(Random random, AxisAngleBasics axisAngleToRandomize) {
        EuclidCoreRandomTools.randomizeAxisAngle(random, Math.PI, axisAngleToRandomize);
    }

    public static void randomizeAxisAngle(Random random, double minMaxAngle, AxisAngleBasics axisAngleToRandomize) {
        double height = 2.0 * random.nextDouble() - 1.0;
        double angle = EuclidCoreRandomTools.nextDouble(random, minMaxAngle);
        double radius = EuclidCoreTools.squareRoot(1.0 - height * height);
        axisAngleToRandomize.set(radius * EuclidCoreTools.cos(angle), radius * EuclidCoreTools.sin(angle), height, angle);
    }

    public static void randomizeTuple3D(Random random, Tuple3DBasics tupleToRandomize) {
        EuclidCoreRandomTools.randomizeTuple3D(random, new Point3D(1.0, 1.0, 1.0), tupleToRandomize);
    }

    public static void randomizeTuple3D(Random random, Tuple3DReadOnly minMax, Tuple3DBasics tupleToRandomize) {
        for (int i = 0; i < 3; ++i) {
            tupleToRandomize.setElement(i, EuclidCoreRandomTools.nextDouble(random, minMax.getElement(i)));
        }
    }

    public static void randomizeTuple3D(Random random, Tuple3DReadOnly min, Tuple3DReadOnly max, Tuple3DBasics tupleToRandomize) {
        for (int i = 0; i < 3; ++i) {
            tupleToRandomize.setElement(i, EuclidCoreRandomTools.nextDouble(random, min.getElement(i), max.getElement(i)));
        }
    }

    public static void randomizeTuple2D(Random random, Tuple2DBasics tupleToRandomize) {
        EuclidCoreRandomTools.randomizeTuple2D(random, new Point2D(1.0, 1.0), tupleToRandomize);
    }

    public static void randomizeTuple2D(Random random, Tuple2DReadOnly minMax, Tuple2DBasics tupleToRandomize) {
        for (int i = 0; i < 2; ++i) {
            tupleToRandomize.setElement(i, EuclidCoreRandomTools.nextDouble(random, minMax.getElement(i)));
        }
    }

    public static void randomizeTuple2D(Random random, Tuple2DReadOnly min, Tuple2DReadOnly max, Tuple2DBasics tupleToRandomize) {
        for (int i = 0; i < 2; ++i) {
            tupleToRandomize.setElement(i, EuclidCoreRandomTools.nextDouble(random, min.getElement(i), max.getElement(i)));
        }
    }
}

