/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.SingularValueDecomposition3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class SymmetricEigenDecomposition3D {
    static final double sqrtTwoOverTwo = EuclidCoreTools.squareRoot(2.0) / 2.0;
    private final Matrix3D A_internal = new Matrix3D();
    private final Quaternion Qquat = new Quaternion();
    private final Eigen3DOutput output = new Eigen3DOutput();
    private int maxIterations = 25;
    private double tolerance = 1.0E-13;
    private boolean sortDescendingOrder = true;
    private int iterations = -1;

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public void setSortDescendingOrder(boolean sortDescendingOrder) {
        this.sortDescendingOrder = sortDescendingOrder;
    }

    public boolean decompose(Matrix3DReadOnly A) {
        double max = A.maxAbsElement();
        if (!A.isMatrixSymmetric(max * this.tolerance)) {
            return false;
        }
        this.initialize(A, 1.0 / max);
        this.computeQ(this.A_internal);
        this.output.eigenValues.set(this.A_internal.getM00(), this.A_internal.getM11(), this.A_internal.getM22());
        if (this.sortDescendingOrder) {
            SymmetricEigenDecomposition3D.sortEigenValues(this.output.eigenValues, this.Qquat);
        }
        SymmetricEigenDecomposition3D.toEigenVectors(this.Qquat, this.output.eigenVector0, this.output.eigenVector1, this.output.eigenVector2);
        this.output.eigenValues.scale(max);
        return true;
    }

    private void initialize(Matrix3DReadOnly A, double scale) {
        double a00 = A.getM00() * scale;
        double a11 = A.getM11() * scale;
        double a22 = A.getM22() * scale;
        double offScale = 0.5 * scale;
        double a01 = offScale * (A.getM01() + A.getM10());
        double a02 = offScale * (A.getM02() + A.getM20());
        double a12 = offScale * (A.getM12() + A.getM21());
        this.A_internal.set(a00, a01, a02, a01, a11, a12, a02, a12, a22);
    }

    private boolean computeQ(Matrix3DBasics A) {
        this.iterations = SingularValueDecomposition3D.computeV(A, this.Qquat, this.maxIterations, this.tolerance);
        return this.iterations < this.maxIterations;
    }

    private static void sortEigenValues(Vector3DBasics lambda, QuaternionBasics Qquat) {
        double rho0 = Math.abs(lambda.getX());
        double rho1 = Math.abs(lambda.getY());
        double rho2 = Math.abs(lambda.getZ());
        double qx = Qquat.getX();
        double qy = Qquat.getY();
        double qz = Qquat.getZ();
        double qs = Qquat.getS();
        if (rho0 > rho1) {
            if (rho0 > rho2) {
                if (!(rho1 > rho2)) {
                    lambda.set(lambda.getX(), lambda.getZ(), lambda.getY());
                    Qquat.setUnsafe(sqrtTwoOverTwo * (qs + qx), sqrtTwoOverTwo * (qy + qz), sqrtTwoOverTwo * (qz - qy), sqrtTwoOverTwo * (qs - qx));
                }
            } else {
                lambda.set(lambda.getZ(), lambda.getX(), lambda.getY());
                Qquat.setUnsafe(0.5 * (-qs + qx - qy + qz), 0.5 * (-qs + qx + qy - qz), 0.5 * (-qs - qx + qy + qz), 0.5 * (qs + qx + qy + qz));
            }
        } else if (rho1 > rho2) {
            if (rho0 > rho2) {
                lambda.set(lambda.getY(), lambda.getX(), lambda.getZ());
                Qquat.setUnsafe(sqrtTwoOverTwo * (qx + qy), sqrtTwoOverTwo * (qy - qx), sqrtTwoOverTwo * (qs + qz), sqrtTwoOverTwo * (qs - qz));
            } else {
                lambda.set(lambda.getY(), lambda.getZ(), lambda.getX());
                Qquat.setUnsafe(0.5 * (qs + qx + qy - qz), 0.5 * (qs - qx + qy + qz), 0.5 * (qs + qx - qy + qz), 0.5 * (qs - qx - qy - qz));
            }
        } else {
            lambda.set(lambda.getZ(), lambda.getY(), lambda.getX());
            Qquat.setUnsafe(sqrtTwoOverTwo * (qx + qz), sqrtTwoOverTwo * (qy - qs), sqrtTwoOverTwo * (qz - qx), sqrtTwoOverTwo * (qs + qy));
        }
    }

    private static void toEigenVectors(QuaternionReadOnly q, Vector3DBasics v0, Vector3DBasics v1, Vector3DBasics v2) {
        double qx = q.getX();
        double qy = q.getY();
        double qz = q.getZ();
        double qs = q.getS();
        double yy2 = 2.0 * qy * qy;
        double zz2 = 2.0 * qz * qz;
        double xx2 = 2.0 * qx * qx;
        double xy2 = 2.0 * qx * qy;
        double sz2 = 2.0 * qs * qz;
        double xz2 = 2.0 * qx * qz;
        double sy2 = 2.0 * qs * qy;
        double yz2 = 2.0 * qy * qz;
        double sx2 = 2.0 * qs * qx;
        double m00 = 1.0 - yy2 - zz2;
        double m01 = xy2 - sz2;
        double m02 = xz2 + sy2;
        double m10 = xy2 + sz2;
        double m11 = 1.0 - xx2 - zz2;
        double m12 = yz2 - sx2;
        double m20 = xz2 - sy2;
        double m21 = yz2 + sx2;
        double m22 = 1.0 - xx2 - yy2;
        v0.set(m00, m10, m20);
        v1.set(m01, m11, m21);
        v2.set(m02, m12, m22);
    }

    public Vector3D getEigenVector(int index) {
        return this.output.getEigenVector(index);
    }

    public Matrix3DBasics getEigenVectors(Matrix3DBasics eigenVectorsToPack) {
        return this.output.getEigenVectors(eigenVectorsToPack);
    }

    public double getEigenValue(int index) {
        return this.output.getEigenValue(index);
    }

    public Vector3D getEigenValues() {
        return this.output.getEigenValues();
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean getSortDescendingOrder() {
        return this.sortDescendingOrder;
    }

    public static class Eigen3DOutput {
        private final Vector3D eigenValues = new Vector3D();
        private final Vector3D eigenVector0 = new Vector3D();
        private final Vector3D eigenVector1 = new Vector3D();
        private final Vector3D eigenVector2 = new Vector3D();
        private final Vector3D[] eigenVectors = new Vector3D[]{this.eigenVector0, this.eigenVector1, this.eigenVector2};

        public void set(Eigen3DOutput other) {
            this.eigenValues.set(other.eigenValues);
            this.eigenVector0.set(other.eigenVector0);
            this.eigenVector1.set(other.eigenVector1);
            this.eigenVector2.set(other.eigenVector2);
        }

        public void setIdentity() {
            this.eigenValues.set(1.0, 1.0, 1.0);
            this.eigenVector0.set(1.0, 0.0, 0.0);
            this.eigenVector1.set(0.0, 1.0, 0.0);
            this.eigenVector2.set(0.0, 0.0, 1.0);
        }

        public void setToNaN() {
            this.eigenValues.setToNaN();
            this.eigenVector0.setToNaN();
            this.eigenVector1.setToNaN();
            this.eigenVector2.setToNaN();
        }

        public Vector3D getEigenVector(int index) {
            return this.eigenVectors[index];
        }

        public Matrix3DBasics getEigenVectors(Matrix3DBasics eigenVectorsToPack) {
            if (eigenVectorsToPack == null) {
                eigenVectorsToPack = new Matrix3D();
            }
            eigenVectorsToPack.setColumns(this.eigenVector0, this.eigenVector1, this.eigenVector2);
            return eigenVectorsToPack;
        }

        public double getEigenValue(int index) {
            return this.eigenValues.getElement(index);
        }

        public Vector3D getEigenValues() {
            return this.eigenValues;
        }
    }
}

