/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ToDoubleFunction;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class EuclidCoreFactories {
    private EuclidCoreFactories() {
    }

    public static Point2DReadOnly newLinkedPoint2DReadOnly(DoubleSupplier scaleSupplier, Tuple2DReadOnly originalTuple) {
        DoubleSupplier xSupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getX();
        DoubleSupplier ySupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getY();
        return EuclidCoreFactories.newLinkedPoint2DReadOnly(xSupplier, ySupplier);
    }

    public static Vector2DReadOnly newLinkedVector2DReadOnly(DoubleSupplier scaleSupplier, Tuple2DReadOnly originalTuple) {
        DoubleSupplier xSupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getX();
        DoubleSupplier ySupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getY();
        return EuclidCoreFactories.newLinkedVector2DReadOnly(xSupplier, ySupplier);
    }

    public static Point3DReadOnly newLinkedPoint3DReadOnly(DoubleSupplier scaleSupplier, Tuple3DReadOnly originalTuple) {
        DoubleSupplier xSupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getX();
        DoubleSupplier ySupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getY();
        DoubleSupplier zSupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getZ();
        return EuclidCoreFactories.newLinkedPoint3DReadOnly(xSupplier, ySupplier, zSupplier);
    }

    public static Vector3DReadOnly newLinkedVector3DReadOnly(DoubleSupplier scaleSupplier, Tuple3DReadOnly originalTuple) {
        DoubleSupplier xSupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getX();
        DoubleSupplier ySupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getY();
        DoubleSupplier zSupplier = () -> scaleSupplier.getAsDouble() * originalTuple.getZ();
        return EuclidCoreFactories.newLinkedVector3DReadOnly(xSupplier, ySupplier, zSupplier);
    }

    public static Point2DReadOnly newLinkedPoint2DReadOnly(final DoubleSupplier xSupplier, final DoubleSupplier ySupplier) {
        return new Point2DReadOnly(){

            @Override
            public double getX() {
                return xSupplier.getAsDouble();
            }

            @Override
            public double getY() {
                return ySupplier.getAsDouble();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Point2DReadOnly) {
                    return this.equals((Point2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static Vector2DReadOnly newLinkedVector2DReadOnly(final DoubleSupplier xSupplier, final DoubleSupplier ySupplier) {
        return new Vector2DReadOnly(){

            @Override
            public double getX() {
                return xSupplier.getAsDouble();
            }

            @Override
            public double getY() {
                return ySupplier.getAsDouble();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector2DReadOnly) {
                    return this.equals((Vector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static Point3DReadOnly newLinkedPoint3DReadOnly(final DoubleSupplier xSupplier, final DoubleSupplier ySupplier, final DoubleSupplier zSupplier) {
        return new Point3DReadOnly(){

            @Override
            public double getX() {
                return xSupplier.getAsDouble();
            }

            @Override
            public double getY() {
                return ySupplier.getAsDouble();
            }

            @Override
            public double getZ() {
                return zSupplier.getAsDouble();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Point3DReadOnly) {
                    return this.equals((Point3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static Vector3DReadOnly newLinkedVector3DReadOnly(final DoubleSupplier xSupplier, final DoubleSupplier ySupplier, final DoubleSupplier zSupplier) {
        return new Vector3DReadOnly(){

            @Override
            public double getX() {
                return xSupplier.getAsDouble();
            }

            @Override
            public double getY() {
                return ySupplier.getAsDouble();
            }

            @Override
            public double getZ() {
                return zSupplier.getAsDouble();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector3DReadOnly) {
                    return this.equals((Vector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static Point2DReadOnly newNegativeLinkedPoint2D(Point2DReadOnly originalPoint) {
        DoubleSupplier xSupplier = () -> -originalPoint.getX();
        DoubleSupplier ySupplier = () -> -originalPoint.getY();
        return EuclidCoreFactories.newLinkedPoint2DReadOnly(xSupplier, ySupplier);
    }

    public static Vector2DReadOnly newNegativeLinkedVector2D(Vector2DReadOnly originalVector) {
        DoubleSupplier xSupplier = () -> -originalVector.getX();
        DoubleSupplier ySupplier = () -> -originalVector.getY();
        return EuclidCoreFactories.newLinkedVector2DReadOnly(xSupplier, ySupplier);
    }

    public static Point3DReadOnly newNegativeLinkedPoint3D(Point3DReadOnly originalPoint) {
        DoubleSupplier xSupplier = () -> -originalPoint.getX();
        DoubleSupplier ySupplier = () -> -originalPoint.getY();
        DoubleSupplier zSupplier = () -> -originalPoint.getZ();
        return EuclidCoreFactories.newLinkedPoint3DReadOnly(xSupplier, ySupplier, zSupplier);
    }

    public static Vector3DReadOnly newNegativeLinkedVector3D(Vector3DReadOnly originalVector) {
        DoubleSupplier xSupplier = () -> -originalVector.getX();
        DoubleSupplier ySupplier = () -> -originalVector.getY();
        DoubleSupplier zSupplier = () -> -originalVector.getZ();
        return EuclidCoreFactories.newLinkedVector3DReadOnly(xSupplier, ySupplier, zSupplier);
    }

    public static UnitVector2DReadOnly newNegativeLinkedUnitVector2D(final UnitVector2DReadOnly originalUnitVector) {
        return new UnitVector2DReadOnly(){

            @Override
            public boolean isDirty() {
                return originalUnitVector.isDirty();
            }

            @Override
            public double getX() {
                return -originalUnitVector.getX();
            }

            @Override
            public double getY() {
                return -originalUnitVector.getY();
            }

            @Override
            public double getRawX() {
                return -originalUnitVector.getRawX();
            }

            @Override
            public double getRawY() {
                return -originalUnitVector.getRawY();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector2DReadOnly) {
                    return this.equals((Vector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static UnitVector3DReadOnly newNegativeLinkedUnitVector3D(final UnitVector3DReadOnly originalUnitVector) {
        return new UnitVector3DReadOnly(){

            @Override
            public boolean isDirty() {
                return originalUnitVector.isDirty();
            }

            @Override
            public double getX() {
                return -originalUnitVector.getX();
            }

            @Override
            public double getY() {
                return -originalUnitVector.getY();
            }

            @Override
            public double getZ() {
                return -originalUnitVector.getZ();
            }

            @Override
            public double getRawX() {
                return -originalUnitVector.getRawX();
            }

            @Override
            public double getRawY() {
                return -originalUnitVector.getRawY();
            }

            @Override
            public double getRawZ() {
                return -originalUnitVector.getRawZ();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector3DReadOnly) {
                    return this.equals((Vector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static QuaternionReadOnly newConjugateLinkedQuaternion(final QuaternionReadOnly originalQuaternion) {
        return new QuaternionReadOnly(){

            @Override
            public double getX() {
                return -originalQuaternion.getX();
            }

            @Override
            public double getY() {
                return -originalQuaternion.getY();
            }

            @Override
            public double getZ() {
                return -originalQuaternion.getZ();
            }

            @Override
            public double getS() {
                return originalQuaternion.getS();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ(), this.getS());
            }

            public boolean equals(Object object) {
                if (object instanceof QuaternionReadOnly) {
                    return this.equals((QuaternionReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple4DString(this);
            }
        };
    }

    public static Matrix3DReadOnly newTransposeLinkedMatrix3DReadOnly(final Matrix3DReadOnly original) {
        return new Matrix3DReadOnly(){

            @Override
            public double getM00() {
                return original.getM00();
            }

            @Override
            public double getM01() {
                return original.getM10();
            }

            @Override
            public double getM02() {
                return original.getM20();
            }

            @Override
            public double getM10() {
                return original.getM01();
            }

            @Override
            public double getM11() {
                return original.getM11();
            }

            @Override
            public double getM12() {
                return original.getM21();
            }

            @Override
            public double getM20() {
                return original.getM02();
            }

            @Override
            public double getM21() {
                return original.getM12();
            }

            @Override
            public double getM22() {
                return original.getM22();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
            }

            public boolean equals(Object object) {
                if (object instanceof Matrix3DReadOnly) {
                    return this.equals((Matrix3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getMatrix3DString(this);
            }
        };
    }

    public static Matrix3DReadOnly newTildeLinkedMatrix3DReadOnly(final Tuple3DReadOnly originalTuple) {
        return new Matrix3DReadOnly(){

            @Override
            public double getM00() {
                return 0.0;
            }

            @Override
            public double getM01() {
                return -originalTuple.getZ();
            }

            @Override
            public double getM02() {
                return originalTuple.getY();
            }

            @Override
            public double getM10() {
                return originalTuple.getZ();
            }

            @Override
            public double getM11() {
                return 0.0;
            }

            @Override
            public double getM12() {
                return -originalTuple.getX();
            }

            @Override
            public double getM20() {
                return -originalTuple.getY();
            }

            @Override
            public double getM21() {
                return originalTuple.getX();
            }

            @Override
            public double getM22() {
                return 0.0;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
            }

            public boolean equals(Object object) {
                if (object instanceof Matrix3DReadOnly) {
                    return this.equals((Matrix3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getMatrix3DString(this);
            }
        };
    }

    public static Matrix3DReadOnly newDiagonalLinkedMatrix3DReadOnly(final Tuple3DReadOnly originalTuple) {
        return new Matrix3DReadOnly(){

            @Override
            public double getM00() {
                return originalTuple.getX();
            }

            @Override
            public double getM01() {
                return 0.0;
            }

            @Override
            public double getM02() {
                return 0.0;
            }

            @Override
            public double getM10() {
                return 0.0;
            }

            @Override
            public double getM11() {
                return originalTuple.getY();
            }

            @Override
            public double getM12() {
                return 0.0;
            }

            @Override
            public double getM20() {
                return 0.0;
            }

            @Override
            public double getM21() {
                return 0.0;
            }

            @Override
            public double getM22() {
                return originalTuple.getZ();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
            }

            public boolean equals(Object object) {
                if (object instanceof Matrix3DReadOnly) {
                    return this.equals((Matrix3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getMatrix3DString(this);
            }
        };
    }

    public static Point2DReadOnly newObservablePoint2DReadOnly(Consumer<Axis2D> valueAccessedListener, Point2DReadOnly source) {
        ToDoubleFunction<Axis2D> notifier = EuclidCoreFactories.readNotification(valueAccessedListener, axis -> axis.extract(source));
        return EuclidCoreFactories.newLinkedPoint2DReadOnly(() -> notifier.applyAsDouble(Axis2D.X), () -> notifier.applyAsDouble(Axis2D.Y));
    }

    public static Point3DReadOnly newObservablePoint3DReadOnly(Consumer<Axis3D> valueAccessedListener, Point3DReadOnly source) {
        ToDoubleFunction<Axis3D> notifier = EuclidCoreFactories.readNotification(valueAccessedListener, axis -> axis.extract(source));
        return EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> notifier.applyAsDouble(Axis3D.X), () -> notifier.applyAsDouble(Axis3D.Y), () -> notifier.applyAsDouble(Axis3D.Z));
    }

    public static Vector2DReadOnly newObservableVector2DReadOnly(Consumer<Axis2D> valueAccessedListener, Vector2DReadOnly source) {
        ToDoubleFunction<Axis2D> notifier = EuclidCoreFactories.readNotification(valueAccessedListener, axis -> axis.extract(source));
        return EuclidCoreFactories.newLinkedVector2DReadOnly(() -> notifier.applyAsDouble(Axis2D.X), () -> notifier.applyAsDouble(Axis2D.Y));
    }

    public static Vector3DReadOnly newObservableVector3DReadOnly(Consumer<Axis3D> valueAccessedListener, Vector3DReadOnly source) {
        ToDoubleFunction<Axis3D> notifier = EuclidCoreFactories.readNotification(valueAccessedListener, axis -> axis.extract(source));
        return EuclidCoreFactories.newLinkedVector3DReadOnly(() -> notifier.applyAsDouble(Axis3D.X), () -> notifier.applyAsDouble(Axis3D.Y), () -> notifier.applyAsDouble(Axis3D.Z));
    }

    private static <T> ToDoubleFunction<T> readNotification(final Consumer<T> listener, final ToDoubleFunction<T> valueReader) {
        return new ToDoubleFunction<T>(){
            private boolean isNotifying = false;

            @Override
            public double applyAsDouble(T value) {
                if (!this.isNotifying) {
                    this.isNotifying = true;
                    listener.accept(value);
                    this.isNotifying = false;
                }
                return valueReader.applyAsDouble(value);
            }
        };
    }

    public static UnitVector2DReadOnly newObservableUnitVector2DReadOnly(Consumer<Axis2D> valueAccessedListener, final UnitVector2DReadOnly source) {
        final ToDoubleFunction<Axis2D> notifier = EuclidCoreFactories.readNotification(valueAccessedListener, axis -> axis.extract(source));
        return new UnitVector2DReadOnly(){

            @Override
            public boolean isDirty() {
                return source.isDirty();
            }

            @Override
            public double getX() {
                return notifier.applyAsDouble(Axis2D.X);
            }

            @Override
            public double getY() {
                return notifier.applyAsDouble(Axis2D.Y);
            }

            @Override
            public double getRawX() {
                return source.getRawX();
            }

            @Override
            public double getRawY() {
                return source.getRawY();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector2DReadOnly) {
                    return this.equals((Vector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static UnitVector3DReadOnly newObservableUnitVector3DReadOnly(Consumer<Axis3D> valueAccessedListener, final UnitVector3DReadOnly source) {
        final ToDoubleFunction<Axis3D> notifier = EuclidCoreFactories.readNotification(valueAccessedListener, axis -> axis.extract(source));
        return new UnitVector3DReadOnly(){

            @Override
            public boolean isDirty() {
                return source.isDirty();
            }

            @Override
            public double getX() {
                return notifier.applyAsDouble(Axis3D.X);
            }

            @Override
            public double getY() {
                return notifier.applyAsDouble(Axis3D.Y);
            }

            @Override
            public double getZ() {
                return notifier.applyAsDouble(Axis3D.Z);
            }

            @Override
            public double getRawX() {
                return source.getRawX();
            }

            @Override
            public double getRawY() {
                return source.getRawY();
            }

            @Override
            public double getRawZ() {
                return source.getRawZ();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector3DReadOnly) {
                    return this.equals((Vector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static RotationMatrixReadOnly newObservableRotationMatrixReadOnly(final BiConsumer<Axis3D, Axis3D> valueAccessedListener, final RotationMatrixReadOnly source) {
        return new RotationMatrixReadOnly(){
            private boolean isNotifying = false;

            @Override
            public boolean isDirty() {
                return source.isDirty();
            }

            @Override
            public double getM00() {
                this.notifyAccessListener(Axis3D.X, Axis3D.X);
                return source.getM00();
            }

            @Override
            public double getM01() {
                this.notifyAccessListener(Axis3D.X, Axis3D.Y);
                return source.getM01();
            }

            @Override
            public double getM02() {
                this.notifyAccessListener(Axis3D.X, Axis3D.Z);
                return source.getM02();
            }

            @Override
            public double getM10() {
                this.notifyAccessListener(Axis3D.Y, Axis3D.X);
                return source.getM10();
            }

            @Override
            public double getM11() {
                this.notifyAccessListener(Axis3D.Y, Axis3D.Y);
                return source.getM11();
            }

            @Override
            public double getM12() {
                this.notifyAccessListener(Axis3D.Y, Axis3D.Z);
                return source.getM12();
            }

            @Override
            public double getM20() {
                this.notifyAccessListener(Axis3D.Z, Axis3D.X);
                return source.getM20();
            }

            @Override
            public double getM21() {
                this.notifyAccessListener(Axis3D.Z, Axis3D.Y);
                return source.getM21();
            }

            @Override
            public double getM22() {
                this.notifyAccessListener(Axis3D.Z, Axis3D.Z);
                return source.getM22();
            }

            private void notifyAccessListener(Axis3D row, Axis3D column) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(row, column);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
            }

            public boolean equals(Object object) {
                if (object instanceof Matrix3DReadOnly) {
                    return this.equals((Matrix3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getMatrix3DString(this);
            }
        };
    }

    public static QuaternionReadOnly newObservableQuaternionReadOnly(final IntConsumer valueAccessedListener, final QuaternionReadOnly source) {
        return new QuaternionReadOnly(){
            private boolean isNotifying = false;

            @Override
            public double getX() {
                this.notifyAccessListener(0);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(1);
                return source.getY();
            }

            @Override
            public double getZ() {
                this.notifyAccessListener(2);
                return source.getZ();
            }

            @Override
            public double getS() {
                this.notifyAccessListener(3);
                return source.getS();
            }

            private void notifyAccessListener(int index) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(index);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ(), this.getS());
            }

            public boolean equals(Object object) {
                if (object instanceof QuaternionReadOnly) {
                    return this.equals((QuaternionReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple4DString(this);
            }
        };
    }

    public static Point2DBasics newObservablePoint2DBasics(ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener) {
        return EuclidCoreFactories.newObservablePoint2DBasics(valueChangedListener, valueAccessedListener, new Point2D());
    }

    public static Point2DBasics newObservablePoint2DBasics(final ObjDoubleConsumer<Axis2D> valueChangedListener, final Consumer<Axis2D> valueAccessedListener, final Point2DBasics source) {
        return new Point2DBasics(){
            private boolean isNotifying = false;

            @Override
            public void setX(double x) {
                if (x != source.getX()) {
                    source.setX(x);
                    this.notifyChangeListener(Axis2D.X, x);
                }
            }

            @Override
            public void setY(double y) {
                if (y != source.getY()) {
                    source.setY(y);
                    this.notifyChangeListener(Axis2D.Y, y);
                }
            }

            @Override
            public double getX() {
                this.notifyAccessListener(Axis2D.X);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(Axis2D.Y);
                return source.getY();
            }

            private void notifyChangeListener(Axis2D axis, double newValue) {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.accept(axis, newValue);
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis2D axis) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(axis);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Point2DReadOnly) {
                    return this.equals((Point2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static Point3DBasics newObservablePoint3DBasics(ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener) {
        return EuclidCoreFactories.newObservablePoint3DBasics(valueChangedListener, valueAccessedListener, new Point3D());
    }

    public static Point3DBasics newObservablePoint3DBasics(final ObjDoubleConsumer<Axis3D> valueChangedListener, final Consumer<Axis3D> valueAccessedListener, final Point3DBasics source) {
        return new Point3DBasics(){
            private boolean isNotifying = false;

            @Override
            public void setX(double x) {
                if (x != source.getX()) {
                    source.setX(x);
                    this.notifyChangeListener(Axis3D.X, x);
                }
            }

            @Override
            public void setY(double y) {
                if (y != source.getY()) {
                    source.setY(y);
                    this.notifyChangeListener(Axis3D.Y, y);
                }
            }

            @Override
            public void setZ(double z) {
                if (z != source.getZ()) {
                    source.setZ(z);
                    this.notifyChangeListener(Axis3D.Z, z);
                }
            }

            @Override
            public double getX() {
                this.notifyAccessListener(Axis3D.X);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(Axis3D.Y);
                return source.getY();
            }

            @Override
            public double getZ() {
                this.notifyAccessListener(Axis3D.Z);
                return source.getZ();
            }

            private void notifyChangeListener(Axis3D axis, double newValue) {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.accept(axis, newValue);
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis3D axis) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(axis);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Point3DReadOnly) {
                    return this.equals((Point3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static Vector2DBasics newObservableVector2DBasics(ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener) {
        return EuclidCoreFactories.newObservableVector2DBasics(valueChangedListener, valueAccessedListener, new Vector2D());
    }

    public static Vector2DBasics newObservableVector2DBasics(final ObjDoubleConsumer<Axis2D> valueChangedListener, final Consumer<Axis2D> valueAccessedListener, final Vector2DBasics source) {
        return new Vector2DBasics(){
            private boolean isNotifying = false;

            @Override
            public void setX(double x) {
                if (x != source.getX()) {
                    source.setX(x);
                    this.notifyChangeListener(Axis2D.X, x);
                }
            }

            @Override
            public void setY(double y) {
                if (y != source.getY()) {
                    source.setY(y);
                    this.notifyChangeListener(Axis2D.Y, y);
                }
            }

            @Override
            public double getX() {
                this.notifyAccessListener(Axis2D.X);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(Axis2D.Y);
                return source.getY();
            }

            private void notifyChangeListener(Axis2D axis, double newValue) {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.accept(axis, newValue);
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis2D axis) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(axis);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector2DReadOnly) {
                    return this.equals((Vector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static Vector3DBasics newObservableVector3DBasics(ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener) {
        return EuclidCoreFactories.newObservableVector3DBasics(valueChangedListener, valueAccessedListener, new Vector3D());
    }

    public static Vector3DBasics newObservableVector3DBasics(final ObjDoubleConsumer<Axis3D> valueChangedListener, final Consumer<Axis3D> valueAccessedListener, final Vector3DBasics source) {
        return new Vector3DBasics(){
            private boolean isNotifying = false;

            @Override
            public void setX(double x) {
                if (x != source.getX()) {
                    source.setX(x);
                    this.notifyChangeListener(Axis3D.X, x);
                }
            }

            @Override
            public void setY(double y) {
                if (y != source.getY()) {
                    source.setY(y);
                    this.notifyChangeListener(Axis3D.Y, y);
                }
            }

            @Override
            public void setZ(double z) {
                if (z != source.getZ()) {
                    source.setZ(z);
                    this.notifyChangeListener(Axis3D.Z, z);
                }
            }

            @Override
            public double getX() {
                this.notifyAccessListener(Axis3D.X);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(Axis3D.Y);
                return source.getY();
            }

            @Override
            public double getZ() {
                this.notifyAccessListener(Axis3D.Z);
                return source.getZ();
            }

            private void notifyChangeListener(Axis3D axis, double newValue) {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.accept(axis, newValue);
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis3D axis) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(axis);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector3DReadOnly) {
                    return this.equals((Vector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static UnitVector2DBasics newObservableUnitVector2DBasics(ObjDoubleConsumer<Axis2D> valueChangedListener, Consumer<Axis2D> valueAccessedListener) {
        return EuclidCoreFactories.newObservableUnitVector2DBasics(valueChangedListener, valueAccessedListener, new UnitVector2D());
    }

    public static UnitVector2DBasics newObservableUnitVector2DBasics(final ObjDoubleConsumer<Axis2D> valueChangedListener, final Consumer<Axis2D> valueAccessedListener, final UnitVector2DBasics source) {
        return new UnitVector2DBasics(){
            private boolean isNotifying = false;

            @Override
            public void absolute() {
                boolean notifyX = this.getRawX() < 0.0;
                boolean notifyY = this.getRawY() < 0.0;
                source.absolute();
                if (notifyX) {
                    this.notifyChangeListener(Axis2D.X, this.getRawX());
                }
                if (notifyY) {
                    this.notifyChangeListener(Axis2D.Y, this.getRawY());
                }
            }

            @Override
            public void negate() {
                source.negate();
                this.notifyChangeListener(Axis2D.X, this.getRawX());
                this.notifyChangeListener(Axis2D.Y, this.getRawY());
            }

            @Override
            public void markAsDirty() {
                source.markAsDirty();
            }

            @Override
            public boolean isDirty() {
                return source.isDirty();
            }

            @Override
            public void normalize() {
                boolean notify = this.isDirty();
                source.normalize();
                if (notify) {
                    this.notifyChangeListener(Axis2D.X, this.getRawX());
                    this.notifyChangeListener(Axis2D.Y, this.getRawY());
                }
            }

            @Override
            public void set(UnitVector2DReadOnly other) {
                boolean notifyX = this.getRawX() != other.getRawX();
                boolean notifyY = this.getRawY() != other.getRawY();
                source.set(other);
                if (notifyX) {
                    this.notifyChangeListener(Axis2D.X, this.getRawX());
                }
                if (notifyY) {
                    this.notifyChangeListener(Axis2D.Y, this.getRawY());
                }
            }

            @Override
            public void setX(double x) {
                if (x != source.getRawX()) {
                    source.setX(x);
                    this.notifyChangeListener(Axis2D.X, x);
                }
            }

            @Override
            public void setY(double y) {
                if (y != source.getRawY()) {
                    source.setY(y);
                    this.notifyChangeListener(Axis2D.Y, y);
                }
            }

            @Override
            public double getX() {
                this.notifyAccessListener(Axis2D.X);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(Axis2D.Y);
                return source.getY();
            }

            @Override
            public double getRawX() {
                return source.getRawX();
            }

            @Override
            public double getRawY() {
                return source.getRawY();
            }

            private void notifyChangeListener(Axis2D axis, double newValue) {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.accept(axis, newValue);
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis2D axis) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(axis);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector2DReadOnly) {
                    return this.equals((Vector2DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple2DString(this);
            }
        };
    }

    public static UnitVector3DBasics newObservableUnitVector3DBasics(ObjDoubleConsumer<Axis3D> valueChangedListener, Consumer<Axis3D> valueAccessedListener) {
        return EuclidCoreFactories.newObservableUnitVector3DBasics(valueChangedListener, valueAccessedListener, new UnitVector3D());
    }

    public static UnitVector3DBasics newObservableUnitVector3DBasics(final ObjDoubleConsumer<Axis3D> valueChangedListener, final Consumer<Axis3D> valueAccessedListener, final UnitVector3DBasics source) {
        return new UnitVector3DBasics(){
            private boolean isNotifying = false;

            @Override
            public void absolute() {
                boolean notifyX = this.getRawX() < 0.0;
                boolean notifyY = this.getRawY() < 0.0;
                boolean notifyZ = this.getRawY() < 0.0;
                source.absolute();
                if (notifyX) {
                    this.notifyChangeListener(Axis3D.X, this.getRawX());
                }
                if (notifyY) {
                    this.notifyChangeListener(Axis3D.Y, this.getRawY());
                }
                if (notifyZ) {
                    this.notifyChangeListener(Axis3D.Z, this.getRawZ());
                }
            }

            @Override
            public void negate() {
                source.negate();
                this.notifyChangeListener(Axis3D.X, this.getRawX());
                this.notifyChangeListener(Axis3D.Y, this.getRawY());
                this.notifyChangeListener(Axis3D.Z, this.getRawZ());
            }

            @Override
            public void markAsDirty() {
                source.markAsDirty();
            }

            @Override
            public boolean isDirty() {
                return source.isDirty();
            }

            @Override
            public void normalize() {
                boolean notify = this.isDirty();
                source.normalize();
                if (notify) {
                    this.notifyChangeListener(Axis3D.X, this.getRawX());
                    this.notifyChangeListener(Axis3D.Y, this.getRawY());
                    this.notifyChangeListener(Axis3D.Z, this.getRawZ());
                }
            }

            @Override
            public void set(UnitVector3DReadOnly other) {
                boolean notifyX = this.getRawX() != other.getRawX();
                boolean notifyY = this.getRawY() != other.getRawY();
                boolean notifyZ = this.getRawZ() != other.getRawZ();
                source.set(other);
                if (notifyX) {
                    this.notifyChangeListener(Axis3D.X, this.getRawX());
                }
                if (notifyY) {
                    this.notifyChangeListener(Axis3D.Y, this.getRawY());
                }
                if (notifyZ) {
                    this.notifyChangeListener(Axis3D.Z, this.getRawZ());
                }
            }

            @Override
            public void setX(double x) {
                if (x != source.getRawX()) {
                    source.setX(x);
                    this.notifyChangeListener(Axis3D.X, x);
                }
            }

            @Override
            public void setY(double y) {
                if (y != source.getRawY()) {
                    source.setY(y);
                    this.notifyChangeListener(Axis3D.Y, y);
                }
            }

            @Override
            public void setZ(double z) {
                if (z != this.getRawZ()) {
                    source.setZ(z);
                    this.notifyChangeListener(Axis3D.Z, z);
                }
            }

            @Override
            public double getX() {
                this.notifyAccessListener(Axis3D.X);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(Axis3D.Y);
                return source.getY();
            }

            @Override
            public double getZ() {
                this.notifyAccessListener(Axis3D.Z);
                return source.getZ();
            }

            @Override
            public double getRawX() {
                return source.getRawX();
            }

            @Override
            public double getRawY() {
                return source.getRawY();
            }

            @Override
            public double getRawZ() {
                return source.getRawZ();
            }

            private void notifyChangeListener(Axis3D axis, double newValue) {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.accept(axis, newValue);
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis3D axis) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(axis);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ());
            }

            public boolean equals(Object object) {
                if (object instanceof Vector3DReadOnly) {
                    return this.equals((Vector3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString(this);
            }
        };
    }

    public static RotationMatrixBasics newObservableRotationMatrixBasics(Runnable valueChangedListener, BiConsumer<Axis3D, Axis3D> valueAccessedListener) {
        return EuclidCoreFactories.newObservableRotationMatrixBasics(valueChangedListener, valueAccessedListener, new RotationMatrix());
    }

    public static RotationMatrixBasics newObservableRotationMatrixBasics(final Runnable valueChangedListener, final BiConsumer<Axis3D, Axis3D> valueAccessedListener, final RotationMatrixBasics source) {
        return new RotationMatrixBasics(){
            private boolean isNotifying = false;

            @Override
            public void setIdentity() {
                source.setIdentity();
                this.notifyChangeListener();
            }

            @Override
            public void setToNaN() {
                source.setToNaN();
                this.notifyChangeListener();
            }

            @Override
            public void normalize() {
                source.normalize();
                this.notifyChangeListener();
            }

            @Override
            public void transpose() {
                source.transpose();
                this.notifyChangeListener();
            }

            @Override
            public void setUnsafe(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
                source.setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
                this.notifyChangeListener();
            }

            @Override
            public void set(RotationMatrixReadOnly other) {
                if (other != source) {
                    source.set(other);
                    this.notifyChangeListener();
                }
            }

            @Override
            public boolean isDirty() {
                return source.isDirty();
            }

            @Override
            public double getM00() {
                this.notifyAccessListener(Axis3D.X, Axis3D.X);
                return source.getM00();
            }

            @Override
            public double getM01() {
                this.notifyAccessListener(Axis3D.X, Axis3D.Y);
                return source.getM01();
            }

            @Override
            public double getM02() {
                this.notifyAccessListener(Axis3D.X, Axis3D.Z);
                return source.getM02();
            }

            @Override
            public double getM10() {
                this.notifyAccessListener(Axis3D.Y, Axis3D.X);
                return source.getM10();
            }

            @Override
            public double getM11() {
                this.notifyAccessListener(Axis3D.Y, Axis3D.Y);
                return source.getM11();
            }

            @Override
            public double getM12() {
                this.notifyAccessListener(Axis3D.Y, Axis3D.Z);
                return source.getM12();
            }

            @Override
            public double getM20() {
                this.notifyAccessListener(Axis3D.Z, Axis3D.X);
                return source.getM20();
            }

            @Override
            public double getM21() {
                this.notifyAccessListener(Axis3D.Z, Axis3D.Y);
                return source.getM21();
            }

            @Override
            public double getM22() {
                this.notifyAccessListener(Axis3D.Z, Axis3D.Z);
                return source.getM22();
            }

            private void notifyChangeListener() {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.run();
                this.isNotifying = false;
            }

            private void notifyAccessListener(Axis3D row, Axis3D column) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(row, column);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getM00(), this.getM01(), this.getM02(), this.getM10(), this.getM11(), this.getM12(), this.getM20(), this.getM21(), this.getM22());
            }

            public boolean equals(Object object) {
                if (object instanceof Matrix3DReadOnly) {
                    return this.equals((Matrix3DReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getMatrix3DString(this);
            }
        };
    }

    public static QuaternionBasics newObservableQuaternionBasics(Runnable valueChangedListener, IntConsumer valueAccessedListener) {
        return EuclidCoreFactories.newObservableQuaternionBasics(valueChangedListener, valueAccessedListener, new Quaternion());
    }

    public static QuaternionBasics newObservableQuaternionBasics(final Runnable valueChangedListener, final IntConsumer valueAccessedListener, final QuaternionBasics source) {
        return new QuaternionBasics(){
            private boolean isNotifying = false;

            @Override
            public void setUnsafe(double qx, double qy, double qz, double qs) {
                source.setUnsafe(qx, qy, qz, qs);
                this.notifyChangeListener();
            }

            @Override
            public double getX() {
                this.notifyAccessListener(0);
                return source.getX();
            }

            @Override
            public double getY() {
                this.notifyAccessListener(1);
                return source.getY();
            }

            @Override
            public double getZ() {
                this.notifyAccessListener(2);
                return source.getZ();
            }

            @Override
            public double getS() {
                this.notifyAccessListener(3);
                return source.getS();
            }

            private void notifyChangeListener() {
                if (valueChangedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueChangedListener.run();
                this.isNotifying = false;
            }

            private void notifyAccessListener(int index) {
                if (valueAccessedListener == null) {
                    return;
                }
                if (this.isNotifying) {
                    return;
                }
                this.isNotifying = true;
                valueAccessedListener.accept(index);
                this.isNotifying = false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode(this.getX(), this.getY(), this.getZ(), this.getS());
            }

            public boolean equals(Object object) {
                if (object instanceof QuaternionReadOnly) {
                    return this.equals((QuaternionReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple4DString(this);
            }
        };
    }
}

