/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class RotationMatrix
implements RotationMatrixBasics,
GeometryObject<RotationMatrix> {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private double m20;
    private double m21;
    private double m22;
    private boolean dirty = false;
    private boolean isIdentity = true;

    public RotationMatrix() {
        this.setIdentity();
    }

    public RotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public RotationMatrix(double[] rotationMatrixArray) {
        this.set(rotationMatrixArray);
    }

    public RotationMatrix(DMatrix rotationMatrix) {
        this.set(rotationMatrix);
    }

    public RotationMatrix(Matrix3DReadOnly rotationMatrix) {
        this.set(rotationMatrix);
    }

    public RotationMatrix(RotationMatrixReadOnly other) {
        this.set(other);
    }

    public RotationMatrix(Orientation3DReadOnly orientation) {
        this.set(orientation);
    }

    public RotationMatrix(Vector3DReadOnly rotationVector) {
        this.setRotationVector(rotationVector);
    }

    public RotationMatrix(double yaw, double pitch, double roll) {
        this.setYawPitchRoll(yaw, pitch, roll);
    }

    @Override
    public void setIdentity() {
        this.setUnsafe(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        this.isIdentity = true;
        this.dirty = false;
    }

    @Override
    public void setToNaN() {
        this.setUnsafe(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        this.isIdentity = false;
        this.dirty = false;
    }

    @Override
    public void normalize() {
        if (this.isIdentity()) {
            this.setIdentity();
        } else {
            Matrix3DTools.normalize(this);
        }
    }

    @Override
    public boolean isIdentity() {
        if (this.dirty) {
            this.isIdentity = RotationMatrixBasics.super.isIdentity();
        }
        return this.isIdentity;
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    @Override
    public void transpose() {
        double temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
    }

    @Override
    public void setUnsafe(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.markAsDirty();
    }

    @Override
    public void set(RotationMatrix other) {
        this.set((RotationMatrixReadOnly)other);
    }

    @Override
    public void set(RotationMatrixReadOnly other) {
        this.m00 = other.getM00();
        this.m01 = other.getM01();
        this.m02 = other.getM02();
        this.m10 = other.getM10();
        this.m11 = other.getM11();
        this.m12 = other.getM12();
        this.m20 = other.getM20();
        this.m21 = other.getM21();
        this.m22 = other.getM22();
        if (other.isDirty()) {
            this.markAsDirty();
        } else {
            this.dirty = false;
            this.isIdentity = other.isIdentity();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public double getM00() {
        return this.m00;
    }

    @Override
    public double getM01() {
        return this.m01;
    }

    @Override
    public double getM02() {
        return this.m02;
    }

    @Override
    public double getM10() {
        return this.m10;
    }

    @Override
    public double getM11() {
        return this.m11;
    }

    @Override
    public double getM12() {
        return this.m12;
    }

    @Override
    public double getM20() {
        return this.m20;
    }

    @Override
    public double getM21() {
        return this.m21;
    }

    @Override
    public double getM22() {
        return this.m22;
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix3DReadOnly) {
            return this.equals((Matrix3DReadOnly)object);
        }
        return false;
    }

    @Override
    public boolean epsilonEquals(RotationMatrix other, double epsilon) {
        return RotationMatrixBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    public boolean geometricallyEquals(RotationMatrix other, double epsilon) {
        return RotationMatrixBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidCoreIOTools.getMatrix3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }
}

