/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import java.util.stream.DoubleStream;
import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.NotAPositiveDefiniteMatrixException;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;

public class Matrix3DFeaturesTest {
    private static final double EPS = 1.0E-10;

    @Test
    public void testContainsNaN() throws Exception {
        Matrix3D matrix = new Matrix3D();
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)matrix.containsNaN());
        matrix.set(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)matrix.containsNaN());
    }

    @Test
    public void testCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrix() {
        Random random = new Random(93486534L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToZero();
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToDiagonal(1.0, 3.0, 5.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.invert();
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.scale(3.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.scale(-1.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.set(4.0, -1.0, 0.0, -1.0, 3.0, -1.0, 0.0, -1.0, 2.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.invert();
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.scale(7.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.scale(-5.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToDiagonal(4.0, -3.0, 1.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.scaleM11(-1.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToDiagonal(2.0, 0.0, 1.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.addM11(1.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.set(1.0, -3.0, -3.0, -3.0, 1.0, 2.0, -3.0, 2.0, 1.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.addM00(10.0);
        matrix.addM11(10.0);
        matrix.addM22(10.0);
        this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
        for (int i = 0; i < 1000; ++i) {
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            matrix.invert();
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            double positiveScalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            matrix.scale(positiveScalar);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            Matrix3D other = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            matrix.add((Matrix3DReadOnly)other);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            other = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            matrix.multiply((Matrix3DReadOnly)other);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            Assertions.assertTrue((matrix.getM00() >= 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM11() >= 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM22() >= 0.0 ? 1 : 0) != 0);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            double negativeScalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            matrix.scale(negativeScalar);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            int diagonalToNegate = random.nextInt(3);
            matrix.setElement(diagonalToNegate, diagonalToNegate, -1.0 * matrix.getElement(diagonalToNegate, diagonalToNegate));
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            int diagonalToZero = random.nextInt(3);
            matrix.setElement(diagonalToZero, diagonalToZero, 0.0);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            int row = random.nextInt(3);
            int row2 = random.nextInt(2);
            if (row2 == row) {
                ++row2;
            }
            double[] swapArray = new double[3];
            double[] swapArray2 = new double[3];
            matrix.getRow(row, swapArray);
            matrix.getRow(row2, swapArray2);
            matrix.setRow(row, swapArray2);
            matrix.setRow(row2, swapArray);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextPositiveDefiniteMatrix3D((Random)random));
            int col = random.nextInt(3);
            int col2 = random.nextInt(2);
            if (col2 == col) {
                ++col2;
            }
            swapArray = new double[3];
            swapArray2 = new double[3];
            matrix.getColumn(col, swapArray);
            matrix.getColumn(col2, swapArray2);
            matrix.setColumn(col, swapArray2);
            matrix.setColumn(col2, swapArray);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D();
            matrix.setToDiagonal(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            boolean positiveDefinite = matrix.getM00() > 0.0 && matrix.getM11() > 0.0 && matrix.getM22() > 0.0;
            RotationMatrix rotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D afterRotation = new Matrix3D();
            rotation.transform((Matrix3DReadOnly)matrix, (Matrix3DBasics)afterRotation);
            this.testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods((Matrix3DReadOnly)afterRotation, positiveDefinite);
        }
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfPositiveDefiniteMatrix((DMatrix)new DMatrixRMaj(2, 3)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfPositiveDefiniteMatrix((DMatrix)new DMatrixRMaj(3, 2)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfPositiveDefiniteMatrix((DMatrix)new DMatrixRMaj(4, 3)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfPositiveDefiniteMatrix((DMatrix)new DMatrixRMaj(3, 4)));
    }

    private void testAllCheckIfPositiveDefiniteMatrixAndIsPositiveDefiniteMatrixMethods(Matrix3DReadOnly matrix, boolean isPositiveDefiniteMatrix) {
        int index;
        int column;
        int row;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        matrix.get((DMatrix)denseMatrix);
        DMatrixRMaj denseMatrixCopy = new DMatrixRMaj(denseMatrix);
        double[] matrixArray = new double[9];
        matrix.get(matrixArray);
        double[] matrixArrayCopy = new double[9];
        System.arraycopy(matrixArray, 0, matrixArrayCopy, 0, 9);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        try {
            Matrix3DFeatures.checkIfPositiveDefiniteMatrix((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22);
            if (!isPositiveDefiniteMatrix) {
                Assertions.fail((String)"Should have thrown a NotAPositiveDefiniteMatrixException.");
            }
        }
        catch (NotAPositiveDefiniteMatrixException e) {
            if (isPositiveDefiniteMatrix) {
                throw e;
            }
            Assertions.assertEquals((Object)e.getMessage(), (Object)("The matrix is not a positive definite matrix: \n" + matrix.toString(null)));
        }
        Assertions.assertEquals((Object)Matrix3DFeatures.isPositiveDefiniteMatrix((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (Object)isPositiveDefiniteMatrix);
        try {
            matrix.checkIfPositiveDefiniteMatrix();
            if (!isPositiveDefiniteMatrix) {
                Assertions.fail((String)"Should have thrown a NotAPositiveDefiniteMatrixException.");
            }
        }
        catch (NotAPositiveDefiniteMatrixException e) {
            if (isPositiveDefiniteMatrix) {
                throw e;
            }
            Assertions.assertEquals((Object)e.getMessage(), (Object)("The matrix is not a positive definite matrix: \n" + matrix.toString(null)));
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
        Assertions.assertEquals((Object)matrix.isPositiveDefiniteMatrix(), (Object)isPositiveDefiniteMatrix);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
        try {
            Matrix3DFeatures.checkIfPositiveDefiniteMatrix((DMatrix)denseMatrix);
            if (!isPositiveDefiniteMatrix) {
                Assertions.fail((String)"Should have thrown a NotAPositiveDefiniteMatrixException.");
            }
        }
        catch (NotAPositiveDefiniteMatrixException e) {
            if (isPositiveDefiniteMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("The matrix is not a positive definite matrix: \n" + matrix.toString(null)));
        }
        for (int index2 = 0; index2 < denseMatrix.getNumElements(); ++index2) {
            Assertions.assertEquals((int)0, (int)Double.compare(denseMatrix.get(index2), denseMatrixCopy.get(index2)));
        }
        Assertions.assertEquals((Object)Matrix3DFeatures.isPositiveDefiniteMatrix((DMatrix)denseMatrix), (Object)isPositiveDefiniteMatrix);
        try {
            Matrix3DFeatures.checkIfPositiveDefiniteMatrix((double[])matrixArray);
            if (!isPositiveDefiniteMatrix) {
                Assertions.fail((String)"Should have thrown a NotAPositiveDefiniteMatrixException.");
            }
        }
        catch (NotAPositiveDefiniteMatrixException e) {
            if (isPositiveDefiniteMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("The matrix is not a positive definite matrix: \n" + matrix.toString(null)));
        }
        for (index = 0; index < 9; ++index) {
            Assertions.assertEquals((int)0, (int)Double.compare(matrixArray[index], matrixArrayCopy[index]));
        }
        Assertions.assertEquals((Object)Matrix3DFeatures.isPositiveDefiniteMatrix((double[])matrixArray), (Object)isPositiveDefiniteMatrix);
        for (index = 0; index < 9; ++index) {
            Assertions.assertEquals((int)0, (int)Double.compare(matrixArray[index], matrixArrayCopy[index]));
        }
    }

    @Test
    public void testCheckIfRotationMatrixAndIsRotationMatrix() {
        Random random = new Random(93486534L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToZero();
        this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            int row = random.nextInt(3);
            int column = random.nextInt(3);
            matrix.setElement(row, column, matrix.getElement(row, column) + random.nextDouble());
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)1.5);
            matrix.setElement(row, 0, scale * matrix.getElement(row, 0));
            matrix.setElement(row, 1, scale * matrix.getElement(row, 1));
            matrix.setElement(row, 2, scale * matrix.getElement(row, 2));
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            column = random.nextInt(3);
            scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)1.5);
            matrix.setElement(0, column, scale * matrix.getElement(0, column));
            matrix.setElement(1, column, scale * matrix.getElement(1, column));
            matrix.setElement(2, column, scale * matrix.getElement(2, column));
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            column = random.nextInt(3);
            double previousValue = matrix.getElement(row, column);
            matrix.setElement(row, column, 0.0);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, Math.abs(previousValue) < 1.0E-7);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            column = random.nextInt(3);
            int row2 = random.nextInt(2);
            int column2 = random.nextInt(2);
            if (row2 == row) {
                ++row2;
            }
            if (column2 == column) {
                ++column2;
            }
            double temp = matrix.getElement(row, column);
            matrix.setElement(row, column, matrix.getElement(row2, column2));
            matrix.setElement(row2, column2, temp);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            row2 = random.nextInt(2);
            if (row2 == row) {
                ++row2;
            }
            double[] swapArray = new double[3];
            double[] swapArray2 = new double[3];
            matrix.getRow(row, swapArray);
            matrix.getRow(row2, swapArray2);
            matrix.setRow(row, swapArray2);
            matrix.setRow(row2, swapArray);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            column = random.nextInt(3);
            column2 = random.nextInt(2);
            if (column2 == column) {
                ++column2;
            }
            matrix.getColumn(column, swapArray);
            matrix.getColumn(column2, swapArray2);
            matrix.setColumn(column, swapArray2);
            matrix.setColumn(column2, swapArray);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
        }
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(2, 3)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 2)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(4, 3)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 4)));
    }

    private void testAllCheckIfRotationMatrixAndIsRotationMatrixMethods(Matrix3DReadOnly matrix, boolean isRotationMatrix) {
        int index;
        int column;
        int row;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        matrix.get((DMatrix)denseMatrix);
        DMatrixRMaj denseMatrixCopy = new DMatrixRMaj(denseMatrix);
        double[] matrixArray = new double[9];
        matrix.get(matrixArray);
        double[] matrixArrayCopy = new double[9];
        System.arraycopy(matrixArray, 0, matrixArrayCopy, 0, 9);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        try {
            Matrix3DFeatures.checkIfRotationMatrix((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22);
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertEquals((Object)e.getMessage(), (Object)("The matrix is not a rotation matrix: \n" + matrix.toString(null)));
        }
        Assertions.assertEquals((Object)Matrix3DFeatures.isRotationMatrix((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (Object)isRotationMatrix);
        try {
            matrix.checkIfRotationMatrix();
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertEquals((Object)e.getMessage(), (Object)("The matrix is not a rotation matrix: \n" + matrix.toString(null)));
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
        Assertions.assertEquals((Object)matrix.isRotationMatrix(), (Object)isRotationMatrix);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)denseMatrix);
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("The matrix is not a rotation matrix: \n" + matrix.toString(null)));
        }
        for (int index2 = 0; index2 < denseMatrix.getNumElements(); ++index2) {
            Assertions.assertEquals((int)0, (int)Double.compare(denseMatrix.get(index2), denseMatrixCopy.get(index2)));
        }
        Assertions.assertEquals((Object)Matrix3DFeatures.isRotationMatrix((DMatrix)denseMatrix), (Object)isRotationMatrix);
        try {
            Matrix3DFeatures.checkIfRotationMatrix((double[])matrixArray);
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("The matrix is not a rotation matrix: \n" + matrix.toString(null)));
        }
        for (index = 0; index < 9; ++index) {
            Assertions.assertEquals((int)0, (int)Double.compare(matrixArray[index], matrixArrayCopy[index]));
        }
        Assertions.assertEquals((Object)Matrix3DFeatures.isRotationMatrix((double[])matrixArray), (Object)isRotationMatrix);
        for (index = 0; index < 9; ++index) {
            Assertions.assertEquals((int)0, (int)Double.compare(matrixArray[index], matrixArrayCopy[index]));
        }
    }

    @Test
    public void testCheckIfMatrix2DAndIsMatrix2D() {
        Random random = new Random(93486534L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToZero();
        this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D randomMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            randomMatrix.setM02(0.0);
            randomMatrix.setM20(0.0);
            randomMatrix.setM12(0.0);
            randomMatrix.setM21(0.0);
            randomMatrix.setM22(1.0);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, true);
            double delta = random.nextBoolean() ? 1.0 : -1.0;
            randomMatrix.setM22(1.0 + (delta *= random.nextDouble()));
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM22(1.0);
            randomMatrix.setM02(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM02(0.0);
            randomMatrix.setM20(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM20(0.0);
            randomMatrix.setM12(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM12(0.0);
            randomMatrix.setM21(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
        }
    }

    private void testCheckIfMatrix2DAndIsMatrix2DMethods(Matrix3DReadOnly matrix, boolean isMatrix2D) {
        int column;
        int row;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        String matrixAsString = EuclidCoreIOTools.getMatrix3DString(null, (double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22);
        Assertions.assertEquals((Object)Matrix3DFeatures.isMatrix2D((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-8), (Object)isMatrix2D);
        try {
            matrix.checkIfMatrix2D();
            if (!isMatrix2D) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
            }
        }
        catch (NotAMatrix2DException e) {
            if (isMatrix2D) {
                throw e;
            }
            Assertions.assertEquals((Object)e.getMessage(), (Object)("The matrix is not in XY plane: \n" + matrixAsString));
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
        Assertions.assertEquals((Object)matrix.isMatrix2D(), (Object)isMatrix2D);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
    }

    @Test
    public void testCheckMatrixSize() {
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(2, 3));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"Unexpected matrix size: 2-by-3. Must be 3-by-3.", (Object)e.getMessage());
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 2));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"Unexpected matrix size: 3-by-2. Must be 3-by-3.", (Object)e.getMessage());
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(4, 3));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"Unexpected matrix size: 4-by-3. Must be 3-by-3.", (Object)e.getMessage());
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 4));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"Unexpected matrix size: 3-by-4. Must be 3-by-3.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeterminant() {
        double detScaled;
        double[] row2;
        double detSwapped;
        double temp2;
        double temp1;
        double temp0;
        double[] column2;
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        int i;
        Random random = new Random(641651L);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        Matrix3D identity = new Matrix3D();
        identity.setIdentity();
        Assertions.assertEquals((double)1.0, (double)identity.determinant(), (double)1.0E-10);
        Assertions.assertEquals((double)1.0, (double)Matrix3DFeatures.determinant((double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0), (double)1.0E-10);
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Assertions.assertEquals((double)1.0, (double)rotationMatrix.determinant(), (double)1.0E-10);
            double m00 = rotationMatrix.getM00();
            double m01 = rotationMatrix.getM01();
            double m02 = rotationMatrix.getM02();
            m10 = rotationMatrix.getM10();
            m11 = rotationMatrix.getM11();
            m12 = rotationMatrix.getM12();
            m20 = rotationMatrix.getM20();
            m21 = rotationMatrix.getM21();
            m22 = rotationMatrix.getM22();
            Assertions.assertEquals((double)1.0, (double)Matrix3DFeatures.determinant((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            int zeroColumn = random.nextInt(3);
            double[] row0 = new double[3];
            double[] row1 = new double[3];
            double[] row22 = new double[3];
            for (int column = 0; column < 3; ++column) {
                row0[column] = column == zeroColumn ? 0.0 : random.nextDouble();
                row1[column] = column == zeroColumn ? 0.0 : random.nextDouble();
                row22[column] = column == zeroColumn ? 0.0 : random.nextDouble();
            }
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row22[0], (double)row22[1], (double)row22[2]);
            Assertions.assertEquals((double)0.0, (double)det, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] column0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] column1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            column2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            int rowSwap1 = random.nextInt(3);
            int rowSwap2 = (rowSwap1 + 1 + random.nextInt(2)) % 3;
            temp0 = column0[rowSwap1];
            temp1 = column1[rowSwap1];
            temp2 = column2[rowSwap1];
            column0[rowSwap1] = column0[rowSwap2];
            column1[rowSwap1] = column1[rowSwap2];
            column2[rowSwap1] = column2[rowSwap2];
            column0[rowSwap2] = temp0;
            column1[rowSwap2] = temp1;
            column2[rowSwap2] = temp2;
            detSwapped = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            Assertions.assertEquals((double)detSwapped, (double)(-det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] row0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] row1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            row2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            int columnSwap1 = random.nextInt(3);
            int columnSwap2 = (columnSwap1 + 1 + random.nextInt(2)) % 3;
            temp0 = row0[columnSwap1];
            temp1 = row1[columnSwap1];
            temp2 = row2[columnSwap1];
            row0[columnSwap1] = row0[columnSwap2];
            row1[columnSwap1] = row1[columnSwap2];
            row2[columnSwap1] = row2[columnSwap2];
            row0[columnSwap2] = temp0;
            row1[columnSwap2] = temp1;
            row2[columnSwap2] = temp2;
            detSwapped = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            Assertions.assertEquals((double)detSwapped, (double)(-det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] column0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] column1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            column2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            int rowScale = random.nextInt(3);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            int n = rowScale;
            column0[n] = column0[n] * scale;
            int n2 = rowScale;
            column1[n2] = column1[n2] * scale;
            int n3 = rowScale;
            column2[n3] = column2[n3] * scale;
            detScaled = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            Assertions.assertEquals((double)detScaled, (double)(scale * det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] row0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] row1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            row2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            int columnScale = random.nextInt(3);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            int n = columnScale;
            row0[n] = row0[n] * scale;
            int n4 = columnScale;
            row1[n4] = row1[n4] * scale;
            int n5 = columnScale;
            row2[n5] = row2[n5] * scale;
            detScaled = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            Assertions.assertEquals((double)detScaled, (double)(scale * det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] column0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] column1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            column2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            int rowCopyDest = random.nextInt(3);
            int rowCopySrc = (rowCopyDest + 1 + random.nextInt(2)) % 3;
            column0[rowCopyDest] = column0[rowCopySrc];
            column1[rowCopyDest] = column1[rowCopySrc];
            column2[rowCopyDest] = column2[rowCopySrc];
            double det = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            Assertions.assertEquals((double)0.0, (double)det, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] row0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] row1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            row2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            int columnCopyDest = random.nextInt(3);
            int columnCopySrc = (columnCopyDest + 1 + random.nextInt(2)) % 3;
            row0[columnCopyDest] = row0[columnCopySrc];
            row1[columnCopyDest] = row1[columnCopySrc];
            row2[columnCopyDest] = row2[columnCopySrc];
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            Assertions.assertEquals((double)0.0, (double)det, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Matrix3D matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrix.get((DMatrix)denseMatrix);
            Assertions.assertEquals((double)CommonOps_DDRM.det((DMatrixRMaj)denseMatrix), (double)matrix.determinant(), (double)1.0E-10);
            double m00 = matrix.getM00();
            double m01 = matrix.getM01();
            double m02 = matrix.getM02();
            m10 = matrix.getM10();
            m11 = matrix.getM11();
            m12 = matrix.getM12();
            m20 = matrix.getM20();
            m21 = matrix.getM21();
            m22 = matrix.getM22();
            Assertions.assertEquals((double)CommonOps_DDRM.det((DMatrixRMaj)denseMatrix), (double)Matrix3DFeatures.determinant((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (double)1.0E-10);
        }
    }

    @Test
    public void testIsIdentity() {
        Random random = new Random(982364L);
        Matrix3D matrix = new Matrix3D();
        matrix.setToZero();
        this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, false);
        matrix.setIdentity();
        this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, true);
        for (int i = 0; i < 1000; ++i) {
            double delta = random.nextBoolean() ? 1.0 : -1.0;
            matrix.setIdentity();
            matrix.setM00(matrix.getM00() + (delta *= random.nextDouble()));
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM01(matrix.getM01() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM02(matrix.getM02() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM10(matrix.getM10() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM11(matrix.getM11() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM12(matrix.getM12() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM20(matrix.getM20() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM21(matrix.getM21() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM22(matrix.getM22() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
        }
    }

    private void testAllIsIdentityMethods(Matrix3DReadOnly matrix, boolean isIdentity) {
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        Assertions.assertEquals((Object)Matrix3DFeatures.isIdentity((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (Object)isIdentity);
        Assertions.assertEquals((Object)Matrix3DFeatures.isIdentity((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-12), (Object)isIdentity);
        Assertions.assertEquals((Object)matrix.isIdentity(1.0E-12), (Object)isIdentity);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
    }

    @Test
    public void testIsZero() {
        Random random = new Random(982364L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToZero();
        this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, true);
        for (int i = 0; i < 1000; ++i) {
            double delta = random.nextBoolean() ? 1.0 : -1.0;
            matrix.setToZero();
            matrix.setM00(matrix.getM00() + (delta *= random.nextDouble()));
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM01(matrix.getM01() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM02(matrix.getM02() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM10(matrix.getM10() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM11(matrix.getM11() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM12(matrix.getM12() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM20(matrix.getM20() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM21(matrix.getM21() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM22(matrix.getM22() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
        }
    }

    private void testAllIsZeroMethods(Matrix3DReadOnly matrix, boolean isZero) {
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        Assertions.assertEquals((Object)Matrix3DFeatures.isZero((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (Object)isZero);
        Assertions.assertEquals((Object)Matrix3DFeatures.isZero((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-12), (Object)isZero);
        Assertions.assertEquals((Object)matrix.isZero(1.0E-12), (Object)isZero);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
    }

    @Test
    public void testIsMatrixSkewSymmetric() {
        Random random = new Random(982364L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixCorrupted = new Matrix3D();
        matrix.setToZero();
        this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setIdentity();
        this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            matrix.setToZero();
            matrix.setM01(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM02(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM12(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM10(-matrix.getM01());
            matrix.setM20(-matrix.getM02());
            matrix.setM21(-matrix.getM12());
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, true);
            double delta = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7);
            boolean isSkewSymmetric = Math.abs(delta) < 1.0E-8;
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM00(matrixCorrupted.getM00() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM01(matrixCorrupted.getM01() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM02(matrixCorrupted.getM02() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM10(matrixCorrupted.getM10() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM11(matrixCorrupted.getM11() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM12(matrixCorrupted.getM12() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM20(matrixCorrupted.getM20() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM21(matrixCorrupted.getM21() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM22(matrixCorrupted.getM22() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
        }
    }

    private void testAllIsMatrixSkewSymmetrixMethods(Matrix3DReadOnly matrix, boolean isSkewSymmetric) {
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        Assertions.assertEquals((Object)Matrix3DFeatures.isMatrixSkewSymmetric((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (Object)isSkewSymmetric);
        Assertions.assertEquals((Object)Matrix3DFeatures.isMatrixSkewSymmetric((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-8), (Object)isSkewSymmetric);
        Assertions.assertEquals((Object)matrix.isMatrixSkewSymmetric(1.0E-8), (Object)isSkewSymmetric);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
    }

    @Test
    public void testIsMatrixSymmetric() {
        Random random = new Random(43676L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixCorrupted = new Matrix3D();
        matrix.setToZero();
        this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setIdentity();
        this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToNaN();
        this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            matrix.setM01(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM02(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM12(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM10(matrix.getM01());
            matrix.setM20(matrix.getM02());
            matrix.setM21(matrix.getM12());
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, true);
            double delta = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7);
            boolean isSymmetric = Math.abs(delta) < 1.0E-8;
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM01(matrixCorrupted.getM01() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM02(matrixCorrupted.getM02() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM12(matrixCorrupted.getM12() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM10(matrixCorrupted.getM10() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM20(matrixCorrupted.getM20() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set(matrix);
            matrixCorrupted.setM21(matrixCorrupted.getM21() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
        }
    }

    private void testAllIsMatrixSymmetrixMethods(Matrix3DReadOnly matrix, boolean isSymmetric) {
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        Assertions.assertEquals((Object)Matrix3DFeatures.isMatrixSymmetric((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (Object)isSymmetric);
        Assertions.assertEquals((Object)Matrix3DFeatures.isMatrixSymmetric((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-8), (Object)isSymmetric);
        Assertions.assertEquals((Object)matrix.isMatrixSymmetric(1.0E-8), (Object)isSymmetric);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertEquals((int)0, (int)Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)));
            }
        }
    }

    @Test
    public void testMaxElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).max().getAsDouble(), (double)new Matrix3D(coeffs).maxElement());
        }
    }

    @Test
    public void testMaxAbsElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).map(Math::abs).max().getAsDouble(), (double)new Matrix3D(coeffs).maxAbsElement());
        }
    }

    @Test
    public void testMinElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).min().getAsDouble(), (double)new Matrix3D(coeffs).minElement());
        }
    }

    @Test
    public void testMinAbsElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).map(Math::abs).min().getAsDouble(), (double)new Matrix3D(coeffs).minAbsElement());
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(346L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3D delta = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            double epsilon = random.nextDouble();
            delta.fill(0.1 * epsilon);
            m2.add((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
            Assertions.assertTrue((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
            m2.sub((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
            Assertions.assertTrue((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    delta.fill(0.1 * epsilon);
                    delta.setElement(row, column, 1.1 * epsilon);
                    m2.add((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
                    m2.sub((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
                }
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(346L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        double smallestEpsilon = 1.0E-15;
        Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, null));
        Assertions.assertFalse((boolean)Matrix3DFeatures.equals(null, (Matrix3DReadOnly)m2));
        Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)new RotationMatrix(), (Matrix3DReadOnly)m2));
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            m2.set(m1);
            Assertions.assertTrue((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2));
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    m2.set(m1);
                    m2.setElement(row, column, m2.getElement(row, column) + smallestEpsilon);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2));
                    m2.set(m1);
                    m2.setElement(row, column, m2.getElement(row, column) - smallestEpsilon);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2));
                }
            }
        }
    }
}

