/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

class EuclidPolytopeFactoriesTest {
    public static final int ITERATIONS = 1000;
    public static final double EPSILON = 1.0E-12;

    EuclidPolytopeFactoriesTest() {
    }

    @Test
    void testNewIcosahedron() {
        Random random = new Random(23049723L);
        for (int i = 0; i < 1000; ++i) {
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            ConvexPolytope3D icosahedron = EuclidPolytopeFactories.newIcosahedron((double)radius);
            Assertions.assertEquals((int)12, (int)icosahedron.getNumberOfVertices());
            Assertions.assertEquals((int)20, (int)icosahedron.getNumberOfFaces());
            Assertions.assertEquals((int)30, (int)icosahedron.getNumberOfEdges());
            icosahedron.getVertices().forEach(vertex -> Assertions.assertEquals((double)radius, (double)vertex.distanceFromOrigin(), (double)1.0E-12));
            icosahedron.getHalfEdges().forEach(edge -> Assertions.assertEquals((double)EuclidShapeTools.icosahedronEdgeLength((double)radius), (double)edge.getDirection(false).norm(), (double)1.0E-12));
            Assertions.assertEquals((double)EuclidShapeTools.icosahedronVolume((double)EuclidShapeTools.icosahedronEdgeLength((double)radius)), (double)icosahedron.getVolume(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(), (EuclidGeometry)icosahedron.getCentroid(), (double)1.0E-12);
        }
    }

    @Test
    void testNewIcoSphere() throws Exception {
        Random random = new Random(3463634L);
        for (int i = 0; i < 1000; ++i) {
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            int recursionLevel = random.nextInt(3);
            ConvexPolytope3D icoSphere = EuclidPolytopeFactories.newIcoSphere((double)radius, (int)recursionLevel);
            icoSphere.getVertices().forEach(vertex -> Assertions.assertEquals((double)radius, (double)vertex.distanceFromOrigin(), (double)1.0E-12));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(), (EuclidGeometry)icoSphere.getCentroid(), (double)1.0E-12);
        }
    }

    @Test
    void testNewCone() throws Exception {
        Random random = new Random(0x88A899L);
        for (int i = 0; i < 1000; ++i) {
            double height = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            int numberOfDivisions = random.nextInt(100) + 3;
            ConvexPolytope3D cone = EuclidPolytopeFactories.newCone((double)height, (double)radius, (int)numberOfDivisions);
            Assertions.assertEquals((int)(numberOfDivisions + 1), (int)cone.getNumberOfVertices());
            Assertions.assertEquals((int)(numberOfDivisions + 1), (int)cone.getNumberOfFaces());
            Assertions.assertEquals((int)(2 * numberOfDivisions), (int)cone.getNumberOfEdges());
            Point3D topVertex = new Point3D(0.0, 0.0, height);
            Assertions.assertEquals((long)1L, (long)cone.getVertices().stream().filter(vertex -> vertex.epsilonEquals((EuclidGeometry)topVertex, 1.0E-12)).count());
            cone.getVertices().stream().filter(vertex -> !vertex.epsilonEquals((EuclidGeometry)topVertex, 1.0E-12)).peek(baseVertex -> Assertions.assertEquals((double)0.0, (double)baseVertex.getZ(), (double)1.0E-12)).forEach(baseVertex -> Assertions.assertEquals((double)radius, (double)baseVertex.distanceFromOrigin(), (double)1.0E-12));
            Vector3D baseNormal = new Vector3D(0.0, 0.0, -1.0);
            Assertions.assertEquals((long)1L, (long)cone.getFaces().stream().filter(face -> face.getNormal().epsilonEquals((EuclidGeometry)baseNormal, 1.0E-12)).count());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, 0.25 * height), (EuclidGeometry)cone.getCentroid(), (double)1.0E-12);
        }
    }

    @Test
    void testNewCube() throws Exception {
        Random random = new Random(34563575L);
        for (int i = 0; i < 1000; ++i) {
            double edgeLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            ConvexPolytope3D cube = EuclidPolytopeFactories.newCube((double)edgeLength);
            Assertions.assertEquals((int)8, (int)cube.getNumberOfVertices());
            Assertions.assertEquals((int)12, (int)cube.getNumberOfEdges());
            Assertions.assertEquals((int)6, (int)cube.getNumberOfFaces());
            Point3D absoluteVertex = new Point3D(edgeLength, edgeLength, edgeLength);
            absoluteVertex.scale(0.5);
            cube.getVertices().stream().map(Point3D::new).peek(Tuple3DBasics::absolute).forEach(vertex -> EuclidCoreTestTools.assertEquals((EuclidGeometry)vertex, (EuclidGeometry)absoluteVertex, (double)1.0E-12));
            Assertions.assertEquals((double)(edgeLength * edgeLength * edgeLength), (double)cube.getVolume(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(), (EuclidGeometry)cube.getCentroid(), (double)1.0E-12);
            for (Face3D face : cube.getFaces()) {
                Vector3D expectedNormal;
                if (EuclidCoreTools.epsilonEquals((double)(0.5 * edgeLength), (double)Math.abs(face.getCentroid().getX()), (double)1.0E-12)) {
                    expectedNormal = new Vector3D((Tuple3DReadOnly)Axis3D.X);
                    if (face.getCentroid().getX() < 0.0) {
                        expectedNormal.negate();
                    }
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
                    continue;
                }
                if (EuclidCoreTools.epsilonEquals((double)(0.5 * edgeLength), (double)Math.abs(face.getCentroid().getY()), (double)1.0E-12)) {
                    expectedNormal = new Vector3D((Tuple3DReadOnly)Axis3D.Y);
                    if (face.getCentroid().getY() < 0.0) {
                        expectedNormal.negate();
                    }
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
                    continue;
                }
                if (EuclidCoreTools.epsilonEquals((double)(0.5 * edgeLength), (double)Math.abs(face.getCentroid().getZ()), (double)1.0E-12)) {
                    expectedNormal = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
                    if (face.getCentroid().getZ() < 0.0) {
                        expectedNormal.negate();
                    }
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
                    continue;
                }
                Assertions.fail((String)("Unexpected face's centroid: " + String.valueOf(face.getCentroid()) + ", edge length: " + edgeLength));
            }
        }
    }

    @Test
    void testNewCylinder() throws Exception {
        Random random = new Random(345343L);
        for (int i = 0; i < 1000; ++i) {
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            int numberOfDivisions = random.nextInt(100) + 3;
            ConvexPolytope3D cylinder = EuclidPolytopeFactories.newCylinder((double)length, (double)radius, (int)numberOfDivisions);
            Assertions.assertEquals((int)(2 * numberOfDivisions), (int)cylinder.getNumberOfVertices());
            Assertions.assertEquals((int)(3 * numberOfDivisions), (int)cylinder.getNumberOfEdges());
            Assertions.assertEquals((int)(numberOfDivisions + 2), (int)cylinder.getNumberOfFaces());
            cylinder.getVertices().stream().map(Point2D::new).forEach(vertex -> Assertions.assertEquals((double)radius, (double)vertex.distanceFromOrigin(), (double)1.0E-12));
            cylinder.getVertices().stream().forEach(vertex -> Assertions.assertEquals((double)(0.5 * length), (double)Math.abs(vertex.getZ()), (double)1.0E-12));
            for (Face3D face : cylinder.getFaces()) {
                if (EuclidCoreTools.epsilonEquals((double)(radius * EuclidCoreTools.cos((double)(Math.PI / (double)numberOfDivisions))), (double)face.getCentroid().distanceXY((Point2DReadOnly)new Point2D()), (double)1.0E-12)) {
                    Assertions.assertEquals((double)0.0, (double)face.getNormal().getZ(), (double)1.0E-12);
                    Vector3D expectedNormal = new Vector3D((Tuple3DReadOnly)face.getCentroid());
                    expectedNormal.normalize();
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)face.getNormal(), (double)1.0E-12);
                    continue;
                }
                if (EuclidCoreTools.epsilonEquals((double)0.0, (double)face.getCentroid().distanceXY((Point2DReadOnly)new Point2D()), (double)1.0E-12)) {
                    if (face.getCentroid().getZ() < 0.0) {
                        Assertions.assertEquals((double)-1.0, (double)face.getNormal().getZ(), (double)1.0E-12);
                        continue;
                    }
                    Assertions.assertEquals((double)1.0, (double)face.getNormal().getZ(), (double)1.0E-12);
                    continue;
                }
                Assertions.fail((String)("Unexpected face's centroid: " + String.valueOf(face.getCentroid())));
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(), (EuclidGeometry)cylinder.getCentroid(), (double)1.0E-12);
        }
    }

    @Test
    void testNewPyramid() throws Exception {
        Random random = new Random(354355L);
        for (int i = 0; i < 1000; ++i) {
            double height = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double baseLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double baseWidth = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            ConvexPolytope3D pyramid = EuclidPolytopeFactories.newPyramid((double)height, (double)baseLength, (double)baseWidth);
            Assertions.assertEquals((int)5, (int)pyramid.getNumberOfVertices());
            Assertions.assertEquals((int)5, (int)pyramid.getNumberOfFaces());
            Assertions.assertEquals((int)8, (int)pyramid.getNumberOfEdges());
            Point3D topVertex = new Point3D(0.0, 0.0, height);
            Assertions.assertEquals((long)1L, (long)pyramid.getVertices().stream().filter(vertex -> vertex.epsilonEquals((EuclidGeometry)topVertex, 1.0E-12)).count());
            pyramid.getVertices().stream().filter(vertex -> !vertex.epsilonEquals((EuclidGeometry)topVertex, 1.0E-12)).peek(baseVertex -> Assertions.assertEquals((double)(0.5 * baseLength), (double)Math.abs(baseVertex.getX()), (double)1.0E-12)).peek(baseVertex -> Assertions.assertEquals((double)(0.5 * baseWidth), (double)Math.abs(baseVertex.getY()), (double)1.0E-12)).forEach(baseVertex -> Assertions.assertEquals((double)0.0, (double)baseVertex.getZ(), (double)1.0E-12));
            Assertions.assertEquals((double)EuclidShapeTools.pyramidVolume((double)height, (double)baseLength, (double)baseWidth), (double)pyramid.getVolume(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, 0.25 * height), (EuclidGeometry)pyramid.getCentroid(), (double)1.0E-12);
        }
    }
}

