/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.TranslationReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class TranslationReferenceFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testUpdateInMiddleFrameAtConstruction() {
        FrameVector3D translation1 = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.1, 0.13, 0.45);
        TranslationReferenceFrame frame1 = new TranslationReferenceFrame("frame1", ReferenceFrame.getWorldFrame(), (FrameVector3DReadOnly)translation1);
        FrameVector3D translation2 = new FrameVector3D((ReferenceFrame)frame1, 0.7, 0.26, 0.09);
        TranslationReferenceFrame frame2 = new TranslationReferenceFrame("frame2", (ReferenceFrame)frame1, (FrameVector3DReadOnly)translation2);
        FrameVector3D translation3 = new FrameVector3D((ReferenceFrame)frame2, 0.04, 0.023, 0.067);
        TranslationReferenceFrame frame3 = new TranslationReferenceFrame("frame3", (ReferenceFrame)frame2, (FrameVector3DReadOnly)translation3);
        frame1.setTranslationAndUpdate((FrameTuple3DReadOnly)translation1);
        frame2.setTranslationAndUpdate((FrameTuple3DReadOnly)translation2);
        frame3.setTranslationAndUpdate((FrameTuple3DReadOnly)translation3);
        RigidBodyTransform transformToDesiredFrame = frame3.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        Vector3D totalTranslation = new Vector3D();
        Vector3D expectedTranslation = new Vector3D((Tuple3DReadOnly)translation1);
        expectedTranslation.add((Tuple3DReadOnly)translation2);
        expectedTranslation.add((Tuple3DReadOnly)translation3);
        totalTranslation.set((Tuple3DReadOnly)transformToDesiredFrame.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)totalTranslation, (double)1.0E-7);
        translation2.set(0.33, 0.44, 0.11);
        frame2.setTranslationAndUpdate((FrameTuple3DReadOnly)translation2);
        transformToDesiredFrame = frame3.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        totalTranslation = new Vector3D();
        expectedTranslation = new Vector3D((Tuple3DReadOnly)translation1);
        expectedTranslation.add((Tuple3DReadOnly)translation2);
        expectedTranslation.add((Tuple3DReadOnly)translation3);
        totalTranslation.set((Tuple3DReadOnly)transformToDesiredFrame.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)totalTranslation, (double)1.0E-7);
    }

    @Test
    public void testUpdateInMiddleFrame() {
        TranslationReferenceFrame frame1 = new TranslationReferenceFrame("frame1", ReferenceFrame.getWorldFrame());
        TranslationReferenceFrame frame2 = new TranslationReferenceFrame("frame2", (ReferenceFrame)frame1);
        TranslationReferenceFrame frame3 = new TranslationReferenceFrame("frame3", (ReferenceFrame)frame2);
        Vector3D translation1 = new Vector3D(0.1, 0.13, 0.45);
        Vector3D translation2 = new Vector3D(0.7, 0.26, 0.09);
        Vector3D translation3 = new Vector3D(0.04, 0.023, 0.067);
        frame1.setTranslationAndUpdate((Tuple3DReadOnly)translation1);
        frame2.setTranslationAndUpdate((Tuple3DReadOnly)translation2);
        frame3.setTranslationAndUpdate((Tuple3DReadOnly)translation3);
        RigidBodyTransform transformToDesiredFrame = frame3.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        Vector3D totalTranslation = new Vector3D();
        Vector3D expectedTranslation = new Vector3D((Tuple3DReadOnly)translation1);
        expectedTranslation.add((Tuple3DReadOnly)translation2);
        expectedTranslation.add((Tuple3DReadOnly)translation3);
        totalTranslation.set((Tuple3DReadOnly)transformToDesiredFrame.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)totalTranslation, (double)1.0E-7);
        translation2.set(0.33, 0.44, 0.11);
        frame2.setTranslationAndUpdate((Tuple3DReadOnly)translation2);
        transformToDesiredFrame = frame3.getTransformToDesiredFrame(ReferenceFrame.getWorldFrame());
        totalTranslation = new Vector3D();
        expectedTranslation = new Vector3D((Tuple3DReadOnly)translation1);
        expectedTranslation.add((Tuple3DReadOnly)translation2);
        expectedTranslation.add((Tuple3DReadOnly)translation3);
        totalTranslation.set((Tuple3DReadOnly)transformToDesiredFrame.getTranslation());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)totalTranslation, (double)1.0E-7);
    }
}

