/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.LinearTransform3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.Matrix3DBasicsTest;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public class LinearTransform3DTest
extends Matrix3DBasicsTest<LinearTransform3D> {
    private static final double SMALL_EPSILON = 1.0E-12;
    private static final double MID_EPSILON = 1.0E-9;
    private static final double LARGE_EPSILON = 1.0E-7;
    private static final int ITERATIONS = 10000;

    @Override
    public LinearTransform3D createEmptyMatrix() {
        return new LinearTransform3D();
    }

    @Override
    public LinearTransform3D createMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return new LinearTransform3D(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Override
    public LinearTransform3D createRandomMatrix(Random random) {
        return EuclidCoreRandomTools.nextLinearTransform3D((Random)random, (double)0.1, (double)5.0);
    }

    @Test
    public void testConstructor() {
        LinearTransform3D linearTransform3D;
        int i;
        Random random = new Random(762834L);
        LinearTransform3D linearTransform3D2 = new LinearTransform3D();
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)EuclidCoreTools.identityMatrix3D, (Matrix3DReadOnly)linearTransform3D2, (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D2.getAsQuaternion(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D2.getPreScaleQuaternion(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D2.getPostScaleQuaternion(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(1.0, 1.0, 1.0), (EuclidGeometry)linearTransform3D2.getScaleVector(), (double)0.0);
        Assertions.assertTrue((boolean)linearTransform3D2.isIdentity());
        Assertions.assertTrue((boolean)linearTransform3D2.isRotationMatrix());
        for (i = 0; i < 10000; ++i) {
            Matrix3D matrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            linearTransform3D = new LinearTransform3D((Matrix3DReadOnly)matrix3D);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix3D, (Matrix3DReadOnly)linearTransform3D, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            DMatrixRMaj matrix = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)3, (int)3, (double)10.0);
            linearTransform3D = new LinearTransform3D((DMatrix)matrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new Matrix3D((DMatrix)matrix), (Matrix3DReadOnly)linearTransform3D, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            linearTransform3D = new LinearTransform3D((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (Matrix3DReadOnly)linearTransform3D, (double)1.0E-12);
        }
    }

    @Override
    @Test
    public void testSetIdentity() throws Exception {
        super.testSetIdentity();
        Random random = new Random(76435L);
        for (int i = 0; i < 10000; ++i) {
            LinearTransform3D linearTransform3D = EuclidCoreRandomTools.nextLinearTransform3D((Random)random, (double)10.0);
            linearTransform3D.setIdentity();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)EuclidCoreTools.identityMatrix3D, (Matrix3DReadOnly)linearTransform3D, (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D.getAsQuaternion(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D.getPreScaleQuaternion(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D.getPostScaleQuaternion(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(1.0, 1.0, 1.0), (EuclidGeometry)linearTransform3D.getScaleVector(), (double)0.0);
            Assertions.assertTrue((boolean)linearTransform3D.isIdentity());
            Assertions.assertTrue((boolean)linearTransform3D.isRotationMatrix());
        }
    }

    @Test
    public void testSetToZero() {
        Random random = new Random(76435L);
        for (int i = 0; i < 10000; ++i) {
            LinearTransform3D linearTransform3D = EuclidCoreRandomTools.nextLinearTransform3D((Random)random, (double)10.0);
            linearTransform3D.setToZero();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)EuclidCoreTools.zeroMatrix3D, (Matrix3DReadOnly)linearTransform3D, (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D.getAsQuaternion(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D.getPreScaleQuaternion(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)linearTransform3D.getPostScaleQuaternion(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 0.0), (EuclidGeometry)linearTransform3D.getScaleVector(), (double)0.0);
            Assertions.assertFalse((boolean)linearTransform3D.isIdentity());
            Assertions.assertFalse((boolean)linearTransform3D.isRotationMatrix());
        }
    }

    @Override
    @Test
    public void testSetToNaN() {
        Random random = new Random(76435L);
        for (int i = 0; i < 10000; ++i) {
            LinearTransform3D linearTransform3D = EuclidCoreRandomTools.nextLinearTransform3D((Random)random, (double)10.0);
            linearTransform3D.setToNaN();
            EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)linearTransform3D);
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)linearTransform3D.getAsQuaternion());
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)linearTransform3D.getPreScaleQuaternion());
            EuclidCoreTestTools.assertTuple4DContainsOnlyNaN((Tuple4DReadOnly)linearTransform3D.getPostScaleQuaternion());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)linearTransform3D.getScaleVector());
            Assertions.assertFalse((boolean)linearTransform3D.isIdentity());
            Assertions.assertFalse((boolean)linearTransform3D.isRotationMatrix());
        }
    }

    @Test
    public void testResetScale() {
        Random random = new Random(485725L);
        for (int i = 0; i < 10000; ++i) {
            LinearTransform3D linearTransform3D = EuclidCoreRandomTools.nextLinearTransform3D((Random)random, (double)10.0);
            Quaternion expectedOrientation = new Quaternion(linearTransform3D.getAsQuaternion());
            linearTransform3D.resetScale();
            Assertions.assertEquals((Object)new Vector3D(1.0, 1.0, 1.0), (Object)linearTransform3D.getScaleVector());
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedOrientation, (Orientation3DReadOnly)linearTransform3D.getAsQuaternion(), (double)1.0E-12);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedOrientation, (Orientation3DReadOnly)linearTransform3D.getPreScaleQuaternion(), (double)1.0E-12);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)linearTransform3D.getPostScaleQuaternion(), (double)1.0E-12);
        }
    }

    @Override
    @Test
    public void testSetters() throws Exception {
        LinearTransform3D actualMatrix;
        Matrix3D expectedMatrix;
        int i;
        super.testSetters();
        Random random = new Random(2342L);
        for (i = 0; i < 10000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            actualMatrix = this.createEmptyMatrix();
            actualMatrix.set((Matrix3DReadOnly)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextLinearTransform3D((Random)random, (double)10.0);
            actualMatrix = this.createEmptyMatrix();
            actualMatrix.set((LinearTransform3D)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualMatrix = this.createEmptyMatrix();
            actualMatrix.set((Orientation3DReadOnly)new Quaternion((Orientation3DReadOnly)expectedMatrix));
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testSetRotationVector() {
        Random random = new Random(32546L);
        for (int i = 0; i < 10000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            RotationMatrix expected = new RotationMatrix();
            expected.setRotationVector((Vector3DReadOnly)rotationVector);
            LinearTransform3D actual = new LinearTransform3D();
            actual.setRotationVector((Vector3DReadOnly)rotationVector);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSetEuler() {
        Random random = new Random(32546L);
        for (int i = 0; i < 10000; ++i) {
            Vector3D euler = EuclidCoreRandomTools.nextRotationVector((Random)random);
            RotationMatrix expected = new RotationMatrix();
            expected.setEuler((Vector3DReadOnly)euler);
            LinearTransform3D actual = new LinearTransform3D();
            actual.setEuler((Tuple3DReadOnly)euler);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSetScale() {
        Random random = new Random(364534L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics seed = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            LinearTransform3D original = new LinearTransform3D((Matrix3DReadOnly)seed);
            Vector3D expectedScale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            if (random.nextBoolean()) {
                expectedScale.setZ(-expectedScale.getZ());
            }
            LinearTransform3D tested = new LinearTransform3D((Matrix3DReadOnly)seed);
            tested.setScale((Tuple3DReadOnly)expectedScale);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)original.getAsQuaternion(), (Orientation3DReadOnly)tested.getAsQuaternion(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedScale, (EuclidGeometry)tested.getScaleVector(), (double)1.0E-12);
        }
    }

    @Test
    public void testAppendRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendRotation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendRotationInvertThis() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)true, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendRotationInvertThis((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)(Math.max(1.0, expected.maxAbsElement()) * 1.0E-12));
        }
    }

    @Test
    public void testAppendRotationInvertOther() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false, (boolean)true, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendRotationInvertOther((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendYawRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)new RotationMatrix(yaw, 0.0, 0.0), (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendYawRotation(yaw);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendPitchRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)new RotationMatrix(0.0, pitch, 0.0), (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendPitchRotation(pitch);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendRollRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)new RotationMatrix(0.0, 0.0, roll), (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendRollRotation(roll);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendScale() {
        LinearTransform3D actual;
        Matrix3D expected;
        CommonMatrix3DBasics original;
        int i;
        Random random = new Random(34676L);
        for (i = 0; i < 10000; ++i) {
            original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Matrix3D expected2 = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)new Matrix3D(scale, 0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0, scale), (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected2);
            LinearTransform3D actual2 = new LinearTransform3D((Matrix3DReadOnly)original);
            actual2.appendScale(scale);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected2, (Matrix3DReadOnly)actual2, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Matrix3D scale = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)10.0);
            expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)scale, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendScale((Tuple3DReadOnly)new Vector3D(scale.getM00(), scale.getM11(), scale.getM22()));
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Matrix3D scale = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)10.0);
            expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)original, (boolean)false, (boolean)false, (Matrix3DReadOnly)scale, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.appendScale(scale.getM00(), scale.getM11(), scale.getM22());
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependRotation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependRotationInvertThis() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)true, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependRotationInvertThis((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)(Math.max(1.0, expected.maxAbsElement()) * 1.0E-12));
        }
    }

    @Test
    public void testPrependRotationInvertOther() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false, (boolean)true, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependRotationInvertOther((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependYawRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new RotationMatrix(yaw, 0.0, 0.0), (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependYawRotation(yaw);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependPitchRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new RotationMatrix(0.0, pitch, 0.0), (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependPitchRotation(pitch);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependRollRotation() {
        Random random = new Random(34676L);
        for (int i = 0; i < 10000; ++i) {
            CommonMatrix3DBasics original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            Matrix3D expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new RotationMatrix(0.0, 0.0, roll), (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            LinearTransform3D actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependRollRotation(roll);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependScale() {
        LinearTransform3D actual;
        Matrix3D expected;
        CommonMatrix3DBasics original;
        int i;
        Random random = new Random(34676L);
        for (i = 0; i < 10000; ++i) {
            original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Matrix3D expected2 = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)new Matrix3D(scale, 0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0, scale), (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected2);
            LinearTransform3D actual2 = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual2.getScaleX();
            }
            actual2.prependScale(scale);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected2, (Matrix3DReadOnly)actual2, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Matrix3D scale = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)10.0);
            expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)scale, (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependScale((Tuple3DReadOnly)new Vector3D(scale.getM00(), scale.getM11(), scale.getM22()));
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            original = EuclidCoreRandomTools.nextCommonMatrix3DBasics((Random)random);
            Matrix3D scale = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)10.0);
            expected = new Matrix3D((Matrix3DReadOnly)original);
            Matrix3DTools.multiply((Matrix3DReadOnly)scale, (boolean)false, (boolean)false, (Matrix3DReadOnly)original, (boolean)false, (boolean)false, (CommonMatrix3DBasics)expected);
            actual = new LinearTransform3D((Matrix3DReadOnly)original);
            if (random.nextBoolean()) {
                actual.getScaleX();
            }
            actual.prependScale(scale.getM00(), scale.getM11(), scale.getM22());
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testGetOrientation() {
        Random random = new Random(74534L);
        for (int i = 0; i < 10000; ++i) {
            RotationMatrix r1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D scale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.5, (double)10.0);
            RotationMatrix r2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix expected = new RotationMatrix();
            expected.set(r1);
            expected.append((Orientation3DReadOnly)r2);
            LinearTransform3D linearTransform3D = new LinearTransform3D();
            linearTransform3D.set((RotationMatrixReadOnly)r1);
            linearTransform3D.appendScale((Tuple3DReadOnly)scale);
            linearTransform3D.appendRotation((Orientation3DReadOnly)r2);
            RotationMatrix actual = new RotationMatrix();
            linearTransform3D.getOrientation((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-9);
            actual = new Quaternion();
            linearTransform3D.getOrientation((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)new Quaternion((Orientation3DReadOnly)expected), (Orientation3DReadOnly)actual, (double)1.0E-9);
            actual = new YawPitchRoll();
            linearTransform3D.getOrientation((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new YawPitchRoll((Orientation3DReadOnly)expected), (EuclidGeometry)actual, (double)1.0E-9);
        }
    }

    @Test
    public void testGetRotationVector() {
        Random random = new Random(74534L);
        for (int i = 0; i < 10000; ++i) {
            RotationMatrix r1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D scale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.5, (double)10.0);
            RotationMatrix r2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.set(r1);
            rotationMatrix.append((Orientation3DReadOnly)r2);
            Vector3D expected = new Vector3D();
            rotationMatrix.getRotationVector((Vector3DBasics)expected);
            LinearTransform3D linearTransform3D = new LinearTransform3D();
            linearTransform3D.set((RotationMatrixReadOnly)r1);
            linearTransform3D.appendScale((Tuple3DReadOnly)scale);
            linearTransform3D.appendRotation((Orientation3DReadOnly)r2);
            Vector3D actual = new Vector3D();
            linearTransform3D.getRotationVector((Vector3DBasics)actual);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)expected, (Vector3DReadOnly)actual, (double)1.0E-9);
        }
    }

    @Test
    public void testGetEuler() {
        Random random = new Random(74534L);
        for (int i = 0; i < 10000; ++i) {
            RotationMatrix r1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D scale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.5, (double)10.0);
            RotationMatrix r2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.set(r1);
            rotationMatrix.append((Orientation3DReadOnly)r2);
            Vector3D expected = new Vector3D();
            rotationMatrix.getEuler((Tuple3DBasics)expected);
            LinearTransform3D linearTransform3D = new LinearTransform3D();
            linearTransform3D.set((RotationMatrixReadOnly)r1);
            linearTransform3D.appendScale((Tuple3DReadOnly)scale);
            linearTransform3D.appendRotation((Orientation3DReadOnly)r2);
            Vector3D actual = new Vector3D();
            linearTransform3D.getEuler((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-9);
        }
    }

    @Test
    public void testGetScaleComponents() {
        Random random = new Random(74534L);
        for (int i = 0; i < 10000; ++i) {
            RotationMatrix r1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D scale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.5, (double)10.0);
            double maxScale = EuclidCoreTools.max((double)scale.getX(), (double)scale.getY(), (double)scale.getZ());
            double medScale = EuclidCoreTools.med((double)scale.getX(), (double)scale.getY(), (double)scale.getZ());
            double minScale = EuclidCoreTools.min((double)scale.getX(), (double)scale.getY(), (double)scale.getZ());
            scale.set(maxScale, medScale, minScale);
            RotationMatrix r2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            LinearTransform3D linearTransform3D = new LinearTransform3D();
            linearTransform3D.set((RotationMatrixReadOnly)r1);
            linearTransform3D.appendScale((Tuple3DReadOnly)scale);
            linearTransform3D.appendRotation((Orientation3DReadOnly)r2);
            Assertions.assertEquals((double)maxScale, (double)linearTransform3D.getScaleX(), (double)1.0E-12);
            Assertions.assertEquals((double)medScale, (double)linearTransform3D.getScaleY(), (double)1.0E-12);
            Assertions.assertEquals((double)minScale, (double)linearTransform3D.getScaleZ(), (double)1.0E-12);
        }
    }

    @Test
    public void testGetAsQuaternion() {
        Random random = new Random(34536L);
        LinearTransform3D linearTransform3D = new LinearTransform3D();
        QuaternionReadOnly actual = linearTransform3D.getAsQuaternion();
        Quaternion expected = new Quaternion();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        for (int i = 0; i < 10000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            linearTransform3D.appendRotation((Orientation3DReadOnly)rotationMatrix);
            expected.append((Orientation3DReadOnly)rotationMatrix);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((String)("Iteration: " + i), (Orientation3DReadOnly)expected, (Orientation3DReadOnly)actual, (double)1.0E-9);
            linearTransform3D.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.75, (double)1.25));
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((String)("Iteration: " + i), (Orientation3DReadOnly)expected, (Orientation3DReadOnly)actual, (double)1.0E-9);
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            linearTransform3D.appendRotation((Orientation3DReadOnly)rotationMatrix);
            expected.append((Orientation3DReadOnly)rotationMatrix);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((String)("Iteration: " + i), (Orientation3DReadOnly)expected, (Orientation3DReadOnly)actual, (double)1.0E-9);
            linearTransform3D.resetScale();
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expected, (Orientation3DReadOnly)actual, (double)1.0E-9);
            expected.set(actual);
        }
    }

    @Test
    public void testGetPrePostQuaternionAndScale() {
        Random random = new Random(678658L);
        LinearTransform3D linearTransform3D = new LinearTransform3D();
        QuaternionReadOnly actualPreScale = linearTransform3D.getPreScaleQuaternion();
        Vector3DReadOnly actualScale = linearTransform3D.getScaleVector();
        QuaternionReadOnly actualPostScale = linearTransform3D.getPostScaleQuaternion();
        Quaternion expectedPreScale = new Quaternion();
        Vector3D expectedScale = new Vector3D(1.0, 1.0, 1.0);
        Quaternion expectedPostScale = new Quaternion();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPreScale, (EuclidGeometry)actualPreScale, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedScale, (EuclidGeometry)actualScale, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPostScale, (EuclidGeometry)actualPostScale, (double)1.0E-12);
        for (int i = 0; i < 10000; ++i) {
            expectedPreScale.set(EuclidCoreRandomTools.nextQuaternion((Random)random));
            expectedScale.set(EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.5, (double)10.0));
            double maxScale = EuclidCoreTools.max((double)expectedScale.getX(), (double)expectedScale.getY(), (double)expectedScale.getZ());
            double midScale = EuclidCoreTools.med((double)expectedScale.getX(), (double)expectedScale.getY(), (double)expectedScale.getZ());
            double minScale = EuclidCoreTools.min((double)expectedScale.getX(), (double)expectedScale.getY(), (double)expectedScale.getZ());
            expectedScale.set(maxScale, midScale, random.nextBoolean() ? minScale : -minScale);
            expectedPostScale.set(EuclidCoreRandomTools.nextQuaternion((Random)random));
            linearTransform3D.set((Orientation3DReadOnly)expectedPreScale);
            linearTransform3D.appendScale((Tuple3DReadOnly)expectedScale);
            linearTransform3D.appendRotation((Orientation3DReadOnly)expectedPostScale);
            if (expectedPreScale.geometricallyEquals((EuclidGeometry)actualPreScale, 1.0E-7)) {
                EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((String)("Iteration: " + i), (Orientation3DReadOnly)expectedPostScale, (Orientation3DReadOnly)actualPostScale, (double)1.0E-7);
            } else {
                double distance = expectedPreScale.distance((Orientation3DReadOnly)actualPreScale);
                Assertions.assertEquals((double)Math.PI, (double)distance, (double)1.0E-7);
                Quaternion difference = new Quaternion();
                difference.difference((QuaternionReadOnly)expectedPreScale, actualPreScale);
                difference.conjugate();
                expectedPostScale.prepend((Orientation3DReadOnly)difference);
                EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((String)("Iteration: " + i), (Orientation3DReadOnly)expectedPostScale, (Orientation3DReadOnly)actualPostScale, (double)1.0E-7);
            }
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)expectedScale, (EuclidGeometry)actualScale, (double)1.0E-12);
        }
    }

    @Test
    public void testBugScaleNotUpdated() {
        LinearTransform3D linearTransform3D = new LinearTransform3D();
        RotationMatrix rotation = new RotationMatrix();
        Vector3D scale = new Vector3D(0.3, 0.3, 0.0);
        linearTransform3D.setIdentity();
        linearTransform3D.set((RotationMatrixReadOnly)rotation);
        linearTransform3D.appendScale((Tuple3DReadOnly)scale);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)new Quaternion((Orientation3DReadOnly)rotation), (Orientation3DReadOnly)linearTransform3D.getAsQuaternion(), (double)1.0E-9);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)scale, (EuclidGeometry)linearTransform3D.getScaleVector(), (double)1.0E-12);
    }
}

