/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.QuaternionCalculus;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class QuaternionCalculusTest {
    private static final double EPSILON = 1.0E-10;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testLogAndExpAlgebra() {
        Random random = new Random(651651961L);
        for (int i = 0; i < 10000; ++i) {
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Vector4D qLog = new Vector4D();
            Quaternion vExp = new Quaternion();
            quaternionCalculus.log((QuaternionReadOnly)q, (Vector4DBasics)qLog);
            Vector3D v = new Vector3D(qLog.getX(), qLog.getY(), qLog.getZ());
            QuaternionCalculus.exp((Vector3DReadOnly)v, (QuaternionBasics)vExp);
            Assertions.assertTrue((Math.abs(q.getX() - vExp.getX()) < 1.0E-9 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(q.getY() - vExp.getY()) < 1.0E-9 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(q.getZ() - vExp.getZ()) < 1.0E-9 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(q.getS() - vExp.getS()) < 1.0E-9 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConversionQDotToAngularVelocityBackAndForth() {
        Random random = new Random(651651961L);
        for (int i = 0; i < 10000; ++i) {
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Vector3D expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)length);
            if (random.nextBoolean()) {
                expectedAngularVelocity.negate();
            }
            Vector3D actualAngularVelocity = new Vector3D();
            Vector4D qDot = new Vector4D();
            QuaternionCalculus.computeQDotInParentFrame((QuaternionReadOnly)q, (Vector3DReadOnly)expectedAngularVelocity, (Vector4DBasics)qDot);
            quaternionCalculus.computeAngularVelocityInParentFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-10);
        }
    }

    @Test
    public void testConversionQDDotToAngularAccelerationBackAndForth() {
        Random random = new Random(651651961L);
        for (int i = 0; i < 10000; ++i) {
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)length);
            if (random.nextBoolean()) {
                angularVelocity.negate();
            }
            Vector3D expectedAngularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random, (double)length);
            if (random.nextBoolean()) {
                expectedAngularAcceleration.negate();
            }
            Vector3D actualAngularAcceleration = new Vector3D();
            Vector4D qDot = new Vector4D();
            Vector4D qDDot = new Vector4D();
            QuaternionCalculus.computeQDotInParentFrame((QuaternionReadOnly)q, (Vector3DReadOnly)angularVelocity, (Vector4DBasics)qDot);
            quaternionCalculus.computeQDDotInParentFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DReadOnly)expectedAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAccelerationInRotatedFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
            quaternionCalculus.computeQDDotInParentFrame((QuaternionReadOnly)q, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)actualAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAccelerationInRotatedFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
            quaternionCalculus.computeQDDotInParentFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)actualAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAccelerationInRotatedFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
            quaternionCalculus.computeQDDotInParentFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DReadOnly)expectedAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAccelerationInParentFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDDot, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
        }
    }

    @Test
    public void testFDSimpleCase() {
        double dt;
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        Random random = new Random(65265L);
        double integrationTime = 1.0;
        double angleVelocity = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2)) / integrationTime;
        Vector3D expectedAngularVelocity = new Vector3D(angleVelocity, 0.0, 0.0);
        Vector3D expectedAngularAcceleration = new Vector3D();
        AxisAngle axisAnglePrevious = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        AxisAngle axisAngleCurrent = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        AxisAngle axisAngleNext = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        Quaternion qPrevious = new Quaternion();
        Quaternion qCurrent = new Quaternion();
        Quaternion qNext = new Quaternion();
        Vector4D qDot = new Vector4D();
        Vector4D qDDot = new Vector4D();
        Vector3D actualAngularVelocity = new Vector3D();
        Vector3D actualAngularAcceleration = new Vector3D();
        for (double time = dt = 1.0E-4; time < integrationTime; time += dt) {
            axisAnglePrevious.setAngle(EuclidCoreTools.trimAngleMinusPiToPi((double)(angleVelocity * (time - dt))) - Math.PI);
            qPrevious.set((Orientation3DReadOnly)axisAnglePrevious);
            axisAngleCurrent.setAngle(EuclidCoreTools.trimAngleMinusPiToPi((double)(angleVelocity * time)) - Math.PI);
            qCurrent.set((Orientation3DReadOnly)axisAngleCurrent);
            axisAngleNext.setAngle(EuclidCoreTools.trimAngleMinusPiToPi((double)(angleVelocity * (time + dt))) - Math.PI);
            qNext.set((Orientation3DReadOnly)axisAngleNext);
            QuaternionCalculus.computeQDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)qNext, (double)dt, (Vector4DBasics)qDot);
            quaternionCalculus.computeAngularVelocityInParentFrame((QuaternionReadOnly)qCurrent, (Vector4DReadOnly)qDot, (Vector3DBasics)actualAngularVelocity);
            QuaternionCalculus.computeQDDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)qCurrent, (QuaternionReadOnly)qNext, (double)dt, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAccelerationInRotatedFrame((QuaternionReadOnly)qCurrent, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            boolean sameVelocity = expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualAngularVelocity, 1.0E-7);
            if (!sameVelocity) {
                System.out.println("Expected angular velocity: " + String.valueOf(expectedAngularVelocity));
                System.out.println("Actual   angular velocity: " + String.valueOf(actualAngularVelocity));
            }
            Assertions.assertTrue((boolean)sameVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-7);
        }
    }

    @Test
    public void testInterpolateAgainstQuat4d() {
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        Random random = new Random(6546545L);
        Quaternion q0 = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion q1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion expectedQInterpolated = new Quaternion();
        Quaternion actualQInterpolated = new Quaternion();
        for (double alpha = 0.0; alpha <= 1.0; alpha += 1.0E-6) {
            expectedQInterpolated.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)q1, alpha);
            quaternionCalculus.interpolate(alpha, (QuaternionReadOnly)q0, (QuaternionReadOnly)q1, (QuaternionBasics)actualQInterpolated);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQInterpolated, (EuclidGeometry)actualQInterpolated, (double)1.0E-10);
        }
    }

    static double shiftAngleToStartOfRange(double angleToShift, double startOfAngleRange, double endOfAngleRange) {
        double ret = angleToShift;
        if (angleToShift < (startOfAngleRange -= 1.0E-10)) {
            ret = angleToShift + Math.ceil((startOfAngleRange - angleToShift) / endOfAngleRange) * endOfAngleRange;
        }
        if (angleToShift >= startOfAngleRange + endOfAngleRange) {
            ret = angleToShift - Math.floor((angleToShift - startOfAngleRange) / endOfAngleRange) * endOfAngleRange;
        }
        return ret;
    }

    @Test
    public void testShiftAngleToStartOfRangeUnitless() {
        double range;
        double endOfAngleRange = range = Math.pow(2.0, 13.0);
        double angleToShift = 1.6 * range;
        double expectedReturn = 0.6 * range;
        double actualReturn = QuaternionCalculusTest.shiftAngleToStartOfRange(angleToShift, 0.0, endOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        angleToShift = -0.4 * range;
        expectedReturn = 0.6 * range;
        actualReturn = QuaternionCalculusTest.shiftAngleToStartOfRange(angleToShift, 0.0, endOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        angleToShift = 0.4 * range;
        expectedReturn = 0.4 * range;
        actualReturn = QuaternionCalculusTest.shiftAngleToStartOfRange(angleToShift, 0.0, endOfAngleRange);
        Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        int iters = 1000;
        Random random = new Random();
        for (int i = 0; i < iters; ++i) {
            double ratio = -6.0 + 12.0 * random.nextDouble();
            expectedReturn = angleToShift = ratio * range;
            if (angleToShift < 0.0) {
                expectedReturn = angleToShift + Math.ceil(-angleToShift / endOfAngleRange) * endOfAngleRange;
            }
            if (angleToShift >= endOfAngleRange) {
                expectedReturn = angleToShift - Math.floor(angleToShift / endOfAngleRange) * endOfAngleRange;
            }
            actualReturn = QuaternionCalculusTest.shiftAngleToStartOfRange(angleToShift, 0.0, endOfAngleRange);
            Assertions.assertEquals((double)expectedReturn, (double)actualReturn, (double)1.0E-12);
        }
    }
}

