/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.Pose2DReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Pose2DReferenceFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testAsynchronousUpdatesOne() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Pose2DReferenceFrame poseFrame0 = new Pose2DReferenceFrame("poseFrame0", worldFrame);
        Pose2DReferenceFrame poseFrame00 = new Pose2DReferenceFrame("poseFrame00", (ReferenceFrame)poseFrame0);
        Pose2DReferenceFrame poseFrame000 = new Pose2DReferenceFrame("poseFrame000", (ReferenceFrame)poseFrame00);
        FramePoint3D framePoint = new FramePoint3D((ReferenceFrame)poseFrame000, 1.0, 2.8, 4.4);
        Random random = new Random(1776L);
        this.doRandomPoseChangeAndUpdate(poseFrame0, random);
        this.doRandomPoseChangeAndUpdate(poseFrame00, random);
        this.doRandomPoseChangeAndUpdate(poseFrame000, random);
        FramePoint3D framePointInWorldOne = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
        framePointInWorldOne.changeFrame(worldFrame);
        this.doRandomPoseChangeAndUpdate(poseFrame0, random);
        FramePoint3D framePointInWorldTwo = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
        framePointInWorldTwo.changeFrame(worldFrame);
        Assertions.assertFalse((boolean)framePointInWorldOne.epsilonEquals((EuclidFrameGeometry)framePointInWorldTwo, 1.0E-7));
        poseFrame0.update();
        poseFrame00.update();
        poseFrame000.update();
        FramePoint3D framePointInWorldThree = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
        framePointInWorldThree.changeFrame(worldFrame);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)framePointInWorldThree, (EuclidFrameGeometry)framePointInWorldTwo, (double)1.0E-7);
    }

    @Test
    public void testLongChainEfficiency() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        int numberOfFramesInChain = 100;
        ReferenceFrame previousFrame = worldFrame;
        for (int i = 0; i < numberOfFramesInChain; ++i) {
            Pose2DReferenceFrame poseFrame = new Pose2DReferenceFrame("poseFrame" + i, previousFrame);
            poseFrame.setPositionAndUpdate((FramePoint2DReadOnly)new FramePoint2D(previousFrame, 1.0, 0.0));
            previousFrame = poseFrame;
        }
        FramePoint2D finalPosition = new FramePoint2D(previousFrame);
        finalPosition.changeFrame(worldFrame);
        long startTime = System.currentTimeMillis();
        int numberOfChangeFrames = 1000000;
        for (int i = 0; i < numberOfChangeFrames; ++i) {
            FramePoint2D finalPosition2 = new FramePoint2D(previousFrame);
            finalPosition2.changeFrame(worldFrame);
        }
        long endTime = System.currentTimeMillis();
        double millisPerChangeFrame = (double)(endTime - startTime) / (double)numberOfChangeFrames;
        System.out.println("millisPerChangeFrame = " + millisPerChangeFrame);
        Assertions.assertTrue((millisPerChangeFrame < 0.01 ? 1 : 0) != 0);
        FramePoint2D finalPosition3 = new FramePoint2D(previousFrame);
        finalPosition3.changeFrame(worldFrame);
    }

    @Test
    public void testAsynchronousUpdatesTwo() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Pose2DReferenceFrame poseFrame0 = new Pose2DReferenceFrame("poseFrame0", worldFrame);
        Pose2DReferenceFrame poseFrame00 = new Pose2DReferenceFrame("poseFrame00", (ReferenceFrame)poseFrame0);
        Pose2DReferenceFrame poseFrame01 = new Pose2DReferenceFrame("poseFrame01", (ReferenceFrame)poseFrame0);
        Pose2DReferenceFrame poseFrame010 = new Pose2DReferenceFrame("poseFrame010", (ReferenceFrame)poseFrame01);
        Pose2DReferenceFrame poseFrame000 = new Pose2DReferenceFrame("poseFrame000", (ReferenceFrame)poseFrame00);
        Pose2DReferenceFrame poseFrame001 = new Pose2DReferenceFrame("poseFrame001", (ReferenceFrame)poseFrame00);
        Pose2DReferenceFrame poseFrame1 = new Pose2DReferenceFrame("poseFrame1", worldFrame);
        Pose2DReferenceFrame poseFrame10 = new Pose2DReferenceFrame("poseFrame10", (ReferenceFrame)poseFrame1);
        Pose2DReferenceFrame poseFrame100 = new Pose2DReferenceFrame("poseFrame100", (ReferenceFrame)poseFrame10);
        Pose2DReferenceFrame poseFrame101 = new Pose2DReferenceFrame("poseFrame101", (ReferenceFrame)poseFrame10);
        Pose2DReferenceFrame[] referenceFrames = new Pose2DReferenceFrame[]{poseFrame0, poseFrame00, poseFrame01, poseFrame010, poseFrame000, poseFrame001, poseFrame1, poseFrame10, poseFrame100, poseFrame101};
        Point2D position = new Point2D(1.0, 2.2);
        FramePoint2D framePoint = new FramePoint2D((ReferenceFrame)poseFrame010, (Tuple2DReadOnly)position);
        this.updateAllFrames((ReferenceFrame[])referenceFrames);
        Random random = new Random(1776L);
        FramePoint2D newPoint = this.doRandomChangeFrames((ReferenceFrame[])referenceFrames, framePoint, random);
        newPoint.changeFrame(framePoint.getReferenceFrame());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)framePoint, (EuclidFrameGeometry)newPoint, (double)1.0E-7);
        this.doRandomPoseChangeAndUpdate(poseFrame01, random);
        newPoint = this.doRandomChangeFrames((ReferenceFrame[])referenceFrames, framePoint, random);
        FramePoint2D newPointInWorldOne = new FramePoint2D((FrameTuple2DReadOnly)newPoint);
        newPointInWorldOne.changeFrame(worldFrame);
        this.updateAllFrames((ReferenceFrame[])referenceFrames);
        FramePoint2D newPointInWorldTwo = new FramePoint2D((FrameTuple2DReadOnly)newPoint);
        newPointInWorldTwo.changeFrame(worldFrame);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)newPointInWorldOne, (EuclidFrameGeometry)newPointInWorldTwo, (double)1.0E-7);
    }

    private void updateAllFrames(ReferenceFrame[] referenceFrames) {
        for (ReferenceFrame frame : referenceFrames) {
            frame.update();
        }
    }

    private void doRandomPoseChangeAndUpdate(Pose2DReferenceFrame poseReferenceFrame, Random random) {
        Point2D randomPoint2d = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)1234.0, (double)1234.0);
        FramePose2D framePose = new FramePose2D(poseReferenceFrame.getParent(), (Tuple2DReadOnly)randomPoint2d, random.nextGaussian());
        poseReferenceFrame.setPoseAndUpdate((FramePose2DReadOnly)framePose);
    }

    private FramePoint2D doRandomChangeFrames(ReferenceFrame[] referenceFrames, FramePoint2D framePoint, Random random) {
        for (int i = 0; i < 10; ++i) {
            int index = random.nextInt(referenceFrames.length);
            ReferenceFrame desiredFrame = referenceFrames[index];
            framePoint.changeFrame(desiredFrame);
        }
        return framePoint;
    }
}

