/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.Vector2D32;
import us.ihmc.euclid.tuple2D.Vector2DBasicsTest;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Vector2D32Test
extends Vector2DBasicsTest<Vector2D32> {
    @Test
    public void testVector2D32() {
        int i;
        Random random = new Random(621541L);
        Vector2D32 vector = new Vector2D32();
        Assertions.assertTrue((0.0f == vector.getX32() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0f == vector.getY32() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            float newY;
            float newX = random.nextFloat();
            Assertions.assertTrue((newX == (vector = new Vector2D32(newX, newY = random.nextFloat())).getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == vector.getY32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D32 vectorArray;
            float[] randomVector2DArray = new float[]{random.nextFloat(), random.nextFloat()};
            Assertions.assertTrue((randomVector2DArray[0] == (vectorArray = new Vector2D32(randomVector2DArray)).getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((randomVector2DArray[1] == vectorArray.getY32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D32 vector2 = EuclidCoreRandomTools.nextVector2D32((Random)random);
            vector = new Vector2D32((Tuple2DReadOnly)vector2);
            Assertions.assertTrue((vector.getX32() == vector2.getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY32() == vector2.getY32() ? 1 : 0) != 0);
        }
    }

    @Override
    public void testSetters() throws Exception {
        int i;
        super.testSetters();
        Random random = new Random(621541L);
        Vector2D32 tuple1 = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            tuple1.setX(x);
            Assertions.assertEquals((double)tuple1.getX32(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float y = random.nextFloat();
            tuple1.setY(y);
            Assertions.assertEquals((double)tuple1.getY32(), (double)y, (double)this.getEpsilon());
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Point2D32 point = EuclidCoreRandomTools.nextPoint2D32((Random)random);
        int newHashCode = point.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)point.hashCode());
        int previousHashCode = point.hashCode();
        for (int i = 0; i < 1000; ++i) {
            point.setElement(i % 2, (double)random.nextFloat());
            newHashCode = point.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector2D32 vectorB;
            Vector2D32 vectorA = EuclidCoreRandomTools.nextVector2D32((Random)random);
            if (vectorA.geometricallyEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextVector2D32((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
        }
    }

    @Override
    public double getEpsilon() {
        return 1.0E-6;
    }

    @Override
    public Vector2D32 createEmptyTuple() {
        return new Vector2D32();
    }

    @Override
    public Vector2D32 createTuple(double x, double y) {
        return new Vector2D32((float)x, (float)y);
    }

    @Override
    public Vector2D32 createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextVector2D32((Random)random);
    }
}

