/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.Pose3DBasicsTest;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class Pose3DTest
extends Pose3DBasicsTest<Pose3D> {
    private static final double EPSILON = 1.0E-7;

    @Override
    public Pose3D createEmptyPose3D() {
        return new Pose3D();
    }

    @Override
    public Pose3D createRandomPose3D(Random random) {
        return EuclidGeometryRandomTools.nextPose3D((Random)random);
    }

    @Test
    public void testConstructors() {
        Random random = new Random(52942L);
        for (int i = 0; i < 1000; ++i) {
            double x = random.nextDouble() - random.nextDouble();
            double y = random.nextDouble() - random.nextDouble();
            double z = random.nextDouble() - random.nextDouble();
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Pose3D allDoubles = new Pose3D(x, y, z, quaternion.getYaw(), quaternion.getPitch(), quaternion.getRoll());
            Assertions.assertEquals((double)x, (double)allDoubles.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)allDoubles.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)allDoubles.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getYaw(), (double)allDoubles.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)allDoubles.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)allDoubles.getRoll(), (double)1.0E-7);
            Pose3D fromComponents = new Pose3D((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertEquals((double)x, (double)fromComponents.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)fromComponents.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)fromComponents.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getYaw(), (double)fromComponents.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)fromComponents.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)fromComponents.getRoll(), (double)1.0E-7);
            Pose3D copiedPose = new Pose3D((Pose3DReadOnly)fromComponents);
            Assertions.assertEquals((double)x, (double)fromComponents.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)fromComponents.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)fromComponents.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)fromComponents.getYaw(), (double)copiedPose.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)fromComponents.getPitch(), (double)copiedPose.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)fromComponents.getRoll(), (double)copiedPose.getRoll(), (double)1.0E-7);
            Pose3D fromRBT = new Pose3D((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)new QuaternionBasedTransform((Orientation3DReadOnly)quaternion, (Tuple3DReadOnly)new Point3D(x, y, z))));
            Assertions.assertEquals((double)x, (double)fromRBT.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)fromRBT.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)fromRBT.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getYaw(), (double)fromRBT.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)fromRBT.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)fromRBT.getRoll(), (double)1.0E-7);
        }
    }

    @Override
    public double getEpsilon() {
        return 1.0E-7;
    }

    @Override
    public Pose3D createRandomTransform(Random random) {
        return this.createRandomPose3D(random);
    }

    @Override
    public Pose3D createRandomTransform2D(Random random) {
        Pose3D pose2D = new Pose3D();
        pose2D.getRotation().setToYawOrientation(Math.PI * 2 * random.nextDouble() - Math.PI);
        pose2D.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        return pose2D;
    }

    @Override
    public Pose3D copy(Pose3D original) {
        return (Pose3D)this.copy((Pose3DReadOnly)original);
    }

    @Override
    public Pose3D identity() {
        return new Pose3D();
    }
}

