/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.AxisAngle32;
import us.ihmc.euclid.axisAngle.AxisAngleBasicsTest;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public class AxisAngle32Test
extends AxisAngleBasicsTest<AxisAngle32> {
    public static final double EPS = 1.0E-6;

    @Test
    public void testAxisAngle32() {
        AxisAngle32 expected;
        int i;
        Random random = new Random(613615L);
        AxisAngle32 axisAngle = new AxisAngle32();
        Assertions.assertTrue((axisAngle.getX() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            axisAngle = expected = EuclidCoreRandomTools.nextAxisAngle32((Random)random);
            AxisAngle32 axisAngle2 = new AxisAngle32((Orientation3DReadOnly)axisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)axisAngle2, (double)1.0E-6);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expected, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle32((Random)random);
            axisAngle = new AxisAngle32(expected.getX32(), expected.getY32(), expected.getZ32(), expected.getAngle32());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expected, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextAxisAngle32((Random)random);
            float[] axisAngleArrayCopy = new float[]{expected.getX32(), expected.getY32(), expected.getZ32(), expected.getAngle32()};
            float[] axisAngleArray = axisAngleArrayCopy;
            axisAngle = new AxisAngle32(axisAngleArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expected, (double)1.0E-6);
            for (int j = 0; j < axisAngleArray.length; ++j) {
                Assertions.assertTrue((axisAngleArray[j] == axisAngleArrayCopy[j] ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            UnitVector3D vectorAxis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            float angle = random.nextFloat();
            axisAngle = new AxisAngle32((Vector3DReadOnly)vectorAxis, angle);
            Assertions.assertEquals((double)axisAngle.getX(), (double)vectorAxis.getX(), (double)1.0E-6);
            Assertions.assertEquals((double)axisAngle.getY(), (double)vectorAxis.getY(), (double)1.0E-6);
            Assertions.assertEquals((double)axisAngle.getZ(), (double)vectorAxis.getZ(), (double)1.0E-6);
            Assertions.assertEquals((double)axisAngle.getAngle(), (double)angle, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternionCopy;
            Quaternion quaternion = quaternionCopy = EuclidCoreRandomTools.nextQuaternion((Random)random);
            axisAngle = new AxisAngle32((Orientation3DReadOnly)quaternion);
            AxisAngle32 expectedAxisAngle32 = new AxisAngle32();
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)expectedAxisAngle32);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle32, (double)1.0E-6);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)quaternionCopy, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            float angleCopy;
            RotationMatrix matrixCopy;
            RotationMatrix matrix = matrixCopy = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            float angle = angleCopy = random.nextFloat();
            axisAngle = new AxisAngle32((Orientation3DReadOnly)matrix);
            AxisAngle32 expectedAxisAngle32 = new AxisAngle32();
            AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)matrix, (AxisAngleBasics)expectedAxisAngle32);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle32, (double)1.0E-6);
            Assertions.assertTrue((angle == angleCopy ? 1 : 0) != 0);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)matrixCopy, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVectorCopy;
            Vector3D rotationVector = rotationVectorCopy = EuclidCoreRandomTools.nextRotationVector((Random)random);
            axisAngle = new AxisAngle32((Vector3DReadOnly)rotationVector);
            AxisAngle32 expectedAxisAngle32 = new AxisAngle32();
            AxisAngleConversion.convertRotationVectorToAxisAngle((Vector3DReadOnly)rotationVector, (AxisAngleBasics)expectedAxisAngle32);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle32, (double)1.0E-6);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)rotationVector, (Vector3DReadOnly)rotationVectorCopy, (double)1.0E-6);
        }
        for (i = 0; i < 1000; ++i) {
            YawPitchRoll yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            axisAngle = new AxisAngle32(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll());
            AxisAngle32 expectedAxisAngle = new AxisAngle32();
            AxisAngleConversion.convertYawPitchRollToAxisAngle((double)yawPitchRoll.getYaw(), (double)yawPitchRoll.getPitch(), (double)yawPitchRoll.getRoll(), (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle, (EuclidGeometry)expectedAxisAngle, (double)1.0E-6);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        AxisAngle32 axisAngle = EuclidCoreRandomTools.nextAxisAngle32((Random)random);
        int newHashCode = axisAngle.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)axisAngle.hashCode());
        int previousHashCode = axisAngle.hashCode();
        for (int i = 0; i < 1000; ++i) {
            axisAngle.setElement(random.nextInt(4), (double)random.nextFloat());
            newHashCode = axisAngle.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(35454L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            AxisAngle32 aabA = EuclidCoreRandomTools.nextAxisAngle32((Random)random);
            AxisAngle aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), epsilon + random.nextDouble() - random.nextDouble());
            AxisAngle32 aabB = new AxisAngle32((Orientation3DReadOnly)aa);
            aabB.preMultiply((AxisAngleReadOnly)aabA);
            if (aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon)) {
                Assertions.assertTrue((boolean)aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon));
                continue;
            }
            Assertions.assertFalse((boolean)aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon));
        }
    }

    @Override
    public AxisAngle32 createEmptyAxisAngle() {
        return new AxisAngle32();
    }

    @Override
    public AxisAngle32 createAxisAngle(Vector3DReadOnly axis, double angle) {
        return new AxisAngle32(axis, (float)angle);
    }

    @Override
    public AxisAngle32 createAxisAngle(double ux, double uy, double uz, double angle) {
        return new AxisAngle32((float)ux, (float)uy, (float)uz, (float)angle);
    }

    @Override
    public AxisAngle32 createRandomAxisAngle(Random random) {
        return EuclidCoreRandomTools.nextAxisAngle32((Random)random);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-6;
    }

    @Override
    public double getSmallestEpsilon() {
        return 1.0E-6;
    }
}

