/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import java.util.function.Predicate;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameTuple3DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Tuple3DBasicsTest;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class FrameTuple3DBasicsTest<F extends FrameTuple3DBasics>
extends FrameTuple3DReadOnlyTest<F> {
    public abstract Tuple3DBasics createRandomFramelessTuple(Random var1);

    @Test
    public void testSet() throws Exception {
        ReferenceFrame differentFrame;
        int differenceFrameIndex;
        FrameTuple3DBasics actual;
        ReferenceFrame initialFrame;
        int initialFrameIndex;
        Tuple3DBasics expected;
        ReferenceFrame[] referenceFrames;
        int i;
        Random random = new Random(5472L);
        for (i = 0; i < 1000; ++i) {
            referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            expected = this.createRandomFramelessTuple(random);
            initialFrameIndex = random.nextInt(referenceFrames.length);
            initialFrame = referenceFrames[initialFrameIndex];
            actual = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-15));
            actual.set(initialFrame, (Tuple3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((Tuple3DReadOnly)this.createRandomFramelessTuple(random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-15));
            expected.set((Tuple3DReadOnly)actual);
            differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, (Tuple3DReadOnly)this.createRandomFramelessTuple(random));
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            }
        }
        for (i = 0; i < 1000; ++i) {
            referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            expected = this.createRandomFramelessTuple(random);
            initialFrameIndex = random.nextInt(referenceFrames.length);
            initialFrame = referenceFrames[initialFrameIndex];
            actual = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-15));
            actual.set(initialFrame, expected.getX(), expected.getY(), expected.getZ());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((Tuple3DReadOnly)this.createRandomFramelessTuple(random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-15));
            expected.set((Tuple3DReadOnly)actual);
            differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, random.nextDouble(), random.nextDouble(), random.nextDouble());
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            }
        }
    }

    @Test
    public void testSetIncludingFrame() throws Exception {
        Exception expectedException;
        FrameTuple3DBasics frameTuple;
        Vector3D tuple;
        Vector3D tuple2;
        ReferenceFrame newFrame;
        int i;
        Random random = new Random(2342L);
        ReferenceFrame initialFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            double z = random.nextDouble();
            ReferenceFrame newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple3DBasics frameTuple2 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Vector3D tuple3 = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple2.getReferenceFrame());
            frameTuple2.setIncludingFrame(newFrame2, x, y, z);
            tuple3.set(x, y, z);
            Assertions.assertEquals((Object)newFrame2, (Object)frameTuple2.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple3, (EuclidGeometry)frameTuple2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D input = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double z = random.nextDouble();
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple3DBasics frameTuple3 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple3.getReferenceFrame());
            frameTuple3.setIncludingFrame(newFrame, (Tuple2DReadOnly)input, z);
            tuple2.set((Tuple2DReadOnly)input, z);
            Assertions.assertEquals((Object)newFrame, (Object)frameTuple3.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple2, (EuclidGeometry)frameTuple3, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D input = EuclidCoreRandomTools.nextPoint3D((Random)random);
            ReferenceFrame newFrame3 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple3DBasics frameTuple4 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple4.getReferenceFrame());
            frameTuple4.setIncludingFrame(newFrame3, (Tuple3DReadOnly)input);
            tuple.set((Tuple3DReadOnly)input);
            Assertions.assertEquals((Object)newFrame3, (Object)frameTuple4.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)frameTuple4, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            double[] input = new double[random.nextInt(20)];
            for (int j = 0; j < input.length; ++j) {
                input[j] = random.nextDouble();
            }
            ReferenceFrame newFrame4 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple3DBasics frameTuple5 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple5.getReferenceFrame());
            Exception expectedException2 = null;
            try {
                tuple.set(input);
            }
            catch (Exception e) {
                expectedException2 = e;
            }
            try {
                frameTuple5.setIncludingFrame(newFrame4, input);
                if (expectedException2 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame4, (Object)frameTuple5.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)frameTuple5, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException2 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                String message = e.getMessage();
                if (!e.getClass().equals(expectedException2.getClass())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException2));
                }
                if (message != null && !message.equals(expectedException2.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException2));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(10);
            double[] input = new double[random.nextInt(20)];
            for (int j = 0; j < input.length; ++j) {
                input[j] = random.nextDouble();
            }
            ReferenceFrame newFrame5 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameTuple = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Vector3D tuple4 = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple.getReferenceFrame());
            expectedException = null;
            try {
                tuple4.set(startIndex, input);
            }
            catch (Exception e) {
                expectedException = e;
            }
            try {
                frameTuple.setIncludingFrame(newFrame5, startIndex, input);
                if (expectedException != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame5, (Object)frameTuple.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple4, (EuclidGeometry)frameTuple, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj input = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            ReferenceFrame newFrame6 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple3DBasics frameTuple6 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple6.getReferenceFrame());
            Exception expectedException3 = null;
            try {
                tuple.set((DMatrix)input);
            }
            catch (Exception e) {
                expectedException3 = e;
            }
            try {
                frameTuple6.setIncludingFrame(newFrame6, (DMatrix)input);
                if (expectedException3 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame6, (Object)frameTuple6.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)frameTuple6, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException3 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException3.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException3.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException3));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            DMatrixRMaj input = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            ReferenceFrame newFrame7 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameTuple = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Vector3D tuple5 = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple.getReferenceFrame());
            expectedException = null;
            try {
                tuple5.set(startRow, (DMatrix)input);
            }
            catch (Exception e) {
                expectedException = e;
            }
            try {
                frameTuple.setIncludingFrame(newFrame7, startRow, (DMatrix)input);
                if (expectedException != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame7, (Object)frameTuple.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple5, (EuclidGeometry)frameTuple, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            int column = random.nextInt(10);
            DMatrixRMaj input = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)random.nextInt(20), (int)random.nextInt(20));
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameTuple3DBasics frameTuple7 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple7.getReferenceFrame());
            Exception expectedException4 = null;
            try {
                tuple2.set(startRow, column, (DMatrix)input);
            }
            catch (Exception e) {
                expectedException4 = e;
            }
            try {
                frameTuple7.setIncludingFrame(newFrame, startRow, column, (DMatrix)input);
                if (expectedException4 != null) {
                    throw new AssertionError((Object)"Should have thrown an exception.");
                }
                Assertions.assertEquals((Object)newFrame, (Object)frameTuple7.getReferenceFrame());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple2, (EuclidGeometry)frameTuple7, (double)1.0E-15);
                continue;
            }
            catch (Exception e) {
                if (expectedException4 == null) {
                    throw new AssertionError((Object)"Should not have thrown an exception.");
                }
                if (!e.getClass().equals(expectedException4.getClass()) || e.getMessage() != null && !e.getMessage().equals(expectedException4.getMessage())) {
                    throw new AssertionError((Object)("Unexpected exception:\nactual: " + e + "\nexpected: " + expectedException4));
                }
                continue;
            }
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame8 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint2D input = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)newFrame8);
            double z = random.nextDouble();
            FrameTuple3DBasics frameTuple8 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple2 = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple8.getReferenceFrame());
            frameTuple8.setIncludingFrame((FrameTuple2DReadOnly)input, z);
            tuple2.set((Tuple2DReadOnly)input, z);
            Assertions.assertEquals((Object)newFrame8, (Object)frameTuple8.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple2, (EuclidGeometry)frameTuple8, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame9 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint3D input = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)newFrame9);
            FrameTuple3DBasics frameTuple9 = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            tuple = new Vector3D();
            Assertions.assertEquals((Object)initialFrame, (Object)frameTuple9.getReferenceFrame());
            frameTuple9.setIncludingFrame((FrameTuple3DReadOnly)input);
            tuple.set((Tuple3DReadOnly)input);
            Assertions.assertEquals((Object)newFrame9, (Object)frameTuple9.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)frameTuple9, (double)1.0E-15);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            Tuple3DBasics expectedGeometryObject = this.createRandomFramelessTuple(random);
            expectedGeometryObject.setToZero();
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameTuple3DBasics frameGeometryObject = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((EuclidGeometry)frameGeometryObject, 1.0E-15));
            frameGeometryObject.setToZero();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedGeometryObject, (EuclidGeometry)frameGeometryObject, (double)1.0E-15);
            frameGeometryObject = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)expectedGeometryObject.epsilonEquals((EuclidGeometry)frameGeometryObject, 1.0E-15));
            frameGeometryObject.setToZero(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedGeometryObject, (EuclidGeometry)frameGeometryObject, (double)1.0E-15);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(574L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameTuple3DBasics frameGeometryObject = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN();
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)frameGeometryObject);
            frameGeometryObject = (FrameTuple3DBasics)this.createRandomFrameTuple(random, initialFrame);
            ReferenceFrame newFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Assertions.assertEquals((Object)initialFrame, (Object)frameGeometryObject.getReferenceFrame());
            Assertions.assertFalse((boolean)frameGeometryObject.containsNaN());
            frameGeometryObject.setToNaN(newFrame);
            Assertions.assertEquals((Object)newFrame, (Object)frameGeometryObject.getReferenceFrame());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)frameGeometryObject);
        }
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameTuple, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithTuple3D() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, tuple) -> (FrameTuple3DBasics)this.createFrameTuple(frame, (Tuple3DReadOnly)tuple);
        RandomFramelessTypeBuilder framelessTypeBuilber = this::createRandomFramelessTuple;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameTuple3DBasics.class, Tuple3DBasics.class, true, 1);
    }

    @Test
    public void testTuple3DBasicsFeatures() throws Exception {
        Tuple3DBasicsTest tuple3dBasicsTest = new Tuple3DBasicsTest<F>(){

            @Override
            public F createEmptyTuple() {
                return (FrameTuple3DBasics)FrameTuple3DBasicsTest.this.createEmptyFrameTuple();
            }

            @Override
            public F createTuple(double x, double y, double z) {
                return (FrameTuple3DBasics)FrameTuple3DBasicsTest.this.createFrameTuple(x, y, z);
            }

            @Override
            public F createRandomTuple(Random random) {
                return (FrameTuple3DBasics)FrameTuple3DBasicsTest.this.createRandomFrameTuple(random);
            }

            @Override
            public double getEpsilon() {
                return 1.0E-15;
            }
        };
        for (Method testMethod : tuple3dBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)tuple3dBasicsTest, new Object[0]);
        }
    }
}

