/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameShape3DPose;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameShapeAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.primitives.Shape3DPose;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;

public class FrameShape3DPoseTest {
    @Test
    public void testAPIOverloading() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FrameShape3DPoseReadOnly.class, Shape3DPoseReadOnly.class, false, 1, methodFilter);
        methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FixedFrameShape3DPoseBasics.class, Shape3DPoseBasics.class, false, 1, methodFilter);
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Shape3DPose.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Shape3DPose.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Shape3DPose.class, Double.TYPE}));
        methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FrameShape3DPose.class, Shape3DPose.class, false, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals");
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(EuclidFrameShapeRandomTools::nextFrameShape3DPose, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithShape3DPose() {
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().equals("toString");
        methodFilter = methodFilter.and(m -> !m.getName().contains("ChangeListener"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality((frame, shape3DPose) -> new FrameShape3DPose(frame, (RigidBodyTransformReadOnly)((Shape3DPose)shape3DPose)), EuclidShapeRandomTools::nextShape3DPose, methodFilter, 10);
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFrameShape3DPose, 10);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameShapeRandomTools::nextFrameShape3DPose, 10);
    }
}

