/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose2D;
import us.ihmc.euclid.geometry.interfaces.Pose2DReadOnly;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Pose2DTest {
    private static final double EPSILON = 1.0E-7;

    @Test
    public void testConstructors() {
        Random random = new Random(52942L);
        for (int i = 0; i < 1000; ++i) {
            double x = random.nextDouble() - random.nextDouble();
            double y = random.nextDouble() - random.nextDouble();
            double yaw = Math.PI - Math.PI * 2 * random.nextDouble();
            Pose2D allDoubles = new Pose2D(x, y, yaw);
            Assertions.assertEquals((double)x, (double)allDoubles.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)allDoubles.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)allDoubles.getYaw(), (double)1.0E-7);
            Pose2D toCopy = new Pose2D(x, y, yaw);
            Pose2D copyPose = new Pose2D((Pose2DReadOnly)toCopy);
            Assertions.assertEquals((double)x, (double)copyPose.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)copyPose.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)copyPose.getYaw(), (double)1.0E-7);
            Vector2D tuple = new Vector2D(x, y);
            Orientation2D orientation = new Orientation2D(yaw);
            Pose2D fromComponents = new Pose2D((Tuple2DReadOnly)tuple, (Orientation2DReadOnly)orientation);
            Assertions.assertEquals((double)x, (double)fromComponents.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)fromComponents.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)yaw, (double)fromComponents.getYaw(), (double)1.0E-7);
        }
    }
}

