/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.AxisAngleReadOnlyTest;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasicsTest;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public abstract class AxisAngleBasicsTest<T extends AxisAngleBasics>
extends AxisAngleReadOnlyTest<T> {
    @Test
    public void testScaleAngle() throws Exception {
        Random random = new Random(32434L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics axisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double angle = axisAngle.getAngle();
            axisAngle.scaleAngle(scale);
            Assertions.assertEquals((double)(scale * angle), (double)axisAngle.getAngle(), (double)this.getSmallestEpsilon());
        }
    }

    @Test
    public void testSetAngle() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics axisAngle = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            double expectedAngle = random.nextInt(100);
            axisAngle.setAngle(expectedAngle);
            Assertions.assertTrue((axisAngle.getX() == 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle() == expectedAngle ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSettter() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics axisAngle = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            UnitVector3D axis = new UnitVector3D((Tuple3DReadOnly)axisAngle.getAxis());
            double expectedX = random.nextInt(100);
            double expectedY = random.nextInt(100);
            double expectedZ = random.nextInt(100);
            double expectedAngle = random.nextDouble();
            axisAngle.setX(expectedX);
            axis.setX(expectedX);
            Assertions.assertEquals((double)axisAngle.getX(), (double)axis.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getY(), (double)axis.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getZ(), (double)axis.getZ(), (double)this.getEpsilon());
            Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
            axisAngle.setY(expectedY);
            axis.setY(expectedY);
            Assertions.assertEquals((double)axisAngle.getX(), (double)axis.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getY(), (double)axis.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getZ(), (double)axis.getZ(), (double)this.getEpsilon());
            Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
            axisAngle.setZ(expectedZ);
            axis.setZ(expectedZ);
            Assertions.assertEquals((double)axisAngle.getX(), (double)axis.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getY(), (double)axis.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getZ(), (double)axis.getZ(), (double)this.getEpsilon());
            Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
            axisAngle.setAngle(expectedAngle);
            Assertions.assertEquals((double)axisAngle.getX(), (double)axis.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getY(), (double)axis.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getZ(), (double)axis.getZ(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axisAngle.getAngle(), (double)expectedAngle, (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetToZero() {
        AxisAngleBasics axisAngle = (AxisAngleBasics)this.createAxisAngle(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)axisAngle);
        axisAngle.setToZero();
        Assertions.assertTrue((axisAngle.getX() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetToNaN() {
        AxisAngleBasics axisAngle = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((axisAngle.getX() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((axisAngle.getAngle() == 0.0 ? 1 : 0) != 0);
        axisAngle.setToNaN();
        EuclidCoreTestTools.assertAxisAngleContainsOnlyNaN((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getX()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getY()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getZ()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getAngle()));
    }

    @Test
    public void testNegate() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random);
            double y = EuclidCoreRandomTools.nextDouble((Random)random);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random);
            AxisAngleBasics expectedAxisAngle = (AxisAngleBasics)this.createAxisAngle(-x, -y, -z, -angle);
            AxisAngleBasics actualAxisAngle = (AxisAngleBasics)this.createAxisAngle(x, y, z, angle);
            actualAxisAngle.negate();
            Assertions.assertTrue((boolean)expectedAxisAngle.equals((EuclidGeometry)actualAxisAngle));
        }
    }

    @Test
    public void testAbsolute() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random);
            double y = EuclidCoreRandomTools.nextDouble((Random)random);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random);
            AxisAngleBasics expectedAxisAngle = (AxisAngleBasics)this.createAxisAngle(Math.abs(x), Math.abs(y), Math.abs(z), Math.abs(angle));
            AxisAngleBasics actualAxisAngle = (AxisAngleBasics)this.createAxisAngle(x, y, z, angle);
            actualAxisAngle.absolute();
            Assertions.assertTrue((boolean)expectedAxisAngle.equals((EuclidGeometry)actualAxisAngle));
        }
    }

    @Test
    public void testNormalizeAxis() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D randomAxis = EuclidCoreRandomTools.nextRotationVector((Random)random);
            double randomAngle = EuclidCoreRandomTools.nextDouble((Random)random);
            AxisAngleBasics actualAxisAngle = (AxisAngleBasics)this.createAxisAngle(randomAxis.getX(), randomAxis.getY(), randomAxis.getZ(), randomAngle);
            actualAxisAngle.normalize();
            randomAxis.normalize();
            AxisAngleBasics expectedAxisAngle = (AxisAngleBasics)this.createAxisAngle(randomAxis.getX(), randomAxis.getY(), randomAxis.getZ(), randomAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        AxisAngleBasics axisAngle = (AxisAngleBasics)this.createAxisAngle(Double.NaN, 0.0, 0.0, 0.0);
        axisAngle.normalize();
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getX()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getY()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getZ()));
        Assertions.assertFalse((boolean)Double.isNaN(axisAngle.getAngle()));
        axisAngle = (AxisAngleBasics)this.createAxisAngle(0.0, Double.NaN, 0.0, 0.0);
        axisAngle.normalize();
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getX()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getY()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getZ()));
        Assertions.assertFalse((boolean)Double.isNaN(axisAngle.getAngle()));
        axisAngle = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, Double.NaN, 0.0);
        axisAngle.normalize();
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getX()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getY()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getZ()));
        Assertions.assertFalse((boolean)Double.isNaN(axisAngle.getAngle()));
        axisAngle = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, 0.0, Double.NaN);
        axisAngle.normalize();
        Assertions.assertFalse((boolean)Double.isNaN(axisAngle.getX()));
        Assertions.assertFalse((boolean)Double.isNaN(axisAngle.getY()));
        Assertions.assertFalse((boolean)Double.isNaN(axisAngle.getZ()));
        Assertions.assertTrue((boolean)Double.isNaN(axisAngle.getAngle()));
    }

    @Test
    public void testInvert() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics axisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics inverseAxisAngle = (AxisAngleBasics)this.createEmptyAxisAngle();
            inverseAxisAngle.set((AxisAngleReadOnly)axisAngle);
            inverseAxisAngle.invert();
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)axisAngle);
            RotationMatrix inverseRotationMatrix = new RotationMatrix((Orientation3DReadOnly)inverseAxisAngle);
            RotationMatrix identityExpected = new RotationMatrix();
            identityExpected.set(rotationMatrix);
            identityExpected.multiply((RotationMatrixReadOnly)inverseRotationMatrix);
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)identityExpected, (double)this.getEpsilon());
            AxisAngleBasics zeroExpected = (AxisAngleBasics)this.createEmptyAxisAngle();
            zeroExpected.multiply((AxisAngleReadOnly)axisAngle, (AxisAngleReadOnly)inverseAxisAngle);
            EuclidCoreTestTools.assertAngleEquals((double)0.0, (double)zeroExpected.getAngle(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetWithDoubles() {
        Random random = new Random(5646541L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics actualAxisAngle = (AxisAngleBasics)this.createEmptyAxisAngle();
            UnitVector3D axis = new UnitVector3D();
            actualAxisAngle.set(expectedAxisAngle.getX(), expectedAxisAngle.getY(), expectedAxisAngle.getZ(), expectedAxisAngle.getAngle());
            axis.set(expectedAxisAngle.getX(), expectedAxisAngle.getY(), expectedAxisAngle.getZ());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axis, (EuclidGeometry)actualAxisAngle.getAxis(), (double)this.getEpsilon());
            Assertions.assertTrue((expectedAxisAngle.getAngle() == actualAxisAngle.getAngle() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSet() {
        int i;
        AxisAngleBasics actualAxisAngle = (AxisAngleBasics)this.createEmptyAxisAngle();
        AxisAngleBasics expectedAxisAngle = (AxisAngleBasics)this.createEmptyAxisAngle();
        Random random = new Random(64654L);
        for (i = 0; i < 1000; ++i) {
            UnitVector3D vectorAxis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            double angle = random.nextDouble();
            actualAxisAngle.set((Vector3DReadOnly)vectorAxis, angle);
            Assertions.assertEquals((double)actualAxisAngle.getX(), (double)vectorAxis.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)actualAxisAngle.getY(), (double)vectorAxis.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)actualAxisAngle.getZ(), (double)vectorAxis.getZ(), (double)this.getEpsilon());
            Assertions.assertEquals((double)actualAxisAngle.getAngle(), (double)angle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            actualAxisAngle.set((AxisAngleReadOnly)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)actualAxisAngle, (EuclidGeometry)expectedAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            actualAxisAngle.set((AxisAngleReadOnly)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)actualAxisAngle, (EuclidGeometry)expectedAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double[] axisAngleArray = new double[]{expectedAxisAngle.getX(), expectedAxisAngle.getY(), expectedAxisAngle.getZ(), expectedAxisAngle.getAngle()};
            actualAxisAngle.set(axisAngleArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            int startIndex = random.nextInt(10);
            double[] axisAngleArray = new double[4 + startIndex + random.nextInt(10)];
            expectedAxisAngle.get(startIndex, axisAngleArray);
            actualAxisAngle.set(startIndex, axisAngleArray);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            float[] axisAngleArray = new float[]{expectedAxisAngle.getX32(), expectedAxisAngle.getY32(), expectedAxisAngle.getZ32(), expectedAxisAngle.getAngle32()};
            actualAxisAngle.set(axisAngleArray);
            UnitVector3D expectedAxis = new UnitVector3D();
            expectedAxis.set(axisAngleArray);
            Assertions.assertEquals((double)expectedAxis.getX32(), (double)actualAxisAngle.getX32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedAxis.getY32(), (double)actualAxisAngle.getY32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedAxis.getZ32(), (double)actualAxisAngle.getZ32(), (double)this.getEpsilon());
            Assertions.assertTrue((expectedAxisAngle.getAngle32() == actualAxisAngle.getAngle32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            expectedAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            int startIndex = random.nextInt(10);
            float[] axisAngleArray = new float[4 + startIndex + random.nextInt(10)];
            expectedAxisAngle.get(startIndex, axisAngleArray);
            actualAxisAngle.set(startIndex, axisAngleArray);
            UnitVector3D expectedAxis = new UnitVector3D();
            expectedAxis.set(startIndex, axisAngleArray);
            Assertions.assertEquals((double)expectedAxis.getX32(), (double)actualAxisAngle.getX32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedAxis.getY32(), (double)actualAxisAngle.getY32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedAxis.getZ32(), (double)actualAxisAngle.getZ32(), (double)this.getEpsilon());
            Assertions.assertTrue((expectedAxisAngle.getAngle32() == actualAxisAngle.getAngle32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actualAxisAngle.set((Orientation3DReadOnly)quaternion);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)quaternion, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualAxisAngle.set((Orientation3DReadOnly)matrix);
            AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)matrix, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            actualAxisAngle.setRotationVector((Vector3DReadOnly)rotationVector);
            AxisAngleConversion.convertRotationVectorToAxisAngle((Vector3DReadOnly)rotationVector, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.5707963267948966);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actualAxisAngle.setYawPitchRoll(yaw, pitch, roll);
            AxisAngleConversion.convertYawPitchRollToAxisAngle((double)yaw, (double)pitch, (double)roll, (AxisAngleBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAxisAngle, (EuclidGeometry)actualAxisAngle, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            actualAxisAngle = (AxisAngleBasics)this.createRandomAxisAngle(random);
            UnitVector3D unitVector = new UnitVector3D((Tuple3DReadOnly)actualAxisAngle.getAxis());
            for (int index = 0; index < 4; ++index) {
                double expectedValue = random.nextDouble();
                actualAxisAngle.setElement(index, expectedValue);
                if (index < 3) {
                    unitVector.setElement(index, expectedValue);
                    Assertions.assertEquals((double)unitVector.getElement(index), (double)actualAxisAngle.getElement(index), (double)this.getEpsilon());
                    continue;
                }
                Assertions.assertEquals((double)expectedValue, (double)actualAxisAngle.getElement(index), (double)this.getEpsilon());
            }
        }
    }

    @Test
    public void testMultiply() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaOther2 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaActual = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaExpected = (AxisAngleBasics)this.createEmptyAxisAngle();
            Quaternion qOther1 = new Quaternion((Orientation3DReadOnly)aaOther1);
            Quaternion qOther2 = new Quaternion((Orientation3DReadOnly)aaOther2);
            Quaternion qExpected = new Quaternion();
            aaActual.set((AxisAngleReadOnly)aaOther1);
            qExpected.set((Orientation3DReadOnly)aaOther1);
            aaActual.multiply((AxisAngleReadOnly)aaOther2);
            AxisAngleTools.multiply((AxisAngleReadOnly)aaOther1, (AxisAngleReadOnly)aaOther2, (AxisAngleBasics)aaExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            QuaternionTools.multiply((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaActual.set((AxisAngleReadOnly)aaOther1);
            qExpected.set((Orientation3DReadOnly)aaOther1);
            double scale = 0.5 + random.nextDouble();
            aaActual.setX(scale * aaActual.getX());
            aaActual.setY(scale * aaActual.getY());
            aaActual.setZ(scale * aaActual.getZ());
            aaActual.multiply((AxisAngleReadOnly)aaOther2);
            QuaternionTools.multiply((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaActual.set((AxisAngleReadOnly)aaOther1);
            qExpected.set((Orientation3DReadOnly)aaOther1);
            QuaternionTools.multiply((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            aaOther2.setX(scale * aaOther2.getX());
            aaOther2.setY(scale * aaOther2.getY());
            aaOther2.setZ(scale * aaOther2.getZ());
            aaActual.multiply((AxisAngleReadOnly)aaOther2);
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            aaOther2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaOther2.set((AxisAngleReadOnly)aaOther1);
            aaOther2.negate();
            aaActual = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaActual.multiply((AxisAngleReadOnly)aaOther1, (AxisAngleReadOnly)aaOther2);
            Quaternion qOther12 = new Quaternion((Orientation3DReadOnly)aaOther1);
            Quaternion qOther22 = new Quaternion((Orientation3DReadOnly)aaOther2);
            Quaternion qExpected2 = new Quaternion();
            qExpected2.multiply((QuaternionReadOnly)qOther12, (QuaternionReadOnly)qOther22);
            AxisAngleBasics aaExpected2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaExpected2.set((Orientation3DReadOnly)qExpected2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaExpected2, (EuclidGeometry)aaActual, (double)this.getEpsilon());
            aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            aaOther2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaOther2.set((AxisAngleReadOnly)aaOther1);
            aaOther2.invert();
            aaActual = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaActual.multiply((AxisAngleReadOnly)aaOther1, (AxisAngleReadOnly)aaOther2);
            qOther12 = new Quaternion((Orientation3DReadOnly)aaOther1);
            qOther22 = new Quaternion((Orientation3DReadOnly)aaOther2);
            qExpected2 = new Quaternion();
            qExpected2.multiply((QuaternionReadOnly)qOther12, (QuaternionReadOnly)qOther22);
            aaExpected2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaExpected2.set((Orientation3DReadOnly)qExpected2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaExpected2, (EuclidGeometry)aaActual, (double)this.getEpsilon());
            aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            aaOther2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaOther2.set((AxisAngleReadOnly)aaOther1);
            aaOther2.append((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), Math.PI));
            aaActual = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaActual.multiply((AxisAngleReadOnly)aaOther1, (AxisAngleReadOnly)aaOther2);
            qOther12 = new Quaternion((Orientation3DReadOnly)aaOther1);
            qOther22 = new Quaternion((Orientation3DReadOnly)aaOther2);
            qExpected2 = new Quaternion();
            qExpected2.multiply((QuaternionReadOnly)qOther12, (QuaternionReadOnly)qOther22);
            aaExpected2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaExpected2.set((Orientation3DReadOnly)qExpected2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaExpected2, (EuclidGeometry)aaActual, (double)this.getEpsilon());
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            AxisAngleBasics aaOther12 = (AxisAngleBasics)this.createEmptyAxisAngle();
            AxisAngleBasics aaOther22 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaOther12.set((Vector3DReadOnly)axis, alpha * Math.PI);
            aaOther22.set((Vector3DReadOnly)axis, (1.0 - alpha) * Math.PI);
            AxisAngleBasics aaActual2 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaActual2.multiply((AxisAngleReadOnly)aaOther12, (AxisAngleReadOnly)aaOther22);
            Quaternion qOther13 = new Quaternion((Orientation3DReadOnly)aaOther12);
            Quaternion qOther23 = new Quaternion((Orientation3DReadOnly)aaOther22);
            Quaternion qExpected3 = new Quaternion();
            qExpected3.multiply((QuaternionReadOnly)qOther13, (QuaternionReadOnly)qOther23);
            AxisAngleBasics aaExpected3 = (AxisAngleBasics)this.createEmptyAxisAngle();
            aaExpected3.set((Orientation3DReadOnly)qExpected3);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaExpected3, (EuclidGeometry)aaActual2, (double)this.getEpsilon());
        }
    }

    @Test
    public void testMultiplyInvert() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaOther2 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaActual = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaExpected = (AxisAngleBasics)this.createEmptyAxisAngle();
            Quaternion qOther1 = new Quaternion((Orientation3DReadOnly)aaOther1);
            Quaternion qOther2 = new Quaternion((Orientation3DReadOnly)aaOther2);
            Quaternion qExpected = new Quaternion();
            aaActual.set((AxisAngleReadOnly)aaOther1);
            qExpected.set((Orientation3DReadOnly)aaOther1);
            aaActual.multiplyInvertThis((AxisAngleReadOnly)aaOther2);
            AxisAngleTools.multiplyInvertLeft((AxisAngleReadOnly)aaOther1, (AxisAngleReadOnly)aaOther2, (AxisAngleBasics)aaExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaActual.set((AxisAngleReadOnly)aaOther1);
            aaActual.multiplyInvertOther((AxisAngleReadOnly)aaOther2);
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)qOther1, (QuaternionReadOnly)qOther2, (QuaternionBasics)qExpected);
            AxisAngleTools.multiplyInvertRight((AxisAngleReadOnly)aaOther1, (AxisAngleReadOnly)aaOther2, (AxisAngleBasics)aaExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPreMultiply() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaOther2 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaActual = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaExpected = (AxisAngleBasics)this.createEmptyAxisAngle();
            Quaternion qOther1 = new Quaternion((Orientation3DReadOnly)aaOther1);
            Quaternion qOther2 = new Quaternion((Orientation3DReadOnly)aaOther2);
            Quaternion qExpected = new Quaternion();
            aaActual.set((AxisAngleReadOnly)aaOther1);
            qExpected.set((Orientation3DReadOnly)aaOther1);
            aaActual.preMultiply((AxisAngleReadOnly)aaOther2);
            AxisAngleTools.multiply((AxisAngleReadOnly)aaOther2, (AxisAngleReadOnly)aaOther1, (AxisAngleBasics)aaExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            QuaternionTools.multiply((QuaternionReadOnly)qOther2, (QuaternionReadOnly)qOther1, (QuaternionBasics)qExpected);
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPreMultiplyInvert() {
        Random random = new Random(65445L);
        for (int i = 0; i < 1000; ++i) {
            AxisAngleBasics aaOther1 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaOther2 = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaActual = (AxisAngleBasics)this.createRandomAxisAngle(random);
            AxisAngleBasics aaExpected = (AxisAngleBasics)this.createEmptyAxisAngle();
            Quaternion qOther1 = new Quaternion((Orientation3DReadOnly)aaOther1);
            Quaternion qOther2 = new Quaternion((Orientation3DReadOnly)aaOther2);
            Quaternion qExpected = new Quaternion();
            aaActual.set((AxisAngleReadOnly)aaOther1);
            qExpected.set((Orientation3DReadOnly)aaOther1);
            aaActual.preMultiplyInvertThis((AxisAngleReadOnly)aaOther2);
            AxisAngleTools.multiplyInvertRight((AxisAngleReadOnly)aaOther2, (AxisAngleReadOnly)aaOther1, (AxisAngleBasics)aaExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            QuaternionTools.multiplyConjugateRight((QuaternionReadOnly)qOther2, (QuaternionReadOnly)qOther1, (QuaternionBasics)qExpected);
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaActual.set((AxisAngleReadOnly)aaOther1);
            aaActual.preMultiplyInvertOther((AxisAngleReadOnly)aaOther2);
            QuaternionTools.multiplyConjugateLeft((QuaternionReadOnly)qOther2, (QuaternionReadOnly)qOther1, (QuaternionBasics)qExpected);
            AxisAngleTools.multiplyInvertLeft((AxisAngleReadOnly)aaOther2, (AxisAngleReadOnly)aaOther1, (AxisAngleBasics)aaExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
            aaExpected.set((Orientation3DReadOnly)qExpected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)aaActual, (EuclidGeometry)aaExpected, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAppendYawPitchRoll() throws Exception {
        AxisAngleBasics original;
        int i;
        Random random = new Random(35454L);
        AxisAngleBasics expected = (AxisAngleBasics)this.createEmptyAxisAngle();
        AxisAngleBasics actual = (AxisAngleBasics)this.createEmptyAxisAngle();
        double scale = 0.5 + random.nextDouble();
        for (i = 0; i < 1000; ++i) {
            original = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngleBasics yawRotation = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, 1.0, yaw);
            AxisAngleTools.multiply((AxisAngleReadOnly)original, (AxisAngleReadOnly)yawRotation, (AxisAngleBasics)expected);
            actual.set((AxisAngleReadOnly)original);
            actual.setX(scale * actual.getX());
            actual.setY(scale * actual.getY());
            actual.setZ(scale * actual.getZ());
            actual.appendYawRotation(yaw);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngleBasics pitchRotation = (AxisAngleBasics)this.createAxisAngle(0.0, 1.0, 0.0, pitch);
            AxisAngleTools.multiply((AxisAngleReadOnly)original, (AxisAngleReadOnly)pitchRotation, (AxisAngleBasics)expected);
            actual.set((AxisAngleReadOnly)original);
            actual.setX(scale * actual.getX());
            actual.setY(scale * actual.getY());
            actual.setZ(scale * actual.getZ());
            actual.appendPitchRotation(pitch);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngleBasics rollRotation = (AxisAngleBasics)this.createAxisAngle(1.0, 0.0, 0.0, roll);
            AxisAngleTools.multiply((AxisAngleReadOnly)original, (AxisAngleReadOnly)rollRotation, (AxisAngleBasics)expected);
            actual.set((AxisAngleReadOnly)original);
            actual.setX(scale * actual.getX());
            actual.setY(scale * actual.getY());
            actual.setZ(scale * actual.getZ());
            actual.appendRollRotation(roll);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testPrependYawPitchRoll() throws Exception {
        AxisAngleBasics original;
        int i;
        Random random = new Random(35454L);
        AxisAngleBasics expected = (AxisAngleBasics)this.createEmptyAxisAngle();
        AxisAngleBasics actual = (AxisAngleBasics)this.createEmptyAxisAngle();
        double scale = 0.5 + random.nextDouble();
        for (i = 0; i < 1000; ++i) {
            original = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngleBasics yawRotation = (AxisAngleBasics)this.createAxisAngle(0.0, 0.0, 1.0, yaw);
            AxisAngleTools.multiply((AxisAngleReadOnly)yawRotation, (AxisAngleReadOnly)original, (AxisAngleBasics)expected);
            actual.set((AxisAngleReadOnly)original);
            actual.setX(scale * actual.getX());
            actual.setY(scale * actual.getY());
            actual.setZ(scale * actual.getZ());
            actual.prependYawRotation(yaw);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngleBasics pitchRotation = (AxisAngleBasics)this.createAxisAngle(0.0, 1.0, 0.0, pitch);
            AxisAngleTools.multiply((AxisAngleReadOnly)pitchRotation, (AxisAngleReadOnly)original, (AxisAngleBasics)expected);
            actual.set((AxisAngleReadOnly)original);
            actual.setX(scale * actual.getX());
            actual.setY(scale * actual.getY());
            actual.setZ(scale * actual.getZ());
            actual.prependPitchRotation(pitch);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = (AxisAngleBasics)this.createRandomAxisAngle(random);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            AxisAngleBasics rollRotation = (AxisAngleBasics)this.createAxisAngle(1.0, 0.0, 0.0, roll);
            AxisAngleTools.multiply((AxisAngleReadOnly)rollRotation, (AxisAngleReadOnly)original, (AxisAngleBasics)expected);
            actual.set((AxisAngleReadOnly)original);
            actual.setX(scale * actual.getX());
            actual.setY(scale * actual.getY());
            actual.setZ(scale * actual.getZ());
            actual.prependRollRotation(roll);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testOrientation3DBasicsFeatures() throws Throwable {
        Orientation3DBasicsTest test = new Orientation3DBasicsTest(){

            @Override
            public Orientation3DBasics createEmptyOrientation3DBasics() {
                return (Orientation3DBasics)AxisAngleBasicsTest.this.createEmptyAxisAngle();
            }

            @Override
            public double getEpsilon() {
                return AxisAngleBasicsTest.this.getEpsilon();
            }
        };
        for (Method testMethod : test.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            try {
                testMethod.invoke((Object)test, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

