/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.yawPitchRoll;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.YawPitchRollBasicsTest;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class YawPitchRollTest
extends YawPitchRollBasicsTest<YawPitchRoll> {
    @Test
    public void testConstructors() throws Exception {
        YawPitchRoll ypr;
        int i;
        Random random = new Random(423534L);
        for (i = 0; i < 1000; ++i) {
            YawPitchRoll ypr2 = new YawPitchRoll();
            Assertions.assertTrue((ypr2.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr2.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((ypr2.getRoll() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            ypr = new YawPitchRoll((Orientation3DReadOnly)q);
            Assertions.assertEquals((double)ypr.getYaw(), (double)q.getYaw(), (double)this.getEpsilon());
            Assertions.assertEquals((double)ypr.getPitch(), (double)q.getPitch(), (double)this.getEpsilon());
            Assertions.assertEquals((double)ypr.getRoll(), (double)q.getRoll(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double roll;
            double pitch;
            double yaw = random.nextDouble();
            YawPitchRoll ypr3 = new YawPitchRoll(yaw, pitch = random.nextDouble(), roll = random.nextDouble());
            Assertions.assertTrue((ypr3.getYaw() == yaw ? 1 : 0) != 0);
            Assertions.assertTrue((ypr3.getPitch() == pitch ? 1 : 0) != 0);
            Assertions.assertTrue((ypr3.getRoll() == roll ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            double[] yprArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            ypr = new YawPitchRoll(yprArray);
            Assertions.assertTrue((ypr.getYaw() == yprArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == yprArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == yprArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            YawPitchRoll actual = new YawPitchRoll((Vector3DReadOnly)rotationVector);
            YawPitchRoll expected = new YawPitchRoll();
            YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
    }

    @Override
    @Test
    public void testSet() {
        super.testSet();
        Random random = new Random(356L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll ypr1 = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll ypr2 = new YawPitchRoll();
            Assertions.assertFalse((boolean)ypr1.epsilonEquals((EuclidGeometry)ypr2, this.getEpsilon()));
            ypr2.set((YawPitchRollReadOnly)ypr1);
            Assertions.assertTrue((boolean)ypr1.epsilonEquals((EuclidGeometry)ypr2, this.getEpsilon()));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)ypr1, (EuclidGeometry)ypr2, (double)this.getEpsilon());
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        YawPitchRoll ypr = new YawPitchRoll();
        ypr.setYaw(random.nextDouble());
        ypr.setPitch(random.nextDouble());
        ypr.setRoll(random.nextDouble());
        int newHashCode = ypr.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)ypr.hashCode());
        int previousHashCode = ypr.hashCode();
        for (int i = 0; i < 1000; ++i) {
            ypr.setElement(i % 3, random.nextDouble());
            newHashCode = ypr.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    public YawPitchRoll createEmptyYawPitchRoll() {
        return new YawPitchRoll();
    }

    @Override
    public YawPitchRoll createRandomYawPitchRoll(Random random) {
        return EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
    }

    @Override
    public YawPitchRoll createYawPitchRoll(double yaw, double pitch, double roll) {
        return new YawPitchRoll(yaw, pitch, roll);
    }

    @Override
    public YawPitchRoll createYawPitchRoll(Orientation3DReadOnly orientation3D) {
        return new YawPitchRoll(orientation3D);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-13;
    }

    @Override
    public double getSmallestEpsilon() {
        return 1.0E-15;
    }
}

