/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Tuple2DBasicsTest;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Vector2DBasicsTest<T extends Vector2DBasics>
extends Tuple2DBasicsTest<T> {
    @Test
    public void testAngle() {
        Random random = new Random(56461L);
        for (int i = 0; i < 1000; ++i) {
            Vector2DBasics vector1 = (Vector2DBasics)this.createRandomTuple(random);
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double x = EuclidCoreTools.cos((double)expectedAngle) * vector1.getX() - EuclidCoreTools.sin((double)expectedAngle) * vector1.getY();
            double y = EuclidCoreTools.sin((double)expectedAngle) * vector1.getX() + EuclidCoreTools.cos((double)expectedAngle) * vector1.getY();
            Vector2DBasics vector2 = (Vector2DBasics)this.createTuple(x, y);
            vector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0));
            double actualAngle = vector1.angle((Vector2DReadOnly)vector2);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)this.getEpsilon());
        }
    }

    @Test
    public void testCross() {
        Vector2DBasics vector2;
        double y;
        double x;
        double angle;
        Vector2DBasics vector1;
        int i;
        Random random = new Random(56461L);
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector2DBasics)this.createRandomTuple(random);
            angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            x = EuclidCoreTools.cos((double)angle) * vector1.getX() - EuclidCoreTools.sin((double)angle) * vector1.getY();
            y = EuclidCoreTools.sin((double)angle) * vector1.getX() + EuclidCoreTools.cos((double)angle) * vector1.getY();
            vector2 = (Vector2DBasics)this.createTuple(x, y);
            double expectedDot = vector1.norm() * vector2.norm() * EuclidCoreTools.sin((double)angle);
            double actualDot = vector1.cross((Tuple2DReadOnly)vector2);
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector2DBasics)this.createRandomTuple(random);
            angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            x = EuclidCoreTools.cos((double)angle) * vector1.getX() - EuclidCoreTools.sin((double)angle) * vector1.getY();
            y = EuclidCoreTools.sin((double)angle) * vector1.getX() + EuclidCoreTools.cos((double)angle) * vector1.getY();
            vector2 = (Vector2DBasics)this.createTuple(x, y);
            vector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0));
            double expectedCross = vector1.norm() * vector2.norm() * EuclidCoreTools.sin((double)angle);
            double actualCross = Vector2DReadOnly.cross((Tuple2DReadOnly)vector1, (Tuple2DReadOnly)vector2);
            Assertions.assertEquals((double)expectedCross, (double)actualCross, (double)this.getEpsilon());
        }
    }

    @Test
    public void testNormalize() {
        Vector2DBasics vector1;
        int i;
        Random random = new Random(312310L);
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector2DBasics)this.createRandomTuple(random);
            vector1.normalize();
            double expectedLength = 1.0;
            double actualLength = vector1.norm();
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)this.getEpsilon());
            Vector2DBasics vector2 = (Vector2DBasics)this.createRandomTuple(random);
            vector2.normalize();
            vector1.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)vector2);
            vector1.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vector1, (EuclidGeometry)vector2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector2DBasics)this.createRandomTuple(random);
            Vector2DBasics vector2 = (Vector2DBasics)this.createEmptyTuple();
            vector2.setAndNormalize((Tuple2DReadOnly)vector1);
            double expectedLength = 1.0;
            double actualLength = vector2.norm();
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)this.getEpsilon());
            vector2 = (Vector2DBasics)this.createRandomTuple(random);
            vector2.normalize();
            Vector2DBasics vector3 = (Vector2DBasics)this.createEmptyTuple();
            vector3.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)vector2);
            vector1.setAndNormalize((Tuple2DReadOnly)vector3);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vector1, (EuclidGeometry)vector2, (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Vector2DBasics original = (Vector2DBasics)this.createRandomTuple(random);
            Vector2DBasics actual = (Vector2DBasics)this.createEmptyTuple();
            Vector2DBasics expected = (Vector2DBasics)this.createEmptyTuple();
            RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
            rigidBodyTransform.getRotation().setToYawOrientation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            rigidBodyTransform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((Tuple2DReadOnly)original);
            rigidBodyTransform.transform(expected);
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            try {
                actual.applyTransform((Transform)rigidBodyTransform);
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
            }
            catch (NotAMatrix2DException notAMatrix2DException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
            }
            try {
                actual.applyTransform((Transform)rigidBodyTransform, true);
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
            }
            catch (NotAMatrix2DException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
            }
            actual.applyTransform((Transform)rigidBodyTransform, false);
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Vector2DBasics original = (Vector2DBasics)this.createRandomTuple(random);
            Vector2DBasics actual = (Vector2DBasics)this.createEmptyTuple();
            Vector2DBasics expected = (Vector2DBasics)this.createEmptyTuple();
            RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
            rigidBodyTransform.getRotation().setToYawOrientation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            rigidBodyTransform.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((Tuple2DReadOnly)original);
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform);
            actual.applyInverseTransform((Transform)rigidBodyTransform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, false);
            actual.applyInverseTransform((Transform)rigidBodyTransform, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            actual.set((Tuple2DReadOnly)original);
            actual.applyTransform((Transform)rigidBodyTransform, true);
            actual.applyInverseTransform((Transform)rigidBodyTransform, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
            rigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            try {
                actual.applyInverseTransform((Transform)rigidBodyTransform);
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
            }
            catch (NotAnOrientation2DException notAnOrientation2DException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
            }
            try {
                actual.applyInverseTransform((Transform)rigidBodyTransform, true);
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
            }
            catch (NotAnOrientation2DException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a NotAnOrientation2DException.");
            }
            actual.applyInverseTransform((Transform)rigidBodyTransform, false);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector2D vectorB;
            Vector2D vectorA = EuclidCoreRandomTools.nextVector2D((Random)random);
            if (vectorA.epsilonEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextVector2D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, EuclidCoreTools.squareRoot((double)3.0) * this.getEpsilon()));
            } else if (EuclidCoreTools.norm((double)(vectorA.getX() - vectorB.getX()), (double)(vectorA.getY() - vectorB.getY())) <= this.getEpsilon()) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
            } else {
                Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
            }
            vectorA = EuclidCoreRandomTools.nextVector2D((Random)random);
            vectorB = new Vector2D((Tuple2DReadOnly)vectorA);
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, 0.0));
            vectorB.set(vectorA.getX() + 0.9 * this.getEpsilon(), vectorA.getY());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX() + 1.1 * this.getEpsilon(), vectorA.getY());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY() + 0.9 * this.getEpsilon());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY() + 1.1 * this.getEpsilon());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
        }
    }
}

