/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class YawPitchRollToolsTest {
    public static final double EPSILON = 1.0E-12;

    @Test
    public void testIsZero() {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            double roll = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isZero((double)yaw, (double)pitch, (double)roll, (double)epsilon));
        }
    }

    @Test
    public void testIsOrientation2D() {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            double roll = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = Double.NaN;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = Double.NaN;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0);
            roll = 0.0;
            pitch = 0.0;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            roll = epsilon;
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
            roll = 0.0;
            pitch = 0.0;
            roll = 1.01 * epsilon;
            Assertions.assertFalse((boolean)YawPitchRollTools.isOrientation2D((double)yaw, (double)pitch, (double)roll, (double)epsilon));
        }
    }

    @Test
    public void testDistance() throws Exception {
        RotationMatrix converted;
        double expectedDistance;
        YawPitchRoll yawPitchRoll;
        int i;
        Random random = new Random(5321L);
        for (i = 0; i < 1000; ++i) {
            YawPitchRoll firstYPR = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll secondYPR = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            Quaternion firstQ = new Quaternion((Orientation3DReadOnly)firstYPR);
            Quaternion secondQ = new Quaternion((Orientation3DReadOnly)secondYPR);
            Assertions.assertEquals((double)firstQ.distance((Orientation3DReadOnly)secondQ), (double)YawPitchRollTools.distance((YawPitchRollReadOnly)firstYPR, (YawPitchRollReadOnly)secondYPR), (double)1.0E-12);
            Assertions.assertEquals((double)firstQ.distance((Orientation3DReadOnly)secondQ), (double)YawPitchRollTools.distance((double)firstYPR.getYaw(), (double)firstYPR.getPitch(), (double)firstYPR.getRoll(), (double)secondYPR.getYaw(), (double)secondYPR.getPitch(), (double)secondYPR.getRoll()), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion selfConverted = new Quaternion((Orientation3DReadOnly)yawPitchRoll);
            double actualDistance = YawPitchRollTools.distance((YawPitchRollReadOnly)yawPitchRoll, (QuaternionReadOnly)quaternion, (boolean)false);
            expectedDistance = QuaternionTools.distance((QuaternionReadOnly)selfConverted, (QuaternionReadOnly)quaternion, (boolean)false);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            converted = new RotationMatrix((Orientation3DReadOnly)yawPitchRoll);
            double actualDistance = YawPitchRollTools.distance((YawPitchRollReadOnly)yawPitchRoll, (RotationMatrixReadOnly)rotationMatrix);
            expectedDistance = RotationMatrixTools.distance((RotationMatrixReadOnly)rotationMatrix, (RotationMatrixReadOnly)converted);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            converted = new AxisAngle((Orientation3DReadOnly)yawPitchRoll);
            double actualDistance = YawPitchRollTools.distance((YawPitchRollReadOnly)yawPitchRoll, (AxisAngleReadOnly)axisAngle, (boolean)false);
            expectedDistance = AxisAngleTools.distance((AxisAngleReadOnly)axisAngle, (AxisAngleReadOnly)converted, (boolean)false);
            Assertions.assertEquals((double)actualDistance, (double)expectedDistance, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double withQuaternionResult = YawPitchRollTools.distance((YawPitchRollReadOnly)yawPitchRoll, (QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)orientation), (boolean)false);
            double withRotationMatrixResult = YawPitchRollTools.distance((YawPitchRollReadOnly)yawPitchRoll, (Orientation3DReadOnly)new RotationMatrix((Orientation3DReadOnly)orientation), (boolean)false);
            double notCastedResult = YawPitchRollTools.distance((YawPitchRollReadOnly)yawPitchRoll, (Orientation3DReadOnly)orientation, (boolean)false);
            if (Math.abs(notCastedResult) <= Math.PI) {
                Assertions.assertEquals((double)notCastedResult, (double)withRotationMatrixResult, (double)1.0E-12);
                continue;
            }
            Assertions.assertEquals((double)notCastedResult, (double)withQuaternionResult, (double)1.0E-12);
        }
        double min = Math.PI;
        double max = 2.0 * min;
        for (int i2 = 0; i2 < 1000; ++i2) {
            double randomAngle = ThreadLocalRandom.current().nextDouble(min, max);
            AxisAngle aa1 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle distance = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            distance.setAngle(randomAngle);
            AxisAngle aa2 = new AxisAngle();
            AxisAngleTools.multiply((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)distance, (AxisAngleBasics)aa2);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            YawPitchRoll ypr1 = new YawPitchRoll((Orientation3DReadOnly)q1);
            YawPitchRoll ypr2 = new YawPitchRoll((Orientation3DReadOnly)aa2);
            double expected = QuaternionTools.distance((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (boolean)true);
            double actual1 = YawPitchRollTools.distance((YawPitchRollReadOnly)ypr1, (QuaternionReadOnly)q2, (boolean)true);
            double actual2 = YawPitchRollTools.distance((YawPitchRollReadOnly)ypr1, (AxisAngleReadOnly)aa2, (boolean)true);
            double actual3 = YawPitchRollTools.distance((YawPitchRollReadOnly)ypr1, (YawPitchRollReadOnly)ypr2, (boolean)true);
            double expectedNoLimit = QuaternionTools.distance((QuaternionReadOnly)q1, (QuaternionReadOnly)q2, (boolean)false);
            Assertions.assertFalse((Math.abs(actual1 - expectedNoLimit) < 1.0E-12 ? 1 : 0) != 0);
            Assertions.assertFalse((Math.abs(actual2 - expectedNoLimit) < 1.0E-12 ? 1 : 0) != 0);
            Assertions.assertFalse((Math.abs(actual3 - expectedNoLimit) < 1.0E-12 ? 1 : 0) != 0);
            Assertions.assertEquals((double)expected, (double)actual1, (double)1.0E-12);
            Assertions.assertEquals((double)expected, (double)actual2, (double)1.0E-12);
            Assertions.assertEquals((double)expected, (double)actual3, (double)1.0E-12);
            Orientation3DBasics orientation3D = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            double distanceLimit = YawPitchRollTools.distance((YawPitchRollReadOnly)ypr1, (Orientation3DReadOnly)orientation3D, (boolean)true);
            double distanceLimitFromQuaternion = QuaternionTools.distance((QuaternionReadOnly)q1, (Orientation3DReadOnly)orientation3D, (boolean)true);
            double distanceNoLimit = YawPitchRollTools.distance((YawPitchRollReadOnly)ypr1, (Orientation3DReadOnly)orientation3D, (boolean)false);
            double distanceNoLimitFromQuaternion = QuaternionTools.distance((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)ypr1), (Orientation3DReadOnly)orientation3D, (boolean)false);
            Assertions.assertEquals((double)distanceLimit, (double)distanceLimitFromQuaternion, (double)1.0E-12);
            Assertions.assertEquals((double)distanceNoLimit, (double)distanceNoLimitFromQuaternion, (double)1.0E-12);
        }
    }

    @Test
    public void testAngle() throws Exception {
        Random random = new Random(152345L);
        for (int i = 0; i < 1000; ++i) {
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            YawPitchRoll yawPitchRoll = new YawPitchRoll((Orientation3DReadOnly)quaternion);
            double expected = quaternion.angle();
            double actual = YawPitchRollTools.angle((YawPitchRollReadOnly)yawPitchRoll, (boolean)true);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testTransform() throws Exception {
        Point3D expected;
        Point3D actual;
        Point3D tupleOriginal;
        YawPitchRoll ypr;
        int i;
        Random random = new Random(24546654L);
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.addTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).addTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.addTransform((YawPitchRollReadOnly)ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).addTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$0(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$1(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$2(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testTransform$3(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).transform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testInverseTransform() throws Exception {
        Point3D expected;
        Point3D actual;
        Point3D tupleOriginal;
        YawPitchRoll ypr;
        int i;
        Random random = new Random(24546654L);
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$4(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$5(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)false);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$6(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setPitch(0.0);
            EuclidCoreTestTools.assertExceptionIsThrown(() -> YawPitchRollToolsTest.lambda$testInverseTransform$7(ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr.setRoll(0.0);
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix((Orientation3DReadOnly)ypr).inverseTransform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        Random random = new Random(5303298L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll ypr1 = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            AxisAngle aa1 = new AxisAngle((Orientation3DReadOnly)ypr1);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)ypr1);
            RotationMatrix r1 = new RotationMatrix((Orientation3DReadOnly)ypr1);
            YawPitchRoll ypr2 = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            AxisAngle aa2 = new AxisAngle((Orientation3DReadOnly)ypr2);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)ypr2);
            RotationMatrix r2 = new RotationMatrix((Orientation3DReadOnly)ypr2);
            for (int invertByte = 0; invertByte < 4; invertByte = (int)((byte)(invertByte + 1))) {
                boolean invert1 = (invertByte & 1) != 0;
                boolean invert2 = (invertByte & 2) != 0;
                Quaternion qExpected = new Quaternion();
                if (invert1) {
                    qExpected.setAndInvert((Orientation3DReadOnly)q1);
                } else {
                    qExpected.set((QuaternionReadOnly)q1);
                }
                if (invert2) {
                    qExpected.multiplyConjugateOther((QuaternionReadOnly)q2);
                } else {
                    qExpected.multiply((QuaternionReadOnly)q2);
                }
                YawPitchRoll yprExpected = new YawPitchRoll((Orientation3DReadOnly)qExpected);
                YawPitchRoll yprActual = new YawPitchRoll();
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)aa1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)q1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)r1, (boolean)invert1, (Orientation3DReadOnly)ypr2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)aa2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)q2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
                YawPitchRollTools.multiply((Orientation3DReadOnly)ypr1, (boolean)invert1, (Orientation3DReadOnly)r2, (boolean)invert2, (YawPitchRollBasics)yprActual);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)yprExpected, (EuclidGeometry)yprActual, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testPrependYawRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.prependYawRotation(yaw);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.prependYawRotation((YawPitchRollReadOnly)original, (double)yaw, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendYawRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.appendYawRotation(yaw);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.appendYawRotation((YawPitchRollReadOnly)original, (double)yaw, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependPitchRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.prependPitchRotation(pitch);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.prependPitchRotation((YawPitchRollReadOnly)original, (double)pitch, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendPitchRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.appendPitchRotation(pitch);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.appendPitchRotation((YawPitchRollReadOnly)original, (double)pitch, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrependRollRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.prependRollRotation(roll);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.prependRollRotation((YawPitchRollReadOnly)original, (double)roll, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAppendRollRotation() throws Exception {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll original = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            YawPitchRoll actual = new YawPitchRoll();
            YawPitchRoll expected = new YawPitchRoll();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            Quaternion q = new Quaternion();
            q.set((Orientation3DReadOnly)original);
            q.appendRollRotation(roll);
            expected.set((Orientation3DReadOnly)q);
            YawPitchRollTools.appendRollRotation((YawPitchRollReadOnly)original, (double)roll, (YawPitchRollBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    private static /* synthetic */ void lambda$testInverseTransform$7(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testInverseTransform$6(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testInverseTransform$5(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testInverseTransform$4(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.inverseTransform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$3(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$2(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((YawPitchRollReadOnly)ypr, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$1(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }

    private static /* synthetic */ void lambda$testTransform$0(YawPitchRoll ypr, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        YawPitchRollTools.transform((double)ypr.getYaw(), (double)ypr.getPitch(), (double)ypr.getRoll(), (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, (boolean)true);
    }
}

