/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import java.util.stream.DoubleStream;
import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.NotARotationMatrixException;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.Matrix3DFeatures;

public class Matrix3DFeaturesTest {
    private static final double EPS = 1.0E-10;

    @Test
    public void testContainsNaN() throws Exception {
        Matrix3D matrix = new Matrix3D();
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)matrix.containsNaN());
        matrix.set(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)matrix.containsNaN());
        matrix.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)matrix.containsNaN());
    }

    @Test
    public void testCheckIfRotationMatrixAndIsRotationMatrix() throws Exception {
        Random random = new Random(93486534L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToZero();
        this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, true);
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            int row = random.nextInt(3);
            int column = random.nextInt(3);
            matrix.setElement(row, column, matrix.getElement(row, column) + random.nextDouble());
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)1.5);
            matrix.setElement(row, 0, scale * matrix.getElement(row, 0));
            matrix.setElement(row, 1, scale * matrix.getElement(row, 1));
            matrix.setElement(row, 2, scale * matrix.getElement(row, 2));
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            column = random.nextInt(3);
            scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)1.5);
            matrix.setElement(0, column, scale * matrix.getElement(0, column));
            matrix.setElement(1, column, scale * matrix.getElement(1, column));
            matrix.setElement(2, column, scale * matrix.getElement(2, column));
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            column = random.nextInt(3);
            double previousValue = matrix.getElement(row, column);
            matrix.setElement(row, column, 0.0);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, Math.abs(previousValue) < 1.0E-7);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            column = random.nextInt(3);
            int row2 = random.nextInt(2);
            int column2 = random.nextInt(2);
            if (row2 == row) {
                ++row2;
            }
            if (column2 == column) {
                ++column2;
            }
            double temp = matrix.getElement(row, column);
            matrix.setElement(row, column, matrix.getElement(row2, column2));
            matrix.setElement(row2, column2, temp);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            row = random.nextInt(3);
            row2 = random.nextInt(2);
            if (row2 == row) {
                ++row2;
            }
            double[] swapArray = new double[3];
            double[] swapArray2 = new double[3];
            matrix.getRow(row, swapArray);
            matrix.getRow(row2, swapArray2);
            matrix.setRow(row, swapArray2);
            matrix.setRow(row2, swapArray);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
            matrix = new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            column = random.nextInt(3);
            column2 = random.nextInt(2);
            if (column2 == column) {
                ++column2;
            }
            matrix.getColumn(column, swapArray);
            matrix.getColumn(column2, swapArray2);
            matrix.setColumn(column, swapArray2);
            matrix.setColumn(column2, swapArray);
            this.testAllCheckIfRotationMatrixAndIsRotationMatrixMethods((Matrix3DReadOnly)matrix, false);
        }
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(2, 3)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 2)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(4, 3)));
        Assertions.assertThrows(MatrixDimensionException.class, () -> Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 4)));
    }

    private void testAllCheckIfRotationMatrixAndIsRotationMatrixMethods(Matrix3DReadOnly matrix, boolean isRotationMatrix) {
        int index;
        int column;
        int row;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        matrix.get((DMatrix)denseMatrix);
        DMatrixRMaj denseMatrixCopy = new DMatrixRMaj(denseMatrix);
        double[] matrixArray = new double[9];
        matrix.get(matrixArray);
        double[] matrixArrayCopy = new double[9];
        System.arraycopy(matrixArray, 0, matrixArrayCopy, 0, 9);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        try {
            Matrix3DFeatures.checkIfRotationMatrix((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22);
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().equals("The matrix is not a rotation matrix: \n" + matrix));
        }
        Assertions.assertTrue((Matrix3DFeatures.isRotationMatrix((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22) == isRotationMatrix ? 1 : 0) != 0);
        try {
            matrix.checkIfRotationMatrix();
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().equals("The matrix is not a rotation matrix: \n" + matrix));
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
        Assertions.assertTrue((matrix.isRotationMatrix() == isRotationMatrix ? 1 : 0) != 0);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)denseMatrix);
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("The matrix is not a rotation matrix: \n" + matrix));
        }
        for (int index2 = 0; index2 < denseMatrix.getNumElements(); ++index2) {
            Assertions.assertTrue((Double.compare(denseMatrix.get(index2), denseMatrixCopy.get(index2)) == 0 ? 1 : 0) != 0);
        }
        Assertions.assertTrue((Matrix3DFeatures.isRotationMatrix((DMatrix)denseMatrix) == isRotationMatrix ? 1 : 0) != 0);
        try {
            Matrix3DFeatures.checkIfRotationMatrix((double[])matrixArray);
            if (!isRotationMatrix) {
                Assertions.fail((String)"Should have thrown a NotARotationMatrixException.");
            }
        }
        catch (NotARotationMatrixException e) {
            if (isRotationMatrix) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("The matrix is not a rotation matrix: \n" + matrix));
        }
        for (index = 0; index < 9; ++index) {
            Assertions.assertTrue((Double.compare(matrixArray[index], matrixArrayCopy[index]) == 0 ? 1 : 0) != 0);
        }
        Assertions.assertTrue((Matrix3DFeatures.isRotationMatrix((double[])matrixArray) == isRotationMatrix ? 1 : 0) != 0);
        for (index = 0; index < 9; ++index) {
            Assertions.assertTrue((Double.compare(matrixArray[index], matrixArrayCopy[index]) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCheckIfMatrix2DAndIsMatrix2D() throws Exception {
        Random random = new Random(93486534L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToZero();
        this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D randomMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            randomMatrix.setM02(0.0);
            randomMatrix.setM20(0.0);
            randomMatrix.setM12(0.0);
            randomMatrix.setM21(0.0);
            randomMatrix.setM22(1.0);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, true);
            double delta = random.nextBoolean() ? 1.0 : -1.0;
            randomMatrix.setM22(1.0 + (delta *= random.nextDouble()));
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM22(1.0);
            randomMatrix.setM02(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM02(0.0);
            randomMatrix.setM20(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM20(0.0);
            randomMatrix.setM12(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
            randomMatrix.setM12(0.0);
            randomMatrix.setM21(0.0 + delta);
            this.testCheckIfMatrix2DAndIsMatrix2DMethods((Matrix3DReadOnly)randomMatrix, Math.abs(delta) < 1.0E-8);
        }
    }

    private void testCheckIfMatrix2DAndIsMatrix2DMethods(Matrix3DReadOnly matrix, boolean isMatrix2D) {
        int column;
        int row;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        double m01 = matrix.getM01();
        double m02 = matrix.getM02();
        double m10 = matrix.getM10();
        double m11 = matrix.getM11();
        double m12 = matrix.getM12();
        double m20 = matrix.getM20();
        double m21 = matrix.getM21();
        double m22 = matrix.getM22();
        String matrixAsString = EuclidCoreIOTools.getMatrix3DString((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22);
        Assertions.assertTrue((Matrix3DFeatures.isMatrix2D((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-8) == isMatrix2D ? 1 : 0) != 0);
        try {
            matrix.checkIfMatrix2D();
            if (!isMatrix2D) {
                Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
            }
        }
        catch (NotAMatrix2DException e) {
            if (isMatrix2D) {
                throw e;
            }
            Assertions.assertTrue((boolean)e.getMessage().equals("The matrix is not in XY plane: \n" + matrixAsString));
        }
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
        Assertions.assertTrue((matrix.isMatrix2D() == isMatrix2D ? 1 : 0) != 0);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testCheckMatrixSize() throws Exception {
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(2, 3));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().equals("Unexpected matrix size: 2-by-3. Must be 3-by-3."));
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 2));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().equals("Unexpected matrix size: 3-by-2. Must be 3-by-3."));
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(4, 3));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().equals("Unexpected matrix size: 4-by-3. Must be 3-by-3."));
        }
        try {
            Matrix3DFeatures.checkIfRotationMatrix((DMatrix)new DMatrixRMaj(3, 4));
            Assertions.fail((String)"Should have got a RuntimeException for providing a matrix with wrong size.");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().equals("Unexpected matrix size: 3-by-4. Must be 3-by-3."));
        }
    }

    @Test
    public void testDeterminant() throws Exception {
        double detScaled;
        double[] row2;
        double detSwapped;
        double temp2;
        double temp1;
        double temp0;
        double[] column2;
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        int i;
        Random random = new Random(641651L);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        Matrix3D identity = new Matrix3D();
        identity.setIdentity();
        Assertions.assertEquals((double)1.0, (double)identity.determinant(), (double)1.0E-10);
        Assertions.assertEquals((double)1.0, (double)Matrix3DFeatures.determinant((double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0), (double)1.0E-10);
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Assertions.assertEquals((double)1.0, (double)rotationMatrix.determinant(), (double)1.0E-10);
            double m00 = rotationMatrix.getM00();
            double m01 = rotationMatrix.getM01();
            double m02 = rotationMatrix.getM02();
            m10 = rotationMatrix.getM10();
            m11 = rotationMatrix.getM11();
            m12 = rotationMatrix.getM12();
            m20 = rotationMatrix.getM20();
            m21 = rotationMatrix.getM21();
            m22 = rotationMatrix.getM22();
            Assertions.assertEquals((double)1.0, (double)Matrix3DFeatures.determinant((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            int zeroColumn = random.nextInt(3);
            double[] row0 = new double[3];
            double[] row1 = new double[3];
            double[] row22 = new double[3];
            for (int column = 0; column < 3; ++column) {
                row0[column] = column == zeroColumn ? 0.0 : random.nextDouble();
                row1[column] = column == zeroColumn ? 0.0 : random.nextDouble();
                row22[column] = column == zeroColumn ? 0.0 : random.nextDouble();
            }
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row22[0], (double)row22[1], (double)row22[2]);
            Assertions.assertEquals((double)0.0, (double)det, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] column0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] column1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            column2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            int rowSwap1 = random.nextInt(3);
            int rowSwap2 = (rowSwap1 + 1 + random.nextInt(2)) % 3;
            temp0 = column0[rowSwap1];
            temp1 = column1[rowSwap1];
            temp2 = column2[rowSwap1];
            column0[rowSwap1] = column0[rowSwap2];
            column1[rowSwap1] = column1[rowSwap2];
            column2[rowSwap1] = column2[rowSwap2];
            column0[rowSwap2] = temp0;
            column1[rowSwap2] = temp1;
            column2[rowSwap2] = temp2;
            detSwapped = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            Assertions.assertEquals((double)detSwapped, (double)(-det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] row0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] row1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            row2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            int columnSwap1 = random.nextInt(3);
            int columnSwap2 = (columnSwap1 + 1 + random.nextInt(2)) % 3;
            temp0 = row0[columnSwap1];
            temp1 = row1[columnSwap1];
            temp2 = row2[columnSwap1];
            row0[columnSwap1] = row0[columnSwap2];
            row1[columnSwap1] = row1[columnSwap2];
            row2[columnSwap1] = row2[columnSwap2];
            row0[columnSwap2] = temp0;
            row1[columnSwap2] = temp1;
            row2[columnSwap2] = temp2;
            detSwapped = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            Assertions.assertEquals((double)detSwapped, (double)(-det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] column0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] column1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            column2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            int rowScale = random.nextInt(3);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            int n = rowScale;
            column0[n] = column0[n] * scale;
            int n2 = rowScale;
            column1[n2] = column1[n2] * scale;
            int n3 = rowScale;
            column2[n3] = column2[n3] * scale;
            detScaled = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            Assertions.assertEquals((double)detScaled, (double)(scale * det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] row0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] row1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            row2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            int columnScale = random.nextInt(3);
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
            int n = columnScale;
            row0[n] = row0[n] * scale;
            int n4 = columnScale;
            row1[n4] = row1[n4] * scale;
            int n5 = columnScale;
            row2[n5] = row2[n5] * scale;
            detScaled = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            Assertions.assertEquals((double)detScaled, (double)(scale * det), (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] column0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] column1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            column2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            int rowCopyDest = random.nextInt(3);
            int rowCopySrc = (rowCopyDest + 1 + random.nextInt(2)) % 3;
            column0[rowCopyDest] = column0[rowCopySrc];
            column1[rowCopyDest] = column1[rowCopySrc];
            column2[rowCopyDest] = column2[rowCopySrc];
            double det = Matrix3DFeatures.determinant((double)column0[0], (double)column1[0], (double)column2[0], (double)column0[1], (double)column1[1], (double)column2[1], (double)column0[2], (double)column1[2], (double)column2[2]);
            Assertions.assertEquals((double)0.0, (double)det, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double[] row0 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] row1 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            row2 = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            int columnCopyDest = random.nextInt(3);
            int columnCopySrc = (columnCopyDest + 1 + random.nextInt(2)) % 3;
            row0[columnCopyDest] = row0[columnCopySrc];
            row1[columnCopyDest] = row1[columnCopySrc];
            row2[columnCopyDest] = row2[columnCopySrc];
            double det = Matrix3DFeatures.determinant((double)row0[0], (double)row0[1], (double)row0[2], (double)row1[0], (double)row1[1], (double)row1[2], (double)row2[0], (double)row2[1], (double)row2[2]);
            Assertions.assertEquals((double)0.0, (double)det, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Matrix3D matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrix.get((DMatrix)denseMatrix);
            Assertions.assertEquals((double)CommonOps_DDRM.det((DMatrixRMaj)denseMatrix), (double)matrix.determinant(), (double)1.0E-10);
            double m00 = matrix.getM00();
            double m01 = matrix.getM01();
            double m02 = matrix.getM02();
            m10 = matrix.getM10();
            m11 = matrix.getM11();
            m12 = matrix.getM12();
            m20 = matrix.getM20();
            m21 = matrix.getM21();
            m22 = matrix.getM22();
            Assertions.assertEquals((double)CommonOps_DDRM.det((DMatrixRMaj)denseMatrix), (double)Matrix3DFeatures.determinant((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22), (double)1.0E-10);
        }
    }

    @Test
    public void testIsIdentity() throws Exception {
        Random random = new Random(982364L);
        Matrix3D matrix = new Matrix3D();
        matrix.setToZero();
        this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, false);
        matrix.setIdentity();
        this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, true);
        for (int i = 0; i < 1000; ++i) {
            double delta = random.nextBoolean() ? 1.0 : -1.0;
            matrix.setIdentity();
            matrix.setM00(matrix.getM00() + (delta *= random.nextDouble()));
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM01(matrix.getM01() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM02(matrix.getM02() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM10(matrix.getM10() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM11(matrix.getM11() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM12(matrix.getM12() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM20(matrix.getM20() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM21(matrix.getM21() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setIdentity();
            matrix.setM22(matrix.getM22() + delta);
            this.testAllIsIdentityMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
        }
    }

    private void testAllIsIdentityMethods(Matrix3DReadOnly matrix, boolean isIdentity) {
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        Assertions.assertTrue((Matrix3DFeatures.isIdentity((double)m00, (double)(m01 = matrix.getM01()), (double)(m02 = matrix.getM02()), (double)(m10 = matrix.getM10()), (double)(m11 = matrix.getM11()), (double)(m12 = matrix.getM12()), (double)(m20 = matrix.getM20()), (double)(m21 = matrix.getM21()), (double)(m22 = matrix.getM22())) == isIdentity ? 1 : 0) != 0);
        Assertions.assertTrue((Matrix3DFeatures.isIdentity((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-12) == isIdentity ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.isIdentity(1.0E-12) == isIdentity ? 1 : 0) != 0);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testIsZero() throws Exception {
        Random random = new Random(982364L);
        Matrix3D matrix = new Matrix3D();
        matrix.setIdentity();
        this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToZero();
        this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, true);
        for (int i = 0; i < 1000; ++i) {
            double delta = random.nextBoolean() ? 1.0 : -1.0;
            matrix.setToZero();
            matrix.setM00(matrix.getM00() + (delta *= random.nextDouble()));
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM01(matrix.getM01() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM02(matrix.getM02() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM10(matrix.getM10() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM11(matrix.getM11() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM12(matrix.getM12() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM20(matrix.getM20() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM21(matrix.getM21() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
            matrix.setToZero();
            matrix.setM22(matrix.getM22() + delta);
            this.testAllIsZeroMethods((Matrix3DReadOnly)matrix, Math.abs(delta) <= 1.0E-12);
        }
    }

    private void testAllIsZeroMethods(Matrix3DReadOnly matrix, boolean isZero) {
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        Assertions.assertTrue((Matrix3DFeatures.isZero((double)m00, (double)(m01 = matrix.getM01()), (double)(m02 = matrix.getM02()), (double)(m10 = matrix.getM10()), (double)(m11 = matrix.getM11()), (double)(m12 = matrix.getM12()), (double)(m20 = matrix.getM20()), (double)(m21 = matrix.getM21()), (double)(m22 = matrix.getM22())) == isZero ? 1 : 0) != 0);
        Assertions.assertTrue((Matrix3DFeatures.isZero((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-12) == isZero ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.isZero(1.0E-12) == isZero ? 1 : 0) != 0);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testIsMatrixSkewSymmetric() throws Exception {
        Random random = new Random(982364L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixCorrupted = new Matrix3D();
        matrix.setToZero();
        this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setIdentity();
        this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, false);
        matrix.setToNaN();
        this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            matrix.setToZero();
            matrix.setM01(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM02(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM12(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM10(-matrix.getM01());
            matrix.setM20(-matrix.getM02());
            matrix.setM21(-matrix.getM12());
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrix, true);
            double delta = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7);
            boolean isSkewSymmetric = Math.abs(delta) < 1.0E-8;
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM00(matrixCorrupted.getM00() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM01(matrixCorrupted.getM01() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM02(matrixCorrupted.getM02() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM10(matrixCorrupted.getM10() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM11(matrixCorrupted.getM11() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM12(matrixCorrupted.getM12() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM20(matrixCorrupted.getM20() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM21(matrixCorrupted.getM21() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM22(matrixCorrupted.getM22() + delta);
            this.testAllIsMatrixSkewSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSkewSymmetric);
        }
    }

    private void testAllIsMatrixSkewSymmetrixMethods(Matrix3DReadOnly matrix, boolean isSkewSymmetric) {
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        Assertions.assertTrue((Matrix3DFeatures.isMatrixSkewSymmetric((double)m00, (double)(m01 = matrix.getM01()), (double)(m02 = matrix.getM02()), (double)(m10 = matrix.getM10()), (double)(m11 = matrix.getM11()), (double)(m12 = matrix.getM12()), (double)(m20 = matrix.getM20()), (double)(m21 = matrix.getM21()), (double)(m22 = matrix.getM22())) == isSkewSymmetric ? 1 : 0) != 0);
        Assertions.assertTrue((Matrix3DFeatures.isMatrixSkewSymmetric((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-8) == isSkewSymmetric ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.isMatrixSkewSymmetric(1.0E-8) == isSkewSymmetric ? 1 : 0) != 0);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testIsMatrixSymmetric() {
        Random random = new Random(43676L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixCorrupted = new Matrix3D();
        matrix.setToZero();
        this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setIdentity();
        this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, true);
        matrix.setToNaN();
        this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, false);
        for (int i = 0; i < 1000; ++i) {
            matrix.setM01(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM02(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM12(EuclidCoreRandomTools.nextDouble((Random)random));
            matrix.setM10(matrix.getM01());
            matrix.setM20(matrix.getM02());
            matrix.setM21(matrix.getM12());
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrix, true);
            double delta = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7);
            boolean isSymmetric = Math.abs(delta) < 1.0E-8;
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM01(matrixCorrupted.getM01() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM02(matrixCorrupted.getM02() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM12(matrixCorrupted.getM12() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM10(matrixCorrupted.getM10() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM20(matrixCorrupted.getM20() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
            matrixCorrupted.set((Matrix3DReadOnly)matrix);
            matrixCorrupted.setM21(matrixCorrupted.getM21() + delta);
            this.testAllIsMatrixSymmetrixMethods((Matrix3DReadOnly)matrixCorrupted, isSymmetric);
        }
    }

    private void testAllIsMatrixSymmetrixMethods(Matrix3DReadOnly matrix, boolean isSymmetric) {
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        Matrix3D matrixCopy = new Matrix3D(matrix);
        double m00 = matrix.getM00();
        Assertions.assertTrue((Matrix3DFeatures.isMatrixSymmetric((double)m00, (double)(m01 = matrix.getM01()), (double)(m02 = matrix.getM02()), (double)(m10 = matrix.getM10()), (double)(m11 = matrix.getM11()), (double)(m12 = matrix.getM12()), (double)(m20 = matrix.getM20()), (double)(m21 = matrix.getM21()), (double)(m22 = matrix.getM22())) == isSymmetric ? 1 : 0) != 0);
        Assertions.assertTrue((Matrix3DFeatures.isMatrixSymmetric((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (double)1.0E-8) == isSymmetric ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.isMatrixSymmetric(1.0E-8) == isSymmetric ? 1 : 0) != 0);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                Assertions.assertTrue((Double.compare(matrix.getElement(row, column), matrixCopy.getElement(row, column)) == 0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testMaxElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).max().getAsDouble(), (double)new Matrix3D(coeffs).maxElement());
        }
    }

    @Test
    public void testMaxAbsElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).map(Math::abs).max().getAsDouble(), (double)new Matrix3D(coeffs).maxAbsElement());
        }
    }

    @Test
    public void testMinElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).min().getAsDouble(), (double)new Matrix3D(coeffs).minElement());
        }
    }

    @Test
    public void testMinAbsElement() {
        Random random = new Random(4566735L);
        for (int i = 0; i < 1000; ++i) {
            double[] coeffs = random.doubles(9L, -100.0, 100.0).toArray();
            Assertions.assertEquals((double)DoubleStream.of(coeffs).map(Math::abs).min().getAsDouble(), (double)new Matrix3D(coeffs).minAbsElement());
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(346L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3D delta = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            double epsilon = random.nextDouble();
            delta.fill(0.1 * epsilon);
            m2.add((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
            Assertions.assertTrue((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
            m2.sub((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
            Assertions.assertTrue((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    delta.fill(0.1 * epsilon);
                    delta.setElement(row, column, 1.1 * epsilon);
                    m2.add((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
                    m2.sub((Matrix3DReadOnly)m1, (Matrix3DReadOnly)delta);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.epsilonEquals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (double)epsilon));
                }
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(346L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        double smallestEpsilon = 1.0E-15;
        Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, null));
        Assertions.assertFalse((boolean)Matrix3DFeatures.equals(null, (Matrix3DReadOnly)m2));
        Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)new RotationMatrix(), (Matrix3DReadOnly)m2));
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            m2.set((Matrix3DReadOnly)m1);
            Assertions.assertTrue((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2));
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    m2.set((Matrix3DReadOnly)m1);
                    m2.setElement(row, column, m2.getElement(row, column) + smallestEpsilon);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2));
                    m2.set((Matrix3DReadOnly)m1);
                    m2.setElement(row, column, m2.getElement(row, column) - smallestEpsilon);
                    Assertions.assertFalse((boolean)Matrix3DFeatures.equals((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2));
                }
            }
        }
    }
}

