/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class EuclidCoreFactoriesTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testNewLinkedPoint2DReadOnly() {
        Random random = new Random(5416L);
        double[] scale = new double[1];
        Point2D originalTuple = new Point2D();
        Point2DReadOnly actual = EuclidCoreFactories.newLinkedPoint2DReadOnly(() -> scale[0], (Tuple2DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            scale[0] = random.nextDouble();
            Point2D expected = new Point2D();
            expected.setAndScale(scale[0], (Tuple2DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
        Point2D expected = new Point2D();
        Point2DReadOnly actual2 = EuclidCoreFactories.newLinkedPoint2DReadOnly(() -> ((Point2D)expected).getX(), () -> ((Point2D)expected).getY());
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedVector2DReadOnly() {
        Random random = new Random(5416L);
        double[] scale = new double[1];
        Vector2D originalTuple = new Vector2D();
        Vector2DReadOnly actual = EuclidCoreFactories.newLinkedVector2DReadOnly(() -> scale[0], (Tuple2DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            scale[0] = random.nextDouble();
            Vector2D expected = new Vector2D();
            expected.setAndScale(scale[0], (Tuple2DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
        Vector2D expected = new Vector2D();
        Vector2DReadOnly actual2 = EuclidCoreFactories.newLinkedVector2DReadOnly(() -> ((Vector2D)expected).getX(), () -> ((Vector2D)expected).getY());
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedPoint3DReadOnly() {
        Random random = new Random(5416L);
        double[] scale = new double[1];
        Point3D originalTuple = new Point3D();
        Point3DReadOnly actual = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> scale[0], (Tuple3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            scale[0] = random.nextDouble();
            Point3D expected = new Point3D();
            expected.setAndScale(scale[0], (Tuple3DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
        Point3D expected = new Point3D();
        Point3DReadOnly actual2 = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> ((Point3D)expected).getX(), () -> ((Point3D)expected).getY(), () -> ((Point3D)expected).getZ());
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual2);
        }
    }

    @Test
    public void testNewLinkedVector3DReadOnly() {
        Random random = new Random(5416L);
        double[] scale = new double[1];
        Vector3D originalTuple = new Vector3D();
        Vector3DReadOnly actual = EuclidCoreFactories.newLinkedVector3DReadOnly(() -> scale[0], (Tuple3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            scale[0] = random.nextDouble();
            Vector3D expected = new Vector3D();
            expected.setAndScale(scale[0], (Tuple3DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
        Vector3D expected = new Vector3D();
        Vector3DReadOnly actual2 = EuclidCoreFactories.newLinkedVector3DReadOnly(() -> ((Vector3D)expected).getX(), () -> ((Vector3D)expected).getY(), () -> ((Vector3D)expected).getZ());
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual2);
        }
    }

    @Test
    public void testNewNegativeLinkedPoint2D() {
        Random random = new Random(43L);
        Point2D originalTuple = new Point2D();
        Point2DReadOnly actual = EuclidCoreFactories.newNegativeLinkedPoint2D((Point2DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            Point2D expected = new Point2D();
            expected.setAndNegate((Tuple2DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedVector2D() {
        Random random = new Random(43L);
        Vector2D originalTuple = new Vector2D();
        Vector2DReadOnly actual = EuclidCoreFactories.newNegativeLinkedVector2D((Vector2DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            Vector2D expected = new Vector2D();
            expected.setAndNegate((Tuple2DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedPoint3D() {
        Random random = new Random(43L);
        Point3D originalTuple = new Point3D();
        Point3DReadOnly actual = EuclidCoreFactories.newNegativeLinkedPoint3D((Point3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            Point3D expected = new Point3D();
            expected.setAndNegate((Tuple3DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedVector3D() {
        Random random = new Random(43L);
        Vector3D originalTuple = new Vector3D();
        Vector3DReadOnly actual = EuclidCoreFactories.newNegativeLinkedVector3D((Vector3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Vector3D expected = new Vector3D();
            expected.setAndNegate((Tuple3DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
    }

    @Test
    public void testNewNegativeLinkedUnitVector2D() {
        Random random = new Random(389L);
        UnitVector2D originalVector = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
        UnitVector2DReadOnly actual = EuclidCoreFactories.newNegativeLinkedUnitVector2D((UnitVector2DReadOnly)originalVector);
        for (int i = 0; i < 1000; ++i) {
            originalVector.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            UnitVector2D expected = new UnitVector2D();
            expected.setAndNegate((Tuple2DReadOnly)originalVector);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
            Assertions.assertEquals((double)expected.getRawX(), (double)actual.getRawX());
            Assertions.assertEquals((double)expected.getRawY(), (double)actual.getRawY());
            Assertions.assertEquals((Object)originalVector.isDirty(), (Object)actual.isDirty());
            originalVector.setX(1.0);
            Assertions.assertTrue((boolean)originalVector.isDirty());
            Assertions.assertTrue((boolean)actual.isDirty());
            actual.getX();
            Assertions.assertFalse((boolean)actual.isDirty());
            Assertions.assertFalse((boolean)originalVector.isDirty());
        }
    }

    @Test
    public void testNewNegativeLinkedUnitVector3D() {
        Random random = new Random(389L);
        UnitVector3D originalVector = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        UnitVector3DReadOnly actual = EuclidCoreFactories.newNegativeLinkedUnitVector3D((UnitVector3DReadOnly)originalVector);
        for (int i = 0; i < 1000; ++i) {
            originalVector.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            UnitVector3D expected = new UnitVector3D();
            expected.setAndNegate((Tuple3DReadOnly)originalVector);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
            Assertions.assertEquals((double)expected.getRawX(), (double)actual.getRawX());
            Assertions.assertEquals((double)expected.getRawY(), (double)actual.getRawY());
            Assertions.assertEquals((double)expected.getRawZ(), (double)actual.getRawZ());
            Assertions.assertEquals((Object)originalVector.isDirty(), (Object)actual.isDirty());
            originalVector.setX(1.0);
            Assertions.assertTrue((boolean)originalVector.isDirty());
            Assertions.assertTrue((boolean)actual.isDirty());
            actual.getX();
            Assertions.assertFalse((boolean)actual.isDirty());
            Assertions.assertFalse((boolean)originalVector.isDirty());
        }
    }

    @Test
    public void testNewConjugateLinkedQuaternion() {
        Random random = new Random(349653L);
        Quaternion originalQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        QuaternionReadOnly actual = EuclidCoreFactories.newConjugateLinkedQuaternion((QuaternionReadOnly)originalQuaternion);
        for (int i = 0; i < 1000; ++i) {
            originalQuaternion.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            Quaternion expected = new Quaternion();
            expected.setAndConjugate((QuaternionReadOnly)originalQuaternion);
            EuclidCoreFactoriesTest.thoroughAssertionsTuple4D((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual);
        }
    }

    @Test
    public void testNewTransposeLinkedMatrix3DReadOnly() {
        Random random = new Random(43634677L);
        Matrix3D originalMatrix = new Matrix3D();
        Matrix3DReadOnly actual = EuclidCoreFactories.newTransposeLinkedMatrix3DReadOnly((Matrix3DReadOnly)originalMatrix);
        for (int i = 0; i < 1000; ++i) {
            originalMatrix.set((Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random));
            Matrix3D expected = new Matrix3D();
            expected.setAndTranspose((Matrix3DReadOnly)originalMatrix);
            EuclidCoreFactoriesTest.thoroughAssertionsMatrix3D((Matrix3DReadOnly)expected, actual);
        }
    }

    @Test
    public void testNewTildeLinkedMatrix3DReadOnly() {
        Random random = new Random(43634677L);
        Point3D originalTuple = new Point3D();
        Matrix3DReadOnly actual = EuclidCoreFactories.newTildeLinkedMatrix3DReadOnly((Tuple3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            Matrix3D expected = new Matrix3D();
            expected.setToTildeForm((Tuple3DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsMatrix3D((Matrix3DReadOnly)expected, actual);
        }
    }

    @Test
    public void testNewDiagonalLinkedMatrix3DReadOnly() {
        Random random = new Random(43634677L);
        Point3D originalTuple = new Point3D();
        Matrix3DReadOnly actual = EuclidCoreFactories.newDiagonalLinkedMatrix3DReadOnly((Tuple3DReadOnly)originalTuple);
        for (int i = 0; i < 1000; ++i) {
            originalTuple.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            Matrix3D expected = new Matrix3D();
            expected.setToDiagonal((Tuple3DReadOnly)originalTuple);
            EuclidCoreFactoriesTest.thoroughAssertionsMatrix3D((Matrix3DReadOnly)expected, actual);
        }
    }

    @Test
    public void testNewObservablePoint2DReadOnly() {
        Random random = new Random(45L);
        Point2D expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D source = new Point2D();
        Consumer<Axis2D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        Point2DReadOnly observable = EuclidCoreFactories.newObservablePoint2DReadOnly(valueAccessedListener, (Point2DReadOnly)source);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        source = new Point2D((Tuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener2 = axis -> transform.transform((Point2DBasics)source, false);
        Point2DReadOnly observable2 = EuclidCoreFactories.newObservablePoint2DReadOnly(valueAccessedListener2, (Point2DReadOnly)source);
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableVector2DReadOnly() {
        Random random = new Random(45L);
        Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        Vector2D source = new Vector2D();
        Consumer<Axis2D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        Vector2DReadOnly observable = EuclidCoreFactories.newObservableVector2DReadOnly(valueAccessedListener, (Vector2DReadOnly)source);
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        source = new Vector2D((Tuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener2 = axis -> transform.transform((Vector2DBasics)source, false);
        Vector2DReadOnly observable2 = EuclidCoreFactories.newObservableVector2DReadOnly(valueAccessedListener2, (Vector2DReadOnly)source);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservablePoint3DReadOnly() {
        Random random = new Random(45L);
        Point3D expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D source = new Point3D();
        Consumer<Axis3D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        Point3DReadOnly observable = EuclidCoreFactories.newObservablePoint3DReadOnly(valueAccessedListener, (Point3DReadOnly)source);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        Assertions.assertEquals((double)expected.getZ(), (double)observable.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        source = new Point3D((Tuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener2 = axis -> transform.transform((Point3DBasics)source);
        Point3DReadOnly observable2 = EuclidCoreFactories.newObservablePoint3DReadOnly(valueAccessedListener2, (Point3DReadOnly)source);
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
    }

    @Test
    public void testNewObservableUnitVector2DReadOnly() {
        Random random = new Random(45L);
        UnitVector2D expected = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
        UnitVector2D source = new UnitVector2D();
        Consumer<Axis2D> valueAccessedListener = axis -> source.set((UnitVector2DReadOnly)expected);
        UnitVector2DReadOnly observable = EuclidCoreFactories.newObservableUnitVector2DReadOnly(valueAccessedListener, (UnitVector2DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
        source = new UnitVector2D((Tuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener2 = axis -> transform.transform((Vector2DBasics)source, false);
        UnitVector2DReadOnly observable2 = EuclidCoreFactories.newObservableUnitVector2DReadOnly(valueAccessedListener2, (UnitVector2DReadOnly)source);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
    }

    @Test
    public void testNewObservableVector3DReadOnly() {
        Random random = new Random(45L);
        Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D source = new Vector3D();
        Consumer<Axis3D> valueAccessedListener = axis -> source.setElement(axis, expected.getElement(axis));
        Vector3DReadOnly observable = EuclidCoreFactories.newObservableVector3DReadOnly(valueAccessedListener, (Vector3DReadOnly)source);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        Assertions.assertEquals((double)expected.getZ(), (double)observable.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        source = new Vector3D((Tuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener2 = axis -> transform.transform((Vector3DBasics)source);
        Vector3DReadOnly observable2 = EuclidCoreFactories.newObservableVector3DReadOnly(valueAccessedListener2, (Vector3DReadOnly)source);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
    }

    @Test
    public void testNewObservableUnitVector3DReadOnly() {
        Random random = new Random(45L);
        UnitVector3D expected = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        UnitVector3D source = new UnitVector3D();
        Consumer<Axis3D> valueAccessedListener = axis -> source.set((UnitVector3DReadOnly)expected);
        UnitVector3DReadOnly observable = EuclidCoreFactories.newObservableUnitVector3DReadOnly(valueAccessedListener, (UnitVector3DReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        Assertions.assertEquals((double)expected.getZ(), (double)observable.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        source = new UnitVector3D((Tuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener2 = axis -> transform.transform((Vector3DBasics)source);
        UnitVector3DReadOnly observable2 = EuclidCoreFactories.newObservableUnitVector3DReadOnly(valueAccessedListener2, (UnitVector3DReadOnly)source);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
    }

    @Test
    public void testNewObservableRotationMatrixReadOnly() {
        Random random = new Random(45L);
        RotationMatrix expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix source = new RotationMatrix();
        BiConsumer<Axis3D, Axis3D> valueAccessedListener = (row, col) -> source.set((RotationMatrixReadOnly)expected);
        RotationMatrixReadOnly observable = EuclidCoreFactories.newObservableRotationMatrixReadOnly(valueAccessedListener, (RotationMatrixReadOnly)source);
        Assertions.assertTrue((boolean)source.isIdentity());
        for (int row2 = 0; row2 < 3; ++row2) {
            for (int col2 = 0; col2 < 3; ++col2) {
                Assertions.assertEquals((double)expected.getElement(row2, col2), (double)observable.getElement(row2, col2));
                Assertions.assertEquals((double)expected.getElement(row2, col2), (double)source.getElement(row2, col2));
            }
        }
        EuclidCoreFactoriesTest.thoroughAssertionsMatrix3D((Matrix3DReadOnly)expected, (Matrix3DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        source = new RotationMatrix((RotationMatrixReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        BiConsumer<Axis3D, Axis3D> valueAccessedListener2 = (row, col) -> transform.transform((RotationMatrixBasics)source);
        RotationMatrixReadOnly observable2 = EuclidCoreFactories.newObservableRotationMatrixReadOnly(valueAccessedListener2, (RotationMatrixReadOnly)source);
        for (int row3 = 0; row3 < 3; ++row3) {
            for (int col3 = 0; col3 < 3; ++col3) {
                transform.transform((RotationMatrixBasics)expected);
                Assertions.assertEquals((double)expected.getElement(row3, col3), (double)observable2.getElement(row3, col3));
                Assertions.assertEquals((double)expected.getElement(row3, col3), (double)source.getElement(row3, col3));
            }
        }
    }

    @Test
    public void testNewObservableQuaternionReadOnly() {
        Random random = new Random(45L);
        Quaternion expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion source = new Quaternion();
        IntConsumer valueAccessedListener = index -> source.set((QuaternionReadOnly)expected);
        QuaternionReadOnly observable = EuclidCoreFactories.newObservableQuaternionReadOnly((IntConsumer)valueAccessedListener, (QuaternionReadOnly)source);
        Assertions.assertEquals((double)expected.getX(), (double)observable.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        Assertions.assertEquals((double)expected.getY(), (double)observable.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        Assertions.assertEquals((double)expected.getZ(), (double)observable.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
        EuclidCoreFactoriesTest.thoroughAssertionsTuple4D((Tuple4DReadOnly)expected, (Tuple4DReadOnly)observable);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        source = new Quaternion((QuaternionReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        IntConsumer valueAccessedListener2 = index -> transform.transform((Orientation3DBasics)source);
        QuaternionReadOnly observable2 = EuclidCoreFactories.newObservableQuaternionReadOnly((IntConsumer)valueAccessedListener2, (QuaternionReadOnly)source);
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source.getX());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source.getY());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source.getZ());
    }

    @Test
    public void testNewObservablePoint2DBasics() {
        Random random = new Random(4367L);
        Point2D expected = new Point2D();
        Point2DBasics actual = EuclidCoreFactories.newObservablePoint2DBasics(null, null, (Point2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
            actual.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false};
        boolean[] accessTrace = new boolean[]{false, false};
        Point2D source = new Point2D();
        Point2DBasics observable = EuclidCoreFactories.newObservablePoint2DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (Point2DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 2; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D source2 = new Point2D((Tuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener = axis -> transform.transform((Point2DBasics)source2, false);
        Point2DBasics observable2 = EuclidCoreFactories.newObservablePoint2DBasics(null, valueAccessedListener, (Point2DBasics)source2);
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Point2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
    }

    @Test
    public void testNewObservableVector2DBasics() {
        Random random = new Random(4367L);
        Vector2D expected = new Vector2D();
        Vector2DBasics actual = EuclidCoreFactories.newObservableVector2DBasics(null, null, (Vector2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
            actual.set((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false};
        boolean[] accessTrace = new boolean[]{false, false};
        Vector2D source = new Vector2D();
        Vector2DBasics observable = EuclidCoreFactories.newObservableVector2DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (Vector2DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 2; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        Vector2D source2 = new Vector2D((Tuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener = axis -> transform.transform((Vector2DBasics)source2, false);
        Vector2DBasics observable2 = EuclidCoreFactories.newObservableVector2DBasics(null, valueAccessedListener, (Vector2DBasics)source2);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
    }

    @Test
    public void testNewObservablePoint3DBasics() {
        Random random = new Random(4367L);
        Point3D expected = new Point3D();
        Point3DBasics actual = EuclidCoreFactories.newObservablePoint3DBasics(null, null, (Point3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
            actual.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false, false};
        boolean[] accessTrace = new boolean[]{false, false, false};
        Point3D source = new Point3D();
        Point3DBasics observable = EuclidCoreFactories.newObservablePoint3DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (Point3DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 3; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D source2 = new Point3D((Tuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener = axis -> transform.transform((Point3DBasics)source2);
        Point3DBasics observable2 = EuclidCoreFactories.newObservablePoint3DBasics(null, valueAccessedListener, (Point3DBasics)source2);
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Point3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
    }

    @Test
    public void testNewObservableVector3DBasics() {
        Random random = new Random(4367L);
        Vector3D expected = new Vector3D();
        Vector3DBasics actual = EuclidCoreFactories.newObservableVector3DBasics(null, null, (Vector3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
            actual.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false, false};
        boolean[] accessTrace = new boolean[]{false, false, false};
        Vector3D source = new Vector3D();
        Vector3DBasics observable = EuclidCoreFactories.newObservableVector3DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (Vector3DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 3; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D source2 = new Vector3D((Tuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener = axis -> transform.transform((Vector3DBasics)source2);
        Vector3DBasics observable2 = EuclidCoreFactories.newObservableVector3DBasics(null, valueAccessedListener, (Vector3DBasics)source2);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
    }

    @Test
    public void testNewObservableUnitVector2DBasics() {
        Random random = new Random(4367L);
        UnitVector2D expected = new UnitVector2D();
        UnitVector2DBasics actual = EuclidCoreFactories.newObservableUnitVector2DBasics(null, null, (UnitVector2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
            actual.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple2D((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false};
        boolean[] accessTrace = new boolean[]{false, false};
        UnitVector2D source = new UnitVector2D();
        UnitVector2DBasics observable = EuclidCoreFactories.newObservableUnitVector2DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (UnitVector2DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 2; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
        UnitVector2D source2 = new UnitVector2D((Tuple2DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis2D> valueAccessedListener = axis -> transform.transform((Vector2DBasics)source2, false);
        UnitVector2DBasics observable2 = EuclidCoreFactories.newObservableUnitVector2DBasics(null, valueAccessedListener, (UnitVector2DBasics)source2);
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector2DBasics)expected, false);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
    }

    @Test
    public void testNewObservableUnitVector3DBasics() {
        Random random = new Random(4367L);
        UnitVector3D expected = new UnitVector3D();
        UnitVector3DBasics actual = EuclidCoreFactories.newObservableUnitVector3DBasics(null, null, (UnitVector3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
            actual.set((UnitVector3DReadOnly)EuclidCoreRandomTools.nextUnitVector3D((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple3D((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false, false, false};
        boolean[] accessTrace = new boolean[]{false, false, false};
        UnitVector3D source = new UnitVector3D();
        UnitVector3DBasics observable = EuclidCoreFactories.newObservableUnitVector3DBasics((axis, newValue) -> {
            changeTrace[axis.ordinal()] = true;
        }, axis -> {
            accessTrace[axis.ordinal()] = true;
        }, (UnitVector3DBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        for (int i = 0; i < 3; ++i) {
            double value = random.nextDouble();
            observable.setElement(i, value);
            Assertions.assertTrue((boolean)changeTrace[i]);
            changeTrace[i] = false;
            observable.setElement(i, value);
            Assertions.assertFalse((boolean)changeTrace[i]);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        UnitVector3D source2 = new UnitVector3D((Tuple3DReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Consumer<Axis3D> valueAccessedListener = axis -> transform.transform((Vector3DBasics)source2);
        UnitVector3DBasics observable2 = EuclidCoreFactories.newObservableUnitVector3DBasics(null, valueAccessedListener, (UnitVector3DBasics)source2);
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Vector3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
    }

    @Test
    public void testNewObservableRotationMatrixBasics() {
        Random random = new Random(4367L);
        RotationMatrix expected = new RotationMatrix();
        RotationMatrixBasics actual = EuclidCoreFactories.newObservableRotationMatrixBasics(null, null, (RotationMatrixBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsMatrix3D((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual);
            actual.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsMatrix3D((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false};
        boolean[][] accessTrace = new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}};
        RotationMatrix source = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrixBasics observable = EuclidCoreFactories.newObservableRotationMatrixBasics(() -> {
            changeTrace[0] = true;
        }, (row, col) -> {
            accessTrace[row.ordinal()][col.ordinal()] = true;
        }, (RotationMatrixBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        observable.transpose();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.setToNaN();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.setToZero();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        for (int row2 = 0; row2 < 3; ++row2) {
            for (int col2 = 0; col2 < 3; ++col2) {
                observable.getElement(row2, col2);
                Assertions.assertTrue((boolean)accessTrace[row2][col2]);
                accessTrace[row2][col2] = false;
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
            }
        }
        expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix source2 = new RotationMatrix((RotationMatrixReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        BiConsumer<Axis3D, Axis3D> valueAccessedListener = (row, col) -> transform.transform((RotationMatrixBasics)source2);
        RotationMatrixBasics observable2 = EuclidCoreFactories.newObservableRotationMatrixBasics(null, valueAccessedListener, (RotationMatrixBasics)source2);
        for (int row3 = 0; row3 < 3; ++row3) {
            for (int col3 = 0; col3 < 3; ++col3) {
                transform.transform((RotationMatrixBasics)expected);
                Assertions.assertEquals((double)expected.getElement(row3, col3), (double)observable2.getElement(row3, col3));
                Assertions.assertEquals((double)expected.getElement(row3, col3), (double)source2.getElement(row3, col3));
            }
        }
    }

    @Test
    public void testNewObservableQuaternionBasics() {
        Random random = new Random(4367L);
        Quaternion expected = new Quaternion();
        QuaternionBasics actual = EuclidCoreFactories.newObservableQuaternionBasics(null, null, (QuaternionBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple4D((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual);
            actual.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            EuclidCoreFactoriesTest.thoroughAssertionsTuple4D((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual);
        }
        boolean[] changeTrace = new boolean[]{false};
        boolean[] accessTrace = new boolean[]{false, false, false, false};
        Quaternion source = new Quaternion();
        QuaternionBasics observable = EuclidCoreFactories.newObservableQuaternionBasics(() -> {
            changeTrace[0] = true;
        }, index -> {
            accessTrace[index] = true;
        }, (QuaternionBasics)source);
        EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        observable.setToZero();
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        observable.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        Assertions.assertTrue((boolean)changeTrace[0]);
        EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        changeTrace[0] = false;
        for (int i = 0; i < 4; ++i) {
            observable.getElement(i);
            Assertions.assertTrue((boolean)accessTrace[i]);
            accessTrace[i] = false;
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTrace);
        }
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion source2 = new Quaternion((QuaternionReadOnly)expected);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        IntConsumer valueAccessedListener = index -> transform.transform((Orientation3DBasics)source2);
        QuaternionBasics observable2 = EuclidCoreFactories.newObservableQuaternionBasics(null, (IntConsumer)valueAccessedListener, (QuaternionBasics)source2);
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getX(), (double)observable2.getX());
        Assertions.assertEquals((double)expected.getX(), (double)source2.getX());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getY(), (double)observable2.getY());
        Assertions.assertEquals((double)expected.getY(), (double)source2.getY());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getZ(), (double)observable2.getZ());
        Assertions.assertEquals((double)expected.getZ(), (double)source2.getZ());
        transform.transform((Orientation3DBasics)expected);
        Assertions.assertEquals((double)expected.getS(), (double)observable2.getS());
        Assertions.assertEquals((double)expected.getS(), (double)source2.getS());
    }

    public static void assertAllFalses(boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertFalse((boolean)array[i]);
        }
    }

    public static void assertAllFalses(boolean[][] array) {
        for (int i = 0; i < array.length; ++i) {
            EuclidCoreFactoriesTest.assertAllFalses(array[i]);
        }
    }

    public static void thoroughAssertionsTuple2D(Tuple2DReadOnly expected, Tuple2DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    public static void thoroughAssertionsTuple3D(Tuple3DReadOnly expected, Tuple3DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    public static void thoroughAssertionsTuple4D(Tuple4DReadOnly expected, Tuple4DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    public static void thoroughAssertionsMatrix3D(Matrix3DReadOnly expected, Matrix3DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)actual, (Matrix3DReadOnly)expected, (double)1.0E-12);
    }

    public static void assertObjectMethods(Object expected, Object actual) {
        Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)actual, (Object)expected);
        Assertions.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }
}

