/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public abstract class AxisAngleReadOnlyTest<T extends AxisAngleReadOnly> {
    public abstract T createEmptyAxisAngle();

    public abstract T createAxisAngle(Vector3DReadOnly var1, double var2);

    public abstract T createAxisAngle(double var1, double var3, double var5, double var7);

    public abstract T createRandomAxisAngle(Random var1);

    public abstract double getEpsilon();

    public abstract double getSmallestEpsilon();

    @Test
    public void testGetAngle() {
        Random random = new Random(564648L);
        for (int i = 0; i < 1000; ++i) {
            T axisAngle;
            double actualAngle;
            double expectedAngle = random.nextInt(100);
            Assertions.assertTrue((expectedAngle == (actualAngle = (axisAngle = this.createAxisAngle((Vector3DReadOnly)new Vector3D(), expectedAngle)).getAngle()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetters() {
        Random random = new Random(564648L);
        for (int i = 0; i < 1000; ++i) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            UnitVector3D axis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            T axisAngle = this.createAxisAngle((Vector3DReadOnly)axis, angle);
            Assertions.assertEquals((double)axis.getX(), (double)axisAngle.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axis.getY(), (double)axisAngle.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axis.getZ(), (double)axisAngle.getZ(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axis.getX32(), (double)axisAngle.getX32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axis.getY32(), (double)axisAngle.getY32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)axis.getZ32(), (double)axisAngle.getZ32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)angle, (double)axisAngle.getAngle(), (double)this.getEpsilon());
            Assertions.assertEquals((float)((float)angle), (float)axisAngle.getAngle32());
        }
    }

    @Test
    public void testContainsNaN() {
        T axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)axisAngle.containsNaN());
        axisAngle = this.createAxisAngle(Double.NaN, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)axisAngle.containsNaN());
        axisAngle = this.createAxisAngle(0.0, Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)axisAngle.containsNaN());
        axisAngle = this.createAxisAngle(0.0, 0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)axisAngle.containsNaN());
        axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)axisAngle.containsNaN());
    }

    @Test
    public void testIsOrientation2D() throws Exception {
        Random random = new Random(23905872L);
        for (int i = 0; i < 1000; ++i) {
            double ux = random.nextDouble();
            double uy = random.nextDouble();
            double uz = random.nextDouble();
            double angle = random.nextDouble();
            T axisAngle = this.createEmptyAxisAngle();
            Assertions.assertTrue((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(ux, uy, uz, 0.0);
            Assertions.assertTrue((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(ux, uy, uz, angle);
            Assertions.assertFalse((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(0.0, uy, uz, angle);
            Assertions.assertFalse((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(ux, 0.0, uz, angle);
            Assertions.assertFalse((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(0.0, 0.0, uz, angle);
            Assertions.assertTrue((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(2.0 * this.getEpsilon(), 0.0, uz, angle);
            Assertions.assertFalse((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
            axisAngle = this.createAxisAngle(0.0, 2.0 * this.getEpsilon(), uz, angle);
            Assertions.assertFalse((boolean)axisAngle.isOrientation2D(this.getEpsilon()));
        }
    }

    @Test
    public void testCheckIfIsZOnly() throws Exception {
        Random random = new Random(23905872L);
        for (int i = 0; i < 1000; ++i) {
            double ux = random.nextDouble();
            double uy = random.nextDouble();
            double uz = random.nextDouble();
            double angle = random.nextDouble();
            T axisAngle = this.createEmptyAxisAngle();
            axisAngle.checkIfOrientation2D(this.getEpsilon());
            axisAngle = this.createAxisAngle(ux, uy, uz, 0.0);
            axisAngle.checkIfOrientation2D(this.getEpsilon());
            axisAngle = this.createAxisAngle(ux, uy, uz, angle);
            try {
                axisAngle.checkIfOrientation2D(this.getEpsilon());
                Assertions.fail((String)"Should have thrown a RuntimeException");
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a RuntimeException");
            }
            axisAngle = this.createAxisAngle(0.0, uy, uz, angle);
            try {
                axisAngle.checkIfOrientation2D(this.getEpsilon());
                Assertions.fail((String)"Should have thrown a RuntimeException");
            }
            catch (RuntimeException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a RuntimeException");
            }
            axisAngle = this.createAxisAngle(ux, 0.0, uz, angle);
            try {
                axisAngle.checkIfOrientation2D(this.getEpsilon());
                Assertions.fail((String)"Should have thrown a RuntimeException");
            }
            catch (RuntimeException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a RuntimeException");
            }
            axisAngle = this.createAxisAngle(0.0, 0.0, uz, angle);
            axisAngle.checkIfOrientation2D(this.getEpsilon());
        }
    }

    @Test
    public void testDistance() throws Exception {
        Random random = new Random(32434L);
        for (int i = 0; i < 1000; ++i) {
            T aa1 = this.createRandomAxisAngle(random);
            T aa2 = this.createRandomAxisAngle(random);
            Quaternion q1 = new Quaternion(aa1);
            Quaternion q2 = new Quaternion(aa2);
            double actualDistance = aa1.distance(aa2);
            double expectedDistance = q1.distance((Orientation3DReadOnly)q2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
            Assertions.assertEquals((double)0.0, (double)aa1.distance(aa1), (double)this.getEpsilon());
        }
    }

    @Test
    public void testAngle() throws Exception {
        Random random = new Random(564648L);
        for (int i = 0; i < 1000; ++i) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            UnitVector3D axis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            T axisAngle = this.createAxisAngle((Vector3DReadOnly)axis, angle);
            Assertions.assertEquals((double)angle, (double)axisAngle.angle(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetRotationVector() {
        Random random = new Random(2343456L);
        Vector3D actualVector = new Vector3D();
        Vector3D expectedVector = new Vector3D();
        for (int i = 0; i < 1000; ++i) {
            T axisAngle = this.createRandomAxisAngle(random);
            actualVector.setToNaN();
            axisAngle.getRotationVector((Vector3DBasics)actualVector);
            RotationVectorConversion.convertAxisAngleToRotationVector(axisAngle, (Vector3DBasics)expectedVector);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)actualVector, (Vector3DReadOnly)expectedVector, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetYawPitchRoll() throws Exception {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            T axisAngle = this.createRandomAxisAngle(random);
            double yaw = axisAngle.getYaw();
            double expectedYaw = YawPitchRollConversion.computeYaw(axisAngle);
            Assertions.assertEquals((double)yaw, (double)expectedYaw, (double)this.getEpsilon());
            double pitch = axisAngle.getPitch();
            double expectedPitch = YawPitchRollConversion.computePitch(axisAngle);
            Assertions.assertEquals((double)pitch, (double)expectedPitch, (double)this.getEpsilon());
            double roll = axisAngle.getRoll();
            double expectedRoll = YawPitchRollConversion.computeRoll(axisAngle);
            Assertions.assertEquals((double)roll, (double)expectedRoll, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetDoubleArray() {
        T axisAngle;
        int i;
        Random random = new Random(3513515L);
        for (i = 0; i < 1000; ++i) {
            double[] axisAngleArray = new double[4];
            axisAngle = this.createRandomAxisAngle(random);
            axisAngle.get(axisAngleArray);
            Assertions.assertTrue((axisAngle.getX() == axisAngleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY() == axisAngleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ() == axisAngleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle() == axisAngleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(20);
            double[] axisAngleArray = new double[startIndex + 4 + random.nextInt(10)];
            axisAngle = this.createRandomAxisAngle(random);
            axisAngle.get(startIndex, axisAngleArray);
            Assertions.assertTrue((axisAngle.getX() == axisAngleArray[startIndex + 0] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY() == axisAngleArray[startIndex + 1] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ() == axisAngleArray[startIndex + 2] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle() == axisAngleArray[startIndex + 3] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetFloatArray() {
        T axisAngle;
        int i;
        Random random = new Random(3513515L);
        for (i = 0; i < 1000; ++i) {
            float[] axisAngleArray = new float[4];
            axisAngle = this.createRandomAxisAngle(random);
            axisAngle.get(axisAngleArray);
            Assertions.assertTrue((axisAngle.getX32() == axisAngleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY32() == axisAngleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ32() == axisAngleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle32() == axisAngleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(20);
            float[] axisAngleArray = new float[startIndex + 4 + random.nextInt(10)];
            axisAngle = this.createRandomAxisAngle(random);
            axisAngle.get(startIndex, axisAngleArray);
            Assertions.assertTrue((axisAngle.getX32() == axisAngleArray[startIndex + 0] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY32() == axisAngleArray[startIndex + 1] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ32() == axisAngleArray[startIndex + 2] ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle32() == axisAngleArray[startIndex + 3] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetElement() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            T axisAngle = this.createRandomAxisAngle(random);
            Assertions.assertTrue((axisAngle.getX() == axisAngle.getElement(0) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY() == axisAngle.getElement(1) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ() == axisAngle.getElement(2) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle() == axisAngle.getElement(3) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getX32() == axisAngle.getElement32(0) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getY32() == axisAngle.getElement32(1) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getZ32() == axisAngle.getElement32(2) ? 1 : 0) != 0);
            Assertions.assertTrue((axisAngle.getAngle32() == axisAngle.getElement32(3) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTransform() {
        Matrix3D matrixActual;
        Matrix3D matrixOriginal;
        double scale;
        double theta;
        double scale2;
        Vector3D expectedTuple;
        Vector3D actualTuple;
        Vector3D tuple;
        int i;
        Random random = new Random(6787L);
        T axisAngle = this.createEmptyAxisAngle();
        Quaternion quaternion = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.transform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.transform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple = new Vector3D();
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = new Vector3D((Tuple3DReadOnly)tuple);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.addTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedTuple = new Vector3D((Tuple3DReadOnly)actualTuple);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.addTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.addTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple = new Vector3D();
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = new Vector3D((Tuple3DReadOnly)tuple);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.subTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.subTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedTuple = new Vector3D((Tuple3DReadOnly)actualTuple);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.subTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.subTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple = new Vector3D();
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            axisAngle = this.createAxisAngle(0.0, 0.0, 1.0, theta);
            scale = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale * axisAngle.getX(), scale * axisAngle.getY(), scale * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            axisAngle.transform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            axisAngle.transform((Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            axisAngle.transform((Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            axisAngle = this.createAxisAngle(0.0, 0.0, 1.0, theta);
            scale = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale * axisAngle.getX(), scale * axisAngle.getY(), scale * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            axisAngle.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple = new Vector2D();
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).transform((Tuple2DBasics)new Vector2D()), (Class[])new Class[]{NotAnOrientation2DException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).transform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D()), (Class[])new Class[]{NotAnOrientation2DException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).transform((Tuple2DBasics)new Vector2D(), true), (Class[])new Class[]{NotAnOrientation2DException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).transform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D(), true), (Class[])new Class[]{NotAnOrientation2DException.class});
        for (i = 0; i < 1000; ++i) {
            axisAngle = this.createRandomAxisAngle(random);
            double scale3 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale3 * axisAngle.getX(), scale3 * axisAngle.getY(), scale3 * axisAngle.getZ(), axisAngle.getAngle());
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D matrixExpected = new Matrix3D();
            matrixActual = new Matrix3D();
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixExpected);
            axisAngle.transform((Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            matrixActual.set((Matrix3DReadOnly)matrixOriginal);
            axisAngle.transform((Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            matrixActual = new Matrix3D();
            axisAngle.transform((Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixOriginal, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = this.createRandomAxisAngle(random);
            double scale4 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale4 * axisAngle.getX(), scale4 * axisAngle.getY(), scale4 * axisAngle.getZ(), axisAngle.getAngle());
            Quaternion qOriginal = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion qExpected = new Quaternion();
            Quaternion qActual = new Quaternion();
            quaternion.set(axisAngle);
            qExpected.multiply((QuaternionReadOnly)quaternion, (QuaternionReadOnly)qOriginal);
            axisAngle.transform((Orientation3DReadOnly)qOriginal, (Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
            qActual.set((QuaternionReadOnly)qOriginal);
            axisAngle.transform((Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qExpected, (EuclidGeometry)qActual, (double)this.getEpsilon());
            qActual = new Quaternion();
            axisAngle.transform((Orientation3DReadOnly)qOriginal, (Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)qOriginal, (EuclidGeometry)qActual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = this.createRandomAxisAngle(random);
            double scale5 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale5 * axisAngle.getX(), scale5 * axisAngle.getY(), scale5 * axisAngle.getZ(), axisAngle.getAngle());
            Vector4D vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Vector4D vectorExpected = new Vector4D();
            Vector4D vectorActual = new Vector4D();
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorExpected);
            axisAngle.transform((Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)this.getEpsilon());
            vectorActual.set((Tuple4DReadOnly)vectorOriginal);
            axisAngle.transform((Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)this.getEpsilon());
            vectorActual = new Vector4D();
            axisAngle.transform((Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorOriginal, (EuclidGeometry)vectorActual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            axisAngle = this.createRandomAxisAngle(random);
            double scale6 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale6 * axisAngle.getX(), scale6 * axisAngle.getY(), scale6 * axisAngle.getZ(), axisAngle.getAngle());
            matrixOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix matrixExpected = new RotationMatrix();
            matrixActual = new RotationMatrix();
            quaternion.set(axisAngle);
            QuaternionTools.transform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)matrixOriginal, (RotationMatrixBasics)matrixExpected);
            axisAngle.transform((RotationMatrixReadOnly)matrixOriginal, (RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            matrixActual.set((RotationMatrixReadOnly)matrixOriginal);
            axisAngle.transform((RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            axisAngle = this.createAxisAngle(0.0, 0.0, 0.0, 0.0);
            axisAngle.transform((RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
            matrixActual = new RotationMatrix();
            axisAngle.transform((RotationMatrixReadOnly)matrixOriginal, (RotationMatrixBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixOriginal, (Matrix3DReadOnly)matrixActual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testInverseTransform() {
        Quaternion expected;
        Quaternion actual;
        Quaternion original;
        double scale;
        double theta;
        double scale2;
        Vector3D expectedTuple;
        Vector3D actualTuple;
        Vector3D tuple;
        int i;
        Random random = new Random(6787L);
        T axisAngle = this.createEmptyAxisAngle();
        Quaternion quaternion = new Quaternion();
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.inverseTransform((Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            actualTuple = new Vector3D((Tuple3DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple3DReadOnly)tuple, (Tuple3DBasics)expectedTuple);
            axisAngle.inverseTransform((Tuple3DReadOnly)tuple, (Tuple3DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            axisAngle = this.createAxisAngle(0.0, 0.0, 1.0, theta);
            scale = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale * axisAngle.getX(), scale * axisAngle.getY(), scale * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            axisAngle.inverseTransform((Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            axisAngle.inverseTransform((Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            actualTuple.set((Tuple2DReadOnly)tuple);
            axisAngle.inverseTransform((Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            actualTuple = new Vector2D((Tuple2DReadOnly)tuple);
            expectedTuple = EuclidCoreRandomTools.nextVector2D((Random)random);
            theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            axisAngle = this.createAxisAngle(0.0, 0.0, 1.0, theta);
            scale = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale * axisAngle.getX(), scale * axisAngle.getY(), scale * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Tuple2DReadOnly)tuple, (Tuple2DBasics)expectedTuple, (boolean)false);
            axisAngle.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, true);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
            axisAngle.inverseTransform((Tuple2DReadOnly)tuple, (Tuple2DBasics)actualTuple, false);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)this.getEpsilon());
        }
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).inverseTransform((Tuple2DBasics)new Vector2D()), (Class[])new Class[]{NotAnOrientation2DException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).inverseTransform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D()), (Class[])new Class[]{NotAnOrientation2DException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).inverseTransform((Tuple2DBasics)new Vector2D(), true), (Class[])new Class[]{NotAnOrientation2DException.class});
        EuclidCoreTestTools.assertExceptionIsThrown(() -> this.createRandomAxisAngle(random).inverseTransform((Tuple2DReadOnly)new Vector2D(), (Tuple2DBasics)new Vector2D(), true), (Class[])new Class[]{NotAnOrientation2DException.class});
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actual = new Quaternion((QuaternionReadOnly)original);
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            axisAngle.inverseTransform((Orientation3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextQuaternion((Random)random);
            actual = new Quaternion((QuaternionReadOnly)original);
            expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (QuaternionReadOnly)original, (QuaternionBasics)expected);
            axisAngle.inverseTransform((Orientation3DReadOnly)original, (Orientation3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D((Tuple4DReadOnly)original);
            expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            axisAngle.inverseTransform((Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D((Tuple4DReadOnly)original);
            expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Vector4DReadOnly)original, (Vector4DBasics)expected);
            axisAngle.inverseTransform((Vector4DReadOnly)original, (Vector4DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            axisAngle.inverseTransform((Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (Matrix3DReadOnly)original, (Matrix3DBasics)expected);
            axisAngle.inverseTransform((Matrix3DReadOnly)original, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix((RotationMatrixReadOnly)original);
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)original, (RotationMatrixBasics)expected);
            axisAngle.inverseTransform((RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix((RotationMatrixReadOnly)original);
            expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            axisAngle = this.createRandomAxisAngle(random);
            scale2 = 0.5 + random.nextDouble();
            axisAngle = this.createAxisAngle(scale2 * axisAngle.getX(), scale2 * axisAngle.getY(), scale2 * axisAngle.getZ(), axisAngle.getAngle());
            quaternion.set(axisAngle);
            QuaternionTools.inverseTransform((QuaternionReadOnly)quaternion, (RotationMatrixReadOnly)original, (RotationMatrixBasics)expected);
            axisAngle.inverseTransform((RotationMatrixReadOnly)original, (RotationMatrixBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        T axisAngle = this.createRandomAxisAngle(random);
        Assertions.assertFalse((boolean)axisAngle.equals(this.createEmptyAxisAngle()));
        T emptyAxisAngleAsObject = this.createEmptyAxisAngle();
        Assertions.assertFalse((boolean)axisAngle.equals(emptyAxisAngleAsObject));
        T axisAngleAsObject = axisAngle;
        Assertions.assertTrue((boolean)axisAngle.equals(axisAngleAsObject));
        Assertions.assertFalse((boolean)axisAngle.equals(null));
        Assertions.assertFalse((boolean)axisAngle.equals(new double[5]));
        double x = axisAngle.getX();
        double y = axisAngle.getY();
        double z = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        Assertions.assertTrue((boolean)axisAngle.equals(this.createAxisAngle(x, y, z, angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x + this.getSmallestEpsilon(), y, z, angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x - this.getSmallestEpsilon(), y, z, angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x, y + this.getSmallestEpsilon(), z, angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x, y - this.getSmallestEpsilon(), z, angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x, y, z + this.getSmallestEpsilon(), angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x, y, z - this.getSmallestEpsilon(), angle)));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x, y, z, angle + this.getSmallestEpsilon())));
        Assertions.assertFalse((boolean)axisAngle.equals(this.createAxisAngle(x, y, z, angle - this.getSmallestEpsilon())));
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        T axisAngle = this.createRandomAxisAngle(random);
        double x = axisAngle.getX();
        double y = axisAngle.getY();
        double z = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        Assertions.assertTrue((boolean)axisAngle.epsilonEquals(this.createAxisAngle(x, y, z, angle + 0.999 * epsilon), epsilon));
        Assertions.assertTrue((boolean)axisAngle.epsilonEquals(this.createAxisAngle(x, y, z, angle - 0.999 * epsilon), epsilon));
        Assertions.assertFalse((boolean)axisAngle.epsilonEquals(this.createAxisAngle(x, y, z, angle + 1.001 * epsilon), epsilon));
        Assertions.assertFalse((boolean)axisAngle.epsilonEquals(this.createAxisAngle(x, y, z, angle - 1.001 * epsilon), epsilon));
        UnitVector3D vector1 = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        UnitVector3D vector2 = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        vector2.set((UnitVector3DReadOnly)vector1);
        Assertions.assertTrue((boolean)vector1.epsilonEquals((EuclidGeometry)vector2, epsilon));
        AxisAngle transform = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector1, (boolean)true), 0.0);
        transform.setAngle(0.999 * epsilon);
        transform.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertTrue((boolean)this.createAxisAngle((Vector3DReadOnly)vector1, angle).epsilonEquals(this.createAxisAngle((Vector3DReadOnly)vector2, angle), epsilon));
        transform.setAngle(-0.999 * epsilon);
        transform.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertTrue((boolean)this.createAxisAngle((Vector3DReadOnly)vector1, angle).epsilonEquals(this.createAxisAngle((Vector3DReadOnly)vector2, angle), epsilon));
        transform.setAngle(2.0 * epsilon);
        transform.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertFalse((boolean)this.createAxisAngle((Vector3DReadOnly)vector1, angle).epsilonEquals(this.createAxisAngle((Vector3DReadOnly)vector2, angle), epsilon));
        transform.setAngle(-2.0 * epsilon);
        transform.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertFalse((boolean)this.createAxisAngle((Vector3DReadOnly)vector1, angle).epsilonEquals(this.createAxisAngle((Vector3DReadOnly)vector2, angle), epsilon));
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        AxisAngle aabB;
        AxisAngle aa;
        double angleEps;
        AxisAngle aabA;
        double epsilon;
        int i;
        Random random = new Random(35454L);
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            aabA = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            angleEps = epsilon * 0.99;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleEps);
            aabB = new AxisAngle((Orientation3DReadOnly)aa);
            aabB.preMultiply((AxisAngleReadOnly)aabA);
            Assertions.assertTrue((boolean)aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            aabA = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            angleEps = epsilon * 1.01;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleEps);
            aabB = new AxisAngle((Orientation3DReadOnly)aa);
            aabB.preMultiply((AxisAngleReadOnly)aabA);
            Assertions.assertFalse((boolean)aabA.geometricallyEquals((EuclidGeometry)aabB, epsilon));
        }
    }
}

