/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Vector3DTest
extends Vector3DBasicsTest<Vector3D> {
    @Test
    public void testVector() {
        int i;
        Random random = new Random(621541L);
        Vector3D vector = new Vector3D();
        Assertions.assertTrue((0.0 == vector.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == vector.getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == vector.getZ() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            double newZ;
            double newY;
            double newX = random.nextDouble();
            Assertions.assertTrue((newX == (vector = new Vector3D(newX, newY = random.nextDouble(), newZ = random.nextDouble())).getX() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == vector.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((newZ == vector.getZ() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D vectorArray;
            double[] randomVectorArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            Assertions.assertTrue((randomVectorArray[0] == (vectorArray = new Vector3D(randomVectorArray)).getX() ? 1 : 0) != 0);
            Assertions.assertTrue((randomVectorArray[1] == vectorArray.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((randomVectorArray[2] == vectorArray.getZ() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D vector2 = new Vector3D();
            vector2.setX(random.nextDouble());
            vector2.setY(random.nextDouble());
            vector2.setZ(random.nextDouble());
            vector = new Vector3D((Tuple3DReadOnly)vector2);
            Assertions.assertTrue((vector.getX() == vector2.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == vector2.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ() == vector2.getZ() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Vector3D tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 3, random.nextDouble());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector3D vectorB;
            Vector3D vectorA = EuclidCoreRandomTools.nextVector3D((Random)random);
            if (vectorA.geometricallyEquals((Vector3DReadOnly)(vectorB = EuclidCoreRandomTools.nextVector3D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals(vectorB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals(vectorB, this.getEpsilon()));
        }
    }

    @Override
    public Vector3D createEmptyTuple() {
        return new Vector3D();
    }

    @Override
    public Vector3D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextRotationVector((Random)random);
    }

    @Override
    public Vector3D createTuple(double x, double y, double z) {
        return new Vector3D(x, y, z);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-15;
    }
}

