/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class UnitVector3DTest
extends Vector3DBasicsTest<UnitVector3D> {
    private static final double DOUBLE_EPSILON = 1.0E-14;
    private static final double FLOAT_EPSILON = 1.0E-7;

    @Test
    public void testConstructor() {
        UnitVector3D actual;
        int i;
        Random random = new Random(621541L);
        UnitVector3D actual2 = new UnitVector3D();
        Assertions.assertTrue((1.0 == actual2.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == actual2.getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == actual2.getZ() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            double newX = random.nextDouble();
            double newY = random.nextDouble();
            double newZ = random.nextDouble();
            UnitVector3D actual3 = new UnitVector3D(newX, newY, newZ);
            Vector3D expected = new Vector3D(newX, newY, newZ);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            double[] randomVectorArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            actual = new UnitVector3D(randomVectorArray);
            Vector3D expected = new Vector3D(randomVectorArray);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)other);
            Vector3D expected = new Vector3D((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testSetters() throws Exception {
        DMatrixRMaj matrix;
        Object[] tupleArray;
        Point2D tuple2D;
        Vector3D expected;
        UnitVector3D other;
        double z;
        double y;
        double x;
        UnitVector3D actual;
        Vector3D expected2;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            x = random.nextDouble();
            actual.setX(x);
            expected2.setX(x);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            double y2 = random.nextDouble();
            actual.setY(y2);
            expected2.setY(y2);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            double z2 = random.nextDouble();
            actual.setZ(z2);
            expected2.setZ(z2);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            try {
                actual.setElement(-1, random.nextDouble());
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException z2) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            try {
                actual.setElement(3, random.nextDouble());
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            actual.setElement(0, x);
            actual.setElement(1, y);
            actual.setElement(2, z);
            expected2.setElement(0, x);
            expected2.setElement(1, y);
            expected2.setElement(2, z);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            expected2.normalize();
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            actual.set(x, y, z);
            expected2.set(x, y, z);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual2 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual2.set(other);
            expected.set((Tuple3DReadOnly)other);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual3 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual3.set((Tuple3DReadOnly)other);
            expected.set((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tuple2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual4 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual4.set((Tuple2DReadOnly)tuple2D);
            expected.set((Tuple2DReadOnly)tuple2D);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual4, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tuple2D = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual5 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            double z3 = random.nextDouble();
            actual5.set((Tuple2DReadOnly)tuple2D, z3);
            expected.set((Tuple2DReadOnly)tuple2D, z3);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual5, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual6 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual6.set(tupleArray);
            expected.set(tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual6, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual7 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual7.set(2, tupleArray);
            expected.set(2, tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual7, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual8 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual8.set((float[])tupleArray);
            expected.set((float[])tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual8, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual9 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual9.set(2, (float[])tupleArray);
            expected.set(2, (float[])tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual9, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(5, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual10 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual10.set((DMatrix)matrix);
            expected.set((DMatrix)matrix);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual10, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(10, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual11 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual11.set(5, (DMatrix)matrix);
            expected.set(5, (DMatrix)matrix);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual11, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(10, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual12 = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual12.set(5, 2, (DMatrix)matrix);
            expected.set(5, 2, (DMatrix)matrix);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual12, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testAbsolute() throws Exception {
        Random random = new Random(45036L);
        for (int i = 0; i < 1000; ++i) {
            Point3D other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual.absolute();
            expected.absolute();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
            actual.setAndAbsolute((Tuple3DReadOnly)other);
            expected.setAndAbsolute((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testNegate() throws Exception {
        Random random = new Random(45036L);
        for (int i = 0; i < 1000; ++i) {
            Point3D other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual.negate();
            expected.negate();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
            actual.setAndNegate((Tuple3DReadOnly)other);
            expected.setAndNegate((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testGetters() throws Exception {
        double length;
        float y;
        double length2;
        double z;
        int i;
        Random random = new Random(621541L);
        UnitVector3D vector = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y2 = random.nextDouble();
            z = random.nextDouble();
            vector = this.createTuple(x, y2, z);
            length2 = EuclidCoreTools.norm((double)x, (double)y2, (double)z);
            Assertions.assertEquals((double)vector.getX(), (double)(x / length2), (double)1.0E-14);
            Assertions.assertEquals((double)vector.getY(), (double)(y2 / length2), (double)1.0E-14);
            Assertions.assertEquals((double)vector.getZ(), (double)(z / length2), (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            y = random.nextFloat();
            float z2 = random.nextFloat();
            vector = this.createTuple(x, y, z2);
            length = EuclidCoreTools.norm((double)x, (double)y, (double)z2);
            Assertions.assertEquals((double)vector.getX32(), (double)((double)x / length), (double)1.0E-7);
            Assertions.assertEquals((double)vector.getY32(), (double)((double)y / length), (double)1.0E-7);
            Assertions.assertEquals((double)vector.getZ32(), (double)((double)z2 / length), (double)1.0E-7);
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y3 = random.nextDouble();
            z = random.nextDouble();
            vector = this.createTuple(x, y3, z);
            length2 = EuclidCoreTools.norm((double)x, (double)y3, (double)z);
            Assertions.assertEquals((double)vector.getElement(0), (double)(x / length2), (double)1.0E-14);
            Assertions.assertEquals((double)vector.getElement(1), (double)(y3 / length2), (double)1.0E-14);
            Assertions.assertEquals((double)vector.getElement(2), (double)(z / length2), (double)1.0E-14);
            try {
                vector.getElement(-1);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            try {
                vector.getElement(3);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            y = random.nextFloat();
            float z3 = random.nextFloat();
            vector = this.createTuple(x, y, z3);
            length = EuclidCoreTools.norm((double)x, (double)y, (double)z3);
            Assertions.assertEquals((double)vector.getElement32(0), (double)((double)x / length), (double)1.0E-7);
            Assertions.assertEquals((double)vector.getElement32(1), (double)((double)y / length), (double)1.0E-7);
            Assertions.assertEquals((double)vector.getElement32(2), (double)((double)z3 / length), (double)1.0E-7);
            try {
                vector.getElement32(-1);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            try {
                vector.getElement32(3);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            vector.get(tupleArray);
            Assertions.assertTrue((vector.getX() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ() == tupleArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            vector.get(2, tupleArray);
            Assertions.assertTrue((vector.getX() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ() == tupleArray[4] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            vector.get(tupleArray);
            Assertions.assertTrue((vector.getX32() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY32() == tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ32() == tupleArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            vector.get(2, tupleArray);
            Assertions.assertTrue((vector.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY32() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ32() == tupleArray[4] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            vector.get((DMatrix)matrix);
            Assertions.assertTrue((vector.getX() == matrix.get(0, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == matrix.get(1, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ() == matrix.get(2, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            vector.get(2, (DMatrix)matrix);
            Assertions.assertTrue((vector.getX() == matrix.get(2, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == matrix.get(3, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ() == matrix.get(4, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            vector.get(2, 4, (DMatrix)matrix);
            Assertions.assertTrue((vector.getX() == matrix.get(2, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == matrix.get(3, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getZ() == matrix.get(4, 4) ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testAdd() throws Exception {
        double z;
        double y;
        double x;
        Vector3D expected;
        UnitVector3D actual;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            actual.set((Tuple3DReadOnly)expected);
            actual.addX(x);
            expected.addX(x);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
            actual.addY(y);
            expected.addY(y);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
            actual.addZ(z);
            expected.addZ(z);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            actual.set((Tuple3DReadOnly)expected);
            actual.add(x, y, z);
            expected.add(x, y, z);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D tupleToAdd = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual.set((Tuple3DReadOnly)expected);
            actual.add((Tuple3DReadOnly)tupleToAdd);
            expected.add((Tuple3DReadOnly)tupleToAdd);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D tupleToAdd1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D tupleToAdd2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual.set((Tuple3DReadOnly)expected);
            actual.add((Tuple3DReadOnly)tupleToAdd1, (Tuple3DReadOnly)tupleToAdd2);
            expected.add((Tuple3DReadOnly)tupleToAdd1, (Tuple3DReadOnly)tupleToAdd2);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testSub() throws Exception {
        double z;
        double y;
        double x;
        Vector3D expected;
        UnitVector3D actual;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            actual.set((Tuple3DReadOnly)expected);
            actual.subX(x);
            expected.subX(x);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
            actual.subY(y);
            expected.subY(y);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
            actual.subZ(z);
            expected.subZ(z);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            z = random.nextDouble();
            actual.set((Tuple3DReadOnly)expected);
            actual.sub(x, y, z);
            expected.sub(x, y, z);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D tupleToSub = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual.set((Tuple3DReadOnly)expected);
            actual.sub((Tuple3DReadOnly)tupleToSub);
            expected.sub((Tuple3DReadOnly)tupleToSub);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector3D();
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D tupleToSub1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D tupleToSub2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual.set((Tuple3DReadOnly)expected);
            actual.sub((Tuple3DReadOnly)tupleToSub1, (Tuple3DReadOnly)tupleToSub2);
            expected.sub((Tuple3DReadOnly)tupleToSub1, (Tuple3DReadOnly)tupleToSub2);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testClip() throws Exception {
        double min;
        UnitVector3D actual;
        Vector3D expected;
        Point3D other;
        UnitVector3D actual2;
        Vector3D expected2;
        double max;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            max = random.nextDouble();
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual2 = new UnitVector3D((Tuple3DReadOnly)expected2);
            expected2.normalize();
            actual2.clipToMax(max);
            expected2.clipToMax(max);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            max = random.nextDouble();
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual.setAndClipToMax(max, (Tuple3DReadOnly)other);
            expected.setAndClipToMax(max, (Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual2 = new UnitVector3D((Tuple3DReadOnly)expected2);
            expected2.normalize();
            actual2.clipToMin(min);
            expected2.clipToMin(min);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual.setAndClipToMin(min, (Tuple3DReadOnly)other);
            expected.setAndClipToMin(min, (Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            double max2 = random.nextDouble() + 0.5;
            Vector3D expected3 = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual3 = new UnitVector3D((Tuple3DReadOnly)expected3);
            expected3.normalize();
            actual3.clipToMinMax(min, max2);
            expected3.clipToMinMax(min, max2);
            expected3.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected3, (Tuple3DReadOnly)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            double max3 = random.nextDouble() + 0.5;
            Point3D other2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected4 = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual4 = new UnitVector3D((Tuple3DReadOnly)expected4);
            expected4.normalize();
            actual4.setAndClipToMinMax(min, max3, (Tuple3DReadOnly)other2);
            expected4.setAndClipToMinMax(min, max3, (Tuple3DReadOnly)other2);
            expected4.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected4, (Tuple3DReadOnly)actual4, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testScale() throws Exception {
        double scale;
        Point3D other2;
        Point3D other1;
        double scale2;
        Vector3D expected;
        Point3D other;
        UnitVector3D actual;
        Vector3D expected2;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            double scale3 = random.nextDouble();
            actual.scale(scale3);
            expected2.scale(scale3);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            actual = new UnitVector3D((Tuple3DReadOnly)expected2);
            double scaleX = random.nextDouble();
            double scaleY = random.nextDouble();
            double scaleZ = random.nextDouble();
            actual.scale(scaleX, scaleY, scaleZ);
            expected2.scale(scaleX, scaleY, scaleZ);
            expected2.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected2, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual2 = new UnitVector3D((Tuple3DReadOnly)expected);
            scale2 = random.nextDouble();
            actual2.setAndScale(scale2, (Tuple3DReadOnly)other);
            expected.setAndScale(scale2, (Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual3 = new UnitVector3D((Tuple3DReadOnly)expected);
            scale2 = random.nextDouble();
            actual3.scaleAdd(scale2, (Tuple3DReadOnly)other);
            expected.add((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            other2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected3 = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual4 = new UnitVector3D((Tuple3DReadOnly)expected3);
            scale = random.nextDouble();
            actual4.scaleAdd(scale, (Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2);
            expected3.scaleAdd(scale, (Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2);
            expected3.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected3, (Tuple3DReadOnly)actual4, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual5 = new UnitVector3D((Tuple3DReadOnly)expected);
            double scale4 = random.nextDouble();
            actual5.scaleAdd(scale4, (Tuple3DReadOnly)other, (Tuple3DReadOnly)actual5);
            expected.scaleAdd(scale4, (Tuple3DReadOnly)other, (Tuple3DReadOnly)expected);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual5, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual6 = new UnitVector3D((Tuple3DReadOnly)expected);
            double scale5 = random.nextDouble();
            actual6.scaleSub(scale5, (Tuple3DReadOnly)other);
            expected.sub((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual6, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            other2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected4 = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual7 = new UnitVector3D((Tuple3DReadOnly)expected4);
            scale = random.nextDouble();
            actual7.scaleSub(scale, (Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2);
            expected4.scaleSub(scale, (Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2);
            expected4.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected4, (Tuple3DReadOnly)actual7, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual8 = new UnitVector3D((Tuple3DReadOnly)expected);
            double scale6 = random.nextDouble();
            actual8.scaleSub(scale6, (Tuple3DReadOnly)other, (Tuple3DReadOnly)actual8);
            expected.scaleSub(scale6, (Tuple3DReadOnly)other, (Tuple3DReadOnly)expected);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual8, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            UnitVector3D tuple = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            tuple.setToZero();
            Assertions.assertTrue((tuple.getX() == 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == 0.0 ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testLengthSquared() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-100.0, (double)100.0);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            Assertions.assertEquals((double)1.0, (double)actual.lengthSquared());
        }
    }

    @Override
    @Test
    public void testInterpolate() throws Exception {
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            Point3D other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            double alpha = random.nextDouble();
            actual.interpolate((Tuple3DReadOnly)other, alpha);
            expected.interpolate((Tuple3DReadOnly)other, alpha);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D other1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D other2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            double alpha = random.nextDouble();
            actual.interpolate((Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2, alpha);
            expected.interpolate((Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2, alpha);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        UnitVector3D tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 3, random.nextDouble());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testLength() {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            UnitVector3D vector = new UnitVector3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)-100.0, (double)100.0));
            Assertions.assertTrue((vector.length() == 1.0 ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testClipToMaxLength() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            UnitVector3D vector = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            Vector3D oldValues = new Vector3D((Tuple3DReadOnly)vector);
            Assertions.assertFalse((boolean)vector.clipToMaxLength(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0)));
            Assertions.assertTrue((boolean)oldValues.equals((Tuple3DReadOnly)vector));
        }
    }

    @Override
    @Test
    public void testCross() {
        int i;
        Random random = new Random(56461L);
        for (i = 0; i < 1000; ++i) {
            Point3D other1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D other2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual.cross((Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2);
            expected.cross((Tuple3DReadOnly)other1, (Tuple3DReadOnly)other2);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D other = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            UnitVector3D actual = new UnitVector3D((Tuple3DReadOnly)expected);
            expected.normalize();
            actual.cross((Tuple3DReadOnly)other);
            expected.cross((Tuple3DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        UnitVector3D vector1 = this.createRandomTuple(random);
        UnitVector3D vector2 = this.createRandomTuple(random);
        vector2.set(vector1);
        Assertions.assertTrue((boolean)vector1.epsilonEquals(vector2, epsilon));
        AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector1, (boolean)true), 0.0);
        axisAngle.setAngle(0.999 * epsilon);
        axisAngle.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertTrue((boolean)vector1.epsilonEquals(vector2, epsilon));
        axisAngle.setAngle(-0.999 * epsilon);
        axisAngle.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertTrue((boolean)vector1.epsilonEquals(vector2, epsilon));
        axisAngle.setAngle(2.0 * epsilon);
        axisAngle.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertFalse((boolean)vector1.epsilonEquals(vector2, epsilon));
        axisAngle.setAngle(-2.0 * epsilon);
        axisAngle.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
        Assertions.assertFalse((boolean)vector1.epsilonEquals(vector2, epsilon));
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            UnitVector3D vectorB;
            UnitVector3D vectorA = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            if (vectorA.geometricallyEquals((Vector3DReadOnly)(vectorB = EuclidCoreRandomTools.nextUnitVector3D((Random)random)), 1.0E-14)) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals(vectorB, 1.0E-14));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals(vectorB, 1.0E-14));
        }
    }

    @Override
    public UnitVector3D createEmptyTuple() {
        return new UnitVector3D();
    }

    @Override
    public UnitVector3D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextUnitVector3D((Random)random);
    }

    @Override
    public UnitVector3D createTuple(double x, double y, double z) {
        return new UnitVector3D(x, y, z);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }
}

