/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public abstract class Tuple2DReadOnlyTest<T extends Tuple2DReadOnly> {
    public abstract T createEmptyTuple();

    public abstract T createTuple(double var1, double var3);

    public abstract T createRandomTuple(Random var1);

    public abstract double getEpsilon();

    @Test
    public void testGetters() throws Exception {
        float y;
        Object tuple;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y2 = random.nextDouble();
            tuple = this.createTuple(x, y2);
            Assertions.assertEquals((double)tuple.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getY(), (double)y2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            T tuple2 = this.createTuple(x, y = random.nextFloat());
            Assertions.assertTrue((tuple2.getX32() == x ? 1 : 0) != 0);
            Assertions.assertTrue((tuple2.getY32() == y ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y3 = random.nextDouble();
            tuple = this.createTuple(x, y3);
            Assertions.assertEquals((double)tuple.getElement(0), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getElement(1), (double)y3, (double)this.getEpsilon());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple.getElement(-1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple.getElement(2));
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y4 = random.nextDouble();
            tuple = this.createTuple(x, y4);
            Assertions.assertEquals((double)tuple.getElement(Axis2D.X), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getElement(Axis2D.Y), (double)y4, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            Object tuple3 = this.createTuple(x, y = random.nextFloat());
            Assertions.assertTrue((tuple3.getElement32(0) == x ? 1 : 0) != 0);
            Assertions.assertTrue((tuple3.getElement32(1) == y ? 1 : 0) != 0);
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple3.getElement32(-1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple3.getElement32(2));
        }
        for (i = 0; i < 1000; ++i) {
            T tuple4 = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple4.get(tupleArray);
            Assertions.assertTrue((tuple4.getX() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple4.getY() == tupleArray[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple5 = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple5.get(2, tupleArray);
            Assertions.assertTrue((tuple5.getX() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple5.getY() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple6 = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple6.get(tupleArray);
            Assertions.assertTrue((tuple6.getX32() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple6.getY32() == tupleArray[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple7 = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple7.get(2, tupleArray);
            Assertions.assertTrue((tuple7.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple7.getY32() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple8 = this.createRandomTuple(random);
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple8.get((DMatrix)matrix);
            Assertions.assertTrue((tuple8.getX() == matrix.get(0, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple8.getY() == matrix.get(1, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple9 = this.createRandomTuple(random);
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple9.get(2, (DMatrix)matrix);
            Assertions.assertTrue((tuple9.getX() == matrix.get(2, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple9.getY() == matrix.get(3, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            T tuple10 = this.createRandomTuple(random);
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple10.get(2, 4, (DMatrix)matrix);
            Assertions.assertTrue((tuple10.getX() == matrix.get(2, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple10.getY() == matrix.get(3, 4) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testContainsNaN() throws Exception {
        Assertions.assertFalse((boolean)this.createTuple(0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(Double.NaN, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(0.0, Double.NaN).containsNaN());
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        T tuple = this.createRandomTuple(random);
        double x = tuple.getX();
        double y = tuple.getY();
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x + 0.999 * epsilon, y), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x - 0.999 * epsilon, y), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y + 0.999 * epsilon), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y - 0.999 * epsilon), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x + 1.001 * epsilon, y), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x - 1.001 * epsilon, y), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y + 1.001 * epsilon), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y - 1.001 * epsilon), epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        T tuple = this.createRandomTuple(random);
        Assertions.assertFalse((boolean)tuple.equals(this.createEmptyTuple()));
        Assertions.assertFalse((boolean)tuple.equals(null));
        Assertions.assertFalse((boolean)tuple.equals(new double[5]));
        T tupleAsObject = tuple;
        Assertions.assertTrue((boolean)tuple.equals(tupleAsObject));
        double x = tuple.getX();
        double y = tuple.getY();
        Assertions.assertTrue((boolean)tuple.equals(this.createTuple(x, y)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x + this.getEpsilon(), y)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x - this.getEpsilon(), y)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y + this.getEpsilon())));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y - this.getEpsilon())));
    }
}

