/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public abstract class TransformTest<T extends Transform> {
    private static final double EPS = 1.0E-10;

    public abstract T createRandomTransform(Random var1);

    public abstract T createRandomTransform2D(Random var1);

    @Test
    public void testInverseTransformWithTuple() throws Exception {
        Random random = new Random(3454L);
        T transform = this.createRandomTransform(random);
        Point3D pointExpected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointActual = new Point3D();
        pointActual.set(pointExpected);
        transform.transform((Point3DBasics)pointActual);
        transform.inverseTransform((Point3DBasics)pointActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)pointExpected, (Tuple3DReadOnly)pointActual, (double)1.0E-10);
        pointExpected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        pointActual = new Point3D();
        transform.inverseTransform((Point3DReadOnly)pointExpected, (Point3DBasics)pointActual);
        transform.transform((Point3DBasics)pointActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)pointExpected, (Tuple3DReadOnly)pointActual, (double)1.0E-10);
        Vector3D vectorExpected = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D vectorActual = new Vector3D();
        vectorActual.set(vectorExpected);
        transform.transform((Vector3DBasics)vectorActual);
        transform.inverseTransform((Vector3DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vectorExpected, (Tuple3DReadOnly)vectorActual, (double)1.0E-10);
        vectorExpected = EuclidCoreRandomTools.nextVector3D((Random)random);
        vectorActual = new Vector3D();
        transform.inverseTransform((Vector3DReadOnly)vectorExpected, (Vector3DBasics)vectorActual);
        transform.transform((Vector3DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vectorExpected, (Tuple3DReadOnly)vectorActual, (double)1.0E-10);
    }

    @Test
    public void testInverseTransformWithTuple2D() throws Exception {
        Random random = new Random(3454L);
        T transfom2D = this.createRandomTransform2D(random);
        Point2D pointExpected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D pointActual = new Point2D();
        pointActual.set(pointExpected);
        transfom2D.transform((Point2DBasics)pointActual);
        transfom2D.inverseTransform((Point2DBasics)pointActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)pointExpected, (Tuple2DReadOnly)pointActual, (double)1.0E-10);
        pointExpected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointActual = new Point2D();
        transfom2D.inverseTransform((Point2DReadOnly)pointExpected, (Point2DBasics)pointActual);
        transfom2D.transform((Point2DBasics)pointActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)pointExpected, (Tuple2DReadOnly)pointActual, (double)1.0E-10);
        Vector2D vectorExpected = EuclidCoreRandomTools.nextVector2D((Random)random);
        Vector2D vectorActual = new Vector2D();
        vectorActual.set(vectorExpected);
        transfom2D.transform((Vector2DBasics)vectorActual);
        transfom2D.inverseTransform((Vector2DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)vectorExpected, (Tuple2DReadOnly)vectorActual, (double)1.0E-10);
        vectorExpected = EuclidCoreRandomTools.nextVector2D((Random)random);
        vectorActual = new Vector2D();
        transfom2D.inverseTransform((Vector2DReadOnly)vectorExpected, (Vector2DBasics)vectorActual);
        transfom2D.transform((Vector2DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)vectorExpected, (Tuple2DReadOnly)vectorActual, (double)1.0E-10);
    }

    @Test
    public void testInverseTransformWithQuaternion() throws Exception {
        Random random = new Random(3454L);
        T transform = this.createRandomTransform(random);
        Quaternion expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion actual = new Quaternion();
        actual.set(expected);
        transform.transform((Orientation3DBasics)actual);
        transform.inverseTransform((Orientation3DBasics)actual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = new Quaternion();
        transform.inverseTransform((Orientation3DReadOnly)expected, (Orientation3DBasics)actual);
        transform.transform((Orientation3DBasics)actual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
    }

    @Test
    public void testInverseTransformWithVector4D() throws Exception {
        Random random = new Random(3454L);
        T transform = this.createRandomTransform(random);
        Vector4D expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        Vector4D actual = new Vector4D();
        actual.set(expected);
        transform.transform((Vector4DBasics)actual);
        transform.inverseTransform((Vector4DBasics)actual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = new Vector4D();
        transform.inverseTransform((Vector4DReadOnly)expected, (Vector4DBasics)actual);
        transform.transform((Vector4DBasics)actual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
    }

    @Test
    public void testInverseTransformWithRotationMatrix() throws Exception {
        Random random = new Random(3454L);
        T transform = this.createRandomTransform(random);
        RotationMatrix expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix actual = new RotationMatrix();
        actual.set(expected);
        transform.transform((RotationMatrixBasics)actual);
        transform.inverseTransform((RotationMatrixBasics)actual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = new RotationMatrix();
        transform.inverseTransform((RotationMatrixReadOnly)expected, (RotationMatrixBasics)actual);
        transform.transform((RotationMatrixBasics)actual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
    }

    @Test
    public void testInverseTransformWithMatrix3D() throws Exception {
        Random random = new Random(3454L);
        T transform = this.createRandomTransform(random);
        Matrix3D expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        Matrix3D actual = new Matrix3D();
        actual.set(expected);
        transform.transform((Matrix3DBasics)actual);
        transform.inverseTransform((Matrix3DBasics)actual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = new Matrix3D();
        transform.inverseTransform((Matrix3DReadOnly)expected, (Matrix3DBasics)actual);
        transform.transform((Matrix3DBasics)actual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
    }
}

