/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class RotationVectorConversionTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testAxisAngleToRotationVector() throws Exception {
        Random random = new Random(4591L);
        double minMaxAngleRange = Math.PI * 2;
        for (int i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            Vector3D rotationVector = new Vector3D();
            double ux = axisAngle.getX();
            double uy = axisAngle.getY();
            double uz = axisAngle.getZ();
            double angle = axisAngle.getAngle();
            RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)ux, (double)uy, (double)uz, (double)angle, (Vector3DBasics)rotationVector);
            Assertions.assertEquals((double)rotationVector.length(), (double)Math.abs(angle), (double)1.0E-12);
            Assertions.assertEquals((double)rotationVector.getX(), (double)(angle * ux), (double)1.0E-12);
            Assertions.assertEquals((double)rotationVector.getY(), (double)(angle * uy), (double)1.0E-12);
            Assertions.assertEquals((double)rotationVector.getZ(), (double)(angle * uz), (double)1.0E-12);
        }
        Vector3D expectedRotationVector = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D actualRotationVector = new Vector3D();
        double ux = expectedRotationVector.getX();
        double uy = expectedRotationVector.getY();
        double uz = expectedRotationVector.getZ();
        double angle = expectedRotationVector.length();
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)ux, (double)uy, (double)uz, (double)angle, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        for (int i = 0; i < 100; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            AxisAngle axisAngleCopy = new AxisAngle((Orientation3DReadOnly)axisAngle);
            ux = axisAngle.getX();
            uy = axisAngle.getY();
            uz = axisAngle.getZ();
            angle = axisAngle.getAngle();
            RotationVectorConversion.convertAxisAngleToRotationVectorImpl((double)ux, (double)uy, (double)uz, (double)angle, (Vector3DBasics)expectedRotationVector);
            RotationVectorConversion.convertAxisAngleToRotationVector((AxisAngleReadOnly)axisAngle, (Vector3DBasics)actualRotationVector);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
            Assertions.assertTrue((boolean)axisAngle.equals((AxisAngleReadOnly)axisAngleCopy));
        }
    }

    @Test
    public void testQuaternionToRotationVector() throws Exception {
        double qz;
        double qy;
        double qx;
        double qs;
        double angle;
        double uz;
        double uy;
        double ux;
        AxisAngle axisAngle;
        int i;
        Random random = new Random(1641L);
        double minMaxAngleRange = Math.PI * 2;
        Vector3D expectedRotationVector = new Vector3D();
        Vector3D actualRotationVector = new Vector3D();
        Quaternion quaternion = new Quaternion();
        for (i = 0; i < 10000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            ux = axisAngle.getX();
            uy = axisAngle.getY();
            uz = axisAngle.getZ();
            angle = axisAngle.getAngle();
            expectedRotationVector.setX(ux * angle);
            expectedRotationVector.setY(uy * angle);
            expectedRotationVector.setZ(uz * angle);
            qs = EuclidCoreTools.cos((double)(angle / 2.0));
            qx = ux * EuclidCoreTools.sin((double)(angle / 2.0));
            qy = uy * EuclidCoreTools.sin((double)(angle / 2.0));
            qz = uz * EuclidCoreTools.sin((double)(angle / 2.0));
            quaternion.setUnsafe(qx, qy, qz, qs);
            RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
        }
        minMaxAngleRange = 1.0E-8;
        for (i = 0; i < 10000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            ux = axisAngle.getX();
            uy = axisAngle.getY();
            uz = axisAngle.getZ();
            angle = axisAngle.getAngle();
            expectedRotationVector.setX(ux * angle);
            expectedRotationVector.setY(uy * angle);
            expectedRotationVector.setZ(uz * angle);
            qs = EuclidCoreTools.cos((double)(angle / 2.0));
            qx = ux * EuclidCoreTools.sin((double)(angle / 2.0));
            qy = uy * EuclidCoreTools.sin((double)(angle / 2.0));
            qz = uz * EuclidCoreTools.sin((double)(angle / 2.0));
            quaternion.setUnsafe(qx, qy, qz, qs);
            RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
        }
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualRotationVector);
        quaternion.setUnsafe(Double.NaN, 0.0, 0.0, 0.0);
        RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        quaternion.setUnsafe(0.0, Double.NaN, 0.0, 0.0);
        RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        quaternion.setUnsafe(0.0, 0.0, Double.NaN, 0.0);
        RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        quaternion.setUnsafe(0.0, 0.0, 0.0, Double.NaN);
        RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
    }

    @Test
    public void testMatrixToRotationVector() throws Exception {
        double m21;
        double m12;
        double m02;
        double m20;
        double m10;
        double m01;
        double m22;
        double m11;
        double m00;
        AxisAngle axisAngle;
        int i;
        Random random = new Random(3651651L);
        double minMaxAngleRange = Math.PI;
        Vector3D expectedRotationVector = new Vector3D();
        Vector3D actualRotationVector = new Vector3D();
        for (i = 0; i < 10000; ++i) {
            axisAngle = new AxisAngle();
            axisAngle.setAngle(Math.PI);
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomVector.normalize();
            axisAngle.setX(randomVector.getX());
            axisAngle.setY(randomVector.getY());
            axisAngle.setZ(randomVector.getZ());
            double ux = axisAngle.getX();
            double uy = axisAngle.getY();
            double uz = axisAngle.getZ();
            double angle = axisAngle.getAngle();
            expectedRotationVector.setX(ux * angle);
            expectedRotationVector.setY(uy * angle);
            expectedRotationVector.setZ(uz * angle);
            m00 = EuclidCoreTools.cos((double)angle) + ux * ux * (1.0 - EuclidCoreTools.cos((double)angle));
            m11 = EuclidCoreTools.cos((double)angle) + uy * uy * (1.0 - EuclidCoreTools.cos((double)angle));
            m22 = EuclidCoreTools.cos((double)angle) + uz * uz * (1.0 - EuclidCoreTools.cos((double)angle));
            m01 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) - uz * EuclidCoreTools.sin((double)angle);
            m10 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) + uz * EuclidCoreTools.sin((double)angle);
            m20 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - uy * EuclidCoreTools.sin((double)angle);
            m02 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + uy * EuclidCoreTools.sin((double)angle);
            m12 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - ux * EuclidCoreTools.sin((double)angle);
            m21 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + ux * EuclidCoreTools.sin((double)angle);
            RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
            if (actualRotationVector.getX() * expectedRotationVector.getX() < 0.0) {
                actualRotationVector.negate();
            }
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
        }
        for (i = 0; i < 10000; ++i) {
            axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            double ux = axisAngle.getX();
            double uy = axisAngle.getY();
            double uz = axisAngle.getZ();
            double angle = axisAngle.getAngle();
            expectedRotationVector.setX(ux * angle);
            expectedRotationVector.setY(uy * angle);
            expectedRotationVector.setZ(uz * angle);
            m00 = EuclidCoreTools.cos((double)angle) + ux * ux * (1.0 - EuclidCoreTools.cos((double)angle));
            m11 = EuclidCoreTools.cos((double)angle) + uy * uy * (1.0 - EuclidCoreTools.cos((double)angle));
            m22 = EuclidCoreTools.cos((double)angle) + uz * uz * (1.0 - EuclidCoreTools.cos((double)angle));
            m01 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) - uz * EuclidCoreTools.sin((double)angle);
            m10 = ux * uy * (1.0 - EuclidCoreTools.cos((double)angle)) + uz * EuclidCoreTools.sin((double)angle);
            m20 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - uy * EuclidCoreTools.sin((double)angle);
            m02 = ux * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + uy * EuclidCoreTools.sin((double)angle);
            m12 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) - ux * EuclidCoreTools.sin((double)angle);
            m21 = uy * uz * (1.0 - EuclidCoreTools.cos((double)angle)) + ux * EuclidCoreTools.sin((double)angle);
            RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
        }
        m22 = 1.0;
        m11 = 1.0;
        m00 = 1.0;
        m12 = 0.0;
        m02 = 0.0;
        m01 = 0.0;
        m21 = 0.0;
        m20 = 0.0;
        m10 = 0.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualRotationVector);
        m00 = 1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 0.0;
        m12 = -1.0;
        m20 = 0.0;
        m21 = 1.0;
        m22 = 0.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)1.5707963267948966, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = 1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)Math.PI, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 0.0;
        m02 = 1.0;
        m10 = 0.0;
        m11 = 1.0;
        m12 = 0.0;
        m20 = -1.0;
        m21 = 0.0;
        m22 = 0.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)1.5707963267948966, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = 0.0;
        m01 = -1.0;
        m02 = 0.0;
        m10 = 1.0;
        m11 = 0.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = 1.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)1.5707963267948966, (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = 1.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)Math.PI, (double)actualRotationVector.getZ(), (double)1.0E-12);
        double sqrt2Over2 = EuclidCoreTools.squareRoot((double)2.0) / 2.0;
        m00 = 0.0;
        m01 = 1.0;
        m02 = 0.0;
        m10 = 1.0;
        m11 = 0.0;
        m12 = 0.0;
        m20 = 0.0;
        m21 = 0.0;
        m22 = -1.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)(Math.PI * sqrt2Over2), (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)(Math.PI * sqrt2Over2), (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = 0.0;
        m01 = 0.0;
        m02 = 1.0;
        m10 = 0.0;
        m11 = -1.0;
        m12 = 0.0;
        m20 = 1.0;
        m21 = 0.0;
        m22 = 0.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)(Math.PI * sqrt2Over2), (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)(Math.PI * sqrt2Over2), (double)actualRotationVector.getZ(), (double)1.0E-12);
        m00 = -1.0;
        m01 = 0.0;
        m02 = 0.0;
        m10 = 0.0;
        m11 = 0.0;
        m12 = 1.0;
        m20 = 0.0;
        m21 = 1.0;
        m22 = 0.0;
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)actualRotationVector);
        Assertions.assertEquals((double)0.0, (double)actualRotationVector.getX(), (double)1.0E-12);
        Assertions.assertEquals((double)(Math.PI * sqrt2Over2), (double)actualRotationVector.getY(), (double)1.0E-12);
        Assertions.assertEquals((double)(Math.PI * sqrt2Over2), (double)actualRotationVector.getZ(), (double)1.0E-12);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        RotationVectorConversion.convertMatrixToRotationVectorImpl((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (Vector3DBasics)actualRotationVector);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualRotationVector);
        for (int i2 = 0; i2 < 1000; ++i2) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix rotationMatrixCopy = new RotationMatrix((RotationMatrixReadOnly)rotationMatrix);
            m00 = rotationMatrix.getM00();
            m01 = rotationMatrix.getM01();
            m02 = rotationMatrix.getM02();
            m10 = rotationMatrix.getM10();
            m11 = rotationMatrix.getM11();
            m12 = rotationMatrix.getM12();
            m20 = rotationMatrix.getM20();
            m21 = rotationMatrix.getM21();
            m22 = rotationMatrix.getM22();
            RotationVectorConversion.convertMatrixToRotationVector((RotationMatrixReadOnly)rotationMatrix, (Vector3DBasics)actualRotationVector);
            RotationVectorConversion.convertMatrixToRotationVectorImpl((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12, (double)m20, (double)m21, (double)m22, (Vector3DBasics)expectedRotationVector);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
            Assertions.assertTrue((boolean)rotationMatrix.equals((Matrix3DReadOnly)rotationMatrixCopy));
        }
    }

    @Test
    public void testYawPitchRollToRotationVector() throws Exception {
        Vector3D expectedRotationVector = new Vector3D();
        Vector3D actualRotationVector = new Vector3D();
        double deltaAngle = 0.3141592653589793;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                for (double pitch = -1.5707963267948966; pitch <= 1.5707963267948966; pitch += deltaAngle) {
                    Quaternion quaternion = new Quaternion();
                    QuaternionConversion.convertYawPitchRollToQuaternion((double)yaw, (double)pitch, (double)roll, (QuaternionBasics)quaternion);
                    RotationVectorConversion.convertQuaternionToRotationVector((QuaternionReadOnly)quaternion, (Vector3DBasics)expectedRotationVector);
                    RotationVectorConversion.convertYawPitchRollToRotationVector((double)yaw, (double)pitch, (double)roll, (Vector3DBasics)actualRotationVector);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
                    YawPitchRoll yawPitchRoll = new YawPitchRoll(yaw, pitch, roll);
                    RotationVectorConversion.convertYawPitchRollToRotationVector((YawPitchRollReadOnly)yawPitchRoll, (Vector3DBasics)actualRotationVector);
                    EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedRotationVector, (Tuple3DReadOnly)actualRotationVector, (double)1.0E-12);
                    Assertions.assertTrue((yawPitchRoll.getYaw() == yaw ? 1 : 0) != 0);
                    Assertions.assertTrue((yawPitchRoll.getPitch() == pitch ? 1 : 0) != 0);
                    Assertions.assertTrue((yawPitchRoll.getRoll() == roll ? 1 : 0) != 0);
                }
            }
        }
    }
}

