/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class RotationMatrixConversionTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testYawPitchRollToMatrix() throws Exception {
        Random random = new Random(230487L);
        RotationMatrix expectedMatrix = new RotationMatrix();
        RotationMatrix actualMatrix = new RotationMatrix();
        RotationMatrix yawMatrix = new RotationMatrix();
        RotationMatrix pitchMatrix = new RotationMatrix();
        RotationMatrix rollMatrix = new RotationMatrix();
        double deltaAngle = 0.3141592653589793;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            yawMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrixConversion.computeYawMatrix((double)yaw, (CommonMatrix3DBasics)yawMatrix);
            Assertions.assertTrue((yawMatrix.getM22() == 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((yawMatrix.getM12() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((yawMatrix.getM02() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((yawMatrix.getM21() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((yawMatrix.getM20() == 0.0 ? 1 : 0) != 0);
            Assertions.assertEquals((double)yawMatrix.getM00(), (double)EuclidCoreTools.cos((double)yaw), (double)1.0E-12);
            Assertions.assertEquals((double)yawMatrix.getM11(), (double)EuclidCoreTools.cos((double)yaw), (double)1.0E-12);
            Assertions.assertEquals((double)yawMatrix.getM10(), (double)EuclidCoreTools.sin((double)yaw), (double)1.0E-12);
            Assertions.assertEquals((double)yawMatrix.getM01(), (double)(-EuclidCoreTools.sin((double)yaw)), (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)yawMatrix, (double)1.0E-12);
            for (double pitch = -1.5707963267948966; pitch <= 1.5707963267948966; pitch += deltaAngle) {
                pitchMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                RotationMatrixConversion.computePitchMatrix((double)pitch, (CommonMatrix3DBasics)pitchMatrix);
                Assertions.assertTrue((pitchMatrix.getM11() == 1.0 ? 1 : 0) != 0);
                Assertions.assertTrue((pitchMatrix.getM01() == 0.0 ? 1 : 0) != 0);
                Assertions.assertTrue((pitchMatrix.getM10() == 0.0 ? 1 : 0) != 0);
                Assertions.assertTrue((pitchMatrix.getM21() == 0.0 ? 1 : 0) != 0);
                Assertions.assertTrue((pitchMatrix.getM12() == 0.0 ? 1 : 0) != 0);
                Assertions.assertEquals((double)pitchMatrix.getM00(), (double)EuclidCoreTools.cos((double)pitch), (double)1.0E-12);
                Assertions.assertEquals((double)pitchMatrix.getM22(), (double)EuclidCoreTools.cos((double)pitch), (double)1.0E-12);
                Assertions.assertEquals((double)pitchMatrix.getM20(), (double)(-EuclidCoreTools.sin((double)pitch)), (double)1.0E-12);
                Assertions.assertEquals((double)pitchMatrix.getM02(), (double)EuclidCoreTools.sin((double)pitch), (double)1.0E-12);
                EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)pitchMatrix, (double)1.0E-12);
                for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                    rollMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
                    RotationMatrixConversion.computeRollMatrix((double)roll, (CommonMatrix3DBasics)rollMatrix);
                    Assertions.assertTrue((rollMatrix.getM00() == 1.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((rollMatrix.getM10() == 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((rollMatrix.getM20() == 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((rollMatrix.getM01() == 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((rollMatrix.getM02() == 0.0 ? 1 : 0) != 0);
                    Assertions.assertEquals((double)rollMatrix.getM11(), (double)EuclidCoreTools.cos((double)roll), (double)1.0E-12);
                    Assertions.assertEquals((double)rollMatrix.getM22(), (double)EuclidCoreTools.cos((double)roll), (double)1.0E-12);
                    Assertions.assertEquals((double)rollMatrix.getM12(), (double)(-EuclidCoreTools.sin((double)roll)), (double)1.0E-12);
                    Assertions.assertEquals((double)rollMatrix.getM21(), (double)EuclidCoreTools.sin((double)roll), (double)1.0E-12);
                    EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)rollMatrix, (double)1.0E-12);
                    RotationMatrixTools.multiply((RotationMatrixReadOnly)yawMatrix, (RotationMatrixReadOnly)pitchMatrix, (CommonMatrix3DBasics)expectedMatrix);
                    RotationMatrixTools.multiply((RotationMatrixReadOnly)expectedMatrix, (RotationMatrixReadOnly)rollMatrix, (CommonMatrix3DBasics)expectedMatrix);
                    EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)expectedMatrix, (double)1.0E-12);
                    RotationMatrixConversion.convertYawPitchRollToMatrix((double)yaw, (double)pitch, (double)roll, (CommonMatrix3DBasics)actualMatrix);
                    EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
                    EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
                }
            }
        }
        RotationMatrixConversion.computeYawMatrix((double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        RotationMatrixConversion.computeYawMatrix((double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        RotationMatrixConversion.computePitchMatrix((double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        RotationMatrixConversion.computeRollMatrix((double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        RotationMatrixConversion.convertYawPitchRollToMatrix((double)0.0, (double)0.0, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
    }

    @Test
    public void testAxisAngleToMatrix() throws Exception {
        int i;
        Random random = new Random(489651L);
        double minMaxAngleRange = Math.PI;
        AxisAngle expectedAxisAngle = new AxisAngle();
        AxisAngle actualAxisAngle = new AxisAngle();
        RotationMatrix actualMatrix = new RotationMatrix();
        RotationMatrix expectedMatrix = new RotationMatrix();
        for (i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeAxisAngle((Random)random, (double)minMaxAngleRange, (AxisAngleBasics)expectedAxisAngle);
            double ux = expectedAxisAngle.getX();
            double uy = expectedAxisAngle.getY();
            double uz = expectedAxisAngle.getZ();
            double angle = expectedAxisAngle.getAngle();
            RotationMatrixConversion.convertAxisAngleToMatrix((double)ux, (double)uy, (double)uz, (double)angle, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)actualMatrix, (AxisAngleBasics)actualAxisAngle);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expectedAxisAngle, (AxisAngleReadOnly)actualAxisAngle, (double)1.0E-12);
        }
        RotationMatrixConversion.convertAxisAngleToMatrix((double)0.0, (double)0.0, (double)0.0, (double)1.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        RotationMatrixConversion.convertAxisAngleToMatrix((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        RotationMatrixConversion.convertAxisAngleToMatrix((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        RotationMatrixConversion.convertAxisAngleToMatrix((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        RotationMatrixConversion.convertAxisAngleToMatrix((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        for (i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            AxisAngle axisAngleCopy = new AxisAngle((Orientation3DReadOnly)axisAngle);
            double ux = axisAngle.getX();
            double uy = axisAngle.getY();
            double uz = axisAngle.getZ();
            double angle = axisAngle.getAngle();
            RotationMatrixConversion.convertAxisAngleToMatrix((double)ux, (double)uy, (double)uz, (double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertAxisAngleToMatrix((AxisAngleReadOnly)axisAngle, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            Assertions.assertTrue((boolean)axisAngle.equals((AxisAngleReadOnly)axisAngleCopy));
        }
        for (double angle = -Math.PI; angle <= Math.PI; angle += 0.031415926535897934) {
            RotationMatrixConversion.computeRollMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertAxisAngleToMatrix((double)(1.5 * random.nextDouble()), (double)0.0, (double)0.0, (double)angle, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            RotationMatrixConversion.computePitchMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertAxisAngleToMatrix((double)0.0, (double)(1.5 * random.nextDouble()), (double)0.0, (double)angle, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            RotationMatrixConversion.computeYawMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertAxisAngleToMatrix((double)0.0, (double)0.0, (double)(1.5 * random.nextDouble()), (double)angle, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testQuaternionToMatrix() throws Exception {
        Random random = new Random(489651L);
        double minMaxAngleRange = Math.PI;
        Quaternion expectedQuaternion = new Quaternion();
        Quaternion actualQuaternion = new Quaternion();
        RotationMatrix actualMatrix = new RotationMatrix();
        RotationMatrix expectedMatrix = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            expectedQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random, (double)minMaxAngleRange);
            RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            QuaternionConversion.convertMatrixToQuaternion((RotationMatrixReadOnly)actualMatrix, (QuaternionBasics)actualQuaternion);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expectedQuaternion, (QuaternionReadOnly)actualQuaternion, (double)1.0E-12);
        }
        expectedQuaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        expectedQuaternion.setUnsafe(Double.NaN, 0.0, 0.0, 0.0);
        RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        expectedQuaternion.setUnsafe(0.0, Double.NaN, 0.0, 0.0);
        RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        expectedQuaternion.setUnsafe(0.0, 0.0, Double.NaN, 0.0);
        RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        expectedQuaternion.setUnsafe(0.0, 0.0, 0.0, Double.NaN);
        RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        for (double angle = Math.PI * -2; angle <= Math.PI * 2; angle += 0.031415926535897934) {
            double scale = 1.5 * random.nextDouble();
            RotationMatrixConversion.computeRollMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            expectedQuaternion.setUnsafe(scale * EuclidCoreTools.sin((double)(angle / 2.0)), 0.0, 0.0, scale * EuclidCoreTools.cos((double)(angle / 2.0)));
            RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            RotationMatrixConversion.computePitchMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            expectedQuaternion.setUnsafe(0.0, scale * EuclidCoreTools.sin((double)(angle / 2.0)), 0.0, scale * EuclidCoreTools.cos((double)(angle / 2.0)));
            RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            RotationMatrixConversion.computeYawMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            expectedQuaternion.setUnsafe(0.0, 0.0, scale * EuclidCoreTools.sin((double)(angle / 2.0)), scale * EuclidCoreTools.cos((double)(angle / 2.0)));
            RotationMatrixConversion.convertQuaternionToMatrix((QuaternionReadOnly)expectedQuaternion, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testRotationVectorToMatrix() throws Exception {
        Random random = new Random(126515L);
        double minMaxAngleRange = Math.PI;
        RotationMatrix expectedMatrix = new RotationMatrix();
        RotationMatrix actualMatrix = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            AxisAngle axisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random, (double)minMaxAngleRange);
            double rx = axisAngle.getX() * axisAngle.getAngle();
            double ry = axisAngle.getY() * axisAngle.getAngle();
            double rz = axisAngle.getZ() * axisAngle.getAngle();
            RotationMatrixConversion.convertAxisAngleToMatrix((AxisAngleReadOnly)axisAngle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertRotationVectorToMatrix((double)rx, (double)ry, (double)rz, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        RotationMatrixConversion.convertRotationVectorToMatrix((double)0.0, (double)0.0, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        RotationMatrixConversion.convertRotationVectorToMatrix((double)Double.NaN, (double)0.0, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        RotationMatrixConversion.convertRotationVectorToMatrix((double)0.0, (double)Double.NaN, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        RotationMatrixConversion.convertRotationVectorToMatrix((double)0.0, (double)0.0, (double)Double.NaN, (CommonMatrix3DBasics)actualMatrix);
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)actualMatrix);
        for (double angle = -Math.PI; angle <= Math.PI; angle += 0.031415926535897934) {
            RotationMatrixConversion.computeRollMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertRotationVectorToMatrix((double)angle, (double)0.0, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            RotationMatrixConversion.computePitchMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertRotationVectorToMatrix((double)0.0, (double)angle, (double)0.0, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            RotationMatrixConversion.computeYawMatrix((double)angle, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertRotationVectorToMatrix((double)0.0, (double)0.0, (double)angle, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (int i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextVector3D((Random)random, (Tuple3DReadOnly)new Point3D(minMaxAngleRange, minMaxAngleRange, minMaxAngleRange));
            Vector3D rotationVectorCopy = new Vector3D((Tuple3DReadOnly)rotationVector);
            double rx = rotationVector.getX();
            double ry = rotationVector.getY();
            double rz = rotationVector.getZ();
            RotationMatrixConversion.convertRotationVectorToMatrix((double)rx, (double)ry, (double)rz, (CommonMatrix3DBasics)expectedMatrix);
            RotationMatrixConversion.convertRotationVectorToMatrix((Vector3DReadOnly)rotationVector, (CommonMatrix3DBasics)actualMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            EuclidCoreTestTools.assertRotationMatrix((Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
            Assertions.assertTrue((boolean)rotationVector.equals((Tuple3DReadOnly)rotationVectorCopy));
        }
    }
}

