/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameTuple4DBasicsTest;
import us.ihmc.euclid.referenceFrame.FrameVector4D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.Vector4DBasicsTest;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class FrameVector4DTest
extends FrameTuple4DBasicsTest<FrameVector4D> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Override
    public Tuple4DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextVector4D((Random)random);
    }

    @Override
    public FrameVector4D createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z, double s) {
        return new FrameVector4D(referenceFrame, x, y, z, s);
    }

    @Test
    public void testConstructors() throws Exception {
        FrameVector4D frameVector4D;
        Vector4D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FrameVector4D frameVector4D2 = new FrameVector4D();
        Assertions.assertTrue((frameVector4D2.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        Assertions.assertTrue((frameVector4D2.getX() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((frameVector4D2.getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((frameVector4D2.getZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((frameVector4D2.getS() == 0.0 ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector4D frameVector4D3 = new FrameVector4D(randomFrame);
            Assertions.assertTrue((frameVector4D3.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            Assertions.assertTrue((frameVector4D3.getX() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((frameVector4D3.getY() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((frameVector4D3.getZ() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((frameVector4D3.getS() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector4D = new FrameVector4D(randomFrame, (randomTuple = EuclidCoreRandomTools.nextVector4D((Random)random)).getX(), randomTuple.getY(), randomTuple.getZ(), randomTuple.getS());
            Assertions.assertTrue((frameVector4D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomTuple, (Tuple4DReadOnly)frameVector4D, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextVector4D((Random)random);
            double[] array = new double[4];
            randomTuple.get(array);
            FrameVector4D frameVector4D4 = new FrameVector4D(randomFrame, array);
            Assertions.assertTrue((frameVector4D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomTuple, (Tuple4DReadOnly)frameVector4D4, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameVector4D = new FrameVector4D(randomFrame, (Tuple4DReadOnly)(randomTuple = EuclidCoreRandomTools.nextVector4D((Random)random)));
            Assertions.assertTrue((frameVector4D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomTuple, (Tuple4DReadOnly)frameVector4D, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)randomFrame);
            frameVector4D = new FrameVector4D((FrameTuple4DReadOnly)randomTuple);
            Assertions.assertTrue((frameVector4D.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)randomTuple, (Tuple4DReadOnly)frameVector4D, (double)1.0E-10);
            EuclidFrameTestTools.assertFrameTuple4DEquals((FrameTuple4DReadOnly)randomTuple, (FrameTuple4DReadOnly)frameVector4D, (double)1.0E-10);
        }
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameVector4D, 10);
    }

    @Override
    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameVector4D, 10);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Vector4D expected = EuclidCoreRandomTools.nextVector4D((Random)random);
            FrameVector4D actual = new FrameVector4D(initialFrame, (Tuple4DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            actual.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)1.0E-10);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                actual.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FrameVector4D frameVector1 = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)worldFrame);
            FrameVector4D frameVector2 = new FrameVector4D(worldFrame);
            double epsilon = random.nextDouble();
            Vector4D difference = EuclidCoreRandomTools.nextVector4D((Random)random);
            difference.scale(0.99 * epsilon / difference.norm());
            frameVector2.add((FrameTuple4DReadOnly)frameVector1, (Tuple4DReadOnly)difference);
            Assertions.assertTrue((boolean)frameVector1.geometricallyEquals(frameVector2, epsilon));
            difference = EuclidCoreRandomTools.nextVector4D((Random)random);
            difference.scale(1.01 * epsilon / difference.norm());
            frameVector2.add((FrameTuple4DReadOnly)frameVector1, (Tuple4DReadOnly)difference);
            Assertions.assertFalse((boolean)frameVector1.geometricallyEquals(frameVector2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100);
        FrameVector4D tuple = new FrameVector4D();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setZ(random.nextDouble());
        tuple.setS(random.nextDouble());
        tuple.setReferenceFrame(frames[random.nextInt(frames.length)]);
        int newHashCode = tuple.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple.hashCode());
        int previousHashCode = tuple.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple.setElement(i % 4, random.nextDouble());
            newHashCode = tuple.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
            ReferenceFrame oldFrame = tuple.getReferenceFrame();
            ReferenceFrame newFrame = frames[random.nextInt(frames.length)];
            tuple.setReferenceFrame(newFrame);
            newHashCode = tuple.hashCode();
            if (oldFrame != newFrame) {
                Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            }
            previousHashCode = newHashCode;
        }
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Vector4D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Vector4D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Vector4D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameVector4D.class, Vector4D.class, true, 1, methodFilter);
    }

    @Test
    public void testVectorBasicsFeatures() throws Exception {
        Vector4DBasicsTest<FrameVector4D> vectorBasicsTest = new Vector4DBasicsTest<FrameVector4D>(){

            @Override
            public FrameVector4D createEmptyTuple() {
                return (FrameVector4D)FrameVector4DTest.this.createEmptyFrameTuple();
            }

            @Override
            public FrameVector4D createRandomTuple(Random random) {
                return (FrameVector4D)FrameVector4DTest.this.createRandomFrameTuple(random);
            }

            @Override
            public FrameVector4D createTuple(double x, double y, double z, double s) {
                return (FrameVector4D)FrameVector4DTest.this.createFrameTuple(x, y, z, s);
            }

            @Override
            public double getEpsilon() {
                return 1.0E-10;
            }
        };
        for (Method testMethod : vectorBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)vectorBasicsTest, new Object[0]);
        }
    }
}

