/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameTuple4DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public abstract class FrameQuaternionReadOnlyTest<F extends FrameQuaternionReadOnly>
extends FrameTuple4DReadOnlyTest<F> {
    public final F createRandom2DFrameTuple(Random random, ReferenceFrame referenceFrame) {
        Quaternion quaternion = new Quaternion();
        quaternion.setToYawOrientation(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
        return (F)((FrameQuaternionReadOnly)this.createFrameTuple(referenceFrame, (Tuple4DReadOnly)quaternion));
    }

    @Override
    public F createEmptyFrameTuple(ReferenceFrame referenceFrame) {
        return (F)((FrameQuaternionReadOnly)this.createFrameTuple(referenceFrame, (Tuple4DReadOnly)new Quaternion()));
    }

    @Override
    public final F createRandomFrameTuple(Random random, ReferenceFrame referenceFrame) {
        return (F)((FrameQuaternionReadOnly)this.createFrameTuple(referenceFrame, (Tuple4DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random)));
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameQuaternionReadOnly.class, QuaternionReadOnly.class, true);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameTuple, methodFilter, 10);
    }

    @Override
    @Test
    public void testEpsilonEquals() throws Exception {
        super.testEpsilonEquals();
        Random random = new Random(621541L);
        double epsilon = 0.0;
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        double s = random.nextDouble();
        FrameQuaternionReadOnly tuple1 = (FrameQuaternionReadOnly)this.createFrameTuple(frame1, x, y, z, s);
        FrameQuaternionReadOnly tuple2 = (FrameQuaternionReadOnly)this.createFrameTuple(frame1, x, y, z, s);
        FrameQuaternionReadOnly tuple3 = (FrameQuaternionReadOnly)this.createFrameTuple(frame2, x, y, z, s);
        FrameQuaternionReadOnly tuple4 = (FrameQuaternionReadOnly)this.createFrameTuple(frame2, x, y, z, s);
        Assertions.assertTrue((boolean)tuple1.epsilonEquals((FrameTuple4DReadOnly)tuple2, epsilon));
        Assertions.assertFalse((boolean)tuple1.epsilonEquals((FrameTuple4DReadOnly)tuple3, epsilon));
        Assertions.assertFalse((boolean)tuple3.epsilonEquals((FrameTuple4DReadOnly)tuple2, epsilon));
        Assertions.assertTrue((boolean)tuple3.epsilonEquals((FrameTuple4DReadOnly)tuple4, epsilon));
        Assertions.assertTrue((boolean)tuple1.epsilonEquals((FrameTuple4DReadOnly)tuple2, epsilon));
        Assertions.assertFalse((boolean)tuple1.epsilonEquals((FrameTuple4DReadOnly)tuple3, epsilon));
        Assertions.assertFalse((boolean)tuple3.epsilonEquals((FrameTuple4DReadOnly)tuple2, epsilon));
        Assertions.assertTrue((boolean)tuple3.epsilonEquals((FrameTuple4DReadOnly)tuple4, epsilon));
    }

    @Override
    @Test
    public void testEquals() throws Exception {
        super.testEquals();
        Random random = new Random(621541L);
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        double s = random.nextDouble();
        FrameQuaternionReadOnly tuple1 = (FrameQuaternionReadOnly)this.createFrameTuple(frame1, x, y, z, s);
        FrameQuaternionReadOnly tuple2 = (FrameQuaternionReadOnly)this.createFrameTuple(frame1, x, y, z, s);
        FrameQuaternionReadOnly tuple3 = (FrameQuaternionReadOnly)this.createFrameTuple(frame2, x, y, z, s);
        FrameQuaternionReadOnly tuple4 = (FrameQuaternionReadOnly)this.createFrameTuple(frame2, x, y, z, s);
        Assertions.assertTrue((boolean)tuple1.equals((FrameTuple4DReadOnly)tuple2));
        Assertions.assertFalse((boolean)tuple1.equals((FrameTuple4DReadOnly)tuple3));
        Assertions.assertFalse((boolean)tuple3.equals((FrameTuple4DReadOnly)tuple2));
        Assertions.assertTrue((boolean)tuple3.equals((FrameTuple4DReadOnly)tuple4));
        FrameQuaternionReadOnly tuple2AsObject = tuple2;
        FrameQuaternionReadOnly tuple3AsObject = tuple3;
        FrameQuaternionReadOnly tuple4AsObject = tuple4;
        Assertions.assertTrue((boolean)tuple1.equals(tuple2AsObject));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3AsObject));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2AsObject));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4AsObject));
    }
}

