/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameOrientation2D;
import us.ihmc.euclid.referenceFrame.FrameOrientation2DReadOnlyTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;

public class FrameOrientation2DTest
extends FrameOrientation2DReadOnlyTest<FrameOrientation2D> {
    public static final double EPSILON = 1.0E-15;

    @Override
    public FrameOrientation2D createFrameOrientation(ReferenceFrame referenceFrame, Orientation2DReadOnly orientation) {
        return new FrameOrientation2D(referenceFrame, orientation);
    }

    @Test
    public void testConsistencyWithOrientation2D() {
        FrameTypeCopier frameTypeBuilder = (frame, pose) -> this.createFrameOrientation(frame, (Orientation2DReadOnly)pose);
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidCoreRandomTools::nextOrientation2D;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
    }

    @Override
    @Test
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Orientation2D.class}));
        signaturesToIgnore.add(new MethodSignature("equals", new Class[]{Orientation2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Orientation2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Orientation2D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameOrientation2D.class, Orientation2D.class, true, 1, methodFilter);
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameOrientation2D, 10);
        Random random = new Random(544354L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            FrameOrientation2D source = EuclidFrameRandomTools.nextFrameOrientation2D((Random)random, (ReferenceFrame)sourceFrame);
            FrameOrientation2D actual = EuclidFrameRandomTools.nextFrameOrientation2D((Random)random, (ReferenceFrame)destinationFrame);
            actual.setMatchingFrame((FrameOrientation2DReadOnly)source);
            FrameOrientation2D expected = new FrameOrientation2D((FrameOrientation2DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidCoreTestTools.assertOrientation2DEquals((Orientation2DReadOnly)expected, (Orientation2DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testSetIncludingFrame() {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("setIncludingFrame", new Class[]{ReferenceFrame.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameOrientation2D, methodFilter, 10);
    }
}

