/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Plane3DTest {
    @Test
    public void test() {
        Point3D point = new Point3D();
        Vector3D normal = new Vector3D(1.0, 2.0, 3.0);
        Plane3D plane = new Plane3D((Point3DReadOnly)point, (Vector3DReadOnly)normal);
        Assertions.assertTrue((boolean)point.equals((Tuple3DReadOnly)plane.getPointCopy()));
        Assertions.assertFalse((point == plane.getPointCopy() ? 1 : 0) != 0);
        normal.normalize();
        Assertions.assertTrue((boolean)normal.equals((Tuple3DReadOnly)plane.getNormalCopy()));
        Plane3D plane2 = new Plane3D((Point3DReadOnly)point, (Vector3DReadOnly)normal);
        Assertions.assertTrue((boolean)plane2.epsilonEquals(plane, 1.0E-17));
    }

    @Test
    public void testConstructor() {
        Plane3D plane = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((plane.getNormalCopy().getX() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((plane.getNormalCopy().getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((plane.getNormalCopy().getZ() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((plane.getPointCopy().getX() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((plane.getPointCopy().getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((plane.getPointCopy().getZ() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsOnOrAbove() {
        Plane3D plane = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Point3D Q = new Point3D(0.0, 0.0, 2.0);
        Assertions.assertTrue((boolean)plane.isOnOrAbove((Point3DReadOnly)Q));
        Q = new Point3D(0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)plane.isOnOrAbove((Point3DReadOnly)Q));
        Q = new Point3D(0.0, 0.0, -2.0);
        Assertions.assertFalse((boolean)plane.isOnOrAbove((Point3DReadOnly)Q));
    }

    @Test
    public void testIsOnOrBelow() {
        Plane3D plane = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Point3D Q = new Point3D(0.0, 0.0, -2.0);
        Assertions.assertTrue((boolean)plane.isOnOrBelow((Point3DReadOnly)Q));
        Q = new Point3D(0.0, 0.0, 2.0);
        Assertions.assertFalse((boolean)plane.isOnOrBelow((Point3DReadOnly)Q));
    }

    @Test
    public void testOrthogonalProjection() {
        Point3D q = new Point3D(1.0, 2.0, -3.0);
        Point3D v = new Point3D(1.0, 2.0, 0.0);
        Plane3D plane = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)v.equals((Tuple3DReadOnly)plane.orthogonalProjectionCopy((Point3DReadOnly)q)));
        q.set(3.0, 3.0, -4.0);
        plane.setPoint(1.0, 1.0, 1.0);
        plane.setNormal(2.0, 0.0, 0.0);
        v.set(1.0, 3.0, -4.0);
        Assertions.assertTrue((boolean)v.equals((Tuple3DReadOnly)plane.orthogonalProjectionCopy((Point3DReadOnly)q)));
    }

    @Test
    public void testGetZOnPlane() {
        Point3D point = new Point3D(1.0, 2.0, -3.0);
        Vector3D normal = new Vector3D(0.2, 1.7, 0.4);
        Plane3D plane = new Plane3D((Point3DReadOnly)point, (Vector3DReadOnly)normal);
        double x = 2.33;
        double y = 1.97;
        double z = plane.getZOnPlane(x, y);
        Point3D testPoint = new Point3D(x, y, z);
        Assertions.assertTrue((plane.distance((Point3DReadOnly)testPoint) < 1.0E-10 ? 1 : 0) != 0);
        normal = new Vector3D(0.2, 1.7, 0.0);
        plane = new Plane3D((Point3DReadOnly)point, (Vector3DReadOnly)normal);
        z = plane.getZOnPlane(x, y);
        Assertions.assertTrue((boolean)Double.isNaN(z));
    }

    @Test
    public void testDistance() {
        Point3D q = new Point3D(1.0, 1.0, 1.0);
        Plane3D plane = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertEquals((double)1.0, (double)plane.distance((Point3DReadOnly)q), (double)1.0E-14);
    }

    @Test
    public void testApplyTransform() {
        RigidBodyTransform transformation = new RigidBodyTransform();
        transformation.setRotationYawAndZeroTranslation(2.3);
        Plane3D plane = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        plane.applyTransform((Transform)transformation);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)plane.getNormalCopy(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (double)1.0E-14);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)plane.getPointCopy(), (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.0), (double)1.0E-14);
        RigidBodyTransform transformation2 = new RigidBodyTransform();
        transformation2.setTranslation((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        Plane3D plane2 = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        plane2.applyTransform((Transform)transformation2);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)plane2.getNormalCopy(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (double)1.0E-14);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)plane2.getPointCopy(), (Tuple3DReadOnly)new Point3D(1.0, 2.0, 3.0), (double)1.0E-14);
        RigidBodyTransform transformation3 = new RigidBodyTransform();
        transformation3.setRotationPitchAndZeroTranslation(1.5707963267948966);
        transformation3.setTranslation((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
        Plane3D plane3 = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        plane3.applyTransform((Transform)transformation3);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)plane3.getNormalCopy(), (Tuple3DReadOnly)new Vector3D(1.0, 0.0, 0.0), (double)1.0E-14);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)plane3.getPointCopy(), (Tuple3DReadOnly)new Point3D(1.0, 2.0, 3.0), (double)1.0E-14);
        RigidBodyTransform transformation4 = new RigidBodyTransform();
        transformation4.setRotationPitchAndZeroTranslation(1.5707963267948966);
        transformation4.setTranslation((Tuple3DReadOnly)new Vector3D(1.0, 2.0, 3.0));
    }

    @Test
    public void testGeometricallyEquals() {
        Vector3D normal;
        int i;
        Random random = new Random(0x929BBBL);
        Vector3D translation = new Vector3D();
        double epsilon = 1.0E-5;
        Plane3D firstPlane = EuclidGeometryRandomTools.nextPlane3D((Random)random);
        Plane3D secondPlane = new Plane3D(firstPlane);
        Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
        Assertions.assertTrue((boolean)secondPlane.geometricallyEquals(firstPlane, epsilon));
        Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(firstPlane, epsilon));
        Assertions.assertTrue((boolean)secondPlane.geometricallyEquals(secondPlane, epsilon));
        for (i = 0; i < 1000; ++i) {
            firstPlane = EuclidGeometryRandomTools.nextPlane3D((Random)random);
            secondPlane = new Plane3D(firstPlane);
            normal = firstPlane.getNormalCopy();
            Vector3D rotationAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            double rotationAngle = 0.99 * epsilon;
            normal.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)rotationAxis, rotationAngle), (Tuple3DReadOnly)new Vector3D()));
            secondPlane.setNormal((Vector3DReadOnly)normal);
            Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
            normal = firstPlane.getNormalCopy();
            rotationAngle = 1.01 * epsilon;
            normal.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)rotationAxis, rotationAngle), (Tuple3DReadOnly)new Vector3D()));
            secondPlane.setNormal((Vector3DReadOnly)normal);
            Assertions.assertFalse((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            AxisAngle zeroRotation = new AxisAngle();
            firstPlane = EuclidGeometryRandomTools.nextPlane3D((Random)random);
            secondPlane = new Plane3D(firstPlane);
            translation.setAndScale(0.99 * epsilon, (Tuple3DReadOnly)firstPlane.getNormal());
            secondPlane.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)zeroRotation, (Tuple3DReadOnly)translation));
            Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
            secondPlane = new Plane3D(firstPlane);
            translation.setAndScale(1.01 * epsilon, (Tuple3DReadOnly)firstPlane.getNormal());
            secondPlane.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)zeroRotation, (Tuple3DReadOnly)translation));
            Assertions.assertFalse((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
            secondPlane = new Plane3D(firstPlane);
            translation.setAndScale(0.99 * epsilon, (Tuple3DReadOnly)firstPlane.getNormal());
            secondPlane.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)zeroRotation, (Tuple3DReadOnly)translation));
            Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
            secondPlane = new Plane3D(firstPlane);
            translation.setAndScale(-1.01 * epsilon, (Tuple3DReadOnly)firstPlane.getNormal());
            secondPlane.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)zeroRotation, (Tuple3DReadOnly)translation));
            Assertions.assertFalse((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstPlane = EuclidGeometryRandomTools.nextPlane3D((Random)random);
            secondPlane = new Plane3D(firstPlane);
            normal = secondPlane.getNormalCopy();
            normal.negate();
            secondPlane.setNormal((Vector3DReadOnly)normal);
            Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            firstPlane = EuclidGeometryRandomTools.nextPlane3D((Random)random);
            secondPlane = new Plane3D(firstPlane);
            translation = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstPlane.getNormal(), (boolean)true);
            translation.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon), (String)("Iteration: " + i));
            normal = secondPlane.getNormalCopy();
            normal.negate();
            secondPlane.setNormal((Vector3DReadOnly)normal);
            Assertions.assertTrue((boolean)firstPlane.geometricallyEquals(secondPlane, epsilon), (String)("Iteration: " + i));
        }
    }
}

