/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class LineSegment2DTest {
    private static final double EPSILON = 1.0E-11;

    @Test
    public void testDistancePoint2dLineSegment2d() {
        LineSegment2D line1 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        Point2D point1 = new Point2D(-10.0, 10.0);
        Point2D point2 = new Point2D(0.0, 10.0);
        Point2D point3 = new Point2D(0.0, -10.0);
        Point2D point4 = new Point2D(-10.0, 0.0);
        Point2D point5 = new Point2D(10.0, 0.0);
        Point2D point6 = new Point2D(10.5, 0.0);
        Point2D point7 = new Point2D(0.0, 1.2);
        Point2D point8 = new Point2D(10.1, 0.0);
        Point2D point9 = new Point2D(0.0, 0.0);
        double delta = 1.0E-5;
        Assertions.assertEquals((double)10.0, (double)line1.distance((Point2DReadOnly)point1), (double)delta);
        Assertions.assertEquals((double)10.0, (double)line1.distance((Point2DReadOnly)point2), (double)delta);
        Assertions.assertEquals((double)10.0, (double)line1.distance((Point2DReadOnly)point3), (double)delta);
        Assertions.assertEquals((double)0.0, (double)line1.distance((Point2DReadOnly)point4), (double)delta);
        Assertions.assertEquals((double)0.0, (double)line1.distance((Point2DReadOnly)point5), (double)delta);
        Assertions.assertEquals((double)0.5, (double)line1.distance((Point2DReadOnly)point6), (double)delta);
        Assertions.assertEquals((double)1.2, (double)line1.distance((Point2DReadOnly)point7), (double)delta);
        Assertions.assertEquals((double)0.1, (double)line1.distance((Point2DReadOnly)point8), (double)delta);
        Assertions.assertEquals((double)0.0, (double)line1.distance((Point2DReadOnly)point9), (double)delta);
    }

    @Test
    public void testLineSegment2dDoubleDoubleDoubleDouble() {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            double x1 = random.nextDouble() * 500.0 - 250.0;
            double y1 = random.nextDouble() * 500.0 - 250.0;
            double x2 = random.nextDouble() * 500.0 - 250.0;
            double y2 = random.nextDouble() * 500.0 - 250.0;
            if (x1 == x2 && y1 == y2) continue;
            LineSegment2D test = new LineSegment2D(x1, y1, x2, y2);
            Assertions.assertEquals((double)test.getFirstEndpoint().getX(), (double)x1, (double)0.001);
            Assertions.assertEquals((double)test.getFirstEndpoint().getY(), (double)y1, (double)0.001);
            Assertions.assertEquals((double)test.getSecondEndpoint().getX(), (double)x2, (double)0.001);
            Assertions.assertEquals((double)test.getSecondEndpoint().getY(), (double)y2, (double)0.001);
        }
    }

    @Test
    public void testLineSegment2dPoint2dPoint2d() {
        Random random = new Random(45089L);
        for (int i = 0; i < 1000; ++i) {
            double x1 = random.nextDouble() * 500.0 - 250.0;
            double y1 = random.nextDouble() * 500.0 - 250.0;
            double x2 = random.nextDouble() * 500.0 - 250.0;
            double y2 = random.nextDouble() * 500.0 - 250.0;
            if (x1 == x2 && y1 == y2) continue;
            Point2D[] points = new Point2D[]{new Point2D(x1, y1), new Point2D(x2, y2)};
            LineSegment2D test = new LineSegment2D((Point2DReadOnly)points[0], (Point2DReadOnly)points[1]);
            Assertions.assertEquals((Object)test.getFirstEndpoint(), (Object)points[0]);
            Assertions.assertEquals((Object)test.getSecondEndpoint(), (Object)points[1]);
        }
    }

    @Test
    public void testLineSegment2dLineSegment2d() {
        Random random = new Random(97L);
        for (int i = 0; i < 1000; ++i) {
            double x1 = random.nextDouble() * 500.0 - 250.0;
            double y1 = random.nextDouble() * 500.0 - 250.0;
            double x2 = random.nextDouble() * 500.0 - 250.0;
            double y2 = random.nextDouble() * 500.0 - 250.0;
            if (x1 == x2 && y1 == y2) continue;
            Point2D[] points = new Point2D[]{new Point2D(x1, y1), new Point2D(x2, y2)};
            LineSegment2D test = new LineSegment2D((Point2DReadOnly)points[0], (Point2DReadOnly)points[1]);
            LineSegment2D test2 = new LineSegment2D(test);
            Assertions.assertEquals((Object)test.getFirstEndpoint(), (Object)test2.getFirstEndpoint());
            Assertions.assertEquals((Object)test.getSecondEndpoint(), (Object)test2.getSecondEndpoint());
        }
    }

    @Test
    public void testSetPoint2dPoint2d() {
        Random random = new Random(3453L);
        LineSegment2D testSegment1 = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
        Point2D[] pointsCopy = new Point2D[]{new Point2D((Tuple2DReadOnly)testSegment1.getFirstEndpoint()), new Point2D((Tuple2DReadOnly)testSegment1.getSecondEndpoint())};
        pointsCopy[0].set(pointsCopy[0].getX() - 10.0, pointsCopy[0].getY() - 10.0);
        pointsCopy[1].set(pointsCopy[1].getX() - 10.0, pointsCopy[1].getY() - 10.0);
        testSegment1.set((Point2DReadOnly)pointsCopy[0], (Point2DReadOnly)pointsCopy[1]);
        Assertions.assertEquals((Object)pointsCopy[0], (Object)testSegment1.getFirstEndpoint());
        Assertions.assertEquals((Object)pointsCopy[1], (Object)testSegment1.getSecondEndpoint());
    }

    @Test
    public void testSetDoubleDoubleDoubleDouble() {
        Random random = new Random(3453L);
        LineSegment2D testSegment1 = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
        Point2D[] pointsCopy = new Point2D[]{new Point2D((Tuple2DReadOnly)testSegment1.getFirstEndpoint()), new Point2D((Tuple2DReadOnly)testSegment1.getSecondEndpoint())};
        pointsCopy[0].set(pointsCopy[0].getX() - 10.0, pointsCopy[0].getY() - 10.0);
        pointsCopy[1].set(pointsCopy[1].getX() - 10.0, pointsCopy[1].getY() - 10.0);
        testSegment1.set(pointsCopy[0].getX(), pointsCopy[0].getY(), pointsCopy[1].getX(), pointsCopy[1].getY());
        Assertions.assertEquals((Object)pointsCopy[0], (Object)testSegment1.getFirstEndpoint());
        Assertions.assertEquals((Object)pointsCopy[1], (Object)testSegment1.getSecondEndpoint());
    }

    @Test
    public void testSetLineSegment2d() {
        Random random = new Random(3453L);
        LineSegment2D testSegment1 = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
        LineSegment2D testSegment2 = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
        testSegment1.set(testSegment2);
        Assertions.assertEquals((Object)testSegment2.getFirstEndpoint(), (Object)testSegment1.getFirstEndpoint());
        Assertions.assertEquals((Object)testSegment2.getSecondEndpoint(), (Object)testSegment1.getSecondEndpoint());
    }

    @Test
    public void testFlipDirection() {
        Random random = new Random(3453L);
        Point2D segment1Point1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D segment1Point2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        LineSegment2D testSegment1 = new LineSegment2D((Point2DReadOnly)segment1Point1, (Point2DReadOnly)segment1Point2);
        testSegment1.flipDirection();
        Assertions.assertEquals((Object)segment1Point2, (Object)testSegment1.getFirstEndpoint());
        Assertions.assertEquals((Object)segment1Point1, (Object)testSegment1.getSecondEndpoint());
    }

    @Test
    public void testMidpoint() {
        Random random = new Random(3453L);
        LineSegment2D testSegment1 = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
        Point2DBasics midPoint = testSegment1.midpoint();
        Assertions.assertEquals((double)midPoint.distance((Point2DReadOnly)testSegment1.getFirstEndpoint()), (double)midPoint.distance((Point2DReadOnly)testSegment1.getSecondEndpoint()), (double)0.001);
    }

    @Test
    public void testLength() {
        Random random = new Random(3453L);
        Point2D segment1Point1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D segment1Point2 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        LineSegment2D testSegment1 = new LineSegment2D((Point2DReadOnly)segment1Point1, (Point2DReadOnly)segment1Point2);
        Assertions.assertEquals((double)segment1Point1.distance((Point2DReadOnly)segment1Point2), (double)testSegment1.length(), (double)0.001);
        testSegment1.flipDirection();
        Assertions.assertEquals((double)segment1Point1.distance((Point2DReadOnly)segment1Point2), (double)testSegment1.length(), (double)0.001);
    }

    @Test
    public void testTranslate() throws Exception {
        LineSegment2D translatedLineSegment;
        LineSegment2D originalLineSegment;
        int i;
        Random random = new Random(3653L);
        for (i = 0; i < 1000; ++i) {
            originalLineSegment = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
            translatedLineSegment = new LineSegment2D(originalLineSegment);
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            translatedLineSegment.translate(x, y);
            Assertions.assertEquals((double)originalLineSegment.length(), (double)translatedLineSegment.length(), (double)1.0E-11);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)originalLineSegment.direction(false), (Tuple2DReadOnly)translatedLineSegment.direction(false), (double)1.0E-11);
            LineSegment2D expectedLineSegment = new LineSegment2D(originalLineSegment);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.setTranslation(x, y, 0.0);
            expectedLineSegment.applyTransform((Transform)transform);
            EuclidGeometryTestTools.assertLineSegment2DEquals((LineSegment2DReadOnly)expectedLineSegment, (LineSegment2DReadOnly)translatedLineSegment, (double)1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            originalLineSegment = EuclidGeometryRandomTools.nextLineSegment2D((Random)random, (double)10.0);
            translatedLineSegment = new LineSegment2D(originalLineSegment);
            Point2D translation = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            translatedLineSegment.translate((Tuple2DReadOnly)translation);
            Assertions.assertEquals((double)originalLineSegment.length(), (double)translatedLineSegment.length(), (double)1.0E-11);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)originalLineSegment.direction(false), (Tuple2DReadOnly)translatedLineSegment.direction(false), (double)1.0E-11);
            LineSegment2D expectedLineSegment = new LineSegment2D(originalLineSegment);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.setTranslation(translation.getX(), translation.getY(), 0.0);
            expectedLineSegment.applyTransform((Transform)transform);
            EuclidGeometryTestTools.assertLineSegment2DEquals((LineSegment2DReadOnly)expectedLineSegment, (LineSegment2DReadOnly)translatedLineSegment, (double)1.0E-11);
        }
    }

    @Test
    public void testPercentageAlongLineSegment() {
        LineSegment2D lineSegment;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        int i;
        LineSegment2D line1 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        Assertions.assertEquals((double)0.5, (double)line1.percentageAlongLineSegment((Point2DReadOnly)new Point2D(0.0, 0.0)), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)line1.percentageAlongLineSegment((Point2DReadOnly)new Point2D(-10.0, 0.0)), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)line1.percentageAlongLineSegment((Point2DReadOnly)new Point2D(10.0, 0.0)), (double)0.001);
        Assertions.assertEquals((double)0.5, (double)line1.percentageAlongLineSegment((Point2DReadOnly)new Point2D(0.0, 5.0)), (double)0.001);
        Random random = new Random(23424L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Point2D pointOnLineSegment = new Point2D();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            double actualPercentage = lineSegment.percentageAlongLineSegment((Point2DReadOnly)pointOnLineSegment);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            pointOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            actualPercentage = lineSegment.percentageAlongLineSegment((Point2DReadOnly)pointOnLineSegment);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            pointOnLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            actualPercentage = lineSegment.percentageAlongLineSegment((Point2DReadOnly)pointOnLineSegment);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Point2D pointOffLineSegment = new Point2D();
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            Vector2D orthogonal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineSegmentDirection);
            orthogonal.normalize();
            double expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOffLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOffLineSegment);
            double actualPercentage = lineSegment.percentageAlongLineSegment((Point2DReadOnly)pointOffLineSegment);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            pointOffLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOffLineSegment);
            actualPercentage = lineSegment.percentageAlongLineSegment((Point2DReadOnly)pointOffLineSegment);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
            expectedPercentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            pointOffLineSegment.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, expectedPercentage);
            pointOffLineSegment.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOffLineSegment);
            actualPercentage = lineSegment.percentageAlongLineSegment((Point2DReadOnly)pointOffLineSegment);
            Assertions.assertEquals((double)expectedPercentage, (double)actualPercentage, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionWithLineSegment2d1() {
        LineSegment2D line1 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        LineSegment2D line2 = new LineSegment2D(-10.0, 10.0, 10.0, 0.0);
        LineSegment2D line3 = new LineSegment2D(0.0, 10.0, 0.0, -10.0);
        LineSegment2D line4 = new LineSegment2D(0.0, -10.0, 0.0, 10.0);
        LineSegment2D line5 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        LineSegment2D line6 = new LineSegment2D(10.0, 0.0, -10.0, 0.0);
        LineSegment2D line7 = new LineSegment2D(10.0, 0.0, 20.0, 0.0);
        LineSegment2D line8 = new LineSegment2D(10.0, 0.0, -20.0, 0.0);
        LineSegment2D line9 = new LineSegment2D(10.1, 0.0, 20.0, 0.0);
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line1));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line5));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line6));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line2));
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line3));
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line4));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line7));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line8));
        Assertions.assertEquals(null, (Object)line1.intersectionWith((LineSegment2DReadOnly)line9));
    }

    @Test
    public void testIntersectionWithLineSegment2d2() {
        Point2D lineSegmentEnd2;
        Point2D lineSegmentStart2;
        Vector2D lineDirection2;
        Point2D expectedIntersection;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        int i;
        Random random = new Random(3242L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            expectedIntersection = new Point2D();
            expectedIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfIntersectionWith(expectedIntersection, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionAllCombinations(false, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            expectedIntersection = new Point2D((Tuple2DReadOnly)lineSegmentStart1);
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfIntersectionWith(expectedIntersection, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            Point2D lineSegmentStart22 = new Point2D();
            Point2D lineSegmentEnd22 = new Point2D();
            double alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart22.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha1);
            lineSegmentEnd22.interpolate((Tuple2DReadOnly)lineSegmentStart1, (Tuple2DReadOnly)lineSegmentEnd1, alpha2);
            if (0.0 < alpha1 && alpha1 < 1.0 || 0.0 < alpha2 && alpha2 < 1.0 || alpha1 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionAllCombinations(true, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart22, lineSegmentEnd22);
            } else {
                this.assertOnlyExistenceOfIntersectionAllCombinations(false, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart22, lineSegmentEnd22);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            double distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart22.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart22);
            lineSegmentEnd22.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd22);
            this.assertOnlyExistenceOfIntersectionAllCombinations(false, lineSegmentStart1, lineSegmentEnd1, lineSegmentStart22, lineSegmentEnd22);
        }
    }

    private void assertOnlyExistenceOfIntersectionAllCombinations(boolean intersectionExist, Point2D lineSegmentStart1, Point2D lineSegmentEnd1, Point2D lineSegmentStart2, Point2D lineSegmentEnd2) {
        LineSegment2D lineSegment1 = new LineSegment2D((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1);
        LineSegment2D reverseLineSegment1 = new LineSegment2D((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1);
        LineSegment2D lineSegment2 = new LineSegment2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
        LineSegment2D reverseLineSegment2 = new LineSegment2D((Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
        if (intersectionExist) {
            Assertions.assertNotNull((Object)lineSegment1.intersectionWith((LineSegment2DReadOnly)lineSegment2));
            Assertions.assertNotNull((Object)lineSegment1.intersectionWith((LineSegment2DReadOnly)reverseLineSegment2));
            Assertions.assertNotNull((Object)reverseLineSegment1.intersectionWith((LineSegment2DReadOnly)lineSegment2));
            Assertions.assertNotNull((Object)reverseLineSegment1.intersectionWith((LineSegment2DReadOnly)reverseLineSegment2));
            Assertions.assertNotNull((Object)lineSegment2.intersectionWith((LineSegment2DReadOnly)lineSegment1));
            Assertions.assertNotNull((Object)lineSegment2.intersectionWith((LineSegment2DReadOnly)reverseLineSegment1));
            Assertions.assertNotNull((Object)reverseLineSegment2.intersectionWith((LineSegment2DReadOnly)lineSegment1));
            Assertions.assertNotNull((Object)reverseLineSegment2.intersectionWith((LineSegment2DReadOnly)reverseLineSegment1));
        } else {
            Assertions.assertNull((Object)lineSegment1.intersectionWith((LineSegment2DReadOnly)lineSegment2));
            Assertions.assertNull((Object)lineSegment1.intersectionWith((LineSegment2DReadOnly)reverseLineSegment2));
            Assertions.assertNull((Object)reverseLineSegment1.intersectionWith((LineSegment2DReadOnly)lineSegment2));
            Assertions.assertNull((Object)reverseLineSegment1.intersectionWith((LineSegment2DReadOnly)reverseLineSegment2));
            Assertions.assertNull((Object)lineSegment2.intersectionWith((LineSegment2DReadOnly)lineSegment1));
            Assertions.assertNull((Object)lineSegment2.intersectionWith((LineSegment2DReadOnly)reverseLineSegment1));
            Assertions.assertNull((Object)reverseLineSegment2.intersectionWith((LineSegment2DReadOnly)lineSegment1));
            Assertions.assertNull((Object)reverseLineSegment2.intersectionWith((LineSegment2DReadOnly)reverseLineSegment1));
        }
    }

    private void assertAllCombinationsOfIntersectionWith(Point2D expectedIntersection, Point2D lineSegmentStart1, Point2D lineSegmentEnd1, Point2D lineSegmentStart2, Point2D lineSegmentEnd2) {
        LineSegment2D lineSegment1 = new LineSegment2D((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1);
        LineSegment2D reverseLineSegment1 = new LineSegment2D((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1);
        LineSegment2D lineSegment2 = new LineSegment2D((Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
        LineSegment2D reverseLineSegment2 = new LineSegment2D((Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)lineSegment1.intersectionWith((LineSegment2DReadOnly)lineSegment2), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)lineSegment1.intersectionWith((LineSegment2DReadOnly)reverseLineSegment2), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)reverseLineSegment1.intersectionWith((LineSegment2DReadOnly)lineSegment2), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)reverseLineSegment1.intersectionWith((LineSegment2DReadOnly)reverseLineSegment2), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)lineSegment2.intersectionWith((LineSegment2DReadOnly)lineSegment1), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)lineSegment2.intersectionWith((LineSegment2DReadOnly)reverseLineSegment1), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)reverseLineSegment2.intersectionWith((LineSegment2DReadOnly)lineSegment1), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)reverseLineSegment2.intersectionWith((LineSegment2DReadOnly)reverseLineSegment1), (double)1.0E-11);
    }

    @Test
    public void testIntersectionWithLine2d2() {
        Point2DBasics actualIntersection;
        Vector2D lineDirection;
        Point2D pointOnLine;
        Point2DBasics actualIntersection2;
        LineSegment2D reverseLineSegment;
        LineSegment2D lineSegment;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        int i;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            reverseLineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            Point2D expectedIntersection = new Point2D();
            expectedIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D pointOnLine2 = new Point2D((Tuple2DReadOnly)expectedIntersection);
            Vector2D lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            actualIntersection2 = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
            actualIntersection2 = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)expectedIntersection);
            actualIntersection2 = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
            actualIntersection2 = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            reverseLineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            pointOnLine = new Point2D();
            lineDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineLineIntersection = new Point2D();
            lineLineIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0));
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)lineLineIntersection);
            actualIntersection2 = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            Assertions.assertNull((Object)actualIntersection2);
            actualIntersection2 = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            Assertions.assertNull((Object)actualIntersection2);
            lineLineIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0, (double)0.0));
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)lineLineIntersection);
            actualIntersection2 = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            Assertions.assertNull((Object)actualIntersection2);
            actualIntersection2 = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            Assertions.assertNull((Object)actualIntersection2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            reverseLineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            pointOnLine = new Point2D();
            lineDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D expectedIntersection = new Point2D();
            expectedIntersection.set(lineSegmentStart);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)expectedIntersection);
            actualIntersection2 = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
            actualIntersection2 = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
            expectedIntersection.set(lineSegmentEnd);
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)expectedIntersection);
            actualIntersection2 = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
            actualIntersection2 = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection2, (double)1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Point2D pointOnLine3 = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            Vector2D lineDirection3 = new Vector2D();
            lineDirection3.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineDirection3.normalize();
            if (random.nextBoolean()) {
                lineDirection3.negate();
            }
            Vector2D orthogonal = new Vector2D(-lineDirection3.getY(), lineDirection3.getY());
            pointOnLine3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnLine3);
            pointOnLine3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection3, (Tuple2DReadOnly)pointOnLine3);
            actualIntersection = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine3, (Vector2DReadOnly)lineDirection3));
            Assertions.assertNull((Object)actualIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            reverseLineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
            pointOnLine = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            lineDirection = new Vector2D();
            lineDirection.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            lineDirection.normalize();
            if (random.nextBoolean()) {
                lineDirection.negate();
            }
            pointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            actualIntersection = lineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)actualIntersection, (double)1.0E-11);
            actualIntersection = reverseLineSegment.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)actualIntersection, (double)1.0E-11);
        }
    }

    @Test
    public void testDistancePoint2d() {
        LineSegment2D line1 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        Point2D point1 = new Point2D(-10.0, 10.0);
        Point2D point2 = new Point2D(0.0, 10.0);
        Point2D point3 = new Point2D(0.0, -10.0);
        Point2D point4 = new Point2D(-10.0, 0.0);
        Point2D point5 = new Point2D(10.0, 0.0);
        Point2D point6 = new Point2D(10.5, 0.0);
        Point2D point7 = new Point2D(0.0, 1.2);
        Point2D point8 = new Point2D(10.1, 0.0);
        Point2D point9 = new Point2D(0.0, 0.0);
        double delta = 1.0E-5;
        Assertions.assertEquals((double)10.0, (double)line1.distance((Point2DReadOnly)point1), (double)delta);
        Assertions.assertEquals((double)10.0, (double)line1.distance((Point2DReadOnly)point2), (double)delta);
        Assertions.assertEquals((double)10.0, (double)line1.distance((Point2DReadOnly)point3), (double)delta);
        Assertions.assertEquals((double)0.0, (double)line1.distance((Point2DReadOnly)point4), (double)delta);
        Assertions.assertEquals((double)0.0, (double)line1.distance((Point2DReadOnly)point5), (double)delta);
        Assertions.assertEquals((double)0.5, (double)line1.distance((Point2DReadOnly)point6), (double)delta);
        Assertions.assertEquals((double)1.2, (double)line1.distance((Point2DReadOnly)point7), (double)delta);
        Assertions.assertEquals((double)0.1, (double)line1.distance((Point2DReadOnly)point8), (double)delta);
        Assertions.assertEquals((double)0.0, (double)line1.distance((Point2DReadOnly)point9), (double)delta);
    }

    @Test
    public void testShiftToLeftAndRight() {
        double distanceToShift = 0.2;
        LineSegment2D lineSegment = new LineSegment2D(0.0, 0.0, 0.0, 1.0);
        LineSegment2D shiftedLineSegment = new LineSegment2D(lineSegment);
        shiftedLineSegment.shiftToRight(distanceToShift);
        Point2D firstShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getFirstEndpoint());
        Point2D secondShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getSecondEndpoint());
        Assertions.assertEquals((double)distanceToShift, (double)firstShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)0.0, (double)firstShiftedEndpoint.getY(), (double)1.0E-11);
        Assertions.assertEquals((double)distanceToShift, (double)secondShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)1.0, (double)secondShiftedEndpoint.getY(), (double)1.0E-11);
        shiftedLineSegment.set(lineSegment);
        shiftedLineSegment.shiftToLeft(distanceToShift);
        firstShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getFirstEndpoint());
        secondShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getSecondEndpoint());
        Assertions.assertEquals((double)(-distanceToShift), (double)firstShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)0.0, (double)firstShiftedEndpoint.getY(), (double)1.0E-11);
        Assertions.assertEquals((double)(-distanceToShift), (double)secondShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)1.0, (double)secondShiftedEndpoint.getY(), (double)1.0E-11);
        lineSegment = new LineSegment2D(0.0, 0.0, 1.0, 0.0);
        shiftedLineSegment.set(lineSegment);
        shiftedLineSegment.shiftToRight(distanceToShift);
        firstShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getFirstEndpoint());
        secondShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getSecondEndpoint());
        Assertions.assertEquals((double)0.0, (double)firstShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)(-distanceToShift), (double)firstShiftedEndpoint.getY(), (double)1.0E-11);
        Assertions.assertEquals((double)1.0, (double)secondShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)(-distanceToShift), (double)secondShiftedEndpoint.getY(), (double)1.0E-11);
        shiftedLineSegment.set(lineSegment);
        shiftedLineSegment.shiftToLeft(distanceToShift);
        firstShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getFirstEndpoint());
        secondShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getSecondEndpoint());
        Assertions.assertEquals((double)0.0, (double)firstShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)distanceToShift, (double)firstShiftedEndpoint.getY(), (double)1.0E-11);
        Assertions.assertEquals((double)1.0, (double)secondShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)distanceToShift, (double)secondShiftedEndpoint.getY(), (double)1.0E-11);
        lineSegment = new LineSegment2D(0.0, 0.0, 1.0, 1.0);
        shiftedLineSegment.set(lineSegment);
        shiftedLineSegment.shiftToRight(distanceToShift);
        double distanceAtFortyFiveDegrees = distanceToShift * EuclidCoreTools.squareRoot((double)2.0) / 2.0;
        firstShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getFirstEndpoint());
        secondShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getSecondEndpoint());
        Assertions.assertEquals((double)distanceAtFortyFiveDegrees, (double)firstShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)(-distanceAtFortyFiveDegrees), (double)firstShiftedEndpoint.getY(), (double)1.0E-11);
        Assertions.assertEquals((double)(1.0 + distanceAtFortyFiveDegrees), (double)secondShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)(1.0 - distanceAtFortyFiveDegrees), (double)secondShiftedEndpoint.getY(), (double)1.0E-11);
        shiftedLineSegment.set(lineSegment);
        shiftedLineSegment.shiftToLeft(distanceToShift);
        firstShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getFirstEndpoint());
        secondShiftedEndpoint = new Point2D((Tuple2DReadOnly)shiftedLineSegment.getSecondEndpoint());
        Assertions.assertEquals((double)(-distanceAtFortyFiveDegrees), (double)firstShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)distanceAtFortyFiveDegrees, (double)firstShiftedEndpoint.getY(), (double)1.0E-11);
        Assertions.assertEquals((double)(1.0 - distanceAtFortyFiveDegrees), (double)secondShiftedEndpoint.getX(), (double)1.0E-11);
        Assertions.assertEquals((double)(1.0 + distanceAtFortyFiveDegrees), (double)secondShiftedEndpoint.getY(), (double)1.0E-11);
    }

    @Test
    public void testIsPointOnLeftRightSide() {
        LineSegment2D lineSegment = new LineSegment2D(0.0, 0.0, 0.0, 1.0);
        Point2D point = new Point2D(0.1, 0.5);
        Assertions.assertFalse((boolean)lineSegment.isPointOnLeftSideOfLineSegment((Point2DReadOnly)point));
        Assertions.assertTrue((boolean)lineSegment.isPointOnRightSideOfLineSegment((Point2DReadOnly)point));
        point = new Point2D(-0.1, 0.5);
        Assertions.assertTrue((boolean)lineSegment.isPointOnLeftSideOfLineSegment((Point2DReadOnly)point));
        Assertions.assertFalse((boolean)lineSegment.isPointOnRightSideOfLineSegment((Point2DReadOnly)point));
        lineSegment = new LineSegment2D(0.0, 2.0, 4.0, 6.0);
        point = new Point2D(0.0, 0.0);
        Assertions.assertTrue((boolean)lineSegment.isPointOnRightSideOfLineSegment((Point2DReadOnly)point));
        point = new Point2D(4.1, 6.0);
        Assertions.assertTrue((boolean)lineSegment.isPointOnRightSideOfLineSegment((Point2DReadOnly)point));
        point = new Point2D(3.9, 6.0);
        Assertions.assertTrue((boolean)lineSegment.isPointOnLeftSideOfLineSegment((Point2DReadOnly)point));
    }

    @Test
    public void testOrthogonalProjectionCopyPoint2dLineSegment2d() {
        Point2D startPoint = new Point2D(-10.0, 0.0);
        Point2D endPoint = new Point2D(10.0, 0.0);
        LineSegment2D line1 = new LineSegment2D((Point2DReadOnly)startPoint, (Point2DReadOnly)endPoint);
        Point2D origionalPoint = new Point2D(-20.0, 10.0);
        Point2DBasics projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)startPoint, (Object)projectedPoint);
        origionalPoint = new Point2D(-20.0, -10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)startPoint, (Object)projectedPoint);
        origionalPoint = new Point2D(-20.0, 0.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)startPoint, (Object)projectedPoint);
        origionalPoint = new Point2D(20.0, 10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)endPoint, (Object)projectedPoint);
        origionalPoint = new Point2D(20.0, -10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)endPoint, (Object)projectedPoint);
        origionalPoint = new Point2D(20.0, 0.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)endPoint, (Object)projectedPoint);
        origionalPoint = new Point2D(0.0, 10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(0.0, -10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(5.0, 0.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(5.0, 0.0), (Object)projectedPoint);
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            LineSegment2D lineSegment = new LineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
            EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)orthogonal, (Vector2DBasics)orthogonal);
            orthogonal.normalize();
            Point2D expectedProjection = new Point2D();
            Point2D testPoint = new Point2D();
            expectedProjection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)expectedProjection);
            Point2DBasics actualProjection = lineSegment.orthogonalProjectionCopy((Point2DReadOnly)testPoint);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedProjection, (Tuple2DReadOnly)actualProjection, (double)1.0E-12);
            expectedProjection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)expectedProjection);
            expectedProjection.set(lineSegmentStart);
            actualProjection = lineSegment.orthogonalProjectionCopy((Point2DReadOnly)testPoint);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedProjection, (Tuple2DReadOnly)actualProjection, (double)1.0E-12);
            expectedProjection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
            testPoint.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)expectedProjection);
            expectedProjection.set(lineSegmentEnd);
            actualProjection = lineSegment.orthogonalProjectionCopy((Point2DReadOnly)testPoint);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedProjection, (Tuple2DReadOnly)actualProjection, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionLine2dLineSegment2d() {
        LineSegment2D line1 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(-10.0, 10.0), (Point2DReadOnly)new Point2D(10.0, 0.0));
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(0.0, 10.0), (Point2DReadOnly)new Point2D(0.0, -10.0));
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(0.0, -10.0), (Point2DReadOnly)new Point2D(0.0, 10.0));
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(-10.0, 0.0), (Point2DReadOnly)new Point2D(10.0, 0.0));
        Line2D line6 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(-10.0, 0.0));
        Line2D line7 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(20.0, 0.0));
        Line2D line8 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(-20.0, 0.0));
        Line2D line9 = new Line2D((Point2DReadOnly)new Point2D(10.1, 0.0), (Point2DReadOnly)new Point2D(20.0, 0.0));
        Line2D line10 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(20.0, 1.0));
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line5), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line6), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line2), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line10), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line3), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line4), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line7), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line8), (double)1.0E-11);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-10.0, 0.0), (Tuple2DReadOnly)line1.intersectionWith((Line2DReadOnly)line9), (double)1.0E-11);
    }

    @Test
    public void testIntersectionLineSegment2dLineSegment2d() {
        Point2D colTestp1 = new Point2D(1.5, -5.0);
        Point2D colTestp2 = new Point2D(1.5, 0.0);
        Point2D colTestp3 = new Point2D(1.5, 5.0);
        LineSegment2D colTestLine1 = new LineSegment2D((Point2DReadOnly)colTestp1, (Point2DReadOnly)colTestp2);
        LineSegment2D colTestLine2 = new LineSegment2D((Point2DReadOnly)colTestp2, (Point2DReadOnly)colTestp1);
        LineSegment2D colTestLine3 = new LineSegment2D((Point2DReadOnly)colTestp1, (Point2DReadOnly)colTestp3);
        LineSegment2D colTestLine4 = new LineSegment2D((Point2DReadOnly)colTestp3, (Point2DReadOnly)colTestp1);
        LineSegment2D colTestLine5 = new LineSegment2D((Point2DReadOnly)colTestp2, (Point2DReadOnly)colTestp3);
        LineSegment2D colTestLine6 = new LineSegment2D((Point2DReadOnly)colTestp3, (Point2DReadOnly)colTestp2);
        Assertions.assertEquals((Object)colTestp2, (Object)colTestLine1.intersectionWith((LineSegment2DReadOnly)colTestLine2));
        Assertions.assertEquals((Object)colTestp1, (Object)colTestLine1.intersectionWith((LineSegment2DReadOnly)colTestLine3));
        Assertions.assertEquals((Object)colTestp1, (Object)colTestLine1.intersectionWith((LineSegment2DReadOnly)colTestLine4));
        Assertions.assertEquals((Object)colTestp1, (Object)colTestLine2.intersectionWith((LineSegment2DReadOnly)colTestLine4));
        Assertions.assertEquals((Object)colTestp2, (Object)colTestLine1.intersectionWith((LineSegment2DReadOnly)colTestLine5));
        Assertions.assertEquals((Object)colTestp2, (Object)colTestLine2.intersectionWith((LineSegment2DReadOnly)colTestLine6));
        LineSegment2D line1 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        LineSegment2D line2 = new LineSegment2D(-10.0, 10.0, 10.0, 0.0);
        LineSegment2D line3 = new LineSegment2D(0.0, 10.0, 0.0, -10.0);
        LineSegment2D line4 = new LineSegment2D(0.0, -10.0, 0.0, 10.0);
        LineSegment2D line5 = new LineSegment2D(-10.0, 0.0, 10.0, 0.0);
        LineSegment2D line6 = new LineSegment2D(10.0, 0.0, -10.0, 0.0);
        LineSegment2D line7 = new LineSegment2D(10.0, 0.0, 20.0, 0.0);
        LineSegment2D line8 = new LineSegment2D(10.0, 0.0, -20.0, 0.0);
        LineSegment2D line9 = new LineSegment2D(10.1, 0.0, 20.0, 0.0);
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line5.intersectionWith((LineSegment2DReadOnly)line1));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line5));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line6));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line2));
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line3));
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line4));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line7));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((LineSegment2DReadOnly)line8));
        Assertions.assertEquals(null, (Object)line1.intersectionWith((LineSegment2DReadOnly)line9));
    }

    @Test
    public void testGeometricallyEquals() {
        Random random = new Random(19263L);
        Point2D segment1Point1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D segment1Point2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D segment2Point1 = new Point2D((Tuple2DReadOnly)segment1Point1);
        Point2D segment2Point2 = new Point2D((Tuple2DReadOnly)segment1Point2);
        LineSegment2D lineSegment1 = new LineSegment2D((Point2DReadOnly)segment1Point1, (Point2DReadOnly)segment1Point2);
        LineSegment2D lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point1, (Point2DReadOnly)segment2Point2);
        Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment1, 1.0E-11));
        Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
        Assertions.assertTrue((boolean)lineSegment2.geometricallyEquals(lineSegment1, 1.0E-11));
        Assertions.assertTrue((boolean)lineSegment2.geometricallyEquals(lineSegment2, 1.0E-11));
        for (int i = 0; i < 1000; ++i) {
            segment1Point1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            segment1Point2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            segment2Point1 = new Point2D();
            segment2Point2 = new Point2D();
            lineSegment1 = new LineSegment2D((Point2DReadOnly)segment1Point1, (Point2DReadOnly)segment1Point2);
            segment2Point1.set(segment1Point1);
            segment2Point2.add((Tuple2DReadOnly)segment1Point2, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.9E-12));
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point1, (Point2DReadOnly)segment2Point2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point2, (Point2DReadOnly)segment2Point1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            segment2Point1.set(segment1Point1);
            segment2Point2.add((Tuple2DReadOnly)segment1Point2, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.01E-11));
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point1, (Point2DReadOnly)segment2Point2);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point2, (Point2DReadOnly)segment2Point1);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            segment2Point1.add((Tuple2DReadOnly)segment1Point1, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.9E-12));
            segment2Point2.set(segment1Point2);
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point1, (Point2DReadOnly)segment2Point2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point2, (Point2DReadOnly)segment2Point1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            segment2Point1.add((Tuple2DReadOnly)segment1Point1, (Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.01E-11));
            segment2Point2.set(segment1Point2);
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point1, (Point2DReadOnly)segment2Point2);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2 = new LineSegment2D((Point2DReadOnly)segment2Point2, (Point2DReadOnly)segment2Point1);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2.set(lineSegment1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2.translate((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.9E-12));
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2.flipDirection();
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2.set(lineSegment1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2.translate((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.01E-11));
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
            lineSegment2.flipDirection();
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals(lineSegment2, 1.0E-11));
        }
    }
}

