/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface Shape3DReadOnly
extends SupportingVertexHolder,
EuclidGeometry {
    public Point3DReadOnly getCentroid();

    public double getVolume();

    public boolean containsNaN();

    public boolean evaluatePoint3DCollision(Point3DReadOnly var1, Point3DBasics var2, Vector3DBasics var3);

    default public double distance(Point3DReadOnly point) {
        return Math.max(0.0, this.signedDistance(point));
    }

    public double signedDistance(Point3DReadOnly var1);

    default public boolean isPointInside(Point3DReadOnly query) {
        return this.isPointInside(query, 0.0);
    }

    public boolean isPointInside(Point3DReadOnly var1, double var2);

    default public Point3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        Point3D projection = new Point3D();
        if (this.orthogonalProjection(pointToProject, (Point3DBasics)projection)) {
            return projection;
        }
        return null;
    }

    default public boolean orthogonalProjection(Point3DBasics pointToProject) {
        return this.orthogonalProjection((Point3DReadOnly)pointToProject, pointToProject);
    }

    public boolean orthogonalProjection(Point3DReadOnly var1, Point3DBasics var2);

    default public BoundingBox3DReadOnly getBoundingBox() {
        BoundingBox3D boundingBox3D = new BoundingBox3D();
        this.getBoundingBox((BoundingBox3DBasics)boundingBox3D);
        return boundingBox3D;
    }

    public void getBoundingBox(BoundingBox3DBasics var1);

    public boolean isConvex();

    public boolean isPrimitive();

    public boolean isDefinedByPose();

    public Shape3DPoseReadOnly getPose();

    public Shape3DBasics copy();
}

