/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.interfaces;

import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public interface HalfEdge3DReadOnly
extends LineSegment3DReadOnly {
    public Vertex3DReadOnly getOrigin();

    public Vertex3DReadOnly getDestination();

    default public Point3DReadOnly getFirstEndpoint() {
        return this.getOrigin();
    }

    default public Point3DReadOnly getSecondEndpoint() {
        return this.getDestination();
    }

    public HalfEdge3DReadOnly getTwin();

    public HalfEdge3DReadOnly getNext();

    public HalfEdge3DReadOnly getPrevious();

    public Face3DReadOnly getFace();

    default public double distanceFromSupportLine(Point3DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)point, (Point3DReadOnly)this.getOrigin(), (Point3DReadOnly)this.getDestination());
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry instanceof HalfEdge3DReadOnly) {
            HalfEdge3DReadOnly other = (HalfEdge3DReadOnly)geometry;
            if (this.getOrigin() == null != (other.getOrigin() == null)) {
                return false;
            }
            if (this.getDestination() == null != (other.getDestination() == null)) {
                return false;
            }
        }
        return super.equals(geometry);
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getHalfEdge3DString(format, this);
    }
}

