/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidShapeCollisionTools {
    private EuclidShapeCollisionTools() {
    }

    public static void evaluatePointShape3DBox3DCollision(PointShape3DReadOnly shapeA, Box3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DBox3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DBox3DCollision(Sphere3DReadOnly shapeA, Box3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DBox3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setSignedDistance(distance);
        resultToPack.setShapesAreColliding(distance < 0.0);
    }

    private static void evaluatePoint3DBox3DCollision(Point3DReadOnly point3D, Box3DReadOnly box3D, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        box3D.getPose().inverseTransform(point3D, resultToPack.getPointOnA());
        double distance = EuclidShapeTools.evaluatePoint3DBox3DCollision((Point3DReadOnly)resultToPack.getPointOnA(), box3D.getSize(), resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        box3D.transformToWorld((Transformable)resultToPack.getPointOnB());
        box3D.transformToWorld((Transformable)resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DCapsule3DCollision(PointShape3DReadOnly shapeA, Capsule3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DCapsule3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateCapsule3DCapsule3DCollision(Capsule3DReadOnly shapeA, Capsule3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        Point3DBasics pointOnA = resultToPack.getPointOnA();
        Point3DBasics pointOnB = resultToPack.getPointOnB();
        double distanceBetweenAxes = EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds((Point3DReadOnly)shapeA.getTopCenter(), (Point3DReadOnly)shapeA.getBottomCenter(), (Point3DReadOnly)shapeB.getTopCenter(), (Point3DReadOnly)shapeB.getBottomCenter(), (Point3DBasics)pointOnA, (Point3DBasics)pointOnB);
        Vector3DBasics normalOnA = resultToPack.getNormalOnA();
        Vector3DBasics normalOnB = resultToPack.getNormalOnB();
        normalOnA.sub((Tuple3DReadOnly)pointOnB, (Tuple3DReadOnly)pointOnA);
        normalOnA.scale(1.0 / distanceBetweenAxes);
        normalOnB.setAndNegate((Tuple3DReadOnly)normalOnA);
        pointOnA.scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)normalOnA, (Tuple3DReadOnly)pointOnA);
        pointOnB.scaleAdd(shapeB.getRadius(), (Tuple3DReadOnly)normalOnB, (Tuple3DReadOnly)pointOnB);
        double distance = distanceBetweenAxes - shapeA.getRadius() - shapeB.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DCapsule3DCollision(Sphere3DReadOnly shapeA, Capsule3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DCapsule3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DCapsule3DCollision(Point3DReadOnly point3D, Capsule3DReadOnly capsule3D, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        double distance = EuclidShapeTools.evaluatePoint3DCapsule3DCollision(point3D, capsule3D.getPosition(), (Vector3DReadOnly)capsule3D.getAxis(), capsule3D.getLength(), capsule3D.getRadius(), resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DCylinder3DCollision(PointShape3DReadOnly shapeA, Cylinder3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DCylinder3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DCylinder3DCollision(Sphere3DReadOnly shapeA, Cylinder3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DCylinder3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DCylinder3DCollision(Point3DReadOnly point3D, Cylinder3DReadOnly cylinder3D, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        double distance = EuclidShapeTools.evaluatePoint3DCylinder3DCollision(point3D, cylinder3D.getPosition(), (Vector3DReadOnly)cylinder3D.getAxis(), cylinder3D.getLength(), cylinder3D.getRadius(), resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DEllipsoid3DCollision(PointShape3DReadOnly shapeA, Ellipsoid3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DEllipsoid3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DEllipsoid3DCollision(Sphere3DReadOnly shapeA, Ellipsoid3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DEllipsoid3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DEllipsoid3DCollision(Point3DReadOnly point3D, Ellipsoid3DReadOnly ellipsoid3D, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        ellipsoid3D.getPose().inverseTransform(point3D, resultToPack.getPointOnA());
        double distance = EuclidShapeTools.evaluatePoint3DEllipsoid3DCollision((Point3DReadOnly)resultToPack.getPointOnA(), ellipsoid3D.getRadii(), resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        ellipsoid3D.transformToWorld((Transformable)resultToPack.getPointOnB());
        ellipsoid3D.transformToWorld((Transformable)resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DPointShape3DCollision(PointShape3DReadOnly shapeA, PointShape3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        Point3DBasics pointOnA = resultToPack.getPointOnA();
        Point3DBasics pointOnB = resultToPack.getPointOnB();
        Vector3DBasics normalOnA = resultToPack.getNormalOnA();
        Vector3DBasics normalOnB = resultToPack.getNormalOnB();
        pointOnA.set((Tuple3DReadOnly)shapeA);
        pointOnB.set((Tuple3DReadOnly)shapeB);
        double distance = pointOnA.distance((Point3DReadOnly)pointOnB);
        normalOnA.sub((Tuple3DReadOnly)pointOnB, (Tuple3DReadOnly)pointOnA);
        normalOnA.scale(1.0 / distance);
        normalOnB.setAndNegate((Tuple3DReadOnly)normalOnA);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.setShapesAreColliding(false);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DRamp3DCollision(PointShape3DReadOnly shapeA, Ramp3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DRamp3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DRamp3DCollision(Sphere3DReadOnly shapeA, Ramp3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DRamp3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DRamp3DCollision(Point3DReadOnly point3D, Ramp3DReadOnly ramp3D, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        ramp3D.getPose().inverseTransform(point3D, resultToPack.getPointOnA());
        double distance = EuclidShapeTools.evaluatePoint3DRamp3DCollision((Point3DReadOnly)resultToPack.getPointOnA(), ramp3D.getSize(), resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        ramp3D.transformToWorld((Transformable)resultToPack.getPointOnB());
        ramp3D.transformToWorld((Transformable)resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DSphere3DCollision(PointShape3DReadOnly shapeA, Sphere3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DSphere3DCollision(shapeA, shapeB.getPosition(), shapeB.getRadius(), resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DSphere3DCollision(Sphere3DReadOnly shapeA, Sphere3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DSphere3DCollision(shapeA.getPosition(), shapeB.getPosition(), shapeB.getRadius(), resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance();
        resultToPack.setShapesAreColliding((distance -= shapeA.getRadius()) < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DSphere3DCollision(Point3DReadOnly point3D, Point3DReadOnly sphere3DPosition, double sphere3DRadius, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        double distance = EuclidShapeTools.evaluatePoint3DSphere3DCollision(point3D, sphere3DPosition, sphere3DRadius, resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    public static void evaluatePointShape3DTorus3DCollision(PointShape3DReadOnly shapeA, Torus3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DTorus3DCollision(shapeA, shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
    }

    public static void evaluateSphere3DTorus3DCollision(Sphere3DReadOnly shapeA, Torus3DReadOnly shapeB, EuclidShape3DCollisionResultBasics resultToPack) {
        EuclidShapeCollisionTools.evaluatePoint3DTorus3DCollision(shapeA.getPosition(), shapeB, resultToPack);
        resultToPack.setShapeA(shapeA);
        resultToPack.setShapeB(shapeB);
        resultToPack.getPointOnA().scaleAdd(shapeA.getRadius(), (Tuple3DReadOnly)resultToPack.getNormalOnA(), (Tuple3DReadOnly)resultToPack.getPointOnA());
        double distance = resultToPack.getSignedDistance() - shapeA.getRadius();
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }

    private static void evaluatePoint3DTorus3DCollision(Point3DReadOnly point3D, Torus3DReadOnly torus3D, EuclidShape3DCollisionResultBasics resultToPack) {
        resultToPack.setToNaN();
        double distance = EuclidShapeTools.evaluatePoint3DTorus3DCollision(point3D, torus3D.getPosition(), (Vector3DReadOnly)torus3D.getAxis(), torus3D.getRadius(), torus3D.getTubeRadius(), resultToPack.getPointOnB(), resultToPack.getNormalOnB());
        resultToPack.getPointOnA().set((Tuple3DReadOnly)point3D);
        resultToPack.getNormalOnA().setAndNegate((Tuple3DReadOnly)resultToPack.getNormalOnB());
        resultToPack.setShapesAreColliding(distance < 0.0);
        resultToPack.setSignedDistance(distance);
    }
}

