/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DBasics;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Box3DReadOnly
extends Shape3DReadOnly {
    public Vector3DReadOnly getSize();

    @Override
    public Shape3DPoseReadOnly getPose();

    default public RotationMatrixReadOnly getOrientation() {
        return this.getPose().getShapeOrientation();
    }

    default public Point3DReadOnly getPosition() {
        return this.getPose().getShapePosition();
    }

    @Override
    default public Point3DReadOnly getCentroid() {
        return this.getPosition();
    }

    @Override
    default public double getVolume() {
        return EuclidShapeTools.boxVolume(this.getSizeX(), this.getSizeY(), this.getSizeZ());
    }

    default public void checkSizePositive(Axis3D axis) {
        if (this.getSize().getElement(axis) < 0.0) {
            throw new IllegalArgumentException("The " + axis + "-size of a " + this.getClass().getSimpleName() + " cannot be negative: " + this.getSize().getElement(axis));
        }
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier();

    @Override
    default public boolean containsNaN() {
        return this.getPose().containsNaN() || this.getSize().containsNaN();
    }

    @Override
    default public boolean evaluatePoint3DCollision(Point3DReadOnly pointToCheck, Point3DBasics closestPointOnSurfaceToPack, Vector3DBasics normalAtClosestPointToPack) {
        Point3DBasics queryInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(pointToCheck, queryInLocal);
        double distance = EuclidShapeTools.evaluatePoint3DBox3DCollision((Point3DReadOnly)queryInLocal, this.getSize(), closestPointOnSurfaceToPack, normalAtClosestPointToPack);
        this.transformToWorld((Transformable)closestPointOnSurfaceToPack);
        this.transformToWorld((Transformable)normalAtClosestPointToPack);
        this.getIntermediateVariableSupplier().releasePoint3D(queryInLocal);
        return distance <= 0.0;
    }

    @Override
    default public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        if (this.getOrientation().isIdentity()) {
            EuclidShapeTools.supportingVertexBox3D(supportDirection, this.getSize(), supportingVertexToPack);
            supportingVertexToPack.add((Tuple3DReadOnly)this.getPosition());
        } else {
            Vector3DBasics supportDirectionInLocal = this.getIntermediateVariableSupplier().requestVector3D();
            this.getPose().inverseTransform(supportDirection, supportDirectionInLocal);
            EuclidShapeTools.supportingVertexBox3D((Vector3DReadOnly)supportDirectionInLocal, this.getSize(), supportingVertexToPack);
            this.transformToWorld((Transformable)supportingVertexToPack);
            this.getIntermediateVariableSupplier().releaseVector3D(supportDirectionInLocal);
        }
        return true;
    }

    @Override
    default public double signedDistance(Point3DReadOnly point) {
        Point3DBasics queryInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(point, queryInLocal);
        double signedDistance = EuclidShapeTools.signedDistanceBetweenPoint3DAndBox3D((Point3DReadOnly)queryInLocal, this.getSize());
        this.getIntermediateVariableSupplier().releasePoint3D(queryInLocal);
        return signedDistance;
    }

    @Override
    default public boolean isPointInside(Point3DReadOnly query, double epsilon) {
        double yLocalQuery;
        double dX = query.getX() - this.getPose().getTranslationX();
        double dY = query.getY() - this.getPose().getTranslationY();
        double dZ = query.getZ() - this.getPose().getTranslationZ();
        if (this.getPose().getShapeOrientation().isIdentity()) {
            return EuclidShapeTools.isPoint3DInsideBox3D(dX, dY, dZ, this.getSize(), epsilon);
        }
        double xLocalQuery = TupleTools.dot((double)dX, (double)dY, (double)dZ, (Tuple3DReadOnly)this.getPose().getXAxis());
        if (Math.abs(xLocalQuery) <= 0.5 * this.getSizeX() + epsilon && Math.abs(yLocalQuery = TupleTools.dot((double)dX, (double)dY, (double)dZ, (Tuple3DReadOnly)this.getPose().getYAxis())) <= 0.5 * this.getSizeY() + epsilon) {
            double zLocalQuery = TupleTools.dot((double)dX, (double)dY, (double)dZ, (Tuple3DReadOnly)this.getPose().getZAxis());
            return Math.abs(zLocalQuery) <= 0.5 * this.getSizeZ() + epsilon;
        }
        return false;
    }

    @Override
    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        Point3DBasics pointToProjectInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        this.getPose().inverseTransform(pointToProject, pointToProjectInLocal);
        boolean hasBeenProjected = EuclidShapeTools.orthogonalProjectionOntoBox3D((Point3DReadOnly)pointToProjectInLocal, this.getSize(), projectionToPack);
        if (hasBeenProjected) {
            this.transformToWorld((Transformable)projectionToPack);
        }
        this.getIntermediateVariableSupplier().releasePoint3D(pointToProjectInLocal);
        return hasBeenProjected;
    }

    default public int intersectionWith(Line3DReadOnly line, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return this.intersectionWith(line.getPoint(), (Vector3DReadOnly)line.getDirection(), firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double maxX = 0.5 * this.getSizeX();
        double maxY = 0.5 * this.getSizeY();
        double maxZ = 0.5 * this.getSizeZ();
        double minX = -maxX;
        double minY = -maxY;
        double minZ = -maxZ;
        Point3DBasics pointOnLineInLocal = this.getIntermediateVariableSupplier().requestPoint3D();
        Vector3DBasics lineDirectionInLocal = this.getIntermediateVariableSupplier().requestVector3D();
        this.getPose().inverseTransform(pointOnLine, pointOnLineInLocal);
        this.getPose().inverseTransform(lineDirection, lineDirectionInLocal);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Point3DReadOnly)pointOnLineInLocal, (Vector3DReadOnly)lineDirectionInLocal, (Point3DBasics)firstIntersectionToPack, (Point3DBasics)secondIntersectionToPack);
        this.getIntermediateVariableSupplier().releasePoint3D(pointOnLineInLocal);
        this.getIntermediateVariableSupplier().releaseVector3D(lineDirectionInLocal);
        if (firstIntersectionToPack != null && numberOfIntersections >= 1) {
            this.transformToWorld((Transformable)firstIntersectionToPack);
        }
        if (secondIntersectionToPack != null && numberOfIntersections == 2) {
            this.transformToWorld((Transformable)secondIntersectionToPack);
        }
        return numberOfIntersections;
    }

    @Override
    default public boolean isConvex() {
        return true;
    }

    @Override
    default public boolean isPrimitive() {
        return true;
    }

    @Override
    default public boolean isDefinedByPose() {
        return true;
    }

    default public double getSizeX() {
        return this.getSize().getX();
    }

    default public double getSizeY() {
        return this.getSize().getY();
    }

    default public double getSizeZ() {
        return this.getSize().getZ();
    }

    @Override
    default public void getBoundingBox(BoundingBox3DBasics boundingBoxToPack) {
        EuclidShapeTools.boundingBoxBox3D(this.getPosition(), this.getOrientation(), this.getSize(), boundingBoxToPack);
    }

    public BoxPolytope3DView asConvexPolytope();

    default public Point3DBasics[] getVertices() {
        Point3D[] vertices = new Point3D[8];
        for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
            vertices[vertexIndex] = new Point3D();
            this.getVertex(vertexIndex, (Point3DBasics)vertices[vertexIndex]);
        }
        return vertices;
    }

    default public void getVertices(Point3DBasics[] verticesToPack) {
        if (verticesToPack.length < 8) {
            throw new IllegalArgumentException("Array is too small, has to be at least 8 element long, was: " + verticesToPack.length);
        }
        for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
            this.getVertex(vertexIndex, verticesToPack[vertexIndex]);
        }
    }

    default public Point3DBasics getVertex(int vertexIndex) {
        Point3D vertex = new Point3D();
        this.getVertex(vertexIndex, (Point3DBasics)vertex);
        return vertex;
    }

    default public void getVertex(int vertexIndex, Point3DBasics vertexToPack) {
        if (vertexIndex < 0 || vertexIndex >= 8) {
            throw new IndexOutOfBoundsException("The vertex index has to be in [0, 7], was: " + vertexIndex);
        }
        vertexToPack.set((vertexIndex & 1) == 0 ? this.getSizeX() : -this.getSizeX(), (vertexIndex & 2) == 0 ? this.getSizeY() : -this.getSizeY(), (vertexIndex & 4) == 0 ? this.getSizeZ() : -this.getSizeZ());
        vertexToPack.scale(0.5);
        this.transformToWorld((Transformable)vertexToPack);
    }

    @Override
    public Box3DBasics copy();

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Box3DReadOnly)) {
            return false;
        }
        Box3DReadOnly other = (Box3DReadOnly)geometry;
        return this.getSize().epsilonEquals((EuclidGeometry)other.getSize(), epsilon) && this.getPose().epsilonEquals((EuclidGeometry)other.getPose(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Box3DReadOnly)) {
            return false;
        }
        Box3DReadOnly other = (Box3DReadOnly)geometry;
        if (!this.getPosition().geometricallyEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        Vector3DBasics otherSize = this.getIntermediateVariableSupplier().requestVector3D();
        other.getPose().transform(other.getSize(), otherSize);
        this.transformToLocal((Transformable)otherSize);
        otherSize.absolute();
        boolean result = this.getSize().geometricallyEquals((EuclidGeometry)otherSize, epsilon);
        this.getIntermediateVariableSupplier().releaseVector3D(otherSize);
        return result;
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Box3DReadOnly)) {
            return false;
        }
        Box3DReadOnly other = (Box3DReadOnly)geometry;
        return this.getPose().equals((EuclidGeometry)other.getPose()) && this.getSize().equals((EuclidGeometry)other.getSize());
    }

    default public void transformToLocal(Transformable transformable) {
        transformable.applyInverseTransform((Transform)this.getPose());
    }

    default public void transformToWorld(Transformable transformable) {
        transformable.applyTransform((Transform)this.getPose());
    }

    default public String toString(String format) {
        return EuclidShapeIOTools.getBox3DString(format, this);
    }
}

