/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface EuclidShape3DCollisionResultBasics
extends EuclidShape3DCollisionResultReadOnly,
Clearable,
Transformable {
    public void setShapeA(Shape3DReadOnly var1);

    public void setShapeB(Shape3DReadOnly var1);

    public Point3DBasics getPointOnA();

    public Point3DBasics getPointOnB();

    public Vector3DBasics getNormalOnA();

    public Vector3DBasics getNormalOnB();

    default public void set(EuclidShape3DCollisionResultReadOnly other) {
        this.setShapeA(other.getShapeA());
        this.setShapeB(other.getShapeB());
        this.setShapesAreColliding(other.areShapesColliding());
        this.setSignedDistance(other.getSignedDistance());
        this.getPointOnA().set((Tuple3DReadOnly)other.getPointOnA());
        this.getNormalOnA().set((Tuple3DReadOnly)other.getNormalOnA());
        this.getPointOnB().set((Tuple3DReadOnly)other.getPointOnB());
        this.getNormalOnB().set((Tuple3DReadOnly)other.getNormalOnB());
    }

    public void setShapesAreColliding(boolean var1);

    public void setSignedDistance(double var1);

    @Override
    default public boolean containsNaN() {
        return EuclidShape3DCollisionResultReadOnly.super.containsNaN();
    }

    default public void setToZero() {
        this.setShapesAreColliding(false);
        this.setSignedDistance(0.0);
        this.getPointOnA().setToZero();
        this.getNormalOnA().setToZero();
        this.getPointOnB().setToZero();
        this.getNormalOnB().setToZero();
    }

    default public void setToNaN() {
        this.setShapesAreColliding(false);
        this.setSignedDistance(Double.NaN);
        this.getPointOnA().setToNaN();
        this.getNormalOnA().setToNaN();
        this.getPointOnB().setToNaN();
        this.getNormalOnB().setToNaN();
    }

    default public void swapShapes() {
        Shape3DReadOnly tempShape = this.getShapeA();
        this.setShapeA(this.getShapeB());
        this.setShapeB(tempShape);
        Point3DBasics pointOnA = this.getPointOnA();
        double tempX = pointOnA.getX();
        double tempY = pointOnA.getY();
        double tempZ = pointOnA.getZ();
        pointOnA.set((Tuple3DReadOnly)this.getPointOnB());
        this.getPointOnB().set(tempX, tempY, tempZ);
        Vector3DBasics normalOnA = this.getNormalOnA();
        tempX = normalOnA.getX();
        tempY = normalOnA.getY();
        tempZ = normalOnA.getZ();
        normalOnA.set((Tuple3DReadOnly)this.getNormalOnB());
        this.getNormalOnB().set(tempX, tempY, tempZ);
    }

    default public void applyTransform(Transform transform) {
        if (!this.getPointOnA().containsNaN()) {
            this.getPointOnA().applyTransform(transform);
        }
        if (!this.getPointOnB().containsNaN()) {
            this.getPointOnB().applyTransform(transform);
        }
        if (!this.getNormalOnA().containsNaN()) {
            this.getNormalOnA().applyTransform(transform);
        }
        if (!this.getNormalOnB().containsNaN()) {
            this.getNormalOnB().applyTransform(transform);
        }
    }

    default public void applyInverseTransform(Transform transform) {
        if (!this.getPointOnA().containsNaN()) {
            this.getPointOnA().applyInverseTransform(transform);
        }
        if (!this.getPointOnB().containsNaN()) {
            this.getPointOnB().applyInverseTransform(transform);
        }
        if (!this.getNormalOnA().containsNaN()) {
            this.getNormalOnA().applyInverseTransform(transform);
        }
        if (!this.getNormalOnB().containsNaN()) {
            this.getNormalOnB().applyInverseTransform(transform);
        }
    }
}

