/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.collision.epa;

import us.ihmc.euclid.shape.collision.epa.EPAFace3D;
import us.ihmc.euclid.shape.collision.epa.EPAVertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.HalfEdge3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;

public class EPAHalfEdge3D
implements HalfEdge3DReadOnly {
    private final EPAVertex3D v0;
    private final EPAVertex3D v1;
    private EPAHalfEdge3D twin;
    private EPAHalfEdge3D next;
    private EPAHalfEdge3D previous;
    private final EPAFace3D face;
    private boolean obsolete = false;

    public EPAHalfEdge3D(EPAVertex3D v0, EPAVertex3D v1, EPAFace3D face) {
        this.face = face;
        this.v0 = v0;
        this.v1 = v1;
        v0.addAssociatedEdge(this);
    }

    public void setTwin(EPAHalfEdge3D twin) {
        if (this.v0 != twin.v1 || this.v1 != twin.v0) {
            throw new IllegalArgumentException("Twin does not match: this edge:\n" + this + "\ntwin:\n" + twin);
        }
        this.twin = twin;
        if (twin.twin != this) {
            twin.setTwin(this);
        }
    }

    @Override
    public EPAHalfEdge3D getTwin() {
        return this.twin;
    }

    public void setNext(EPAHalfEdge3D next) {
        this.next = next;
    }

    @Override
    public EPAHalfEdge3D getNext() {
        return this.next;
    }

    public void setPrevious(EPAHalfEdge3D previous) {
        this.previous = previous;
    }

    @Override
    public EPAHalfEdge3D getPrevious() {
        return this.previous;
    }

    public void markObsolete() {
        this.obsolete = true;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    @Override
    public EPAVertex3D getOrigin() {
        return this.v0;
    }

    @Override
    public EPAVertex3D getDestination() {
        return this.v1;
    }

    @Override
    public EPAFace3D getFace() {
        return this.face;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HalfEdge3DReadOnly) {
            return this.equals((HalfEdge3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((long)EuclidHashCodeTools.combineHashCode((long)this.getOrigin().hashCode(), (long)this.getDestination().hashCode()));
    }

    public String toString() {
        return "EPA " + EuclidShapeIOTools.getHalfEdge3DString(this);
    }
}

