/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public interface Pose2DReadOnly
extends EuclidGeometry {
    default public double getX() {
        return this.getPosition().getX();
    }

    default public double getY() {
        return this.getPosition().getY();
    }

    default public double getYaw() {
        return this.getOrientation().getYaw();
    }

    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getOrientation().containsNaN();
    }

    public Point2DReadOnly getPosition();

    public Orientation2DReadOnly getOrientation();

    default public void get(RigidBodyTransformBasics transformToPack) {
        transformToPack.getTranslation().set(this.getX(), this.getY(), 0.0);
        transformToPack.getRotation().setToYawOrientation(this.getYaw());
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Pose2DReadOnly)) {
            return false;
        }
        Pose2DReadOnly other = (Pose2DReadOnly)geometry;
        return this.getPosition().equals((EuclidGeometry)other.getPosition()) && this.getOrientation().equals((EuclidGeometry)other.getOrientation());
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Pose2DReadOnly)) {
            return false;
        }
        Pose2DReadOnly other = (Pose2DReadOnly)geometry;
        return this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon) && this.getOrientation().epsilonEquals((EuclidGeometry)other.getOrientation(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Pose2DReadOnly)) {
            return false;
        }
        Pose2DReadOnly other = (Pose2DReadOnly)geometry;
        return this.getPosition().geometricallyEquals((EuclidGeometry)other.getPosition(), epsilon) && this.getOrientation().geometricallyEquals((EuclidGeometry)other.getOrientation(), epsilon);
    }

    default public String toString(String format) {
        return EuclidGeometryIOTools.getPose2DString(format, this);
    }
}

