/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class ConvexPolygon2D
implements ConvexPolygon2DBasics,
Settable<ConvexPolygon2D> {
    private final boolean clockwiseOrdered = true;
    private int numberOfVertices = 0;
    private final List<Point2D> vertexBuffer = new ArrayList<Point2D>();
    private final List<Point2D> vertexBufferView = Collections.unmodifiableList(this.vertexBuffer);
    private final BoundingBox2D boundingBox = new BoundingBox2D();
    private final Point2D centroid = new Point2D();
    private double area;
    private boolean isUpToDate = false;
    private boolean boundingBoxDirty = true;
    private boolean areaCentroidDirty = true;

    public ConvexPolygon2D() {
        this.numberOfVertices = 0;
        this.update();
    }

    public ConvexPolygon2D(Vertex2DSupplier vertex2DSupplier) {
        this.set(vertex2DSupplier);
    }

    public ConvexPolygon2D(Vertex3DSupplier vertex3DSupplier) {
        this.set(vertex3DSupplier);
    }

    public ConvexPolygon2D(Vertex2DSupplier firstVertex2DSupplier, Vertex2DSupplier secondVertex2DSupplier) {
        this.set(firstVertex2DSupplier, secondVertex2DSupplier);
    }

    @Override
    public boolean isClockwiseOrdered() {
        return true;
    }

    @Override
    public void clear() {
        this.numberOfVertices = 0;
        this.area = Double.NaN;
        this.centroid.setToNaN();
        this.boundingBox.setToNaN();
        this.isUpToDate = false;
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    @Override
    public void clearAndUpdate() {
        this.clear();
        this.isUpToDate = true;
        this.boundingBoxDirty = false;
        this.areaCentroidDirty = false;
    }

    @Override
    public void addVertex(double x, double y) {
        this.isUpToDate = false;
        this.setOrCreate(this.numberOfVertices, x, y);
        ++this.numberOfVertices;
    }

    @Override
    public void removeVertex(int indexOfVertexToRemove) {
        this.checkIndexInBoundaries(indexOfVertexToRemove);
        if (indexOfVertexToRemove == this.numberOfVertices - 1) {
            --this.numberOfVertices;
            return;
        }
        this.isUpToDate = false;
        Collections.swap(this.vertexBuffer, indexOfVertexToRemove, this.numberOfVertices - 1);
        --this.numberOfVertices;
    }

    private void setOrCreate(int i, double x, double y) {
        while (i >= this.vertexBuffer.size()) {
            this.vertexBuffer.add(new Point2D());
        }
        this.vertexBuffer.get(i).set(x, y);
    }

    @Override
    public void update() {
        if (this.isUpToDate) {
            return;
        }
        this.numberOfVertices = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(this.vertexBuffer, this.numberOfVertices);
        this.isUpToDate = true;
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    public void set(ConvexPolygon2D other) {
        if (!other.clockwiseOrdered) {
            ConvexPolygon2DBasics.super.set(other);
            return;
        }
        this.numberOfVertices = other.numberOfVertices;
        for (int i = 0; i < other.numberOfVertices; ++i) {
            Point2D otherVertex = other.vertexBuffer.get(i);
            this.setOrCreate(i, otherVertex.getX(), otherVertex.getY());
        }
        this.boundingBox.set(other.boundingBox);
        this.centroid.set(other.centroid);
        this.area = other.area;
        this.isUpToDate = other.isUpToDate;
        this.boundingBoxDirty = other.boundingBoxDirty;
        this.areaCentroidDirty = other.areaCentroidDirty;
    }

    @Override
    public void set(Vertex2DSupplier vertex2DSupplier) {
        if (vertex2DSupplier instanceof ConvexPolygon2D) {
            this.set((ConvexPolygon2D)vertex2DSupplier);
        } else if (vertex2DSupplier instanceof ConvexPolygon2DReadOnly) {
            ConvexPolygon2DReadOnly other = (ConvexPolygon2DReadOnly)vertex2DSupplier;
            if (!other.isClockwiseOrdered()) {
                ConvexPolygon2DBasics.super.set(vertex2DSupplier);
                return;
            }
            this.clear();
            this.numberOfVertices = other.getNumberOfVertices();
            for (int i = 0; i < this.numberOfVertices; ++i) {
                Point2DReadOnly otherVertex = other.getVertexUnsafe(i);
                this.setOrCreate(i, otherVertex.getX(), otherVertex.getY());
            }
            if (other.isUpToDate()) {
                this.isUpToDate = true;
                this.boundingBoxDirty = true;
                this.areaCentroidDirty = true;
            }
        } else {
            ConvexPolygon2DBasics.super.set(vertex2DSupplier);
        }
    }

    private void updateCentroidAndArea() {
        if (this.areaCentroidDirty) {
            this.areaCentroidDirty = false;
            this.area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(this.vertexBuffer, this.numberOfVertices, true, (Point2DBasics)this.centroid);
        }
    }

    private void updateBoundingBox() {
        if (this.boundingBoxDirty) {
            this.boundingBoxDirty = false;
            this.boundingBox.setToNaN();
            this.boundingBox.updateToIncludePoints(this);
        }
    }

    @Override
    public Point2DBasics getVertexUnsafe(int index) {
        this.checkIndexInBoundaries(index);
        return (Point2DBasics)this.vertexBuffer.get(index);
    }

    @Override
    public double getArea() {
        this.checkIfUpToDate();
        this.updateCentroidAndArea();
        return this.area;
    }

    @Override
    public Point2DReadOnly getCentroid() {
        this.checkIfUpToDate();
        this.updateCentroidAndArea();
        return this.centroid;
    }

    @Override
    public BoundingBox2DReadOnly getBoundingBox() {
        this.checkIfUpToDate();
        this.updateBoundingBox();
        return this.boundingBox;
    }

    @Override
    public int getNumberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public List<? extends Point2DReadOnly> getVertexBufferView() {
        return this.vertexBufferView;
    }

    @Override
    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    @Override
    public void notifyVerticesChanged() {
        this.isUpToDate = false;
    }

    @Override
    public void translate(double x, double y) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).add(x, y);
        }
        if (!this.boundingBoxDirty) {
            this.boundingBox.getMinPoint().add(x, y);
            this.boundingBox.getMaxPoint().add(x, y);
        }
        if (!this.areaCentroidDirty) {
            this.centroid.add(x, y);
        }
    }

    @Override
    public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyTransform(transform, checkIfTransformInXYPlane);
        }
        this.postTransform(transform);
    }

    @Override
    public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyInverseTransform(transform, checkIfTransformInXYPlane);
        }
        this.postTransform(transform);
    }

    private void postTransform(Transform transform) {
        if (this.numberOfVertices <= 3) {
            this.notifyVerticesChanged();
            this.update();
            return;
        }
        boolean updateVertices = true;
        if (transform instanceof RigidBodyTransformReadOnly) {
            RigidBodyTransformReadOnly rbTransform = (RigidBodyTransformReadOnly)transform;
            updateVertices = rbTransform.hasRotation();
        } else if (transform instanceof AffineTransformReadOnly) {
            AffineTransformReadOnly aTransform = (AffineTransformReadOnly)transform;
            updateVertices = aTransform.hasLinearTransform();
        }
        if (updateVertices) {
            EuclidGeometryPolygonTools.Convexity convexity = null;
            for (int vertexIndex = 0; vertexIndex < this.numberOfVertices; ++vertexIndex) {
                if (convexity == null) {
                    convexity = EuclidGeometryPolygonTools.polygon2DConvexityAtVertex(vertexIndex, this.vertexBuffer, vertexIndex, true);
                }
                if (convexity != null) break;
            }
            if (convexity == EuclidGeometryPolygonTools.Convexity.CONCAVE) {
                EuclidCoreTools.reverse(this.vertexBuffer, (int)0, (int)this.numberOfVertices);
            }
            int minXMaxYVertexIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex(this.vertexBuffer, this.numberOfVertices);
            EuclidCoreTools.rotate(this.vertexBuffer, (int)0, (int)this.numberOfVertices, (int)(-minXMaxYVertexIndex));
        }
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    public boolean equals(Object object) {
        if (object instanceof ConvexPolygon2DReadOnly) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((long)EuclidHashCodeTools.addToHashCode((long)Boolean.hashCode(true), this.vertexBufferView));
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

