/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.Location;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.exceptions.BoundingBoxException;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidGeometryTools {
    public static final double ONE_MILLIONTH = 1.0E-6;
    public static final double ONE_TEN_MILLIONTH = 1.0E-7;
    public static final double ONE_TRILLIONTH = 1.0E-12;
    public static final double IS_POINT_ON_LINE_EPS = 1.0E-8;
    public static final double HALF_PI = 1.5707963267948966;

    private EuclidGeometryTools() {
    }

    public static double angleFromFirstToSecondVector2D(double firstVectorX, double firstVectorY, double secondVectorX, double secondVectorY) {
        return TupleTools.angle((double)firstVectorX, (double)firstVectorY, (double)secondVectorX, (double)secondVectorY);
    }

    public static double angleFromXForwardToVector2D(Vector2DReadOnly vector) {
        return Axis2D.X.angle(vector);
    }

    public static double angleFromXForwardToVector2D(double vectorX, double vectorY) {
        return EuclidGeometryTools.angleFromFirstToSecondVector2D(1.0, 0.0, vectorX, vectorY);
    }

    public static double angleFromFirstToSecondVector3D(double firstVectorX, double firstVectorY, double firstVectorZ, double secondVectorX, double secondVectorY, double secondVectorZ) {
        return TupleTools.angle((double)firstVectorX, (double)firstVectorY, (double)firstVectorZ, (double)secondVectorX, (double)secondVectorY, (double)secondVectorZ);
    }

    public static boolean areLine2DsCollinear(double pointOnLine1x, double pointOnLine1y, double lineDirection1x, double lineDirection1y, double pointOnLine2x, double pointOnLine2y, double lineDirection2x, double lineDirection2y, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.areLine2DsCollinear(pointOnLine1x, pointOnLine1y, lineDirection1x, lineDirection1y, false, pointOnLine2x, pointOnLine2y, lineDirection2x, lineDirection2y, false, angleEpsilon, distanceEpsilon);
    }

    private static boolean areLine2DsCollinear(double pointOnLine1x, double pointOnLine1y, double lineDirection1x, double lineDirection1y, boolean isDirection1Unitary, double pointOnLine2x, double pointOnLine2y, double lineDirection2x, double lineDirection2y, boolean isDirection2Unitary, double angleEpsilon, double distanceEpsilon) {
        if (!EuclidGeometryTools.areVector2DsParallel(lineDirection1x, lineDirection1y, isDirection1Unitary, lineDirection2x, lineDirection2y, isDirection2Unitary, angleEpsilon)) {
            return false;
        }
        double distance = EuclidGeometryTools.distanceFromPoint2DToLine2D(pointOnLine2x, pointOnLine2y, pointOnLine1x, pointOnLine1y, lineDirection1x, lineDirection1y, isDirection1Unitary);
        return distance < distanceEpsilon;
    }

    public static boolean areLine2DsCollinear(Point2DReadOnly firstPointOnLine1, Point2DReadOnly secondPointOnLine1, Point2DReadOnly firstPointOnLine2, Point2DReadOnly secondPointOnLine2, double angleEpsilon, double distanceEpsilon) {
        double pointOnLine1x = firstPointOnLine1.getX();
        double pointOnLine1y = firstPointOnLine1.getY();
        double lineDirection1x = secondPointOnLine1.getX() - firstPointOnLine1.getX();
        double lineDirection1y = secondPointOnLine1.getY() - firstPointOnLine1.getY();
        double pointOnLine2x = firstPointOnLine2.getX();
        double pointOnLine2y = firstPointOnLine2.getY();
        double lineDirection2x = secondPointOnLine2.getX() - firstPointOnLine2.getX();
        double lineDirection2y = secondPointOnLine2.getY() - firstPointOnLine2.getY();
        return EuclidGeometryTools.areLine2DsCollinear(pointOnLine1x, pointOnLine1y, lineDirection1x, lineDirection1y, pointOnLine2x, pointOnLine2y, lineDirection2x, lineDirection2y, angleEpsilon, distanceEpsilon);
    }

    public static boolean areLine2DsCollinear(Point2DReadOnly pointOnLine1, Vector2DReadOnly lineDirection1, Point2DReadOnly firstPointOnLine2, Point2DReadOnly secondPointOnLine2, double angleEpsilon, double distanceEpsilon) {
        double pointOnLine2x = firstPointOnLine2.getX();
        double pointOnLine2y = firstPointOnLine2.getY();
        double lineDirection2x = secondPointOnLine2.getX() - firstPointOnLine2.getX();
        double lineDirection2y = secondPointOnLine2.getY() - firstPointOnLine2.getY();
        return EuclidGeometryTools.areLine2DsCollinear(pointOnLine1.getX(), pointOnLine1.getY(), lineDirection1.getX(), lineDirection1.getY(), lineDirection1 instanceof UnitVector2DReadOnly, pointOnLine2x, pointOnLine2y, lineDirection2x, lineDirection2y, false, angleEpsilon, distanceEpsilon);
    }

    public static boolean areLine2DsCollinear(Point2DReadOnly pointOnLine1, Vector2DReadOnly lineDirection1, Point2DReadOnly pointOnLine2, Vector2DReadOnly lineDirection2, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.areLine2DsCollinear(pointOnLine1.getX(), pointOnLine1.getY(), lineDirection1.getX(), lineDirection1.getY(), pointOnLine2.getX(), pointOnLine2.getY(), lineDirection2.getX(), lineDirection2.getY(), angleEpsilon, distanceEpsilon);
    }

    public static boolean areLine3DsCollinear(double pointOnLine1x, double pointOnLine1y, double pointOnLine1z, double lineDirection1x, double lineDirection1y, double lineDirection1z, double pointOnLine2x, double pointOnLine2y, double pointOnLine2z, double lineDirection2x, double lineDirection2y, double lineDirection2z, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.areLine3DsCollinear(pointOnLine1x, pointOnLine1y, pointOnLine1z, lineDirection1x, lineDirection1y, lineDirection1z, false, pointOnLine2x, pointOnLine2y, pointOnLine2z, lineDirection2x, lineDirection2y, lineDirection2z, false, angleEpsilon, distanceEpsilon);
    }

    private static boolean areLine3DsCollinear(double pointOnLine1x, double pointOnLine1y, double pointOnLine1z, double lineDirection1x, double lineDirection1y, double lineDirection1z, boolean isDirection1Unitary, double pointOnLine2x, double pointOnLine2y, double pointOnLine2z, double lineDirection2x, double lineDirection2y, double lineDirection2z, boolean isDirection2Unitary, double angleEpsilon, double distanceEpsilon) {
        if (!EuclidGeometryTools.areVector3DsParallel(lineDirection1x, lineDirection1y, lineDirection1z, isDirection1Unitary, lineDirection2x, lineDirection2y, lineDirection2z, isDirection2Unitary, angleEpsilon)) {
            return false;
        }
        double distance = EuclidGeometryTools.distanceFromPoint3DToLine3D(pointOnLine2x, pointOnLine2y, pointOnLine2z, pointOnLine1x, pointOnLine1y, pointOnLine1z, lineDirection1x, lineDirection1y, lineDirection1z, isDirection1Unitary);
        return distance < distanceEpsilon;
    }

    public static boolean areLine3DsCollinear(Point3DReadOnly firstPointOnLine1, Point3DReadOnly secondPointOnLine1, Point3DReadOnly firstPointOnLine2, Point3DReadOnly secondPointOnLine2, double angleEpsilon, double distanceEpsilon) {
        double pointOnLine1x = firstPointOnLine1.getX();
        double pointOnLine1y = firstPointOnLine1.getY();
        double pointOnLine1z = firstPointOnLine1.getZ();
        double lineDirection1x = secondPointOnLine1.getX() - firstPointOnLine1.getX();
        double lineDirection1y = secondPointOnLine1.getY() - firstPointOnLine1.getY();
        double lineDirection1z = secondPointOnLine1.getZ() - firstPointOnLine1.getZ();
        double pointOnLine2x = firstPointOnLine2.getX();
        double pointOnLine2y = firstPointOnLine2.getY();
        double pointOnLine2z = firstPointOnLine2.getZ();
        double lineDirection2x = secondPointOnLine2.getX() - firstPointOnLine2.getX();
        double lineDirection2y = secondPointOnLine2.getY() - firstPointOnLine2.getY();
        double lineDirection2z = secondPointOnLine2.getZ() - firstPointOnLine2.getZ();
        return EuclidGeometryTools.areLine3DsCollinear(pointOnLine1x, pointOnLine1y, pointOnLine1z, lineDirection1x, lineDirection1y, lineDirection1z, pointOnLine2x, pointOnLine2y, pointOnLine2z, lineDirection2x, lineDirection2y, lineDirection2z, angleEpsilon, distanceEpsilon);
    }

    public static boolean areLine3DsCollinear(Point3DReadOnly pointOnLine1, Vector3DReadOnly lineDirection1, Point3DReadOnly pointOnLine2, Vector3DReadOnly lineDirection2, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.areLine3DsCollinear(pointOnLine1.getX(), pointOnLine1.getY(), pointOnLine1.getZ(), lineDirection1.getX(), lineDirection1.getY(), lineDirection1.getZ(), lineDirection1 instanceof UnitVector3DReadOnly, pointOnLine2.getX(), pointOnLine2.getY(), pointOnLine2.getZ(), lineDirection2.getX(), lineDirection2.getY(), lineDirection2.getZ(), lineDirection2 instanceof UnitVector3DReadOnly, angleEpsilon, distanceEpsilon);
    }

    public static boolean arePlane3DsCoincident(Point3DReadOnly pointOnPlane1, Vector3DReadOnly planeNormal1, Point3DReadOnly pointOnPlane2, Vector3DReadOnly planeNormal2, double angleEpsilon, double distanceEpsilon) {
        if (!EuclidGeometryTools.areVector3DsParallel(planeNormal1, planeNormal2, angleEpsilon)) {
            return false;
        }
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D(pointOnPlane2, pointOnPlane1, planeNormal1) < distanceEpsilon;
    }

    public static boolean areVector2DsParallel(double firstVectorX, double firstVectorY, double secondVectorX, double secondVectorY, double angleEpsilon) {
        return EuclidGeometryTools.areVector2DsParallel(firstVectorX, firstVectorY, false, secondVectorX, secondVectorY, false, angleEpsilon);
    }

    private static boolean areVector2DsParallel(double firstVectorX, double firstVectorY, boolean isFirstVectorUnitary, double secondVectorX, double secondVectorY, boolean isSecondVectorUnitary, double angleEpsilon) {
        double secondVectorLength;
        double firstVectorLength;
        if (angleEpsilon < 0.0 || angleEpsilon > 1.5707963267948966) {
            throw new IllegalArgumentException("The angle epsilon has to be inside the interval: [0.0 ; Math.PI / 2.0]");
        }
        double d = firstVectorLength = isFirstVectorUnitary ? 1.0 : EuclidCoreTools.norm((double)firstVectorX, (double)firstVectorY);
        if (firstVectorLength < 1.0E-7) {
            return false;
        }
        double d2 = secondVectorLength = isSecondVectorUnitary ? 1.0 : EuclidCoreTools.norm((double)secondVectorX, (double)secondVectorY);
        if (secondVectorLength < 1.0E-7) {
            return false;
        }
        double dot = firstVectorX * secondVectorX + firstVectorY * secondVectorY;
        return Math.abs(dot / (firstVectorLength * secondVectorLength)) > EuclidCoreTools.cos((double)angleEpsilon);
    }

    public static boolean areVector2DsParallel(Vector2DReadOnly firstVector, Vector2DReadOnly secondVector, double angleEpsilon) {
        return EuclidGeometryTools.areVector2DsParallel(firstVector.getX(), firstVector.getY(), firstVector instanceof UnitVector2DReadOnly, secondVector.getX(), secondVector.getY(), secondVector instanceof UnitVector2DReadOnly, angleEpsilon);
    }

    public static boolean areVector3DsParallel(double firstVectorX, double firstVectorY, double firstVectorZ, double secondVectorX, double secondVectorY, double secondVectorZ, double angleEpsilon) {
        return EuclidGeometryTools.areVector3DsParallel(firstVectorX, firstVectorY, firstVectorZ, false, secondVectorX, secondVectorY, secondVectorZ, false, angleEpsilon);
    }

    private static boolean areVector3DsParallel(double firstVectorX, double firstVectorY, double firstVectorZ, boolean isFirstVectorUnitary, double secondVectorX, double secondVectorY, double secondVectorZ, boolean isSecondVectorUnitary, double angleEpsilon) {
        double secondVectorLength;
        double firstVectorLength;
        if (angleEpsilon < 0.0 || angleEpsilon > 1.5707963267948966) {
            throw new IllegalArgumentException("The angle epsilon has to be inside the interval: [0.0 ; Math.PI / 2.0]");
        }
        double d = firstVectorLength = isFirstVectorUnitary ? 1.0 : EuclidCoreTools.norm((double)firstVectorX, (double)firstVectorY, (double)firstVectorZ);
        if (firstVectorLength < 1.0E-7) {
            return false;
        }
        double d2 = secondVectorLength = isSecondVectorUnitary ? 1.0 : EuclidCoreTools.norm((double)secondVectorX, (double)secondVectorY, (double)secondVectorZ);
        if (secondVectorLength < 1.0E-7) {
            return false;
        }
        double dot = firstVectorX * secondVectorX + firstVectorY * secondVectorY + firstVectorZ * secondVectorZ;
        return Math.abs(dot / (firstVectorLength * secondVectorLength)) > EuclidCoreTools.cos((double)angleEpsilon);
    }

    public static boolean areVector3DsParallel(Vector3DReadOnly firstVector, Vector3DReadOnly secondVector, double angleEpsilon) {
        return EuclidGeometryTools.areVector3DsParallel(firstVector.getX(), firstVector.getY(), firstVector.getZ(), firstVector instanceof UnitVector3DReadOnly, secondVector.getX(), secondVector.getY(), secondVector.getZ(), secondVector instanceof UnitVector3DReadOnly, angleEpsilon);
    }

    public static Point2D averagePoint2Ds(Collection<? extends Point2DReadOnly> points) {
        if (points.isEmpty()) {
            return null;
        }
        Point2D totalPoint = new Point2D();
        for (Point2DReadOnly point2DReadOnly : points) {
            totalPoint.add((Tuple2DReadOnly)point2DReadOnly);
        }
        totalPoint.scale(1.0 / (double)points.size());
        return totalPoint;
    }

    public static Point3D averagePoint3Ds(Collection<? extends Point3DReadOnly> points) {
        if (points.isEmpty()) {
            return null;
        }
        Point3D totalPoint = new Point3D();
        for (Point3DReadOnly point3DReadOnly : points) {
            totalPoint.add((Tuple3DReadOnly)point3DReadOnly);
        }
        totalPoint.scale(1.0 / (double)points.size());
        return totalPoint;
    }

    public static Point3D averagePoint3Ds(Point3DReadOnly a, Point3DReadOnly b) {
        Point3D average = new Point3D((Tuple3DReadOnly)a);
        average.add((Tuple3DReadOnly)b);
        average.scale(0.5);
        return average;
    }

    public static void orientation3DFromFirstToSecondVector3D(double firstVectorX, double firstVectorY, double firstVectorZ, double secondVectorX, double secondVectorY, double secondVectorZ, Orientation3DBasics rotationToPack) {
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D(firstVectorX, firstVectorY, firstVectorZ, false, secondVectorX, secondVectorY, secondVectorZ, false, rotationToPack);
    }

    private static void orientation3DFromFirstToSecondVector3D(double firstVectorX, double firstVectorY, double firstVectorZ, boolean isFirstVectorUnitary, double secondVectorX, double secondVectorY, double secondVectorZ, boolean isSecondVectorUnitary, Orientation3DBasics rotationToPack) {
        double axisZ;
        double axisY;
        double axisX;
        double crossNormSquared;
        boolean vectorsAreParallel;
        double secondVectorNormSquared;
        double firstVectorNormSquared;
        if (!isFirstVectorUnitary && !EuclidCoreTools.epsilonEquals((double)(firstVectorNormSquared = EuclidCoreTools.normSquared((double)firstVectorX, (double)firstVectorY, (double)firstVectorZ)), (double)1.0, (double)1.0E-6)) {
            double firstVectorInvLength = 1.0 / EuclidCoreTools.squareRoot((double)firstVectorNormSquared);
            firstVectorX *= firstVectorInvLength;
            firstVectorY *= firstVectorInvLength;
            firstVectorZ *= firstVectorInvLength;
        }
        if (!isSecondVectorUnitary && !EuclidCoreTools.epsilonEquals((double)(secondVectorNormSquared = EuclidCoreTools.normSquared((double)secondVectorX, (double)secondVectorY, (double)secondVectorZ)), (double)1.0, (double)1.0E-6)) {
            double secondVectorInvLength = 1.0 / EuclidCoreTools.squareRoot((double)secondVectorNormSquared);
            secondVectorX *= secondVectorInvLength;
            secondVectorY *= secondVectorInvLength;
            secondVectorZ *= secondVectorInvLength;
        }
        boolean bl = vectorsAreParallel = (crossNormSquared = EuclidCoreTools.normSquared((double)(axisX = firstVectorY * secondVectorZ - firstVectorZ * secondVectorY), (double)(axisY = firstVectorZ * secondVectorX - firstVectorX * secondVectorZ), (double)(axisZ = firstVectorX * secondVectorY - firstVectorY * secondVectorX))) < 9.999999999999998E-15;
        if (vectorsAreParallel) {
            double dot = secondVectorX * firstVectorX;
            dot += secondVectorY * firstVectorY;
            if ((dot += secondVectorZ * firstVectorZ) > 0.0) {
                rotationToPack.setToZero();
            } else {
                rotationToPack.setQuaternion(1.0, 0.0, 0.0, 0.0);
            }
            return;
        }
        double dotProduct = firstVectorX * secondVectorX + firstVectorY * secondVectorY + firstVectorZ * secondVectorZ;
        double qs = 1.0 + dotProduct;
        double norm = 1.0 / EuclidCoreTools.norm((double)axisX, (double)axisY, (double)axisZ, (double)qs);
        rotationToPack.setQuaternion(axisX * norm, axisY * norm, axisZ * norm, qs * norm);
    }

    public static void orientation3DFromFirstToSecondVector3D(Vector3DReadOnly firstVector, Vector3DReadOnly secondVector, Orientation3DBasics rotationToPack) {
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D(firstVector.getX(), firstVector.getY(), firstVector.getZ(), firstVector instanceof UnitVector3DReadOnly, secondVector.getX(), secondVector.getY(), secondVector.getZ(), secondVector instanceof UnitVector3DReadOnly, rotationToPack);
    }

    public static AxisAngle axisAngleFromFirstToSecondVector3D(Vector3DReadOnly firstVector, Vector3DReadOnly secondVector) {
        AxisAngle axisAngle = new AxisAngle();
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D(firstVector, secondVector, (Orientation3DBasics)axisAngle);
        return axisAngle;
    }

    public static AxisAngle axisAngleFromZUpToVector3D(Vector3DReadOnly vector) {
        AxisAngle axisAngle = new AxisAngle();
        EuclidGeometryTools.orientation3DFromZUpToVector3D(vector, (Orientation3DBasics)axisAngle);
        return axisAngle;
    }

    public static void orientation3DFromZUpToVector3D(Vector3DReadOnly vector, Orientation3DBasics rotationToPack) {
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.Z, vector, rotationToPack);
    }

    public static double closestPoint3DsBetweenTwoLine3Ds(Point3DReadOnly pointOnLine1, Vector3DReadOnly lineDirection1, Point3DReadOnly pointOnLine2, Vector3DReadOnly lineDirection2, Point3DBasics closestPointOnLine1ToPack, Point3DBasics closestPointOnLine2ToPack) {
        double tc;
        double sc;
        Point3DReadOnly P0 = pointOnLine1;
        Vector3DReadOnly u = lineDirection1;
        Point3DReadOnly Q0 = pointOnLine2;
        Vector3DReadOnly v = lineDirection2;
        Point3DBasics Psc = closestPointOnLine1ToPack;
        Point3DBasics Qtc = closestPointOnLine2ToPack;
        double w0X = P0.getX() - Q0.getX();
        double w0Y = P0.getY() - Q0.getY();
        double w0Z = P0.getZ() - Q0.getZ();
        double a = u.dot((Tuple3DReadOnly)u);
        double b = u.dot((Tuple3DReadOnly)v);
        double c = v.dot((Tuple3DReadOnly)v);
        double d = u.getX() * w0X + u.getY() * w0Y + u.getZ() * w0Z;
        double e = v.getX() * w0X + v.getY() * w0Y + v.getZ() * w0Z;
        double delta = a * c - b * b;
        if (delta <= 1.0E-12) {
            sc = 0.0;
            tc = d / b;
        } else {
            sc = (b * e - c * d) / delta;
            tc = (a * e - b * d) / delta;
        }
        double PscX = sc * u.getX() + P0.getX();
        double PscY = sc * u.getY() + P0.getY();
        double PscZ = sc * u.getZ() + P0.getZ();
        double QtcX = tc * v.getX() + Q0.getX();
        double QtcY = tc * v.getY() + Q0.getY();
        double QtcZ = tc * v.getZ() + Q0.getZ();
        if (Psc != null) {
            Psc.set(PscX, PscY, PscZ);
        }
        if (Qtc != null) {
            Qtc.set(QtcX, QtcY, QtcZ);
        }
        double dx = PscX - QtcX;
        double dy = PscY - QtcY;
        double dz = PscZ - QtcZ;
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        return EuclidCoreTools.squareRoot((double)distanceSquared);
    }

    public static double closestPoint2DsBetweenTwoLineSegment2Ds(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2, Point2DBasics closestPointOnLineSegment1ToPack, Point2DBasics closestPointOnLineSegment2ToPack) {
        return EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds(lineSegmentStart1.getX(), lineSegmentStart1.getY(), lineSegmentEnd1.getX(), lineSegmentEnd1.getY(), lineSegmentStart2.getX(), lineSegmentStart2.getY(), lineSegmentEnd2.getX(), lineSegmentEnd2.getY(), closestPointOnLineSegment1ToPack, closestPointOnLineSegment2ToPack);
    }

    public static double closestPoint2DsBetweenTwoLineSegment2Ds(double lineSegmentStart1X, double lineSegmentStart1Y, double lineSegmentEnd1X, double lineSegmentEnd1Y, double lineSegmentStart2X, double lineSegmentStart2Y, double lineSegmentEnd2X, double lineSegmentEnd2Y, Point2DBasics closestPointOnLineSegment1ToPack, Point2DBasics closestPointOnLineSegment2ToPack) {
        double tNumerator;
        double sNumerator;
        double delta;
        double P0X = lineSegmentStart1X;
        double P0Y = lineSegmentStart1Y;
        double ux = lineSegmentEnd1X - lineSegmentStart1X;
        double uy = lineSegmentEnd1Y - lineSegmentStart1Y;
        double Q0X = lineSegmentStart2X;
        double Q0Y = lineSegmentStart2Y;
        double vx = lineSegmentEnd2X - lineSegmentStart2X;
        double vy = lineSegmentEnd2Y - lineSegmentStart2Y;
        Point2DBasics Psc = closestPointOnLineSegment1ToPack;
        Point2DBasics Qtc = closestPointOnLineSegment2ToPack;
        double w0X = P0X - Q0X;
        double w0Y = P0Y - Q0Y;
        double a = ux * ux + uy * uy;
        double b = ux * vx + uy * vy;
        double c = vx * vx + vy * vy;
        double d = ux * w0X + uy * w0Y;
        double e = vx * w0X + vy * w0Y;
        double ac = a * c;
        double bb = b * b;
        double sDenominator = delta = ac - bb;
        double tDenominator = delta;
        if (delta <= 1.0E-12 * Math.max(ac, bb)) {
            sNumerator = 0.0;
            sDenominator = 1.0;
            tNumerator = e;
            tDenominator = c;
        } else {
            sNumerator = b * e - c * d;
            tNumerator = a * e - b * d;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
                tNumerator = e;
                tDenominator = c;
            } else if (sNumerator > sDenominator) {
                sNumerator = sDenominator;
                tNumerator = e + b;
                tDenominator = c;
            }
        }
        if (tNumerator < 0.0) {
            tNumerator = 0.0;
            sNumerator = -d;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
            } else if (sNumerator > a) {
                sNumerator = a;
            }
            sDenominator = a;
        } else if (tNumerator > tDenominator) {
            tNumerator = tDenominator;
            sNumerator = -d + b;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
            } else if (sNumerator > a) {
                sNumerator = a;
            }
            sDenominator = a;
        }
        double sc = Math.abs(sNumerator) < 1.0E-12 ? 0.0 : sNumerator / sDenominator;
        double tc = Math.abs(tNumerator) < 1.0E-12 ? 0.0 : tNumerator / tDenominator;
        double PscX = sc * ux + P0X;
        double PscY = sc * uy + P0Y;
        double QtcX = tc * vx + Q0X;
        double QtcY = tc * vy + Q0Y;
        if (Psc != null) {
            Psc.set(PscX, PscY);
        }
        if (Qtc != null) {
            Qtc.set(QtcX, QtcY);
        }
        double dx = PscX - QtcX;
        double dy = PscY - QtcY;
        return EuclidCoreTools.norm((double)dx, (double)dy);
    }

    public static double closestPoint3DsBetweenTwoLineSegment3Ds(Point3DReadOnly lineSegmentStart1, Point3DReadOnly lineSegmentEnd1, Point3DReadOnly lineSegmentStart2, Point3DReadOnly lineSegmentEnd2, Point3DBasics closestPointOnLineSegment1ToPack, Point3DBasics closestPointOnLineSegment2ToPack) {
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds(lineSegmentStart1.getX(), lineSegmentStart1.getY(), lineSegmentStart1.getZ(), lineSegmentEnd1.getX(), lineSegmentEnd1.getY(), lineSegmentEnd1.getZ(), lineSegmentStart2.getX(), lineSegmentStart2.getY(), lineSegmentStart2.getZ(), lineSegmentEnd2.getX(), lineSegmentEnd2.getY(), lineSegmentEnd2.getZ(), closestPointOnLineSegment1ToPack, closestPointOnLineSegment2ToPack);
    }

    public static double closestPoint3DsBetweenTwoLineSegment3Ds(double lineSegmentStart1X, double lineSegmentStart1Y, double lineSegmentStart1Z, double lineSegmentEnd1X, double lineSegmentEnd1Y, double lineSegmentEnd1Z, double lineSegmentStart2X, double lineSegmentStart2Y, double lineSegmentStart2Z, double lineSegmentEnd2X, double lineSegmentEnd2Y, double lineSegmentEnd2Z, Point3DBasics closestPointOnLineSegment1ToPack, Point3DBasics closestPointOnLineSegment2ToPack) {
        double tNumerator;
        double sNumerator;
        double delta;
        double P0X = lineSegmentStart1X;
        double P0Y = lineSegmentStart1Y;
        double P0Z = lineSegmentStart1Z;
        double ux = lineSegmentEnd1X - lineSegmentStart1X;
        double uy = lineSegmentEnd1Y - lineSegmentStart1Y;
        double uz = lineSegmentEnd1Z - lineSegmentStart1Z;
        double Q0X = lineSegmentStart2X;
        double Q0Y = lineSegmentStart2Y;
        double Q0Z = lineSegmentStart2Z;
        double vx = lineSegmentEnd2X - lineSegmentStart2X;
        double vy = lineSegmentEnd2Y - lineSegmentStart2Y;
        double vz = lineSegmentEnd2Z - lineSegmentStart2Z;
        Point3DBasics Psc = closestPointOnLineSegment1ToPack;
        Point3DBasics Qtc = closestPointOnLineSegment2ToPack;
        double w0X = P0X - Q0X;
        double w0Y = P0Y - Q0Y;
        double w0Z = P0Z - Q0Z;
        double a = ux * ux + uy * uy + uz * uz;
        double b = ux * vx + uy * vy + uz * vz;
        double c = vx * vx + vy * vy + vz * vz;
        double d = ux * w0X + uy * w0Y + uz * w0Z;
        double e = vx * w0X + vy * w0Y + vz * w0Z;
        double ac = a * c;
        double bb = b * b;
        double sDenominator = delta = ac - bb;
        double tDenominator = delta;
        if (delta <= 1.0E-12 * Math.max(ac, bb)) {
            sNumerator = 0.0;
            sDenominator = 1.0;
            tNumerator = e;
            tDenominator = c;
        } else {
            sNumerator = b * e - c * d;
            tNumerator = a * e - b * d;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
                tNumerator = e;
                tDenominator = c;
            } else if (sNumerator > sDenominator) {
                sNumerator = sDenominator;
                tNumerator = e + b;
                tDenominator = c;
            }
        }
        if (tNumerator < 0.0) {
            tNumerator = 0.0;
            sNumerator = -d;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
            } else if (sNumerator > a) {
                sNumerator = a;
            }
            sDenominator = a;
        } else if (tNumerator > tDenominator) {
            tNumerator = tDenominator;
            sNumerator = -d + b;
            if (sNumerator < 0.0) {
                sNumerator = 0.0;
            } else if (sNumerator > a) {
                sNumerator = a;
            }
            sDenominator = a;
        }
        double sc = Math.abs(sNumerator) < 1.0E-12 ? 0.0 : sNumerator / sDenominator;
        double tc = Math.abs(tNumerator) < 1.0E-12 ? 0.0 : tNumerator / tDenominator;
        double PscX = sc * ux + P0X;
        double PscY = sc * uy + P0Y;
        double PscZ = sc * uz + P0Z;
        double QtcX = tc * vx + Q0X;
        double QtcY = tc * vy + Q0Y;
        double QtcZ = tc * vz + Q0Z;
        if (Psc != null) {
            Psc.set(PscX, PscY, PscZ);
        }
        if (Qtc != null) {
            Qtc.set(QtcX, QtcY, QtcZ);
        }
        double dx = PscX - QtcX;
        double dy = PscY - QtcY;
        double dz = PscZ - QtcZ;
        return EuclidCoreTools.norm((double)dx, (double)dy, (double)dz);
    }

    public static double triangleArea(Point2DReadOnly a, Point2DReadOnly b, Point2DReadOnly c) {
        return Math.abs(0.5 * (a.getX() * (b.getY() - c.getY()) + b.getX() * (c.getY() - a.getY()) + c.getX() * (a.getY() - b.getY())));
    }

    public static double triangleArea(Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c) {
        return EuclidGeometryTools.triangleAreaHeron2(a.distanceSquared(b), b.distanceSquared(c), c.distanceSquared(a));
    }

    public static double triangleAreaHeron1(double lengthA, double lengthB, double lengthC) {
        double s = 0.5 * (lengthA + lengthB + lengthC);
        return EuclidCoreTools.squareRoot((double)(s * (s - lengthA) * (s - lengthB) * (s - lengthC)));
    }

    public static double triangleAreaHeron2(double lengthSquaredA, double lengthSquaredB, double lengthSquaredC) {
        double areaPt1 = lengthSquaredA * lengthSquaredB;
        areaPt1 += lengthSquaredA * lengthSquaredC;
        double areaPt2 = lengthSquaredA + lengthSquaredB + lengthSquaredC;
        double areaPt3 = 4.0 * (areaPt1 += lengthSquaredB * lengthSquaredC) - areaPt2 * areaPt2;
        return areaPt3 <= 0.0 ? 0.0 : 0.25 * EuclidCoreTools.squareRoot((double)areaPt3);
    }

    public static boolean triangleCircumcenter(Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DBasics circumcenterToPack) {
        double ASquared = A.distanceFromOriginSquared();
        double BSquared = B.distanceFromOriginSquared();
        double CSquared = C.distanceFromOriginSquared();
        double ByCy = B.getY() - C.getY();
        double CxBx = C.getX() - B.getX();
        double a = 0.5 / (A.getX() * ByCy + A.getY() * CxBx + B.getX() * C.getY() - B.getY() * C.getX());
        if (!Double.isFinite(a)) {
            return false;
        }
        double CSquaredBSquared = CSquared - BSquared;
        double sx = ASquared * ByCy + A.getY() * CSquaredBSquared + BSquared * C.getY() - B.getY() * CSquared;
        double sy = -A.getX() * CSquaredBSquared + ASquared * CxBx + B.getX() * CSquared - BSquared * C.getX();
        circumcenterToPack.set(sx, sy);
        circumcenterToPack.scale(a);
        return true;
    }

    public static boolean triangleCircumcenter(Point3DReadOnly A, Point3DReadOnly B, Point3DReadOnly C, Point3DBasics circumcenterToPack) {
        double ux = B.getX() - C.getX();
        double uy = B.getY() - C.getY();
        double uz = B.getZ() - C.getZ();
        double vx = A.getX() - C.getX();
        double vy = A.getY() - C.getY();
        double vz = A.getZ() - C.getZ();
        double wx = A.getX() - B.getX();
        double wy = A.getY() - B.getY();
        double wz = A.getZ() - B.getZ();
        double uSquared = EuclidCoreTools.normSquared((double)ux, (double)uy, (double)uz);
        double vSquared = EuclidCoreTools.normSquared((double)vx, (double)vy, (double)vz);
        double wSquared = EuclidCoreTools.normSquared((double)wx, (double)wy, (double)wz);
        double uv = ux * vx + uy * vy + uz * vz;
        double uw = ux * wx + uy * wy + uz * wz;
        double vw = vx * wx + vy * wy + vz * wz;
        double ucwx = wy * uz - wz * uy;
        double ucwy = wz * ux - wx * uz;
        double ucwz = wx * uy - wy * ux;
        double ucwSquared = 0.5 / EuclidCoreTools.normSquared((double)ucwx, (double)ucwy, (double)ucwz);
        if (!Double.isFinite(ucwSquared)) {
            return false;
        }
        double alpha = uSquared * vw * ucwSquared;
        double beta = -vSquared * uw * ucwSquared;
        double gamma = wSquared * uv * ucwSquared;
        double px = alpha * A.getX() + beta * B.getX() + gamma * C.getX();
        double py = alpha * A.getY() + beta * B.getY() + gamma * C.getY();
        double pz = alpha * A.getZ() + beta * B.getZ() + gamma * C.getZ();
        circumcenterToPack.set(px, py, pz);
        return true;
    }

    public static double distanceBetweenPoint2Ds(double firstPointX, double firstPointY, double secondPointX, double secondPointY) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredBetweenPoint2Ds(firstPointX, firstPointY, secondPointX, secondPointY));
    }

    public static double distanceBetweenPoint2Ds(double firstPointX, double firstPointY, Point2DReadOnly secondPoint) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredBetweenPoint2Ds(firstPointX, firstPointY, secondPoint));
    }

    public static double distanceSquaredBetweenPoint2Ds(double firstPointX, double firstPointY, double secondPointX, double secondPointY) {
        double deltaX = secondPointX - firstPointX;
        double deltaY = secondPointY - firstPointY;
        return EuclidCoreTools.normSquared((double)deltaX, (double)deltaY);
    }

    public static double distanceSquaredBetweenPoint2Ds(double firstPointX, double firstPointY, Point2DReadOnly secondPoint) {
        double deltaX = secondPoint.getX() - firstPointX;
        double deltaY = secondPoint.getY() - firstPointY;
        return EuclidCoreTools.normSquared((double)deltaX, (double)deltaY);
    }

    public static double distanceBetweenPoint3Ds(double firstPointX, double firstPointY, double firstPointZ, double secondPointX, double secondPointY, double secondPointZ) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredBetweenPoint3Ds(firstPointX, firstPointY, firstPointZ, secondPointX, secondPointY, secondPointZ));
    }

    public static double distanceBetweenPoint3Ds(double firstPointX, double firstPointY, double firstPointZ, Point3DReadOnly secondPoint) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredBetweenPoint3Ds(firstPointX, firstPointY, firstPointZ, secondPoint));
    }

    public static double distanceSquaredBetweenPoint3Ds(double firstPointX, double firstPointY, double firstPointZ, double secondPointX, double secondPointY, double secondPointZ) {
        double deltaX = secondPointX - firstPointX;
        double deltaY = secondPointY - firstPointY;
        double deltaZ = secondPointZ - firstPointZ;
        return EuclidCoreTools.normSquared((double)deltaX, (double)deltaY, (double)deltaZ);
    }

    public static double distanceSquaredBetweenPoint3Ds(double firstPointX, double firstPointY, double firstPointZ, Point3DReadOnly secondPoint) {
        double deltaX = secondPoint.getX() - firstPointX;
        double deltaY = secondPoint.getY() - firstPointY;
        double deltaZ = secondPoint.getZ() - firstPointZ;
        return EuclidCoreTools.normSquared((double)deltaX, (double)deltaY, (double)deltaZ);
    }

    public static double distanceBetweenTwoLine3Ds(Point3DReadOnly pointOnLine1, Vector3DReadOnly lineDirection1, Point3DReadOnly pointOnLine2, Vector3DReadOnly lineDirection2) {
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds(pointOnLine1, lineDirection1, pointOnLine2, lineDirection2, null, null);
    }

    public static double distanceBetweenTwoLineSegment2Ds(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2) {
        return EuclidGeometryTools.closestPoint2DsBetweenTwoLineSegment2Ds(lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2, null, null);
    }

    public static double distanceBetweenTwoLineSegment3Ds(Point3DReadOnly lineSegmentStart1, Point3DReadOnly lineSegmentEnd1, Point3DReadOnly lineSegmentStart2, Point3DReadOnly lineSegmentEnd2) {
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLineSegment3Ds(lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2, null, null);
    }

    public static double distanceFromPoint2DToLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY, false);
    }

    private static double distanceFromPoint2DToLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, boolean isDirectionUnitary) {
        return Math.abs(EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY, isDirectionUnitary));
    }

    public static double distanceFromPoint2DToLine2D(double pointX, double pointY, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY);
    }

    public static double distanceFromPoint2DToLine2D(double pointX, double pointY, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(pointX, pointY, pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY(), lineDirection instanceof UnitVector2DReadOnly);
    }

    public static double distanceFromPoint2DToLine2D(Point2DReadOnly point, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(point.getX(), point.getY(), firstPointOnLine, secondPointOnLine);
    }

    public static double distanceFromPoint2DToLine2D(Point2DReadOnly point, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(point.getX(), point.getY(), pointOnLine, lineDirection);
    }

    public static double distanceFromPoint2DToLineSegment2D(double pointX, double pointY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D(pointX, pointY, lineSegmentStartX, lineSegmentStartY, lineSegmentEndX, lineSegmentEndY));
    }

    public static double distanceFromPoint2DToLineSegment2D(double pointX, double pointY, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D(pointX, pointY, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY());
    }

    public static double distanceFromPoint2DToLineSegment2D(Point2DReadOnly point, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D(point.getX(), point.getY(), lineSegmentStart, lineSegmentEnd);
    }

    public static double distanceFromPoint2DToRay2D(double pointX, double pointY, double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY) {
        return EuclidGeometryTools.distanceFromPoint2DToRay2D(pointX, pointY, rayOriginX, rayOriginY, rayDirectionX, rayDirectionY, false);
    }

    private static double distanceFromPoint2DToRay2D(double pointX, double pointY, double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY, boolean isDirectionUnitary) {
        if (EuclidGeometryTools.isPoint2DInFrontOfRay2D(pointX, pointY, rayOriginX, rayOriginY, rayDirectionX, rayDirectionY)) {
            return Math.abs(EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(pointX, pointY, rayOriginX, rayOriginY, rayDirectionX, rayDirectionY, isDirectionUnitary));
        }
        return EuclidGeometryTools.distanceBetweenPoint2Ds(pointX, pointY, rayOriginX, rayOriginY);
    }

    public static double distanceFromPoint2DToRay2D(double pointX, double pointY, Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection) {
        return EuclidGeometryTools.distanceFromPoint2DToRay2D(pointX, pointY, rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY(), rayDirection instanceof UnitVector2DReadOnly);
    }

    public static double distanceFromPoint2DToRay2D(Point2DReadOnly point, Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection) {
        return EuclidGeometryTools.distanceFromPoint2DToRay2D(point.getX(), point.getY(), rayOrigin, rayDirection);
    }

    public static double distanceFromPoint3DToLine3D(double pointX, double pointY, double pointZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ) {
        return EuclidGeometryTools.distanceFromPoint3DToLine3D(pointX, pointY, pointZ, pointOnLineX, pointOnLineY, pointOnLineZ, lineDirectionX, lineDirectionY, lineDirectionZ, false);
    }

    private static double distanceFromPoint3DToLine3D(double pointX, double pointY, double pointZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, boolean isDirectionUnitary) {
        double directionMagnitude = isDirectionUnitary ? 1.0 : EuclidCoreTools.fastNorm((double)lineDirectionX, (double)lineDirectionY, (double)lineDirectionZ);
        double dx = pointOnLineX - pointX;
        double dy = pointOnLineY - pointY;
        double dz = pointOnLineZ - pointZ;
        if (directionMagnitude < 1.0E-12) {
            return EuclidCoreTools.norm((double)dx, (double)dy, (double)dz);
        }
        double crossX = lineDirectionY * dz - lineDirectionZ * dy;
        double crossY = lineDirectionZ * dx - lineDirectionX * dz;
        double crossZ = lineDirectionX * dy - lineDirectionY * dx;
        double distance = EuclidCoreTools.norm((double)crossX, (double)crossY, (double)crossZ);
        return distance /= directionMagnitude;
    }

    public static double distanceFromPoint3DToLine3D(Point3DReadOnly point, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine) {
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double pointOnLineZ = firstPointOnLine.getZ();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        double lineDirectionZ = secondPointOnLine.getZ() - firstPointOnLine.getZ();
        return EuclidGeometryTools.distanceFromPoint3DToLine3D(point.getX(), point.getY(), point.getZ(), pointOnLineX, pointOnLineY, pointOnLineZ, lineDirectionX, lineDirectionY, lineDirectionZ);
    }

    public static double distanceFromPoint3DToLine3D(Point3DReadOnly point, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        return EuclidGeometryTools.distanceFromPoint3DToLine3D(point.getX(), point.getY(), point.getZ(), pointOnLine.getX(), pointOnLine.getY(), pointOnLine.getZ(), lineDirection.getX(), lineDirection.getY(), lineDirection.getZ());
    }

    public static double distanceFromPoint3DToLineSegment3D(double pointX, double pointY, double pointZ, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentStartZ, double lineSegmentEndX, double lineSegmentEndY, double lineSegmentEndZ) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D(pointX, pointY, pointZ, lineSegmentStartX, lineSegmentStartY, lineSegmentStartZ, lineSegmentEndX, lineSegmentEndY, lineSegmentEndZ));
    }

    public static double distanceFromPoint3DToLineSegment3D(double pointX, double pointY, double pointZ, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return EuclidCoreTools.squareRoot((double)EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D(pointX, pointY, pointZ, lineSegmentStart, lineSegmentEnd));
    }

    public static double distanceFromPoint3DToLineSegment3D(Point3DReadOnly point, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceFromPoint3DToLineSegment3D(point.getX(), point.getY(), point.getZ(), lineSegmentStart, lineSegmentEnd);
    }

    public static double distanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return Math.abs(EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(pointX, pointY, pointZ, pointOnPlane, planeNormal));
    }

    public static double distanceFromPoint3DToPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return Math.abs(EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(point, pointOnPlane, planeNormal));
    }

    public static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(pointX, pointY, pointZ, pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ, planeNormalX, planeNormalY, planeNormalZ, false);
    }

    private static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ, boolean isNormalUnitary) {
        double dx = pointX - pointOnPlaneX;
        double dy = pointY - pointOnPlaneY;
        double dz = pointZ - pointOnPlaneZ;
        if (isNormalUnitary) {
            return dx * planeNormalX + dy * planeNormalY + dz * planeNormalZ;
        }
        double normalMagnitude = EuclidCoreTools.normSquared((double)planeNormalX, (double)planeNormalY, (double)planeNormalZ);
        if (normalMagnitude < 1.0E-12) {
            return EuclidCoreTools.norm((double)dx, (double)dy, (double)dz);
        }
        return (dx * planeNormalX + dy * planeNormalY + dz * planeNormalZ) / EuclidCoreTools.squareRoot((double)normalMagnitude);
    }

    public static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeFirstTangentX, double planeFirstTangentY, double planeFirstTangentZ, double planeSecondTangentX, double planeSecondTangentY, double planeSecondTangentZ) {
        double planeNormalX = planeFirstTangentY * planeSecondTangentZ - planeFirstTangentZ * planeSecondTangentY;
        double planeNormalY = planeFirstTangentZ * planeSecondTangentX - planeFirstTangentX * planeSecondTangentZ;
        double planeNormalZ = planeFirstTangentX * planeSecondTangentY - planeFirstTangentY * planeSecondTangentX;
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(pointX, pointY, pointZ, pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ, planeNormalX, planeNormalY, planeNormalZ);
    }

    public static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(pointX, pointY, pointZ, pointOnPlane.getX(), pointOnPlane.getY(), pointOnPlane.getZ(), planeNormal.getX(), planeNormal.getY(), planeNormal.getZ(), planeNormal instanceof UnitVector3DReadOnly);
    }

    public static double signedDistanceFromPoint3DToPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(point.getX(), point.getY(), point.getZ(), pointOnPlane, planeNormal);
    }

    public static double signedDistanceFromPoint3DToPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(pointX, pointY, pointZ, pointOnPlane.getX(), pointOnPlane.getY(), pointOnPlane.getZ(), planeFirstTangent.getX(), planeFirstTangent.getY(), planeFirstTangent.getZ(), planeSecondTangent.getX(), planeSecondTangent.getY(), planeSecondTangent.getZ());
    }

    public static double signedDistanceFromPoint3DToPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(point.getX(), point.getY(), point.getZ(), pointOnPlane, planeFirstTangent, planeSecondTangent);
    }

    public static double distanceSquaredFromPoint2DToLineSegment2D(double pointX, double pointY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment2D(pointX, pointY, lineSegmentStartX, lineSegmentStartY, lineSegmentEndX, lineSegmentEndY);
        if (percentage > 1.0) {
            percentage = 1.0;
        } else if (percentage < 0.0) {
            percentage = 0.0;
        }
        double projectionX = (1.0 - percentage) * lineSegmentStartX + percentage * lineSegmentEndX;
        double projectionY = (1.0 - percentage) * lineSegmentStartY + percentage * lineSegmentEndY;
        double dx = projectionX - pointX;
        double dy = projectionY - pointY;
        return dx * dx + dy * dy;
    }

    public static double distanceSquaredFromPoint2DToLineSegment2D(double pointX, double pointY, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D(pointX, pointY, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY());
    }

    public static double distanceSquaredFromPoint2DToLineSegment2D(Point2DReadOnly point, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D(point.getX(), point.getY(), lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY());
    }

    public static double distanceSquaredFromPoint3DToLineSegment3D(double pointX, double pointY, double pointZ, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D(pointX, pointY, pointZ, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentStart.getZ(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), lineSegmentEnd.getZ());
    }

    public static double distanceSquaredFromPoint3DToLineSegment3D(double pointX, double pointY, double pointZ, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentStartZ, double lineSegmentEndX, double lineSegmentEndY, double lineSegmentEndZ) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment3D(pointX, pointY, pointZ, lineSegmentStartX, lineSegmentStartY, lineSegmentStartZ, lineSegmentEndX, lineSegmentEndY, lineSegmentEndZ);
        if (percentage > 1.0) {
            percentage = 1.0;
        } else if (percentage < 0.0) {
            percentage = 0.0;
        }
        double oneMinusPercentage = 1.0 - percentage;
        double projectionX = oneMinusPercentage * lineSegmentStartX + percentage * lineSegmentEndX;
        double projectionY = oneMinusPercentage * lineSegmentStartY + percentage * lineSegmentEndY;
        double projectionZ = oneMinusPercentage * lineSegmentStartZ + percentage * lineSegmentEndZ;
        double dx = projectionX - pointX;
        double dy = projectionY - pointY;
        double dz = projectionZ - pointZ;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distanceSquaredFromPoint3DToLineSegment3D(Point3DReadOnly point, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D(point.getX(), point.getY(), point.getZ(), lineSegmentStart, lineSegmentEnd);
    }

    public static boolean doesLineSegment3DIntersectPlane3D(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        double d = -planeNormal.getX() * pointOnPlane.getX();
        d -= planeNormal.getY() * pointOnPlane.getY();
        double ansStart = planeNormal.getX() * lineSegmentStart.getX();
        ansStart += planeNormal.getY() * lineSegmentStart.getY();
        ansStart += planeNormal.getZ() * lineSegmentStart.getZ();
        double ansEnd = planeNormal.getX() * lineSegmentEnd.getX();
        ansEnd += planeNormal.getY() * lineSegmentEnd.getY();
        ansEnd += planeNormal.getZ() * lineSegmentEnd.getZ();
        return (ansStart += (d -= planeNormal.getZ() * pointOnPlane.getZ())) * (ansEnd += d) < 0.0;
    }

    public static boolean doLine2DAndLineSegment2DIntersect(double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), null);
    }

    public static boolean doLine2DAndLineSegment2DIntersect(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(pointOnLine, lineDirection, lineSegmentStart, lineSegmentEnd, null);
    }

    public static boolean doLineSegment2DsIntersect(double lineSegmentStart1x, double lineSegmentStart1y, double lineSegmentEnd1x, double lineSegmentEnd1y, double lineSegmentStart2x, double lineSegmentStart2y, double lineSegmentEnd2x, double lineSegmentEnd2y) {
        return EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds(lineSegmentStart1x, lineSegmentStart1y, lineSegmentEnd1x, lineSegmentEnd1y, lineSegmentStart2x, lineSegmentStart2y, lineSegmentEnd2x, lineSegmentEnd2y, null);
    }

    public static boolean doLineSegment2DsIntersect(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2) {
        return EuclidGeometryTools.doLineSegment2DsIntersect(lineSegmentStart1.getX(), lineSegmentStart1.getY(), lineSegmentEnd1.getX(), lineSegmentEnd1.getY(), lineSegmentStart2.getX(), lineSegmentStart2.getY(), lineSegmentEnd2.getX(), lineSegmentEnd2.getY());
    }

    public static boolean doRay2DAndLineSegment2DIntersect(double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY) {
        return EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D(rayOriginX, rayOriginY, rayDirectionX, rayDirectionY, lineSegmentStartX, lineSegmentStartY, lineSegmentEndX, lineSegmentEndY, null);
    }

    public static boolean doRay2DAndLineSegment2DIntersect(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.doRay2DAndLineSegment2DIntersect(rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY(), lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY());
    }

    public static double dotProduct(Point2DReadOnly start1, Point2DReadOnly end1, Point2DReadOnly start2, Point2DReadOnly end2) {
        double vector1X = end1.getX() - start1.getX();
        double vector1Y = end1.getY() - start1.getY();
        double vector2X = end2.getX() - start2.getX();
        double vector2Y = end2.getY() - start2.getY();
        return vector1X * vector2X + vector1Y * vector2Y;
    }

    public static double dotProduct(Point3DReadOnly start1, Point3DReadOnly end1, Point3DReadOnly start2, Point3DReadOnly end2) {
        double vector1X = end1.getX() - start1.getX();
        double vector1Y = end1.getY() - start1.getY();
        double vector1Z = end1.getZ() - start1.getZ();
        double vector2X = end2.getX() - start2.getX();
        double vector2Y = end2.getY() - start2.getY();
        double vector2Z = end2.getZ() - start2.getZ();
        return vector1X * vector2X + vector1Y * vector2Y + vector1Z * vector2Z;
    }

    public static int intersectionBetweenLine2DAndBoundingBox2D(Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2DImpl(boundingBoxMin, boundingBoxMax, firstPointOnLine.getX(), firstPointOnLine.getY(), true, secondPointOnLine.getX(), secondPointOnLine.getY(), true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine2DAndBoundingBox2D(Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        double firstPointOnLineX = pointOnLine.getX();
        double firstPointOnLineY = pointOnLine.getY();
        double secondPointOnLineX = pointOnLine.getX() + lineDirection.getX();
        double secondPointOnLineY = pointOnLine.getY() + lineDirection.getY();
        return EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2DImpl(boundingBoxMin, boundingBoxMax, firstPointOnLineX, firstPointOnLineY, true, secondPointOnLineX, secondPointOnLineY, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    private static int intersectionBetweenLine2DAndBoundingBox2DImpl(Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax, double startX, double startY, boolean canIntersectionOccurBeforeStart, double endX, double endY, boolean canIntersectionOccurAfterEnd, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        boolean isIntersectingAtTmax;
        double tymax;
        double tymin;
        double tmax;
        double tmin;
        if (boundingBoxMin.getX() > boundingBoxMax.getX() || boundingBoxMin.getY() > boundingBoxMax.getY()) {
            throw new BoundingBoxException(boundingBoxMin, boundingBoxMax);
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setToNaN();
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setToNaN();
        }
        double dx = endX - startX;
        double dy = endY - startY;
        double invXDir = 1.0 / dx;
        double invYDir = 1.0 / dy;
        if (invXDir > 0.0) {
            tmin = (boundingBoxMin.getX() - startX) * invXDir;
            tmax = (boundingBoxMax.getX() - startX) * invXDir;
        } else {
            tmin = (boundingBoxMax.getX() - startX) * invXDir;
            tmax = (boundingBoxMin.getX() - startX) * invXDir;
        }
        if (invYDir > 0.0) {
            tymin = (boundingBoxMin.getY() - startY) * invYDir;
            tymax = (boundingBoxMax.getY() - startY) * invYDir;
        } else {
            tymin = (boundingBoxMax.getY() - startY) * invYDir;
            tymax = (boundingBoxMin.getY() - startY) * invYDir;
        }
        if (tmin > tymax || tmax < tymin) {
            return 0;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        if (!canIntersectionOccurAfterEnd && tmin > 1.0) {
            return 0;
        }
        if (!canIntersectionOccurBeforeStart && tmax < 0.0) {
            return 0;
        }
        int numberOfIntersections = 0;
        boolean isIntersectingAtTmin = canIntersectionOccurBeforeStart || tmin >= 0.0;
        boolean bl = isIntersectingAtTmax = canIntersectionOccurAfterEnd || tmax <= 1.0;
        if (isIntersectingAtTmin) {
            ++numberOfIntersections;
        }
        if (isIntersectingAtTmax) {
            ++numberOfIntersections;
        }
        switch (numberOfIntersections) {
            case 0: {
                return 0;
            }
            case 1: {
                if (firstIntersectionToPack != null) {
                    if (isIntersectingAtTmin) {
                        firstIntersectionToPack.set(tmin * dx + startX, tmin * dy + startY);
                    } else {
                        firstIntersectionToPack.set(tmax * dx + startX, tmax * dy + startY);
                    }
                }
                if (secondIntersectionToPack != null) {
                    secondIntersectionToPack.setToNaN();
                }
                return 1;
            }
            case 2: {
                if (firstIntersectionToPack != null) {
                    firstIntersectionToPack.set(tmin * dx + startX, tmin * dy + startY);
                }
                if (secondIntersectionToPack != null) {
                    secondIntersectionToPack.set(tmax * dx + startX, tmax * dy + startY);
                }
                return 2;
            }
        }
        throw new IllegalStateException("Unexpected number of intersections. Should either be 0, 1, or 2, but is: " + numberOfIntersections);
    }

    public static boolean intersectionBetweenLine2DAndLineSegment2D(double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY, Point2DBasics intersectionToPack) {
        double lineSegmentDirectionX = lineSegmentEndX - lineSegmentStartX;
        double lineSegmentDirectionY = lineSegmentEndY - lineSegmentStartY;
        double percentage = EuclidGeometryTools.percentageOfIntersectionBetweenTwoLine2Ds(lineSegmentStartX, lineSegmentStartY, lineSegmentDirectionX, lineSegmentDirectionY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY);
        if (Double.isInfinite(percentage)) {
            if (intersectionToPack != null) {
                intersectionToPack.set(lineSegmentStartX, lineSegmentStartY);
            }
            return true;
        }
        if (Double.isNaN(percentage) || percentage < -1.0E-7 || percentage > 1.0000001) {
            if (intersectionToPack != null) {
                intersectionToPack.setToNaN();
            }
            return false;
        }
        if (intersectionToPack != null) {
            intersectionToPack.set(EuclidCoreTools.interpolate((double)lineSegmentStartX, (double)lineSegmentEndX, (double)percentage), EuclidCoreTools.interpolate((double)lineSegmentStartY, (double)lineSegmentEndY, (double)percentage));
        }
        return true;
    }

    private static boolean intersectionBetweenTwoLine2DsImpl(double start1x, double start1y, boolean canIntersectionOccurBeforeStart1, double end1x, double end1y, boolean canIntersectionOccurBeforeEnd1, double start2x, double start2y, boolean canIntersectionOccurBeforeStart2, double end2x, double end2y, boolean canIntersectionOccurBeforeEnd2, Point2DBasics intersectionToPack) {
        boolean areIntersecting;
        double epsilon = 1.0E-7;
        double direction1x = end1x - start1x;
        double direction1y = end1y - start1y;
        double direction2x = end2x - start2x;
        double direction2y = end2y - start2y;
        double determinant = -direction1x * direction2y + direction1y * direction2x;
        double zeroish = 0.0 - epsilon;
        if (Math.abs(determinant) < epsilon) {
            double dx = start2x - start1x;
            double dy = start2y - start1y;
            double cross = dx * direction1y - dy * direction1x;
            if (Math.abs(cross) < epsilon) {
                if (canIntersectionOccurBeforeStart1 && canIntersectionOccurBeforeEnd1) {
                    if (canIntersectionOccurBeforeStart2 && canIntersectionOccurBeforeEnd2) {
                        if (intersectionToPack != null) {
                            intersectionToPack.set(start1x, start1y);
                        }
                        return true;
                    }
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start2x, start2y);
                    }
                    return true;
                }
                if (canIntersectionOccurBeforeStart2 && canIntersectionOccurBeforeEnd2) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start1x, start1y);
                    }
                    return true;
                }
                double direction1LengthSquare = EuclidCoreTools.normSquared((double)direction1x, (double)direction1y);
                dx = start2x - start1x;
                dy = start2y - start1y;
                double dot = dx * direction1x + dy * direction1y;
                if ((canIntersectionOccurBeforeStart1 || zeroish < dot) && (canIntersectionOccurBeforeEnd1 || dot < direction1LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start2x, start2y);
                    }
                    return true;
                }
                dx = end2x - start1x;
                dy = end2y - start1y;
                dot = dx * direction1x + dy * direction1y;
                if ((canIntersectionOccurBeforeStart1 || zeroish < dot) && (canIntersectionOccurBeforeEnd1 || dot < direction1LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(end2x, end2y);
                    }
                    return true;
                }
                double direction2LengthSquare = EuclidCoreTools.normSquared((double)direction2x, (double)direction2y);
                dx = start1x - start2x;
                dy = start1y - start2y;
                dot = dx * direction2x + dy * direction2y;
                if ((canIntersectionOccurBeforeStart2 || zeroish < dot) && (canIntersectionOccurBeforeEnd2 || dot < direction2LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(start1x, start1y);
                    }
                    return true;
                }
                dx = end1x - start2x;
                dy = end1y - start2y;
                dot = dx * direction2x + dy * direction2y;
                if ((canIntersectionOccurBeforeStart2 || zeroish < dot) && (canIntersectionOccurBeforeEnd2 || dot < direction2LengthSquare + epsilon)) {
                    if (intersectionToPack != null) {
                        intersectionToPack.set(end1x, end1y);
                    }
                    return true;
                }
                if (intersectionToPack != null) {
                    intersectionToPack.setToNaN();
                }
                return false;
            }
            if (intersectionToPack != null) {
                intersectionToPack.setToNaN();
            }
            return false;
        }
        double dx = start2x - start1x;
        double dy = start2y - start1y;
        double oneOverDeterminant = 1.0 / determinant;
        double AInverse00 = -direction2y;
        double AInverse01 = direction2x;
        double AInverse10 = -direction1y;
        double AInverse11 = direction1x;
        double alpha = oneOverDeterminant * (AInverse00 * dx + AInverse01 * dy);
        double beta = oneOverDeterminant * (AInverse10 * dx + AInverse11 * dy);
        double oneish = 1.0 + epsilon;
        boolean bl = areIntersecting = (canIntersectionOccurBeforeStart1 || zeroish < alpha) && (canIntersectionOccurBeforeEnd1 || alpha < oneish);
        if (areIntersecting) {
            boolean bl2 = areIntersecting = (canIntersectionOccurBeforeStart2 || zeroish < beta) && (canIntersectionOccurBeforeEnd2 || beta < oneish);
        }
        if (intersectionToPack != null) {
            if (areIntersecting) {
                intersectionToPack.set(start1x + alpha * direction1x, start1y + alpha * direction1y);
            } else {
                intersectionToPack.setToNaN();
            }
        }
        return areIntersecting;
    }

    public static Point2D intersectionBetweenLine2DAndLineSegment2D(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        Point2D intersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(pointOnLine, lineDirection, lineSegmentStart, lineSegmentEnd, (Point2DBasics)intersection);
        if (!success) {
            return null;
        }
        return intersection;
    }

    public static boolean intersectionBetweenLine2DAndLineSegment2D(Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D(pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY(), lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), intersectionToPack);
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3DImpl(boundingBoxMin, boundingBoxMax, firstPointOnLine.getX(), firstPointOnLine.getY(), firstPointOnLine.getZ(), true, secondPointOnLine.getX(), secondPointOnLine.getY(), secondPointOnLine.getZ(), true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D(boundingBoxMin.getX(), boundingBoxMin.getY(), boundingBoxMin.getZ(), boundingBoxMax.getX(), boundingBoxMax.getY(), boundingBoxMax.getZ(), pointOnLine, lineDirection, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(double boundingBoxMinX, double boundingBoxMinY, double boundingBoxMinZ, double boundingBoxMaxX, double boundingBoxMaxY, double boundingBoxMaxZ, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double firstPointOnLineX = pointOnLine.getX();
        double firstPointOnLineY = pointOnLine.getY();
        double firstPointOnLineZ = pointOnLine.getZ();
        double secondPointOnLineX = pointOnLine.getX() + lineDirection.getX();
        double secondPointOnLineY = pointOnLine.getY() + lineDirection.getY();
        double secondPointOnLineZ = pointOnLine.getZ() + lineDirection.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3DImpl(boundingBoxMinX, boundingBoxMinY, boundingBoxMinZ, boundingBoxMaxX, boundingBoxMaxY, boundingBoxMaxZ, firstPointOnLineX, firstPointOnLineY, firstPointOnLineZ, true, secondPointOnLineX, secondPointOnLineY, secondPointOnLineZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndBoundingBox3D(double boundingBoxMinX, double boundingBoxMinY, double boundingBoxMinZ, double boundingBoxMaxX, double boundingBoxMaxY, double boundingBoxMaxZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double firstPointOnLineX = pointOnLineX;
        double firstPointOnLineY = pointOnLineY;
        double firstPointOnLineZ = pointOnLineZ;
        double secondPointOnLineX = pointOnLineX + lineDirectionX;
        double secondPointOnLineY = pointOnLineY + lineDirectionY;
        double secondPointOnLineZ = pointOnLineZ + lineDirectionZ;
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3DImpl(boundingBoxMinX, boundingBoxMinY, boundingBoxMinZ, boundingBoxMaxX, boundingBoxMaxY, boundingBoxMaxZ, firstPointOnLineX, firstPointOnLineY, firstPointOnLineZ, true, secondPointOnLineX, secondPointOnLineY, secondPointOnLineZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    private static int intersectionBetweenLine3DAndBoundingBox3DImpl(Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax, double startX, double startY, double startZ, boolean canIntersectionOccurBeforeStart, double endX, double endY, double endZ, boolean canIntersectionOccurAfterEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3DImpl(boundingBoxMin.getX(), boundingBoxMin.getY(), boundingBoxMin.getZ(), boundingBoxMax.getX(), boundingBoxMax.getY(), boundingBoxMax.getZ(), startX, startY, startZ, canIntersectionOccurBeforeStart, endX, endY, endZ, canIntersectionOccurAfterEnd, firstIntersectionToPack, secondIntersectionToPack);
    }

    private static int intersectionBetweenLine3DAndBoundingBox3DImpl(double boundingBoxMinX, double boundingBoxMinY, double boundingBoxMinZ, double boundingBoxMaxX, double boundingBoxMaxY, double boundingBoxMaxZ, double startX, double startY, double startZ, boolean canIntersectionOccurBeforeStart, double endX, double endY, double endZ, boolean canIntersectionOccurAfterEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        boolean isIntersectingAtTmax;
        double tzmax;
        double tzmin;
        double tymax;
        double tymin;
        double tmax;
        double tmin;
        if (boundingBoxMinX > boundingBoxMaxX || boundingBoxMinY > boundingBoxMaxY || boundingBoxMinZ > boundingBoxMaxZ) {
            throw new BoundingBoxException(boundingBoxMinX, boundingBoxMinY, boundingBoxMinZ, boundingBoxMaxX, boundingBoxMaxY, boundingBoxMaxZ);
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setToNaN();
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setToNaN();
        }
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        double invXDir = 1.0 / dx;
        double invYDir = 1.0 / dy;
        double invZDir = 1.0 / dz;
        if (invXDir > 0.0) {
            tmin = (boundingBoxMinX - startX) * invXDir;
            tmax = (boundingBoxMaxX - startX) * invXDir;
        } else {
            tmin = (boundingBoxMaxX - startX) * invXDir;
            tmax = (boundingBoxMinX - startX) * invXDir;
        }
        if (invYDir > 0.0) {
            tymin = (boundingBoxMinY - startY) * invYDir;
            tymax = (boundingBoxMaxY - startY) * invYDir;
        } else {
            tymin = (boundingBoxMaxY - startY) * invYDir;
            tymax = (boundingBoxMinY - startY) * invYDir;
        }
        if (tmin > tymax || tmax < tymin) {
            return 0;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        if (invZDir > 0.0) {
            tzmin = (boundingBoxMinZ - startZ) * invZDir;
            tzmax = (boundingBoxMaxZ - startZ) * invZDir;
        } else {
            tzmin = (boundingBoxMaxZ - startZ) * invZDir;
            tzmax = (boundingBoxMinZ - startZ) * invZDir;
        }
        if (tmin > tzmax || tmax < tzmin) {
            return 0;
        }
        if (tzmin > tmin) {
            tmin = tzmin;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        if (!canIntersectionOccurAfterEnd && tmin > 1.0) {
            return 0;
        }
        if (!canIntersectionOccurBeforeStart && tmax < 0.0) {
            return 0;
        }
        int numberOfIntersections = 0;
        boolean isIntersectingAtTmin = canIntersectionOccurBeforeStart || tmin >= 0.0;
        boolean bl = isIntersectingAtTmax = canIntersectionOccurAfterEnd || tmax <= 1.0;
        if (isIntersectingAtTmin) {
            ++numberOfIntersections;
        }
        if (isIntersectingAtTmax) {
            ++numberOfIntersections;
        }
        switch (numberOfIntersections) {
            case 0: {
                return 0;
            }
            case 1: {
                if (firstIntersectionToPack != null) {
                    if (isIntersectingAtTmin) {
                        firstIntersectionToPack.set(tmin * dx + startX, tmin * dy + startY, tmin * dz + startZ);
                    } else {
                        firstIntersectionToPack.set(tmax * dx + startX, tmax * dy + startY, tmax * dz + startZ);
                    }
                }
                if (secondIntersectionToPack != null) {
                    secondIntersectionToPack.setToNaN();
                }
                return 1;
            }
            case 2: {
                if (firstIntersectionToPack != null) {
                    firstIntersectionToPack.set(tmin * dx + startX, tmin * dy + startY, tmin * dz + startZ);
                }
                if (secondIntersectionToPack != null) {
                    secondIntersectionToPack.set(tmax * dx + startX, tmax * dy + startY, tmax * dz + startZ);
                }
                return 2;
            }
        }
        throw new IllegalStateException("Unexpected number of intersections. Should either be 0, 1, or 2, but is: " + numberOfIntersections);
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, double cylinderPositionX, double cylinderPositionY, double cylinderPositionZ, double cylinderAxisX, double cylinderAxisY, double cylinderAxisZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double startX = pointOnLineX;
        double startY = pointOnLineY;
        double startZ = pointOnLineZ;
        double endX = pointOnLineX + lineDirectionX;
        double endY = pointOnLineY + lineDirectionY;
        double endZ = pointOnLineZ + lineDirectionZ;
        return EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3DImpl(cylinderLength, cylinderRadius, cylinderPositionX, cylinderPositionY, cylinderPositionZ, cylinderAxisX, cylinderAxisY, cylinderAxisZ, false, startX, startY, startZ, true, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, Point3DReadOnly cylinderPosition, Vector3DReadOnly cylinderAxis, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double cylinderPositionX = cylinderPosition.getX();
        double cylinderPositionY = cylinderPosition.getY();
        double cylinderPositionZ = cylinderPosition.getZ();
        double cylinderAxisX = cylinderAxis.getX();
        double cylinderAxisY = cylinderAxis.getY();
        double cylinderAxisZ = cylinderAxis.getZ();
        double startX = firstPointOnLine.getX();
        double startY = firstPointOnLine.getY();
        double startZ = firstPointOnLine.getZ();
        double endX = secondPointOnLine.getX();
        double endY = secondPointOnLine.getY();
        double endZ = secondPointOnLine.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3DImpl(cylinderLength, cylinderRadius, cylinderPositionX, cylinderPositionY, cylinderPositionZ, cylinderAxisX, cylinderAxisY, cylinderAxisZ, cylinderAxis instanceof UnitVector3DReadOnly, startX, startY, startZ, true, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndCylinder3D(double cylinderLength, double cylinderRadius, Point3DReadOnly cylinderPosition, Vector3DReadOnly cylinderAxis, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double cylinderPositionX = cylinderPosition.getX();
        double cylinderPositionY = cylinderPosition.getY();
        double cylinderPositionZ = cylinderPosition.getZ();
        double cylinderAxisX = cylinderAxis.getX();
        double cylinderAxisY = cylinderAxis.getY();
        double cylinderAxisZ = cylinderAxis.getZ();
        double startX = pointOnLine.getX();
        double startY = pointOnLine.getY();
        double startZ = pointOnLine.getZ();
        double endX = pointOnLine.getX() + lineDirection.getX();
        double endY = pointOnLine.getY() + lineDirection.getY();
        double endZ = pointOnLine.getZ() + lineDirection.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3DImpl(cylinderLength, cylinderRadius, cylinderPositionX, cylinderPositionY, cylinderPositionZ, cylinderAxisX, cylinderAxisY, cylinderAxisZ, cylinderAxis instanceof UnitVector3DReadOnly, startX, startY, startZ, true, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    private static int intersectionBetweenLine3DAndCylinder3DImpl(double cylinderLength, double cylinderRadius, double cylinderPositionX, double cylinderPositionY, double cylinderPositionZ, double cylinderAxisX, double cylinderAxisY, double cylinderAxisZ, boolean isAxisUnitary, double startX, double startY, double startZ, boolean canIntersectionOccurBeforeStart, double endX, double endY, double endZ, boolean canIntersectionOccurAfterEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double C;
        double A;
        double scaledAxisZ2;
        double CZ;
        double scaledAxisZ1;
        double AZ;
        double scaledAxisY2;
        double CY;
        double scaledAxisY1;
        double AY;
        double deltaPZ;
        double deltaPY;
        double linePositionToCylinderDotAxis;
        double scaledAxisX2;
        double deltaPX;
        double CX;
        double scaledAxisX1;
        double AX;
        double B;
        double delta;
        if (cylinderLength < 0.0) {
            throw new IllegalArgumentException("The cylinder length has to be positive.");
        }
        if (cylinderRadius < 0.0) {
            throw new IllegalArgumentException("The cylinder radius has to be positive.");
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setToNaN();
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setToNaN();
        }
        if (cylinderLength == 0.0 || cylinderRadius == 0.0) {
            return 0;
        }
        double axisNormInv = isAxisUnitary ? 1.0 : 1.0 / EuclidCoreTools.fastNorm((double)cylinderAxisX, (double)cylinderAxisY, (double)cylinderAxisZ);
        double axisX = cylinderAxisX * axisNormInv;
        double axisY = cylinderAxisY * axisNormInv;
        double axisZ = cylinderAxisZ * axisNormInv;
        double halfLength = 0.5 * cylinderLength;
        double radiusSquared = cylinderRadius * cylinderRadius;
        double dIntersection1 = Double.NaN;
        double dIntersection2 = Double.NaN;
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        double topX = halfLength * axisX + cylinderPositionX;
        double topY = halfLength * axisY + cylinderPositionY;
        double topZ = halfLength * axisZ + cylinderPositionZ;
        double bottomX = -halfLength * axisX + cylinderPositionX;
        double bottomY = -halfLength * axisY + cylinderPositionY;
        double bottomZ = -halfLength * axisZ + cylinderPositionZ;
        double lineDirectionDotCylinderAxis = dx * axisX + dy * axisY + dz * axisZ;
        if (Math.abs(lineDirectionDotCylinderAxis) >= 1.0E-12) {
            double dTop = Double.NaN;
            double numerator = (topX - startX) * axisX + (topY - startY) * axisY + (topZ - startZ) * axisZ;
            dTop = numerator / lineDirectionDotCylinderAxis;
            double intersectionX = dTop * dx + startX;
            double intersectionY = dTop * dy + startY;
            double intersectionZ = dTop * dz + startZ;
            if (EuclidGeometryTools.distanceSquaredBetweenPoint3Ds(intersectionX, intersectionY, intersectionZ, topX, topY, topZ) > radiusSquared) {
                dTop = Double.NaN;
            }
            if (Double.isFinite(dTop)) {
                dIntersection1 = dTop;
            }
            double dBottom = Double.NaN;
            double numerator2 = (bottomX - startX) * axisX + (bottomY - startY) * axisY + (bottomZ - startZ) * axisZ;
            dBottom = numerator2 / lineDirectionDotCylinderAxis;
            double intersectionX2 = dBottom * dx + startX;
            double intersectionY2 = dBottom * dy + startY;
            double intersectionZ2 = dBottom * dz + startZ;
            if (EuclidGeometryTools.distanceSquaredBetweenPoint3Ds(intersectionX2, intersectionY2, intersectionZ2, bottomX, bottomY, bottomZ) > radiusSquared) {
                dBottom = Double.NaN;
            }
            if (Double.isFinite(dBottom)) {
                if (Double.isNaN(dIntersection1)) {
                    dIntersection1 = dBottom;
                } else if (dBottom < dIntersection1) {
                    dIntersection2 = dIntersection1;
                    dIntersection1 = dBottom;
                } else {
                    dIntersection2 = dBottom;
                }
            }
        }
        if (Double.isNaN(dIntersection2) && Double.isFinite(delta = EuclidCoreTools.squareRoot((double)((B = 2.0 * ((AX = dx - (scaledAxisX1 = lineDirectionDotCylinderAxis * axisX)) * (CX = (deltaPX = startX - cylinderPositionX) - (scaledAxisX2 = (linePositionToCylinderDotAxis = deltaPX * axisX + (deltaPY = startY - cylinderPositionY) * axisY + (deltaPZ = startZ - cylinderPositionZ) * axisZ) * axisX)) + (AY = dy - (scaledAxisY1 = lineDirectionDotCylinderAxis * axisY)) * (CY = deltaPY - (scaledAxisY2 = linePositionToCylinderDotAxis * axisY)) + (AZ = dz - (scaledAxisZ1 = lineDirectionDotCylinderAxis * axisZ)) * (CZ = deltaPZ - (scaledAxisZ2 = linePositionToCylinderDotAxis * axisZ)))) * B - 4.0 * (A = EuclidCoreTools.normSquared((double)AX, (double)AY, (double)AZ)) * (C = EuclidCoreTools.normSquared((double)CX, (double)CY, (double)CZ) - radiusSquared))))) {
            double intersection2Z;
            double intersection2Y;
            double intersection2X;
            double oneOverTwoA = 0.5 / A;
            double dCylinder1 = (-B + delta) * oneOverTwoA;
            double dCylinder2 = (-B - delta) * oneOverTwoA;
            double intersection1X = dCylinder1 * dx + startX;
            double intersection1Y = dCylinder1 * dy + startY;
            double intersection1Z = dCylinder1 * dz + startZ;
            if (Math.abs(EuclidGeometryTools.percentageAlongLine3D(intersection1X, intersection1Y, intersection1Z, cylinderPositionX, cylinderPositionY, cylinderPositionZ, axisX, axisY, axisZ)) > halfLength - 1.0E-12) {
                dCylinder1 = Double.NaN;
            }
            if (Double.isFinite(dCylinder1)) {
                if (Double.isNaN(dIntersection1) || Math.abs(dCylinder1 - dIntersection1) < 1.0E-12) {
                    dIntersection1 = dCylinder1;
                } else if (dCylinder1 < dIntersection1) {
                    dIntersection2 = dIntersection1;
                    dIntersection1 = dCylinder1;
                } else {
                    dIntersection2 = dCylinder1;
                }
            }
            if (Math.abs(EuclidGeometryTools.percentageAlongLine3D(intersection2X = dCylinder2 * dx + startX, intersection2Y = dCylinder2 * dy + startY, intersection2Z = dCylinder2 * dz + startZ, cylinderPositionX, cylinderPositionY, cylinderPositionZ, axisX, axisY, axisZ)) > halfLength - 1.0E-12) {
                dCylinder2 = Double.NaN;
            } else if (Math.abs(dCylinder1 - dCylinder2) < 1.0E-12) {
                dCylinder2 = Double.NaN;
            }
            if (Double.isFinite(dCylinder2)) {
                if (Double.isNaN(dIntersection1)) {
                    dIntersection1 = dCylinder2;
                } else if (dCylinder2 < dIntersection1) {
                    dIntersection2 = dIntersection1;
                    dIntersection1 = dCylinder2;
                } else {
                    dIntersection2 = dCylinder2;
                }
            }
        }
        if (!canIntersectionOccurBeforeStart) {
            if (dIntersection2 < 0.0) {
                dIntersection2 = Double.NaN;
            }
            if (dIntersection1 < 0.0) {
                dIntersection1 = dIntersection2;
                dIntersection2 = Double.NaN;
            }
        }
        if (!canIntersectionOccurAfterEnd) {
            if (dIntersection2 > 1.0) {
                dIntersection2 = Double.NaN;
            }
            if (dIntersection1 > 1.0) {
                dIntersection1 = dIntersection2;
                dIntersection2 = Double.NaN;
            }
        }
        if (Double.isNaN(dIntersection1)) {
            return 0;
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.set(dx, dy, dz);
            firstIntersectionToPack.scale(dIntersection1);
            firstIntersectionToPack.add(startX, startY, startZ);
        }
        if (Double.isNaN(dIntersection2)) {
            return 1;
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.set(dx, dy, dz);
            secondIntersectionToPack.scale(dIntersection2);
            secondIntersectionToPack.add(startX, startY, startZ);
        }
        return 2;
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double startX = pointOnLineX;
        double startY = pointOnLineY;
        double startZ = pointOnLineZ;
        double endX = pointOnLineX + lineDirectionX;
        double endY = pointOnLineY + lineDirectionY;
        double endZ = pointOnLineZ + lineDirectionZ;
        return EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3DImpl(radiusX, radiusY, radiusZ, startX, startY, startZ, true, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double startX = firstPointOnLine.getX();
        double startY = firstPointOnLine.getY();
        double startZ = firstPointOnLine.getZ();
        double endX = secondPointOnLine.getX();
        double endY = secondPointOnLine.getY();
        double endZ = secondPointOnLine.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3DImpl(radiusX, radiusY, radiusZ, startX, startY, startZ, true, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLine3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double startX = pointOnLine.getX();
        double startY = pointOnLine.getY();
        double startZ = pointOnLine.getZ();
        double endX = pointOnLine.getX() + lineDirection.getX();
        double endY = pointOnLine.getY() + lineDirection.getY();
        double endZ = pointOnLine.getZ() + lineDirection.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3DImpl(radiusX, radiusY, radiusZ, startX, startY, startZ, true, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    private static int intersectionBetweenLine3DAndEllipsoid3DImpl(double radiusX, double radiusY, double radiusZ, double startX, double startY, double startZ, boolean canIntersectionOccurBeforeStart, double endX, double endY, double endZ, boolean canIntersectionOccurAfterEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double t2;
        double t1;
        double C;
        if (radiusX < 0.0) {
            throw new IllegalArgumentException("The ellipsoid x-radius has to be positive.");
        }
        if (radiusY < 0.0) {
            throw new IllegalArgumentException("The ellipsoid y-radius has to be positive.");
        }
        if (radiusZ < 0.0) {
            throw new IllegalArgumentException("The ellipsoid z-radius has to be positive.");
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.setToNaN();
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.setToNaN();
        }
        if (radiusX == 0.0 || radiusY == 0.0 || radiusZ == 0.0) {
            return 0;
        }
        double x = startX / radiusX;
        double dx = endX - startX;
        double vx = dx / radiusX;
        double y = startY / radiusY;
        double dy = endY - startY;
        double vy = dy / radiusY;
        double z = startZ / radiusZ;
        double dz = endZ - startZ;
        double vz = dz / radiusZ;
        double B = 2.0 * (x * vx + y * vy + z * vz);
        double A = EuclidCoreTools.normSquared((double)vx, (double)vy, (double)vz);
        double delta = B * B - 4.0 * A * (C = EuclidCoreTools.normSquared((double)x, (double)y, (double)z) - 1.0);
        if (delta < 0.0) {
            return 0;
        }
        double oneOverTwoA = 1.0 / (2.0 * A);
        if ((delta = EuclidCoreTools.squareRoot((double)delta)) < 1.0E-12) {
            t1 = -B * oneOverTwoA;
            t2 = Double.NaN;
        } else {
            t1 = (-B - delta) * oneOverTwoA;
            t2 = (-B + delta) * oneOverTwoA;
        }
        if (!canIntersectionOccurBeforeStart) {
            if (t2 < 0.0) {
                t2 = Double.NaN;
            }
            if (t1 < 0.0) {
                t1 = t2;
                t2 = Double.NaN;
            }
        }
        if (!canIntersectionOccurAfterEnd) {
            if (t2 > 1.0) {
                t2 = Double.NaN;
            }
            if (t1 > 1.0) {
                t1 = t2;
                t2 = Double.NaN;
            }
        }
        if (Double.isNaN(t1)) {
            return 0;
        }
        if (firstIntersectionToPack != null) {
            firstIntersectionToPack.set(dx, dy, dz);
            firstIntersectionToPack.scale(t1);
            firstIntersectionToPack.add(startX, startY, startZ);
        }
        if (Double.isNaN(t2)) {
            return 1;
        }
        if (secondIntersectionToPack != null) {
            secondIntersectionToPack.set(dx, dy, dz);
            secondIntersectionToPack.scale(t2);
            secondIntersectionToPack.add(startX, startY, startZ);
        }
        return 2;
    }

    public static Point3D intersectionBetweenLine3DAndPlane3D(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        Point3D intersection = new Point3D();
        boolean success = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D(pointOnPlane, planeNormal, pointOnLine, lineDirection, (Point3DBasics)intersection);
        if (success) {
            return intersection;
        }
        return null;
    }

    public static boolean intersectionBetweenLine3DAndPlane3D(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics intersectionToPack) {
        Point3DReadOnly p0 = pointOnPlane;
        Vector3DReadOnly n = planeNormal;
        Point3DReadOnly l0 = pointOnLine;
        Vector3DReadOnly l = lineDirection;
        double numerator = (p0.getX() - l0.getX()) * n.getX();
        numerator += (p0.getY() - l0.getY()) * n.getY();
        numerator += (p0.getZ() - l0.getZ()) * n.getZ();
        double denominator = l.dot((Tuple3DReadOnly)n);
        if (Math.abs(denominator) < 1.0E-12) {
            return false;
        }
        double d = numerator / denominator;
        intersectionToPack.scaleAdd(d, (Tuple3DReadOnly)l, (Tuple3DReadOnly)l0);
        return true;
    }

    public static int intersectionBetweenLineSegment2DAndBoundingBox2D(Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2DImpl(boundingBoxMin, boundingBoxMax, lineSegmentStart.getX(), lineSegmentStart.getY(), false, lineSegmentEnd.getX(), lineSegmentEnd.getY(), false, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLineSegment3DAndBoundingBox3D(Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3DImpl(boundingBoxMin, boundingBoxMax, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentStart.getZ(), false, lineSegmentEnd.getX(), lineSegmentEnd.getY(), lineSegmentEnd.getZ(), false, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLineSegment3DAndCylinder3D(double cylinderLength, double cylinderRadius, Point3DReadOnly cylinderPosition, Vector3DReadOnly cylinderAxis, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double cylinderPositionX = cylinderPosition.getX();
        double cylinderPositionY = cylinderPosition.getY();
        double cylinderPositionZ = cylinderPosition.getZ();
        double cylinderAxisX = cylinderAxis.getX();
        double cylinderAxisY = cylinderAxis.getY();
        double cylinderAxisZ = cylinderAxis.getZ();
        double startX = lineSegmentStart.getX();
        double startY = lineSegmentStart.getY();
        double startZ = lineSegmentStart.getZ();
        double endX = lineSegmentEnd.getX();
        double endY = lineSegmentEnd.getY();
        double endZ = lineSegmentEnd.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3DImpl(cylinderLength, cylinderRadius, cylinderPositionX, cylinderPositionY, cylinderPositionZ, cylinderAxisX, cylinderAxisY, cylinderAxisZ, cylinderAxis instanceof UnitVector3DReadOnly, startX, startY, startZ, false, endX, endY, endZ, false, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenLineSegment3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double startX = lineSegmentStart.getX();
        double startY = lineSegmentStart.getY();
        double startZ = lineSegmentStart.getZ();
        double endX = lineSegmentEnd.getX();
        double endY = lineSegmentEnd.getY();
        double endZ = lineSegmentEnd.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3DImpl(radiusX, radiusY, radiusZ, startX, startY, startZ, false, endX, endY, endZ, false, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static Point3D intersectionBetweenLineSegment3DAndPlane3D(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        if (EuclidGeometryTools.doesLineSegment3DIntersectPlane3D(pointOnPlane, planeNormal, lineSegmentStart, lineSegmentEnd)) {
            Vector3D lineDirection = new Vector3D();
            lineDirection.sub((Tuple3DReadOnly)lineSegmentEnd, (Tuple3DReadOnly)lineSegmentStart);
            return EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D(pointOnPlane, planeNormal, lineSegmentStart, (Vector3DReadOnly)lineDirection);
        }
        return null;
    }

    public static int intersectionBetweenRay2DAndBoundingBox2D(Point2DReadOnly boundingBoxMin, Point2DReadOnly boundingBoxMax, Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        double firstPointOnLineX = rayOrigin.getX();
        double firstPointOnLineY = rayOrigin.getY();
        double secondPointOnLineX = rayOrigin.getX() + rayDirection.getX();
        double secondPointOnLineY = rayOrigin.getY() + rayDirection.getY();
        return EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2DImpl(boundingBoxMin, boundingBoxMax, firstPointOnLineX, firstPointOnLineY, false, secondPointOnLineX, secondPointOnLineY, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static boolean intersectionBetweenRay2DAndLineSegment2D(double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY, Point2DBasics intersectionToPack) {
        double start1x = rayOriginX;
        double start1y = rayOriginY;
        double end1x = rayOriginX + rayDirectionX;
        double end1y = rayOriginY + rayDirectionY;
        double start2x = lineSegmentStartX;
        double start2y = lineSegmentStartY;
        double end2x = lineSegmentEndX;
        double end2y = lineSegmentEndY;
        return EuclidGeometryTools.intersectionBetweenTwoLine2DsImpl(start1x, start1y, false, end1x, end1y, true, start2x, start2y, false, end2x, end2y, false, intersectionToPack);
    }

    public static Point2D intersectionBetweenRay2DAndLineSegment2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        Point2D intersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D(rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY(), lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), (Point2DBasics)intersection);
        if (success) {
            return intersection;
        }
        return null;
    }

    public static boolean intersectionBetweenRay2DAndLineSegment2D(Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenRay2DAndLineSegment2D(rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY(), lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), intersectionToPack);
    }

    public static int intersectionBetweenRay3DAndBoundingBox3D(Point3DReadOnly boundingBoxMin, Point3DReadOnly boundingBoxMax, Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double firstPointOnLineX = rayOrigin.getX();
        double firstPointOnLineY = rayOrigin.getY();
        double firstPointOnLineZ = rayOrigin.getZ();
        double secondPointOnLineX = rayOrigin.getX() + rayDirection.getX();
        double secondPointOnLineY = rayOrigin.getY() + rayDirection.getY();
        double secondPointOnLineZ = rayOrigin.getZ() + rayDirection.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3DImpl(boundingBoxMin, boundingBoxMax, firstPointOnLineX, firstPointOnLineY, firstPointOnLineZ, false, secondPointOnLineX, secondPointOnLineY, secondPointOnLineZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenRay3DAndCylinder3D(double cylinderLength, double cylinderRadius, Point3DReadOnly cylinderPosition, Vector3DReadOnly cylinderAxis, Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double cylinderPositionX = cylinderPosition.getX();
        double cylinderPositionY = cylinderPosition.getY();
        double cylinderPositionZ = cylinderPosition.getZ();
        double cylinderAxisX = cylinderAxis.getX();
        double cylinderAxisY = cylinderAxis.getY();
        double cylinderAxisZ = cylinderAxis.getZ();
        double startX = rayOrigin.getX();
        double startY = rayOrigin.getY();
        double startZ = rayOrigin.getZ();
        double endX = rayOrigin.getX() + rayDirection.getX();
        double endY = rayOrigin.getY() + rayDirection.getY();
        double endZ = rayOrigin.getZ() + rayDirection.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndCylinder3DImpl(cylinderLength, cylinderRadius, cylinderPositionX, cylinderPositionY, cylinderPositionZ, cylinderAxisX, cylinderAxisY, cylinderAxisZ, cylinderAxis instanceof UnitVector3DReadOnly, startX, startY, startZ, false, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static int intersectionBetweenRay3DAndEllipsoid3D(double radiusX, double radiusY, double radiusZ, Point3DReadOnly rayOrigin, Vector3DReadOnly rayDirection, Point3DBasics firstIntersectionToPack, Point3DBasics secondIntersectionToPack) {
        double startX = rayOrigin.getX();
        double startY = rayOrigin.getY();
        double startZ = rayOrigin.getZ();
        double endX = rayOrigin.getX() + rayDirection.getX();
        double endY = rayOrigin.getY() + rayDirection.getY();
        double endZ = rayOrigin.getZ() + rayDirection.getZ();
        return EuclidGeometryTools.intersectionBetweenLine3DAndEllipsoid3DImpl(radiusX, radiusY, radiusZ, startX, startY, startZ, false, endX, endY, endZ, true, firstIntersectionToPack, secondIntersectionToPack);
    }

    public static boolean intersectionBetweenTwoLine2Ds(double pointOnLine1x, double pointOnLine1y, double lineDirection1x, double lineDirection1y, double pointOnLine2x, double pointOnLine2y, double lineDirection2x, double lineDirection2y, Point2DBasics intersectionToPack) {
        double alpha = EuclidGeometryTools.percentageOfIntersectionBetweenTwoLine2Ds(pointOnLine1x, pointOnLine1y, lineDirection1x, lineDirection1y, pointOnLine2x, pointOnLine2y, lineDirection2x, lineDirection2y);
        if (Double.isInfinite(alpha)) {
            if (intersectionToPack != null) {
                intersectionToPack.set(pointOnLine1x, pointOnLine1y);
            }
            return true;
        }
        if (Double.isNaN(alpha)) {
            if (intersectionToPack != null) {
                intersectionToPack.setToNaN();
            }
            return false;
        }
        if (intersectionToPack != null) {
            intersectionToPack.set(pointOnLine1x + alpha * lineDirection1x, pointOnLine1y + alpha * lineDirection1y);
        }
        return true;
    }

    public static Point2D intersectionBetweenTwoLine2Ds(Point2DReadOnly firstPointOnLine1, Point2DReadOnly secondPointOnLine1, Point2DReadOnly firstPointOnLine2, Point2DReadOnly secondPointOnLine2) {
        Point2D intersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLine2Ds(firstPointOnLine1, secondPointOnLine1, firstPointOnLine2, secondPointOnLine2, (Point2DBasics)intersection);
        if (!success) {
            return null;
        }
        return intersection;
    }

    public static boolean intersectionBetweenTwoLine2Ds(Point2DReadOnly firstPointOnLine1, Point2DReadOnly secondPointOnLine1, Point2DReadOnly firstPointOnLine2, Point2DReadOnly secondPointOnLine2, Point2DBasics intersectionToPack) {
        double pointOnLine1x = firstPointOnLine1.getX();
        double pointOnLine1y = firstPointOnLine1.getY();
        double lineDirection1x = secondPointOnLine1.getX() - firstPointOnLine1.getX();
        double lineDirection1y = secondPointOnLine1.getY() - firstPointOnLine1.getY();
        double pointOnLine2x = firstPointOnLine2.getX();
        double pointOnLine2y = firstPointOnLine2.getY();
        double lineDirection2x = secondPointOnLine2.getX() - firstPointOnLine2.getX();
        double lineDirection2y = secondPointOnLine2.getY() - firstPointOnLine2.getY();
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds(pointOnLine1x, pointOnLine1y, lineDirection1x, lineDirection1y, pointOnLine2x, pointOnLine2y, lineDirection2x, lineDirection2y, intersectionToPack);
    }

    public static Point2D intersectionBetweenTwoLine2Ds(Point2DReadOnly pointOnLine1, Vector2DReadOnly lineDirection1, Point2DReadOnly pointOnLine2, Vector2DReadOnly lineDirection2) {
        Point2D intersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLine2Ds(pointOnLine1, lineDirection1, pointOnLine2, lineDirection2, (Point2DBasics)intersection);
        if (success) {
            return intersection;
        }
        return null;
    }

    public static boolean intersectionBetweenTwoLine2Ds(Point2DReadOnly pointOnLine1, Vector2DReadOnly lineDirection1, Point2DReadOnly pointOnLine2, Vector2DReadOnly lineDirection2, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoLine2Ds(pointOnLine1.getX(), pointOnLine1.getY(), lineDirection1.getX(), lineDirection1.getY(), pointOnLine2.getX(), pointOnLine2.getY(), lineDirection2.getX(), lineDirection2.getY(), intersectionToPack);
    }

    public static boolean intersectionBetweenTwoLineSegment2Ds(double lineSegmentStart1x, double lineSegmentStart1y, double lineSegmentEnd1x, double lineSegmentEnd1y, double lineSegmentStart2x, double lineSegmentStart2y, double lineSegmentEnd2x, double lineSegmentEnd2y, Point2DBasics intersectionToPack) {
        double start1x = lineSegmentStart1x;
        double start1y = lineSegmentStart1y;
        double end1x = lineSegmentEnd1x;
        double end1y = lineSegmentEnd1y;
        double start2x = lineSegmentStart2x;
        double start2y = lineSegmentStart2y;
        double end2x = lineSegmentEnd2x;
        double end2y = lineSegmentEnd2y;
        return EuclidGeometryTools.intersectionBetweenTwoLine2DsImpl(start1x, start1y, false, end1x, end1y, false, start2x, start2y, false, end2x, end2y, false, intersectionToPack);
    }

    public static Point2D intersectionBetweenTwoLineSegment2Ds(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2) {
        Point2D intersection = new Point2D();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds(lineSegmentStart1, lineSegmentEnd1, lineSegmentStart2, lineSegmentEnd2, (Point2DBasics)intersection);
        if (!success) {
            return null;
        }
        return intersection;
    }

    public static boolean intersectionBetweenTwoLineSegment2Ds(Point2DReadOnly lineSegmentStart1, Point2DReadOnly lineSegmentEnd1, Point2DReadOnly lineSegmentStart2, Point2DReadOnly lineSegmentEnd2, Point2DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds(lineSegmentStart1.getX(), lineSegmentStart1.getY(), lineSegmentEnd1.getX(), lineSegmentEnd1.getY(), lineSegmentStart2.getX(), lineSegmentStart2.getY(), lineSegmentEnd2.getX(), lineSegmentEnd2.getY(), intersectionToPack);
    }

    public static boolean intersectionBetweenTwoPlane3Ds(Point3DReadOnly pointOnPlane1, Vector3DReadOnly planeNormal1, Point3DReadOnly pointOnPlane2, Vector3DReadOnly planeNormal2, double angleThreshold, Point3DBasics pointOnIntersectionToPack, Vector3DBasics intersectionDirectionToPack) {
        if (angleThreshold < 0.0 || angleThreshold > 1.5707963267948966) {
            throw new IllegalArgumentException("The angle threshold has to be inside the interval: [0.0 ; Math.PI / 2.0]");
        }
        pointOnIntersectionToPack.setToNaN();
        intersectionDirectionToPack.setToNaN();
        double normalMagnitude1 = planeNormal1.norm();
        if (normalMagnitude1 < 1.0E-12) {
            return false;
        }
        double normalMagnitude2 = planeNormal2.norm();
        if (normalMagnitude2 < 1.0E-12) {
            return false;
        }
        if (Math.abs(planeNormal1.dot((Tuple3DReadOnly)planeNormal2) / (normalMagnitude1 * normalMagnitude2)) > EuclidCoreTools.cos((double)Math.abs(angleThreshold))) {
            return false;
        }
        intersectionDirectionToPack.cross((Tuple3DReadOnly)planeNormal1, (Tuple3DReadOnly)planeNormal2);
        double det = intersectionDirectionToPack.normSquared();
        double d1 = planeNormal1.getX() * pointOnPlane1.getX() + planeNormal1.getY() * pointOnPlane1.getY() + planeNormal1.getZ() * pointOnPlane1.getZ();
        double d2 = planeNormal2.getX() * pointOnPlane2.getX() + planeNormal2.getY() * pointOnPlane2.getY() + planeNormal2.getZ() * pointOnPlane2.getZ();
        double normal3Cross2X = intersectionDirectionToPack.getY() * planeNormal2.getZ() - intersectionDirectionToPack.getZ() * planeNormal2.getY();
        double normal3Cross2Y = intersectionDirectionToPack.getZ() * planeNormal2.getX() - intersectionDirectionToPack.getX() * planeNormal2.getZ();
        double normal3Cross2Z = intersectionDirectionToPack.getX() * planeNormal2.getY() - intersectionDirectionToPack.getY() * planeNormal2.getX();
        double normal1Cross3X = planeNormal1.getY() * intersectionDirectionToPack.getZ() - planeNormal1.getZ() * intersectionDirectionToPack.getY();
        double normal1Cross3Y = planeNormal1.getZ() * intersectionDirectionToPack.getX() - planeNormal1.getX() * intersectionDirectionToPack.getZ();
        double normal1Cross3Z = planeNormal1.getX() * intersectionDirectionToPack.getY() - planeNormal1.getY() * intersectionDirectionToPack.getX();
        double normal2Cross1X = -intersectionDirectionToPack.getX();
        double normal2Cross1Y = -intersectionDirectionToPack.getY();
        double normal2Cross1Z = -intersectionDirectionToPack.getZ();
        intersectionDirectionToPack.scale(1.0 / EuclidCoreTools.squareRoot((double)det));
        double normal3DotPoint1 = intersectionDirectionToPack.getX() * pointOnPlane1.getX() + intersectionDirectionToPack.getY() * pointOnPlane1.getY() + intersectionDirectionToPack.getZ() * pointOnPlane1.getZ();
        double normal3DotPoint2 = intersectionDirectionToPack.getX() * pointOnPlane2.getX() + intersectionDirectionToPack.getY() * pointOnPlane2.getY() + intersectionDirectionToPack.getZ() * pointOnPlane2.getZ();
        double d3 = 0.5 * (normal3DotPoint1 + normal3DotPoint2);
        pointOnIntersectionToPack.set(d1 * normal3Cross2X + d2 * normal1Cross3X + d3 * normal2Cross1X, d1 * normal3Cross2Y + d2 * normal1Cross3Y + d3 * normal2Cross1Y, d1 * normal3Cross2Z + d2 * normal1Cross3Z + d3 * normal2Cross1Z);
        pointOnIntersectionToPack.scale(-1.0 / det);
        return true;
    }

    public static boolean intersectionBetweenTwoPlane3Ds(Point3DReadOnly pointOnPlane1, Vector3DReadOnly planeNormal1, Point3DReadOnly pointOnPlane2, Vector3DReadOnly planeNormal2, Point3DBasics pointOnIntersectionToPack, Vector3DBasics intersectionDirectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoPlane3Ds(pointOnPlane1, planeNormal1, pointOnPlane2, planeNormal2, 1.0E-6, pointOnIntersectionToPack, intersectionDirectionToPack);
    }

    public static boolean isFormingTriangle(double lengthSideA, double lengthSideB, double lengthSideC) {
        if (lengthSideA < 0.0) {
            throw new IllegalArgumentException("The side A cannot have a negative length, lengthSideA = " + lengthSideA);
        }
        if (lengthSideB < 0.0) {
            throw new IllegalArgumentException("The side B cannot have a negative length, lengthSideB = " + lengthSideB);
        }
        if (lengthSideC < 0.0) {
            throw new IllegalArgumentException("The side C cannot have a negative length, lengthSideC = " + lengthSideC);
        }
        if (lengthSideA + lengthSideB <= lengthSideC) {
            return false;
        }
        if (lengthSideB + lengthSideC <= lengthSideA) {
            return false;
        }
        return !(lengthSideA + lengthSideC <= lengthSideB);
    }

    public static Location whichPartOfRay2DIsPoint2DOn(double pointX, double pointY, double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY) {
        double rayStartToVertexX = pointX - rayOriginX;
        double rayStartToVertexY = pointY - rayOriginY;
        double dotProduct = rayStartToVertexX * rayDirectionX + rayStartToVertexY * rayDirectionY;
        if (dotProduct > 0.0) {
            return Location.AHEAD;
        }
        if (dotProduct < 0.0) {
            return Location.BEHIND;
        }
        return null;
    }

    public static Location whichPartOfRay2DIsPoint2DOn(Point2DReadOnly point, Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection) {
        return EuclidGeometryTools.whichPartOfRay2DIsPoint2DOn(point.getX(), point.getY(), rayOrigin.getX(), rayOrigin.getY(), rayDirection.getX(), rayDirection.getY());
    }

    public static boolean isPoint2DInFrontOfRay2D(double pointX, double pointY, double rayOriginX, double rayOriginY, double rayDirectionX, double rayDirectionY) {
        return EuclidGeometryTools.whichPartOfRay2DIsPoint2DOn(pointX, pointY, rayOriginX, rayOriginY, rayDirectionX, rayDirectionY) != Location.BEHIND;
    }

    public static boolean isPoint2DInFrontOfRay2D(Point2DReadOnly point, Point2DReadOnly rayOrigin, Vector2DReadOnly rayDirection) {
        return EuclidGeometryTools.whichPartOfRay2DIsPoint2DOn(point, rayOrigin, rayDirection) != Location.BEHIND;
    }

    public static boolean isPoint2DInsideTriangleABC(Point2DReadOnly point, Point2DReadOnly a, Point2DReadOnly b, Point2DReadOnly c) {
        boolean checkForLeftSide = EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D(b, a, c);
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D(point, a, b, checkForLeftSide)) {
            return false;
        }
        if (EuclidGeometryTools.isPoint2DOnSideOfLine2D(point, b, c, checkForLeftSide)) {
            return false;
        }
        return !EuclidGeometryTools.isPoint2DOnSideOfLine2D(point, c, a, checkForLeftSide);
    }

    public static boolean isPoint2DOnLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY) < 1.0E-8;
    }

    public static boolean isPoint2DOnLine2D(double pointX, double pointY, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.distanceFromPoint2DToLine2D(pointX, pointY, pointOnLine, lineDirection) < 1.0E-8;
    }

    public static boolean isPoint2DOnLine2D(Point2DReadOnly point, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.isPoint2DOnLine2D(point.getX(), point.getY(), pointOnLine, lineDirection);
    }

    public static boolean isPoint2DOnLineSegment2D(Point2DReadOnly point, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D(point, lineSegmentStart, lineSegmentEnd) < 1.0E-8;
    }

    public static Location whichSideOfLine2DIsPoint2DOn(double pointX, double pointY, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(double pointX, double pointY, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        double pointOnLineX = pointOnLine.getX();
        double pointOnLineY = pointOnLine.getY();
        double lineDirectionX = lineDirection.getX();
        double lineDirectionY = lineDirection.getY();
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(Point2DReadOnly point, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(point.getX(), point.getY(), firstPointOnLine, secondPointOnLine);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(Point2DReadOnly point, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(point.getX(), point.getY(), pointOnLine, lineDirection);
    }

    public static Location whichSideOfLine2DIsPoint2DOn(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY) {
        double dy = pointY - pointOnLineY;
        double dx = pointX - pointOnLineX;
        double crossProduct = lineDirectionX * dy - dx * lineDirectionY;
        if (crossProduct > 0.0) {
            return Location.LEFT;
        }
        if (crossProduct < 0.0) {
            return Location.RIGHT;
        }
        return null;
    }

    public static boolean isPoint2DOnLeftSideOfLine2D(Point2DReadOnly point, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(point, firstPointOnLine, secondPointOnLine) == Location.LEFT;
    }

    public static boolean isPoint2DOnRightSideOfLine2D(Point2DReadOnly point, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        return EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(point, firstPointOnLine, secondPointOnLine) == Location.RIGHT;
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, boolean testLeftSide) {
        Location side = EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY);
        return testLeftSide ? side == Location.LEFT : side == Location.RIGHT;
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(double pointX, double pointY, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine, boolean testLeftSide) {
        Location side = EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(pointX, pointY, firstPointOnLine, secondPointOnLine);
        return testLeftSide ? side == Location.LEFT : side == Location.RIGHT;
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(double pointX, double pointY, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, boolean testLeftSide) {
        Location side = EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(pointX, pointY, pointOnLine, lineDirection);
        return testLeftSide ? side == Location.LEFT : side == Location.RIGHT;
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(Point2DReadOnly point, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine, boolean testLeftSide) {
        Location side = EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(point, firstPointOnLine, secondPointOnLine);
        return testLeftSide ? side == Location.LEFT : side == Location.RIGHT;
    }

    @Deprecated
    public static boolean isPoint2DOnSideOfLine2D(Point2DReadOnly point, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, boolean testLeftSide) {
        Location side = EuclidGeometryTools.whichSideOfLine2DIsPoint2DOn(point, pointOnLine, lineDirection);
        return testLeftSide ? side == Location.LEFT : side == Location.RIGHT;
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ) {
        double dx = (pointX - pointOnPlaneX) * planeNormalX;
        double dy = (pointY - pointOnPlaneY) * planeNormalY;
        double dz = (pointZ - pointOnPlaneZ) * planeNormalZ;
        double signedDistance = dx + dy + dz;
        if (signedDistance > 0.0) {
            return Location.ABOVE;
        }
        if (signedDistance < 0.0) {
            return Location.BELOW;
        }
        return null;
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane.getX(), pointOnPlane.getY(), pointOnPlane.getZ(), planeNormal.getX(), planeNormal.getY(), planeNormal.getZ());
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point.getX(), point.getY(), point.getZ(), pointOnPlane, planeNormal);
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeFirstTangentX, double planeFirstTangentY, double planeFirstTangentZ, double planeSecondTangentX, double planeSecondTangentY, double planeSecondTangentZ) {
        double planeNormalX = planeFirstTangentY * planeSecondTangentZ - planeFirstTangentZ * planeSecondTangentY;
        double planeNormalY = planeFirstTangentZ * planeSecondTangentX - planeFirstTangentX * planeSecondTangentZ;
        double planeNormalZ = planeFirstTangentX * planeSecondTangentY - planeFirstTangentY * planeSecondTangentX;
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ, planeNormalX, planeNormalY, planeNormalZ);
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane.getX(), pointOnPlane.getY(), pointOnPlane.getZ(), planeFirstTangent.getX(), planeFirstTangent.getY(), planeFirstTangent.getZ(), planeSecondTangent.getX(), planeSecondTangent.getY(), planeSecondTangent.getZ());
    }

    public static Location whichSideOfPlane3DIsPoint3DOn(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point.getX(), point.getY(), point.getZ(), pointOnPlane, planeFirstTangent, planeSecondTangent);
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ, boolean testForAbove) {
        Location side = EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ, planeNormalX, planeNormalY, planeNormalZ);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, boolean testForAbove) {
        Location side = EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeNormal);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, boolean testForAbove) {
        Location side = EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeNormal);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    public static boolean isPoint3DAbovePlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeNormal) == Location.ABOVE;
    }

    public static boolean isPoint3DAbovePlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeNormal) == Location.ABOVE;
    }

    public static boolean isPoint3DBelowPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeNormal) == Location.BELOW;
    }

    public static boolean isPoint3DBelowPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeNormal) == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(double pointX, double pointY, double pointZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeFirstTangentX, double planeFirstTangentY, double planeFirstTangentZ, double planeSecondTangentX, double planeSecondTangentY, double planeSecondTangentZ, boolean testForAbove) {
        Location side = EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ, planeFirstTangentX, planeFirstTangentY, planeFirstTangentZ, planeSecondTangentX, planeSecondTangentY, planeSecondTangentZ);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent, boolean testForAbove) {
        Location side = EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeFirstTangent, planeSecondTangent);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    @Deprecated
    public static boolean isPoint3DAboveOrBelowPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent, boolean testForAbove) {
        Location side = EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeFirstTangent, planeSecondTangent);
        return testForAbove ? side == Location.ABOVE : side == Location.BELOW;
    }

    public static boolean isPoint3DAbovePlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.ABOVE;
    }

    public static boolean isPoint3DAbovePlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.ABOVE;
    }

    public static boolean isPoint3DBelowPlane3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(pointX, pointY, pointZ, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.BELOW;
    }

    public static boolean isPoint3DBelowPlane3D(Point3DReadOnly point, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeFirstTangent, Vector3DReadOnly planeSecondTangent) {
        return EuclidGeometryTools.whichSideOfPlane3DIsPoint3DOn(point, pointOnPlane, planeFirstTangent, planeSecondTangent) == Location.BELOW;
    }

    public static Vector3D normal3DFromThreePoint3Ds(Point3DReadOnly firstPointOnPlane, Point3DReadOnly secondPointOnPlane, Point3DReadOnly thirdPointOnPlane) {
        Vector3D normal = new Vector3D();
        boolean success = EuclidGeometryTools.normal3DFromThreePoint3Ds(firstPointOnPlane, secondPointOnPlane, thirdPointOnPlane, (Vector3DBasics)normal);
        if (!success) {
            return null;
        }
        return normal;
    }

    public static boolean normal3DFromThreePoint3Ds(Point3DReadOnly firstPointOnPlane, Point3DReadOnly secondPointOnPlane, Point3DReadOnly thirdPointOnPlane, Vector3DBasics normalToPack) {
        double v1_x = secondPointOnPlane.getX() - firstPointOnPlane.getX();
        double v1_y = secondPointOnPlane.getY() - firstPointOnPlane.getY();
        double v1_z = secondPointOnPlane.getZ() - firstPointOnPlane.getZ();
        double v2_x = thirdPointOnPlane.getX() - firstPointOnPlane.getX();
        double v2_y = thirdPointOnPlane.getY() - firstPointOnPlane.getY();
        double v2_z = thirdPointOnPlane.getZ() - firstPointOnPlane.getZ();
        normalToPack.set(v1_y * v2_z - v1_z * v2_y, v2_x * v1_z - v2_z * v1_x, v1_x * v2_y - v1_y * v2_x);
        double normalLength = normalToPack.norm();
        if (normalLength < 1.0E-12) {
            return false;
        }
        normalToPack.scale(1.0 / normalLength);
        return true;
    }

    public static boolean orthogonalProjectionOnLine2D(Point2DReadOnly pointToProject, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, Point2DBasics projectionToPack) {
        double directionLengthSquared = EuclidCoreTools.normSquared((double)lineDirectionX, (double)lineDirectionY);
        if (directionLengthSquared < 1.0E-12) {
            return false;
        }
        double dx = pointToProject.getX() - pointOnLineX;
        double dy = pointToProject.getY() - pointOnLineY;
        double dot = dx * lineDirectionX + dy * lineDirectionY;
        double alpha = dot / directionLengthSquared;
        projectionToPack.set(pointOnLineX + alpha * lineDirectionX, pointOnLineY + alpha * lineDirectionY);
        return true;
    }

    public static Point2D orthogonalProjectionOnLine2D(Point2DReadOnly pointToProject, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        Point2D projection = new Point2D();
        boolean success = EuclidGeometryTools.orthogonalProjectionOnLine2D(pointToProject, firstPointOnLine, secondPointOnLine, (Point2DBasics)projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean orthogonalProjectionOnLine2D(Point2DReadOnly pointToProject, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine, Point2DBasics projectionToPack) {
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.orthogonalProjectionOnLine2D(pointToProject, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY, projectionToPack);
    }

    public static Point2D orthogonalProjectionOnLine2D(Point2DReadOnly pointToProject, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        Point2D projection = new Point2D();
        boolean success = EuclidGeometryTools.orthogonalProjectionOnLine2D(pointToProject, pointOnLine, lineDirection, (Point2DBasics)projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean orthogonalProjectionOnLine2D(Point2DReadOnly pointToProject, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection, Point2DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLine2D(pointToProject, pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY(), projectionToPack);
    }

    public static boolean orthogonalProjectionOnLine3D(Point3DReadOnly pointToProject, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ, Point3DBasics projectionToPack) {
        double directionLengthSquared = EuclidCoreTools.normSquared((double)lineDirectionX, (double)lineDirectionY, (double)lineDirectionZ);
        if (directionLengthSquared < 1.0E-12) {
            return false;
        }
        double dx = pointToProject.getX() - pointOnLineX;
        double dy = pointToProject.getY() - pointOnLineY;
        double dz = pointToProject.getZ() - pointOnLineZ;
        double dot = dx * lineDirectionX + dy * lineDirectionY + dz * lineDirectionZ;
        double alpha = dot / directionLengthSquared;
        projectionToPack.set(pointOnLineX + alpha * lineDirectionX, pointOnLineY + alpha * lineDirectionY, pointOnLineZ + alpha * lineDirectionZ);
        return true;
    }

    public static Point3D orthogonalProjectionOnLine3D(Point3DReadOnly pointToProject, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        Point3D projection = new Point3D();
        boolean success = EuclidGeometryTools.orthogonalProjectionOnLine3D(pointToProject, pointOnLine, lineDirection, (Point3DBasics)projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean orthogonalProjectionOnLine3D(Point3DReadOnly pointToProject, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLine3D(pointToProject, pointOnLine.getX(), pointOnLine.getY(), pointOnLine.getZ(), lineDirection.getX(), lineDirection.getY(), lineDirection.getZ(), projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment2D(double pointToProjectX, double pointToProjectY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY, Point2DBasics projectionToPack) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment2D(pointToProjectX, pointToProjectY, lineSegmentStartX, lineSegmentStartY, lineSegmentEndX, lineSegmentEndY);
        if (percentage > 1.0) {
            percentage = 1.0;
        } else if (percentage < 0.0) {
            percentage = 0.0;
        }
        projectionToPack.set((1.0 - percentage) * lineSegmentStartX + percentage * lineSegmentEndX, (1.0 - percentage) * lineSegmentStartY + percentage * lineSegmentEndY);
        return true;
    }

    public static boolean orthogonalProjectionOnLineSegment2D(Point2DReadOnly pointToProject, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY, Point2DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D(pointToProject.getX(), pointToProject.getY(), lineSegmentStartX, lineSegmentStartY, lineSegmentEndX, lineSegmentEndY, projectionToPack);
    }

    public static Point2D orthogonalProjectionOnLineSegment2D(Point2DReadOnly pointToProject, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        Point2D projection = new Point2D();
        boolean success = EuclidGeometryTools.orthogonalProjectionOnLineSegment2D(pointToProject, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), (Point2DBasics)projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean orthogonalProjectionOnLineSegment2D(double pointToProjectX, double pointToProjectY, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D(pointToProjectX, pointToProjectY, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment2D(Point2DReadOnly pointToProject, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment2D(pointToProject, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), projectionToPack);
    }

    public static boolean orthogonalProjectionOnLineSegment3D(Point3DReadOnly pointToProject, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentStartZ, double lineSegmentEndX, double lineSegmentEndY, double lineSegmentEndZ, Point3DBasics projectionToPack) {
        double percentage = EuclidGeometryTools.percentageAlongLineSegment3D(pointToProject.getX(), pointToProject.getY(), pointToProject.getZ(), lineSegmentStartX, lineSegmentStartY, lineSegmentStartZ, lineSegmentEndX, lineSegmentEndY, lineSegmentEndZ);
        if (percentage > 1.0) {
            percentage = 1.0;
        } else if (percentage < 0.0) {
            percentage = 0.0;
        }
        projectionToPack.set((1.0 - percentage) * lineSegmentStartX + percentage * lineSegmentEndX, (1.0 - percentage) * lineSegmentStartY + percentage * lineSegmentEndY, (1.0 - percentage) * lineSegmentStartZ + percentage * lineSegmentEndZ);
        return true;
    }

    public static Point3D orthogonalProjectionOnLineSegment3D(Point3DReadOnly pointToProject, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        Point3D projection = new Point3D();
        boolean success = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D(pointToProject, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentStart.getZ(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), lineSegmentEnd.getZ(), (Point3DBasics)projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean orthogonalProjectionOnLineSegment3D(Point3DReadOnly pointToProject, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment3D(pointToProject, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentStart.getZ(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), lineSegmentEnd.getZ(), projectionToPack);
    }

    public static Point3D orthogonalProjectionOnPlane3D(Point3DReadOnly pointToProject, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        Point3D projection = new Point3D();
        boolean success = EuclidGeometryTools.orthogonalProjectionOnPlane3D(pointToProject, pointOnPlane, planeNormal, (Point3DBasics)projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean orthogonalProjectionOnPlane3D(Point3DReadOnly pointToProject, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D(pointToProject.getX(), pointToProject.getY(), pointToProject.getZ(), pointOnPlane, planeNormal, projectionToPack);
    }

    public static boolean orthogonalProjectionOnPlane3D(double x, double y, double z, Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal, Point3DBasics projectionToPack) {
        double normalMagnitude = planeNormal.norm();
        if (normalMagnitude < 1.0E-12) {
            return false;
        }
        projectionToPack.set(x, y, z);
        projectionToPack.sub((Tuple3DReadOnly)pointOnPlane);
        double signedDistance = projectionToPack.getX() * planeNormal.getX() + projectionToPack.getY() * planeNormal.getY() + projectionToPack.getZ() * planeNormal.getZ();
        projectionToPack.set(x - (signedDistance /= normalMagnitude * normalMagnitude) * planeNormal.getX(), y - signedDistance * planeNormal.getY(), z - signedDistance * planeNormal.getZ());
        return true;
    }

    public static double percentageOfIntersectionBetweenTwoLine2Ds(double pointOnLine1x, double pointOnLine1y, double lineDirection1x, double lineDirection1y, double pointOnLine2x, double pointOnLine2y, double lineDirection2x, double lineDirection2y) {
        double determinant = -lineDirection1x * lineDirection2y + lineDirection1y * lineDirection2x;
        double dx = pointOnLine2x - pointOnLine1x;
        double dy = pointOnLine2y - pointOnLine1y;
        if (Math.abs(determinant) < 1.0E-12) {
            double cross = dx * lineDirection1y - dy * lineDirection1x;
            if (Math.abs(cross) < 1.0E-12) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        double oneOverDeterminant = 1.0 / determinant;
        double AInverse00 = oneOverDeterminant * -lineDirection2y;
        double AInverse01 = oneOverDeterminant * lineDirection2x;
        double alpha = AInverse00 * dx + AInverse01 * dy;
        return alpha;
    }

    public static double percentageOfIntersectionBetweenTwoLine2Ds(Point2DReadOnly pointOnLine1, Vector2DReadOnly lineDirection1, Point2DReadOnly pointOnLine2, Vector2DReadOnly lineDirection2) {
        return EuclidGeometryTools.percentageOfIntersectionBetweenTwoLine2Ds(pointOnLine1.getX(), pointOnLine1.getY(), lineDirection1.getX(), lineDirection1.getY(), pointOnLine2.getX(), pointOnLine2.getY(), lineDirection2.getX(), lineDirection2.getY());
    }

    public static double percentageOfIntersectionBetweenLineSegment2DAndLine2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        double lineSegmentDirectionY;
        double lineSegmentDirectionX;
        double lineSegmentStartY;
        double lineSegmentStartX = lineSegmentStart.getX();
        double alpha = EuclidGeometryTools.percentageOfIntersectionBetweenTwoLine2Ds(lineSegmentStartX, lineSegmentStartY = lineSegmentStart.getY(), lineSegmentDirectionX = lineSegmentEnd.getX() - lineSegmentStart.getX(), lineSegmentDirectionY = lineSegmentEnd.getY() - lineSegmentStart.getY(), pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY());
        if (Double.isInfinite(alpha)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(alpha) || alpha < -1.0E-7 || alpha > 1.0000001) {
            return Double.NaN;
        }
        if (alpha < 0.0) {
            return 0.0;
        }
        if (alpha > 1.0) {
            return 1.0;
        }
        return alpha;
    }

    public static double percentageAlongLine2D(Point2DReadOnly point, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.percentageAlongLine2D(point.getX(), point.getY(), pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY());
    }

    public static double percentageAlongLine2D(double pointX, double pointY, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.percentageAlongLine2D(pointX, pointY, pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY());
    }

    public static double percentageAlongLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY) {
        double lengthSquared = EuclidCoreTools.normSquared((double)lineDirectionX, (double)lineDirectionY);
        if (lengthSquared < 1.0E-12) {
            return 0.0;
        }
        double dx = pointX - pointOnLineX;
        double dy = pointY - pointOnLineY;
        double dot = dx * lineDirectionX + dy * lineDirectionY;
        return dot / lengthSquared;
    }

    public static double percentageAlongLineSegment2D(double pointX, double pointY, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentEndX, double lineSegmentEndY) {
        double lineSegmentDx = lineSegmentEndX - lineSegmentStartX;
        double lineSegmentDy = lineSegmentEndY - lineSegmentStartY;
        double lengthSquared = EuclidCoreTools.normSquared((double)lineSegmentDx, (double)lineSegmentDy);
        if (lengthSquared < 1.0E-12) {
            return 0.0;
        }
        double dx = pointX - lineSegmentStartX;
        double dy = pointY - lineSegmentStartY;
        double dot = dx * lineSegmentDx + dy * lineSegmentDy;
        return dot / lengthSquared;
    }

    public static double percentageAlongLineSegment2D(double pointX, double pointY, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.percentageAlongLineSegment2D(pointX, pointY, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentEnd.getX(), lineSegmentEnd.getY());
    }

    public static double percentageAlongLineSegment2D(Point2DReadOnly point, Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.percentageAlongLineSegment2D(point.getX(), point.getY(), lineSegmentStart, lineSegmentEnd);
    }

    public static double percentageAlongLine3D(Point3DReadOnly point, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        return EuclidGeometryTools.percentageAlongLine3D(point.getX(), point.getY(), point.getZ(), pointOnLine.getX(), pointOnLine.getY(), pointOnLine.getZ(), lineDirection.getX(), lineDirection.getY(), lineDirection.getZ());
    }

    public static double percentageAlongLine3D(double pointX, double pointY, double pointZ, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        return EuclidGeometryTools.percentageAlongLine3D(pointX, pointY, pointZ, pointOnLine.getX(), pointOnLine.getY(), pointOnLine.getZ(), lineDirection.getX(), lineDirection.getY(), lineDirection.getZ());
    }

    public static double percentageAlongLine3D(double pointX, double pointY, double pointZ, double pointOnLineX, double pointOnLineY, double pointOnLineZ, double lineDirectionX, double lineDirectionY, double lineDirectionZ) {
        double lengthSquared = EuclidCoreTools.normSquared((double)lineDirectionX, (double)lineDirectionY, (double)lineDirectionZ);
        if (lengthSquared < 1.0E-12) {
            return 0.0;
        }
        double dx = pointX - pointOnLineX;
        double dy = pointY - pointOnLineY;
        double dz = pointZ - pointOnLineZ;
        double dot = dx * lineDirectionX + dy * lineDirectionY + dz * lineDirectionZ;
        return dot / lengthSquared;
    }

    public static double percentageAlongLineSegment3D(double pointX, double pointY, double pointZ, double lineSegmentStartX, double lineSegmentStartY, double lineSegmentStartZ, double lineSegmentEndX, double lineSegmentEndY, double lineSegmentEndZ) {
        double lineSegmentDx = lineSegmentEndX - lineSegmentStartX;
        double lineSegmentDy = lineSegmentEndY - lineSegmentStartY;
        double lineSegmentDz = lineSegmentEndZ - lineSegmentStartZ;
        double lengthSquared = EuclidCoreTools.normSquared((double)lineSegmentDx, (double)lineSegmentDy, (double)lineSegmentDz);
        if (lengthSquared < 1.0E-12) {
            return 0.0;
        }
        double dx = pointX - lineSegmentStartX;
        double dy = pointY - lineSegmentStartY;
        double dz = pointZ - lineSegmentStartZ;
        double dot = dx * lineSegmentDx + dy * lineSegmentDy + dz * lineSegmentDz;
        return dot / lengthSquared;
    }

    public static double percentageAlongLineSegment3D(double pointX, double pointY, double pointZ, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.percentageAlongLineSegment3D(pointX, pointY, pointZ, lineSegmentStart.getX(), lineSegmentStart.getY(), lineSegmentStart.getZ(), lineSegmentEnd.getX(), lineSegmentEnd.getY(), lineSegmentEnd.getZ());
    }

    public static double percentageAlongLineSegment3D(Point3DReadOnly point, Point3DReadOnly lineSegmentStart, Point3DReadOnly lineSegmentEnd) {
        return EuclidGeometryTools.percentageAlongLineSegment3D(point.getX(), point.getY(), point.getZ(), lineSegmentStart, lineSegmentEnd);
    }

    public static boolean perpendicularBisector2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, Point2DBasics bisectorStartToPack, Vector2DBasics bisectorDirectionToPack) {
        if (lineSegmentStart.distance(lineSegmentEnd) < 1.0E-12) {
            return false;
        }
        bisectorStartToPack.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, 0.5);
        bisectorDirectionToPack.sub((Tuple2DReadOnly)lineSegmentEnd, (Tuple2DReadOnly)lineSegmentStart);
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)bisectorDirectionToPack, bisectorDirectionToPack);
        bisectorDirectionToPack.normalize();
        return true;
    }

    public static List<Point2D> perpendicularBisectorSegment2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, double bisectorSegmentHalfLength) {
        Point2D bisectorSegmentStart = new Point2D();
        Point2D bisectorSegmentEnd = new Point2D();
        boolean success = EuclidGeometryTools.perpendicularBisectorSegment2D(lineSegmentStart, lineSegmentEnd, bisectorSegmentHalfLength, (Point2DBasics)bisectorSegmentStart, (Point2DBasics)bisectorSegmentEnd);
        if (!success) {
            return null;
        }
        ArrayList<Point2D> bisectorEndpoints = new ArrayList<Point2D>();
        bisectorEndpoints.add(bisectorSegmentStart);
        bisectorEndpoints.add(bisectorSegmentEnd);
        return bisectorEndpoints;
    }

    public static boolean perpendicularBisectorSegment2D(Point2DReadOnly lineSegmentStart, Point2DReadOnly lineSegmentEnd, double bisectorSegmentHalfLength, Point2DBasics bisectorSegmentStartToPack, Point2DBasics bisectorSegmentEndToPack) {
        if (lineSegmentStart.distance(lineSegmentEnd) < 1.0E-12) {
            return false;
        }
        double bisectorDirectionX = -(lineSegmentEnd.getY() - lineSegmentStart.getY());
        double bisectorDirectionY = lineSegmentEnd.getX() - lineSegmentStart.getX();
        double directionInverseMagnitude = 1.0 / EuclidCoreTools.norm((double)bisectorDirectionX, (double)bisectorDirectionY);
        double midPointX = 0.5 * (lineSegmentStart.getX() + lineSegmentEnd.getX());
        double midPointY = 0.5 * (lineSegmentStart.getY() + lineSegmentEnd.getY());
        bisectorSegmentStartToPack.set(midPointX + (bisectorDirectionX *= directionInverseMagnitude) * bisectorSegmentHalfLength, midPointY + (bisectorDirectionY *= directionInverseMagnitude) * bisectorSegmentHalfLength);
        bisectorSegmentEndToPack.set(midPointX - bisectorDirectionX * bisectorSegmentHalfLength, midPointY - bisectorDirectionY * bisectorSegmentHalfLength);
        return true;
    }

    public static Vector2D perpendicularVector2D(Vector2DReadOnly vector) {
        return new Vector2D(-vector.getY(), vector.getX());
    }

    public static void perpendicularVector2D(Vector2DReadOnly vector, Vector2DBasics perpendicularVectorToPack) {
        perpendicularVectorToPack.set(-vector.getY(), vector.getX());
    }

    public static Vector3D perpendicularVector3DFromLine3DToPoint3D(Point3DReadOnly point, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Point3DBasics orthogonalProjectionToPack) {
        Vector3D perpendicularVector = new Vector3D();
        boolean success = EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D(point, firstPointOnLine, secondPointOnLine, orthogonalProjectionToPack, (Vector3DBasics)perpendicularVector);
        if (!success) {
            return null;
        }
        return perpendicularVector;
    }

    public static boolean perpendicularVector3DFromLine3DToPoint3D(Point3DReadOnly point, Point3DReadOnly firstPointOnLine, Point3DReadOnly secondPointOnLine, Point3DBasics orthogonalProjectionToPack, Vector3DBasics perpendicularVectorToPack) {
        double lineDirectionZ;
        double lineDirectionY;
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineLength = EuclidCoreTools.fastNorm((double)lineDirectionX, (double)(lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY()), (double)(lineDirectionZ = secondPointOnLine.getZ() - firstPointOnLine.getZ()));
        if (lineLength < 1.0E-12) {
            return false;
        }
        lineLength = 1.0 / lineLength;
        double dx = point.getX() - firstPointOnLine.getX();
        double dy = point.getY() - firstPointOnLine.getY();
        double dz = point.getZ() - firstPointOnLine.getZ();
        double distanceFromFirstPointOnLine = (lineDirectionX *= lineLength) * dx + (lineDirectionY *= lineLength) * dy + (lineDirectionZ *= lineLength) * dz;
        if (orthogonalProjectionToPack != null) {
            orthogonalProjectionToPack.set(lineDirectionX, lineDirectionY, lineDirectionZ);
            orthogonalProjectionToPack.scaleAdd(distanceFromFirstPointOnLine, (Tuple3DReadOnly)orthogonalProjectionToPack, (Tuple3DReadOnly)firstPointOnLine);
            perpendicularVectorToPack.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)orthogonalProjectionToPack);
        } else {
            perpendicularVectorToPack.set(lineDirectionX, lineDirectionY, lineDirectionZ);
            perpendicularVectorToPack.scale(distanceFromFirstPointOnLine);
            perpendicularVectorToPack.add((Tuple3DReadOnly)firstPointOnLine);
            perpendicularVectorToPack.negate();
            perpendicularVectorToPack.add((Tuple3DReadOnly)point);
        }
        return true;
    }

    public static double pythagorasGetCathetus(double hypotenuseC, double cathetusA) {
        if (hypotenuseC < 0.0) {
            throw new IllegalArgumentException("The hypotenuse cannot have a negative length, hypotenuseC = " + hypotenuseC);
        }
        if (cathetusA < 0.0) {
            throw new IllegalArgumentException("The cathetus cannot have a negative length, cathetusA = " + cathetusA);
        }
        if (cathetusA > hypotenuseC) {
            throw new IllegalArgumentException("The cathetus cannot be longer than the hypotenuse, cathetusA = " + cathetusA + ", hypotenuseC = " + hypotenuseC);
        }
        return EuclidCoreTools.squareRoot((double)(hypotenuseC * hypotenuseC - cathetusA * cathetusA));
    }

    public static double pythagorasGetHypotenuse(double cathetusA, double cathetusB) {
        if (cathetusA < 0.0) {
            throw new IllegalArgumentException("The cathetus A cannot have a negative length, cathetusA = " + cathetusA);
        }
        if (cathetusB < 0.0) {
            throw new IllegalArgumentException("The cathetus B cannot have a negative length, cathetusB = " + cathetusB);
        }
        return Math.hypot(cathetusA, cathetusB);
    }

    public static double radiusOfArc(double chordLength, double chordAngle) {
        if (chordAngle % Math.PI == 0.0) {
            return Double.NaN;
        }
        return chordLength / (2.0 * EuclidCoreTools.sin((double)(0.5 * chordAngle)));
    }

    public static double signedDistanceFromPoint2DToLine2D(double pointX, double pointY, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY);
    }

    public static double signedDistanceFromPoint2DToLine2D(double pointX, double pointY, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(pointX, pointY, pointOnLine.getX(), pointOnLine.getY(), lineDirection.getX(), lineDirection.getY(), lineDirection instanceof UnitVector2DReadOnly);
    }

    public static double signedDistanceFromPoint2DToLine2D(Point2DReadOnly point, Point2DReadOnly firstPointOnLine, Point2DReadOnly secondPointOnLine) {
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(point.getX(), point.getY(), firstPointOnLine, secondPointOnLine);
    }

    public static double signedDistanceFromPoint2DToLine2D(Point2DReadOnly point, Point2DReadOnly pointOnLine, Vector2DReadOnly lineDirection) {
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(point.getX(), point.getY(), pointOnLine, lineDirection);
    }

    public static double signedDistanceFromPoint2DToLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY) {
        return EuclidGeometryTools.signedDistanceFromPoint2DToLine2D(pointX, pointY, pointOnLineX, pointOnLineY, lineDirectionX, lineDirectionY, false);
    }

    private static double signedDistanceFromPoint2DToLine2D(double pointX, double pointY, double pointOnLineX, double pointOnLineY, double lineDirectionX, double lineDirectionY, boolean isDirectionUnitary) {
        double directionMagnitude;
        double dx = pointX - pointOnLineX;
        double dy = pointY - pointOnLineY;
        double d = directionMagnitude = isDirectionUnitary ? 1.0 : EuclidCoreTools.fastNorm((double)lineDirectionX, (double)lineDirectionY);
        if (directionMagnitude < 1.0E-12) {
            return EuclidCoreTools.norm((double)dx, (double)dy);
        }
        return (lineDirectionX * dy - dx * lineDirectionY) / directionMagnitude;
    }

    public static boolean sphere3DPositionFromThreePoints(Point3DReadOnly p1, Point3DReadOnly p2, Point3DReadOnly p3, double sphere3DRadius, Point3DBasics sphere3DPositionToPack) {
        double beta;
        double betaSquared;
        double wSquaredInverse;
        double vSquared;
        double uv;
        double ux = p2.getX() - p1.getX();
        double uy = p2.getY() - p1.getY();
        double uz = p2.getZ() - p1.getZ();
        double vx = p3.getX() - p1.getX();
        double vy = p3.getY() - p1.getY();
        double vz = p3.getZ() - p1.getZ();
        double wx = uy * vz - uz * vy;
        double wy = uz * vx - ux * vz;
        double wz = ux * vy - uy * vx;
        double radiusSquared = sphere3DRadius * sphere3DRadius;
        double uSquared = EuclidCoreTools.normSquared((double)ux, (double)uy, (double)uz);
        double alpha = 0.5 * (uSquared - (uv = ux * vx + uy * vy + uz * vz)) * (vSquared = EuclidCoreTools.normSquared((double)vx, (double)vy, (double)vz)) * (wSquaredInverse = 1.0 / EuclidCoreTools.normSquared((double)wx, (double)wy, (double)wz));
        double alphaSquared = alpha * alpha;
        double gammaSquared = (radiusSquared - alphaSquared * uSquared - (betaSquared = (beta = 0.5 * (vSquared - uv) * uSquared * wSquaredInverse) * beta) * vSquared - 2.0 * alpha * beta * uv) * wSquaredInverse;
        if (gammaSquared < 0.0 || !Double.isFinite(gammaSquared)) {
            return false;
        }
        double gamma = EuclidCoreTools.squareRoot((double)gammaSquared);
        double px = p1.getX() + alpha * ux + beta * vx + gamma * wx;
        double py = p1.getY() + alpha * uy + beta * vy + gamma * wy;
        double pz = p1.getZ() + alpha * uz + beta * vz + gamma * wz;
        sphere3DPositionToPack.set(px, py, pz);
        return true;
    }

    public static void topVertex3DOfIsoscelesTriangle3D(Point3DReadOnly baseVertexA, Point3DReadOnly baseVertexC, Vector3DReadOnly trianglePlaneNormal, double ccwAngleAboutNormalAtTopVertex, Point3DBasics topVertexBToPack) {
        double baseEdgeACx = baseVertexC.getX() - baseVertexA.getX();
        double baseEdgeACy = baseVertexC.getY() - baseVertexA.getY();
        double baseEdgeACz = baseVertexC.getZ() - baseVertexA.getZ();
        double baseEdgeACLength = EuclidCoreTools.norm((double)baseEdgeACx, (double)baseEdgeACy, (double)baseEdgeACz);
        double legLengthABorCB = EuclidGeometryTools.radiusOfArc(baseEdgeACLength, ccwAngleAboutNormalAtTopVertex);
        double lengthOfBisectorOfBase = EuclidGeometryTools.pythagorasGetCathetus(legLengthABorCB, 0.5 * baseEdgeACLength);
        double perpendicularBisectorX = trianglePlaneNormal.getY() * baseEdgeACz - trianglePlaneNormal.getZ() * baseEdgeACy;
        double perpendicularBisectorY = trianglePlaneNormal.getZ() * baseEdgeACx - trianglePlaneNormal.getX() * baseEdgeACz;
        double perpendicularBisectorZ = trianglePlaneNormal.getX() * baseEdgeACy - trianglePlaneNormal.getY() * baseEdgeACx;
        double scale = lengthOfBisectorOfBase;
        scale /= EuclidCoreTools.norm((double)perpendicularBisectorX, (double)perpendicularBisectorY, (double)perpendicularBisectorZ);
        topVertexBToPack.interpolate((Tuple3DReadOnly)baseVertexA, (Tuple3DReadOnly)baseVertexC, 0.5);
        topVertexBToPack.set(topVertexBToPack.getX() + (perpendicularBisectorX *= scale), topVertexBToPack.getY() + (perpendicularBisectorY *= scale), topVertexBToPack.getZ() + (perpendicularBisectorZ *= scale));
    }

    public static Point2D triangleBisector2D(Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C) {
        Point2D X = new Point2D();
        boolean success = EuclidGeometryTools.triangleBisector2D(A, B, C, (Point2DBasics)X);
        if (success) {
            return X;
        }
        return null;
    }

    public static boolean triangleBisector2D(Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DBasics XToPack) {
        double BA = B.distance(A);
        if (BA < 1.0E-12) {
            return false;
        }
        double BC = B.distance(C);
        if (BC < 1.0E-12) {
            return false;
        }
        double AC = A.distance(C);
        if (AC < 1.0E-12) {
            return false;
        }
        double AX = AC / (BC / BA + 1.0);
        double vectorAXx = C.getX() - A.getX();
        double vectorAXy = C.getY() - A.getY();
        double inverseMagnitude = 1.0 / EuclidCoreTools.norm((double)vectorAXx, (double)vectorAXy);
        XToPack.set(vectorAXx *= AX * inverseMagnitude, vectorAXy *= AX * inverseMagnitude);
        XToPack.add((Tuple2DReadOnly)A);
        return true;
    }

    public static double triangleCircumradius(double lengthA, double lengthB, double lengthC) {
        double circumradiusSquared = lengthA * lengthA * lengthB * lengthB * lengthC * lengthC;
        return EuclidCoreTools.squareRoot((double)(circumradiusSquared /= (lengthA + lengthB + lengthC) * (-lengthA + lengthB + lengthC) * (lengthA - lengthB + lengthC) * (lengthA + lengthB - lengthC)));
    }

    public static double triangleIsoscelesHeight(double legLength, double baseLength) {
        if (legLength < 0.5 * baseLength) {
            throw new IllegalArgumentException("Malformed isosceles triangle, expected legLength > baseLength/2, was legLength: " + legLength + ", baseLength/2: " + 0.5 * baseLength);
        }
        if (baseLength < 0.0) {
            throw new IllegalArgumentException("The base cannot have a negative length, baseLength = " + baseLength);
        }
        return EuclidCoreTools.squareRoot((double)(legLength * legLength - 0.25 * baseLength * baseLength));
    }

    public static double unknownTriangleAngleByLawOfCosine(double lengthNeighbourSideA, double lengthNeighbourSideB, double lengthOppositeSideC) {
        if (!EuclidGeometryTools.isFormingTriangle(lengthNeighbourSideA, lengthNeighbourSideB, lengthOppositeSideC)) {
            throw new IllegalArgumentException("Unable to build a Triangle of the given triangle sides a: " + lengthNeighbourSideA + " b: " + lengthNeighbourSideB + " c: " + lengthOppositeSideC);
        }
        double numerator = lengthNeighbourSideA * lengthNeighbourSideA + lengthNeighbourSideB * lengthNeighbourSideB - lengthOppositeSideC * lengthOppositeSideC;
        double denominator = 2.0 * lengthNeighbourSideA * lengthNeighbourSideB;
        return EuclidCoreTools.fastAcos((double)(numerator / denominator));
    }

    public static double unknownTriangleSideLengthByLawOfCosine(double lengthSideA, double lengthSideB, double angleBetweenAAndB) {
        if (lengthSideA < 0.0) {
            throw new IllegalArgumentException("lengthSideA cannot be negative: " + lengthSideA);
        }
        if (lengthSideB < 0.0) {
            throw new IllegalArgumentException("lengthSideB cannot be negative: " + lengthSideA);
        }
        if (Math.abs(angleBetweenAAndB) > Math.PI) {
            throw new IllegalArgumentException("angleBetweenAAndB " + angleBetweenAAndB + " does not define a triangle.");
        }
        return EuclidCoreTools.squareRoot((double)(lengthSideA * lengthSideA + lengthSideB * lengthSideB - 2.0 * lengthSideA * lengthSideB * EuclidCoreTools.cos((double)angleBetweenAAndB)));
    }
}

