/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public interface Vertex2DSupplier
extends EuclidGeometry {
    public static final Vertex2DSupplier EMPTY_SUPPLIER = new Vertex2DSupplier(){

        @Override
        public Point2DReadOnly getVertex(int index) {
            return null;
        }

        @Override
        public int getNumberOfVertices() {
            return 0;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            if (object instanceof Vertex2DSupplier) {
                return this.equals((Vertex2DSupplier)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };

    public Point2DReadOnly getVertex(int var1);

    public int getNumberOfVertices();

    default public boolean isEmpty() {
        return this.getNumberOfVertices() == 0;
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Vertex2DSupplier)) {
            return false;
        }
        Vertex2DSupplier other = (Vertex2DSupplier)geometry;
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).equals((EuclidGeometry)other.getVertex(i))) continue;
            return false;
        }
        return true;
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Vertex2DSupplier)) {
            return false;
        }
        Vertex2DSupplier other = (Vertex2DSupplier)geometry;
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).epsilonEquals((EuclidGeometry)other.getVertex(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Vertex2DSupplier)) {
            return false;
        }
        Vertex2DSupplier other = (Vertex2DSupplier)geometry;
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).geometricallyEquals((EuclidGeometry)other.getVertex(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    default public String toString(String format) {
        StringBuilder sb = new StringBuilder("Vertex 2D Supplier: [");
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getVertex(i).toString(format));
        }
        sb.append(']');
        return sb.toString();
    }

    public static Vertex2DSupplier emptyVertex2DSupplier() {
        return EMPTY_SUPPLIER;
    }

    public static Vertex2DSupplier asVertex2DSupplier(Point2DReadOnly ... vertices) {
        return Vertex2DSupplier.asVertex2DSupplier(Arrays.asList(vertices));
    }

    public static Vertex2DSupplier asVertex2DSupplier(Point2DReadOnly[] vertices, int numberOfVertices) {
        return Vertex2DSupplier.asVertex2DSupplier(Arrays.asList(vertices), numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(Point2DReadOnly[] vertices, int startIndex, int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex2DSupplier.emptyVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        return Vertex2DSupplier.asVertex2DSupplier(Arrays.asList(vertices), startIndex, numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(List<? extends Point2DReadOnly> vertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, vertices.size());
    }

    public static Vertex2DSupplier asVertex2DSupplier(List<? extends Point2DReadOnly> vertices, int numberOfVertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, 0, numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(final List<? extends Point2DReadOnly> vertices, final int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex2DSupplier.emptyVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.size()) {
            throw new IllegalArgumentException("The list is too small. List size = " + vertices.size() + ", expected minimum size = " + (startIndex + numberOfVertices));
        }
        return new Vertex2DSupplier(){

            @Override
            public Point2DReadOnly getVertex(int index) {
                return (Point2DReadOnly)vertices.get(index + startIndex);
            }

            @Override
            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public int hashCode() {
                long bits = 1L;
                for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                    bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getVertex(i));
                }
                return EuclidHashCodeTools.toIntHashCode((long)bits);
            }

            public boolean equals(Object object) {
                if (object instanceof Vertex2DSupplier) {
                    return this.equals((Vertex2DSupplier)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }

    public static Vertex2DSupplier asVertex2DSupplier(double[][] vertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, vertices.length);
    }

    public static Vertex2DSupplier asVertex2DSupplier(double[][] vertices, int numberOfVertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, 0, numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(double[][] vertices, int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex2DSupplier.emptyVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        final Point2DReadOnly[] point2Ds = new Point2DReadOnly[numberOfVertices];
        for (int index = 0; index < numberOfVertices; ++index) {
            double[] vertex = vertices[startIndex + index];
            point2Ds[index] = EuclidCoreFactories.newLinkedPoint2DReadOnly(() -> vertex[0], () -> vertex[1]);
        }
        return new Vertex2DSupplier(){

            @Override
            public Point2DReadOnly getVertex(int index) {
                return point2Ds[index];
            }

            @Override
            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public int hashCode() {
                long bits = 1L;
                for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                    bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getVertex(i));
                }
                return EuclidHashCodeTools.toIntHashCode((long)bits);
            }

            public boolean equals(Object object) {
                if (object instanceof Vertex2DSupplier) {
                    return this.equals((Vertex2DSupplier)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

