/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public interface Triangle3DReadOnly {
    public Point3DReadOnly getA();

    public Point3DReadOnly getB();

    public Point3DReadOnly getC();

    default public boolean containsNaN() {
        return this.getA().containsNaN() || this.getB().containsNaN() || this.getC().containsNaN();
    }

    default public double getAB() {
        return this.getA().distance(this.getB());
    }

    default public double getBC() {
        return this.getB().distance(this.getC());
    }

    default public double getCA() {
        return this.getC().distance(this.getA());
    }

    default public double getABSquared() {
        return this.getA().distanceSquared(this.getB());
    }

    default public double getBCSquared() {
        return this.getB().distanceSquared(this.getC());
    }

    default public double getCASquared() {
        return this.getC().distanceSquared(this.getA());
    }

    default public double getArea() {
        return EuclidGeometryTools.triangleArea(this.getA(), this.getB(), this.getC());
    }

    default public boolean isEquilateral(double epsilon) {
        if (!EuclidCoreTools.epsilonEquals((double)this.getABSquared(), (double)this.getCASquared(), (double)epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)this.getCASquared(), (double)this.getBCSquared(), (double)epsilon);
    }

    default public boolean epsilonEquals(Triangle3DReadOnly other, double epsilon) {
        if (!this.getA().epsilonEquals((Tuple3DReadOnly)other.getA(), epsilon)) {
            return false;
        }
        if (!this.getB().epsilonEquals((Tuple3DReadOnly)other.getB(), epsilon)) {
            return false;
        }
        return this.getC().epsilonEquals((Tuple3DReadOnly)other.getC(), epsilon);
    }

    default public boolean equals(Triangle3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getA().equals((Tuple3DReadOnly)other.getA()) && this.getB().equals((Tuple3DReadOnly)other.getB()) && this.getC().equals((Tuple3DReadOnly)other.getC());
    }

    default public boolean geometricallyEquals(Triangle3DReadOnly other, double epsilon) {
        return this.geometricallyEquals(other.getA(), other.getB(), other.getC(), epsilon);
    }

    default public boolean geometricallyEquals(Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c, double epsilon) {
        if (this.getA().geometricallyEquals(a, epsilon)) {
            if (this.getB().geometricallyEquals(b, epsilon)) {
                return this.getC().geometricallyEquals(c, epsilon);
            }
            return this.getB().geometricallyEquals(c, epsilon) && this.getC().geometricallyEquals(b, epsilon);
        }
        if (this.getA().geometricallyEquals(b, epsilon)) {
            if (this.getB().geometricallyEquals(a, epsilon)) {
                return this.getC().geometricallyEquals(c, epsilon);
            }
            return this.getB().geometricallyEquals(c, epsilon) && this.getC().geometricallyEquals(a, epsilon);
        }
        if (this.getA().geometricallyEquals(c, epsilon)) {
            if (this.getB().geometricallyEquals(a, epsilon)) {
                return this.getC().geometricallyEquals(b, epsilon);
            }
            return this.getB().geometricallyEquals(b, epsilon) && this.getC().geometricallyEquals(a, epsilon);
        }
        return false;
    }
}

