/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public interface Pose3DReadOnly {
    public Point3DReadOnly getPosition();

    public QuaternionReadOnly getOrientation();

    default public double getX() {
        return this.getPosition().getX();
    }

    default public double getY() {
        return this.getPosition().getY();
    }

    default public double getZ() {
        return this.getPosition().getZ();
    }

    default public double getYaw() {
        return this.getOrientation().getYaw();
    }

    default public double getPitch() {
        return this.getOrientation().getPitch();
    }

    default public double getRoll() {
        return this.getOrientation().getRoll();
    }

    default public boolean containsNaN() {
        return this.getOrientation().containsNaN() || this.getPosition().containsNaN();
    }

    @Deprecated
    default public void getRotationVector(Vector3DBasics rotationVectorToPack) {
        this.getOrientation().getRotationVector(rotationVectorToPack);
    }

    @Deprecated
    default public double getPositionDistance(Point3DReadOnly point) {
        return this.getPosition().distance(point);
    }

    @Deprecated
    default public double getPositionDistance(Pose3DReadOnly other) {
        return this.getPosition().distance(other.getPosition());
    }

    @Deprecated
    default public double getOrientationDistance(QuaternionReadOnly orientation) {
        return this.getOrientation().distance(orientation);
    }

    @Deprecated
    default public double getOrientationDistance(Pose3DReadOnly other) {
        return this.getOrientation().distance(other.getOrientation());
    }

    default public void get(Tuple3DBasics positionToPack, Orientation3DBasics orientationToPack) {
        positionToPack.set((Tuple3DReadOnly)this.getPosition());
        orientationToPack.set((Orientation3DReadOnly)this.getOrientation());
    }

    default public void get(RigidBodyTransformBasics transformToPack) {
        transformToPack.set((Orientation3DReadOnly)this.getOrientation(), (Tuple3DReadOnly)this.getPosition());
    }

    default public boolean epsilonEquals(Pose3DReadOnly other, double epsilon) {
        return this.getPosition().epsilonEquals((Tuple3DReadOnly)other.getPosition(), epsilon) && this.getOrientation().epsilonEquals((Tuple4DReadOnly)other.getOrientation(), epsilon);
    }

    default public boolean geometricallyEquals(Pose3DReadOnly other, double epsilon) {
        return this.getPosition().geometricallyEquals(other.getPosition(), epsilon) && this.getOrientation().geometricallyEquals(other.getOrientation(), epsilon);
    }

    default public boolean equals(Pose3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPosition().equals((Tuple3DReadOnly)other.getPosition()) && this.getOrientation().equals((Tuple4DReadOnly)other.getOrientation());
    }
}

