/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.GeometricallyComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class LineSegment1D
implements Clearable,
Settable<LineSegment1D>,
EpsilonComparable<LineSegment1D>,
GeometricallyComparable<LineSegment1D> {
    private double firstEndpoint = Double.NaN;
    private double secondEndpoint = Double.NaN;
    private boolean positiveDirection;

    public LineSegment1D() {
    }

    public LineSegment1D(double firstEndpoint, double secondEndpoint) {
        this.set(firstEndpoint, secondEndpoint);
    }

    public LineSegment1D(LineSegment1D other) {
        this.set(other);
    }

    public LineSegment1D(double[] endpoints) {
        this.set(endpoints);
    }

    public boolean computeOverlap(LineSegment1D other, LineSegment1D intersectionToPack) {
        if (!this.isOverlappingInclusive(other)) {
            return false;
        }
        double intersectionMin = Math.max(this.getMinPoint(), other.getMinPoint());
        double intersectionMax = Math.min(this.getMaxPoint(), other.getMaxPoint());
        intersectionToPack.set(intersectionMin, intersectionMax);
        return true;
    }

    public LineSegment1D computeOverlap(LineSegment1D other) {
        if (!this.isOverlappingInclusive(other)) {
            return null;
        }
        double intersectionMin = Math.max(this.getMinPoint(), other.getMinPoint());
        double intersectionMax = Math.min(this.getMaxPoint(), other.getMaxPoint());
        return new LineSegment1D(intersectionMin, intersectionMax);
    }

    public boolean isOverlappingInclusive(LineSegment1D other) {
        return this.isBetweenEndpointsInclusive(other.firstEndpoint) || this.isBetweenEndpointsInclusive(other.secondEndpoint) || other.isBetweenEndpointsInclusive(this.firstEndpoint) || other.isBetweenEndpointsInclusive(this.secondEndpoint);
    }

    public boolean isOverlappingExclusive(LineSegment1D other) {
        return this.isBetweenEndpointsExclusive(other.firstEndpoint) || this.isBetweenEndpointsExclusive(other.secondEndpoint) || other.isBetweenEndpointsExclusive(this.firstEndpoint) || other.isBetweenEndpointsExclusive(this.secondEndpoint);
    }

    public boolean isBetweenEndpointsInclusive(LineSegment1D other) {
        return this.isBetweenEndpointsInclusive(other.firstEndpoint) && this.isBetweenEndpointsInclusive(other.secondEndpoint);
    }

    public boolean isBetweenEndpointsExclusive(LineSegment1D other) {
        return this.isBetweenEndpointsExclusive(other.firstEndpoint) && this.isBetweenEndpointsExclusive(other.secondEndpoint);
    }

    public boolean isBetweenEndpointsInclusive(double point) {
        return this.getMinPoint() <= point && point <= this.getMaxPoint();
    }

    public boolean isBetweenEndpointsExclusive(double point) {
        return this.getMinPoint() < point && point < this.getMaxPoint();
    }

    public boolean isBetweenEndpoints(double point, double epsilon) {
        double alpha = (point - this.firstEndpoint) / (this.secondEndpoint - this.firstEndpoint);
        if (alpha < epsilon) {
            return false;
        }
        return !(alpha > 1.0 - epsilon);
    }

    public double signedDistance(double point) {
        if (this.isBetweenEndpointsInclusive(point)) {
            return -Math.min(point - this.getMinPoint(), this.getMaxPoint() - point);
        }
        if (point < this.getMinPoint()) {
            return this.getMinPoint() - point;
        }
        return point - this.getMaxPoint();
    }

    public double distance(double point) {
        if (this.isBetweenEndpointsInclusive(point)) {
            return 0.0;
        }
        if (point < this.getMinPoint()) {
            return this.getMinPoint() - point;
        }
        return point - this.getMaxPoint();
    }

    public void extendSegmentToPoint(double point) {
        if (this.isBetweenEndpointsInclusive(point)) {
            return;
        }
        if (point < this.getMinPoint()) {
            this.setMinPoint(point);
        } else {
            this.setMaxPoint(point);
        }
    }

    public boolean isBefore(double point) {
        if (this.positiveDirection) {
            return point < this.firstEndpoint;
        }
        return point > this.firstEndpoint;
    }

    public boolean isAfter(double point) {
        if (this.positiveDirection) {
            return point > this.secondEndpoint;
        }
        return point < this.secondEndpoint;
    }

    public boolean containsNaN() {
        return Double.isNaN(this.firstEndpoint) || Double.isNaN(this.secondEndpoint);
    }

    public void setToNaN() {
        this.firstEndpoint = Double.NaN;
        this.secondEndpoint = Double.NaN;
    }

    public void setToZero() {
        this.firstEndpoint = 0.0;
        this.secondEndpoint = 0.0;
    }

    public void set(LineSegment1D other) {
        this.set(other.firstEndpoint, other.secondEndpoint);
    }

    public void set(double firstEndpoint, double secondEndpoint) {
        this.firstEndpoint = firstEndpoint;
        this.secondEndpoint = secondEndpoint;
        this.updateDirection();
    }

    public void set(double[] endpoints) {
        if (endpoints.length != 2) {
            throw new RuntimeException("Length of input array is not correct. Length = " + endpoints.length + ", expected an array of two elements");
        }
        this.firstEndpoint = endpoints[0];
        this.secondEndpoint = endpoints[1];
        this.updateDirection();
    }

    public void setFirstEndpoint(double firstEndpoint) {
        this.firstEndpoint = firstEndpoint;
        this.updateDirection();
    }

    public void setSecondEndpoint(double secondEndpoint) {
        this.secondEndpoint = secondEndpoint;
        this.updateDirection();
    }

    public void setMinPoint(double newMinPoint) {
        if (newMinPoint >= this.getMaxPoint()) {
            throw new RuntimeException("Unexpected newMinPoint: " + newMinPoint + ", expected it to be less than the current max point: " + this.getMaxPoint());
        }
        if (this.positiveDirection) {
            this.firstEndpoint = newMinPoint;
        } else {
            this.secondEndpoint = newMinPoint;
        }
        this.updateDirection();
    }

    public void setMaxPoint(double newMaxPoint) {
        if (newMaxPoint <= this.getMinPoint()) {
            throw new RuntimeException("Unexpected newMaxPoint: " + newMaxPoint + ", expected it to be greater than the current min point: " + this.getMinPoint());
        }
        if (this.positiveDirection) {
            this.secondEndpoint = newMaxPoint;
        } else {
            this.firstEndpoint = newMaxPoint;
        }
        this.updateDirection();
    }

    public double getFirstEndpoint() {
        return this.firstEndpoint;
    }

    public double getSecondEndpoint() {
        return this.secondEndpoint;
    }

    public double getMaxPoint() {
        return this.positiveDirection ? this.secondEndpoint : this.firstEndpoint;
    }

    public double getMinPoint() {
        return this.positiveDirection ? this.firstEndpoint : this.secondEndpoint;
    }

    public double getMidPoint() {
        return 0.5 * (this.firstEndpoint + this.secondEndpoint);
    }

    public double length() {
        return (this.positiveDirection ? 1.0 : -1.0) * (this.secondEndpoint - this.firstEndpoint);
    }

    public LineSegment3D toLineSegment3d(Line3DReadOnly line3d) {
        return this.toLineSegment3d(line3d.getPoint(), (Vector3DReadOnly)line3d.getDirection());
    }

    public LineSegment3D toLineSegment3d(Point3DReadOnly zero3d, Vector3DReadOnly direction3d) {
        Point3D firstEndpoint = new Point3D();
        Point3D secondEndpoint = new Point3D();
        firstEndpoint.scaleAdd(this.firstEndpoint, (Tuple3DReadOnly)direction3d, (Tuple3DReadOnly)zero3d);
        secondEndpoint.scaleAdd(this.secondEndpoint, (Tuple3DReadOnly)direction3d, (Tuple3DReadOnly)zero3d);
        return new LineSegment3D((Point3DReadOnly)firstEndpoint, (Point3DReadOnly)secondEndpoint);
    }

    public LineSegment2D toLineSegment2d(Point2DReadOnly zero2d, Vector2DReadOnly direction2d) {
        Point2D firstEndpoint = new Point2D();
        Point2D secondEndpoint = new Point2D();
        firstEndpoint.scaleAdd(this.firstEndpoint, (Tuple2DReadOnly)direction2d, (Tuple2DReadOnly)zero2d);
        secondEndpoint.scaleAdd(this.secondEndpoint, (Tuple2DReadOnly)direction2d, (Tuple2DReadOnly)zero2d);
        return new LineSegment2D((Point2DReadOnly)firstEndpoint, (Point2DReadOnly)secondEndpoint);
    }

    public boolean epsilonEquals(LineSegment1D other, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals((double)this.firstEndpoint, (double)other.firstEndpoint, (double)epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)this.secondEndpoint, (double)other.secondEndpoint, (double)epsilon);
    }

    public boolean geometricallyEquals(LineSegment1D other, double epsilon) {
        if (EuclidCoreTools.epsilonEquals((double)this.firstEndpoint, (double)other.firstEndpoint, (double)epsilon) && EuclidCoreTools.epsilonEquals((double)this.secondEndpoint, (double)other.secondEndpoint, (double)epsilon)) {
            return true;
        }
        return EuclidCoreTools.epsilonEquals((double)this.firstEndpoint, (double)other.secondEndpoint, (double)epsilon) && EuclidCoreTools.epsilonEquals((double)this.secondEndpoint, (double)other.firstEndpoint, (double)epsilon);
    }

    public boolean equals(LineSegment1D other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.firstEndpoint == other.firstEndpoint && this.secondEndpoint == other.secondEndpoint;
    }

    public boolean equals(Object object) {
        if (object instanceof LineSegment1D) {
            return this.equals((LineSegment1D)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((double)this.firstEndpoint, (double)this.secondEndpoint);
    }

    public String toString() {
        return EuclidGeometryIOTools.getLineSegment1DString(this);
    }

    private void updateDirection() {
        this.positiveDirection = this.firstEndpoint <= this.secondEndpoint;
    }
}

