/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class TranslationReferenceFrame
extends ReferenceFrame {
    public final FrameVector3D translationVector;

    public TranslationReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        super(frameName, parentFrame, false, parentFrame.isZupFrame());
        this.translationVector = new FrameVector3D(parentFrame);
    }

    public TranslationReferenceFrame(String frameName, ReferenceFrame parentFrame, FrameVector3DReadOnly translationToParent) {
        this(frameName, parentFrame);
        this.setTranslationAndUpdate(translationToParent);
    }

    @Override
    protected void updateTransformToParent(RigidBodyTransform transformToParentToPack) {
        transformToParentToPack.setIdentity();
        transformToParentToPack.getTranslation().set((Tuple3DReadOnly)this.translationVector);
    }

    public void setTranslationAndUpdate(FrameTuple3DReadOnly translation) {
        this.translationVector.checkReferenceFrameMatch(translation);
        this.setTranslationAndUpdate((Tuple3DReadOnly)translation);
    }

    public void setTranslationAndUpdate(Tuple3DReadOnly translation) {
        this.translationVector.set(translation);
        this.update();
    }
}

