/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import java.util.Arrays;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;

public interface FrameVertex2DSupplier
extends Vertex2DSupplier,
EuclidFrameGeometry {
    public static final FrameVertex2DSupplier EMPTY_SUPPLIER = new FrameVertex2DSupplier(){

        @Override
        public FramePoint2DReadOnly getVertex(int index) {
            return null;
        }

        public int getNumberOfVertices() {
            return 0;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            if (object instanceof FrameVertex2DSupplier) {
                return this.equals((FrameVertex2DSupplier)object);
            }
            return false;
        }

        public String toString() {
            return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
        }
    };

    public FramePoint2DReadOnly getVertex(int var1);

    @Override
    default public ReferenceFrame getReferenceFrame() {
        return this.isEmpty() ? null : this.getVertex(0).getReferenceFrame();
    }

    default public String toString(String format) {
        StringBuilder sb = new StringBuilder("Frame vertex 2D Supplier: [");
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getVertex(i).toString(format));
        }
        sb.append(']');
        return sb.toString();
    }

    public static FrameVertex2DSupplier emptyFrameVertex2DSupplier() {
        return EMPTY_SUPPLIER;
    }

    public static FrameVertex2DSupplier asFrameVertex2DSupplier(FramePoint2DReadOnly ... vertices) {
        return FrameVertex2DSupplier.asFrameVertex2DSupplier(Arrays.asList(vertices));
    }

    public static FrameVertex2DSupplier asFrameVertex2DSupplier(FramePoint2DReadOnly[] vertices, int numberOfVertices) {
        return FrameVertex2DSupplier.asFrameVertex2DSupplier(Arrays.asList(vertices), numberOfVertices);
    }

    public static FrameVertex2DSupplier asFrameVertex2DSupplier(FramePoint2DReadOnly[] vertices, int startIndex, int numberOfVertices) {
        if (numberOfVertices == 0) {
            return FrameVertex2DSupplier.emptyFrameVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        return FrameVertex2DSupplier.asFrameVertex2DSupplier(Arrays.asList(vertices), startIndex, numberOfVertices);
    }

    public static FrameVertex2DSupplier asFrameVertex2DSupplier(List<? extends FramePoint2DReadOnly> vertices) {
        return FrameVertex2DSupplier.asFrameVertex2DSupplier(vertices, vertices.size());
    }

    public static FrameVertex2DSupplier asFrameVertex2DSupplier(List<? extends FramePoint2DReadOnly> vertices, int numberOfVertices) {
        return FrameVertex2DSupplier.asFrameVertex2DSupplier(vertices, 0, numberOfVertices);
    }

    public static FrameVertex2DSupplier asFrameVertex2DSupplier(final List<? extends FramePoint2DReadOnly> vertices, final int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return FrameVertex2DSupplier.emptyFrameVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.size()) {
            throw new IllegalArgumentException("The list is too small. List size = " + vertices.size() + ", expected minimum size = " + (startIndex + numberOfVertices));
        }
        return new FrameVertex2DSupplier(){

            @Override
            public FramePoint2DReadOnly getVertex(int index) {
                return (FramePoint2DReadOnly)vertices.get(index + startIndex);
            }

            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public int hashCode() {
                long bits = 1L;
                for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                    bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getVertex(i));
                }
                return EuclidHashCodeTools.toIntHashCode((long)bits);
            }

            public boolean equals(Object object) {
                if (object instanceof FrameVertex2DSupplier) {
                    return this.equals((FrameVertex2DSupplier)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

