/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.interfaces;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public interface FrameConvexPolygon2DReadOnly
extends ConvexPolygon2DReadOnly,
FrameVertex2DSupplier {
    public List<? extends FramePoint2DReadOnly> getVertexBufferView();

    public FramePoint2DReadOnly getVertexUnsafe(int var1);

    default public List<? extends FramePoint2DReadOnly> getPolygonVerticesView() {
        return this.getVertexBufferView().subList(0, this.getNumberOfVertices());
    }

    @Override
    default public FramePoint2DReadOnly getVertex(int index) {
        return (FramePoint2DReadOnly)super.getVertex(index);
    }

    default public FramePoint2DReadOnly getNextVertex(int index) {
        return (FramePoint2DReadOnly)super.getNextVertex(index);
    }

    default public FramePoint2DReadOnly getPreviousVertex(int index) {
        return (FramePoint2DReadOnly)super.getPreviousVertex(index);
    }

    default public FramePoint2DReadOnly getVertexCCW(int index) {
        return (FramePoint2DReadOnly)super.getVertexCCW(index);
    }

    default public FramePoint2DReadOnly getNextVertexCCW(int index) {
        return (FramePoint2DReadOnly)super.getNextVertexCCW(index);
    }

    default public FramePoint2DReadOnly getPreviousVertexCCW(int index) {
        return (FramePoint2DReadOnly)super.getPreviousVertexCCW(index);
    }

    public FramePoint2DReadOnly getCentroid();

    default public void getFramePointsInClockwiseOrder(int startIndexInclusive, int endIndexInclusive, List<FramePoint2DReadOnly> pointListToPack) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(startIndexInclusive);
        this.checkIndexInBoundaries(endIndexInclusive);
        int index = startIndexInclusive;
        while (true) {
            pointListToPack.add(this.getVertex(index));
            if (index == endIndexInclusive) break;
            index = this.getNextVertexIndex(index);
        }
    }

    default public void getVerticesInClockwiseOrder(int startIndexInclusive, int endIndexInclusive, FixedFrameConvexPolygon2DBasics polygonToPack) {
        this.checkReferenceFrameMatch(polygonToPack);
        super.getVerticesInClockwiseOrder(startIndexInclusive, endIndexInclusive, (ConvexPolygon2DBasics)polygonToPack);
    }

    default public boolean isPointInside(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.isPointInside((Point2DReadOnly)point);
    }

    default public boolean isPointInside(FramePoint2DReadOnly point, double epsilon) {
        this.checkReferenceFrameMatch(point);
        return super.isPointInside((Point2DReadOnly)point, epsilon);
    }

    default public boolean getClosestPointWithRay(Line2DReadOnly ray, FixedFramePoint2DBasics closestPointToPack) {
        this.checkReferenceFrameMatch(closestPointToPack);
        return super.getClosestPointWithRay(ray, (Point2DBasics)closestPointToPack);
    }

    default public boolean getClosestPointWithRay(Line2DReadOnly ray, FramePoint2DBasics closestPointToPack) {
        closestPointToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestPointWithRay(ray, (Point2DBasics)closestPointToPack);
    }

    default public boolean getClosestPointWithRay(FrameLine2DReadOnly ray, Point2DBasics closestPointToPack) {
        this.checkReferenceFrameMatch(ray);
        return super.getClosestPointWithRay((Line2DReadOnly)ray, closestPointToPack);
    }

    default public boolean getClosestPointWithRay(FrameLine2DReadOnly ray, FixedFramePoint2DBasics closestPointToPack) {
        this.checkReferenceFrameMatch(ray, closestPointToPack);
        return super.getClosestPointWithRay((Line2DReadOnly)ray, (Point2DBasics)closestPointToPack);
    }

    default public boolean getClosestPointWithRay(FrameLine2DReadOnly ray, FramePoint2DBasics closestPointToPack) {
        this.checkReferenceFrameMatch(ray);
        closestPointToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestPointWithRay((Line2DReadOnly)ray, (Point2DBasics)closestPointToPack);
    }

    default public FramePoint2DBasics getClosestPointWithRay(Line2DReadOnly ray) {
        Point2DBasics closestPointWithRay = super.getClosestPointWithRay(ray);
        if (closestPointWithRay == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)closestPointWithRay);
    }

    default public FramePoint2DBasics getClosestPointWithRay(FrameLine2DReadOnly ray) {
        this.checkReferenceFrameMatch(ray);
        return this.getClosestPointWithRay((Line2DReadOnly)ray);
    }

    default public double distance(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.distance((Point2DReadOnly)point);
    }

    default public double signedDistance(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.signedDistance((Point2DReadOnly)point);
    }

    default public boolean orthogonalProjection(FixedFramePoint2DBasics pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point2DBasics)pointToProject);
    }

    default public boolean orthogonalProjection(FramePoint2DBasics pointToProject) {
        pointToProject.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point2DBasics)pointToProject);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, FixedFramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(projectionToPack);
        return super.orthogonalProjection(pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(Point2DReadOnly pointToProject, FramePoint2DBasics projectionToPack) {
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection(pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, Point2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, FixedFramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject, projectionToPack);
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, (Point2DBasics)projectionToPack);
    }

    default public boolean orthogonalProjection(FramePoint2DReadOnly pointToProject, FramePoint2DBasics projectionToPack) {
        this.checkReferenceFrameMatch(pointToProject);
        projectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.orthogonalProjection((Point2DReadOnly)pointToProject, (Point2DBasics)projectionToPack);
    }

    default public FramePoint2DBasics orthogonalProjectionCopy(Point2DReadOnly pointToProject) {
        Point2DBasics orthogonalProjection = super.orthogonalProjectionCopy(pointToProject);
        if (orthogonalProjection == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)orthogonalProjection);
    }

    default public FramePoint2DBasics orthogonalProjectionCopy(FramePoint2DReadOnly pointToProject) {
        this.checkReferenceFrameMatch(pointToProject);
        return this.orthogonalProjectionCopy((Point2DReadOnly)pointToProject);
    }

    default public int lineOfSightStartIndex(FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return super.lineOfSightStartIndex((Point2DReadOnly)observer);
    }

    default public int lineOfSightEndIndex(FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return super.lineOfSightEndIndex((Point2DReadOnly)observer);
    }

    default public int[] lineOfSightIndices(FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return super.lineOfSightIndices((Point2DReadOnly)observer);
    }

    default public boolean lineOfSightStartVertex(Point2DReadOnly observer, FixedFramePoint2DBasics startVertexToPack) {
        this.checkReferenceFrameMatch(startVertexToPack);
        return super.lineOfSightStartVertex(observer, (Point2DBasics)startVertexToPack);
    }

    default public boolean lineOfSightStartVertex(Point2DReadOnly observer, FramePoint2DBasics startVertexToPack) {
        startVertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.lineOfSightStartVertex(observer, (Point2DBasics)startVertexToPack);
    }

    default public boolean lineOfSightStartVertex(FramePoint2DReadOnly observer, Point2DBasics startVertexToPack) {
        this.checkReferenceFrameMatch(observer);
        return super.lineOfSightStartVertex((Point2DReadOnly)observer, startVertexToPack);
    }

    default public boolean lineOfSightStartVertex(FramePoint2DReadOnly observer, FixedFramePoint2DBasics startVertexToPack) {
        this.checkReferenceFrameMatch(observer, startVertexToPack);
        return super.lineOfSightStartVertex((Point2DReadOnly)observer, (Point2DBasics)startVertexToPack);
    }

    default public boolean lineOfSightStartVertex(FramePoint2DReadOnly observer, FramePoint2DBasics startVertexToPack) {
        this.checkReferenceFrameMatch(observer);
        startVertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.lineOfSightStartVertex((Point2DReadOnly)observer, (Point2DBasics)startVertexToPack);
    }

    default public boolean lineOfSightEndVertex(Point2DReadOnly observer, FixedFramePoint2DBasics endVertexToPack) {
        this.checkReferenceFrameMatch(endVertexToPack);
        return super.lineOfSightEndVertex(observer, (Point2DBasics)endVertexToPack);
    }

    default public boolean lineOfSightEndVertex(Point2DReadOnly observer, FramePoint2DBasics endVertexToPack) {
        endVertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.lineOfSightEndVertex(observer, (Point2DBasics)endVertexToPack);
    }

    default public boolean lineOfSightEndVertex(FramePoint2DReadOnly observer, Point2DBasics endVertexToPack) {
        this.checkReferenceFrameMatch(observer);
        return super.lineOfSightEndVertex((Point2DReadOnly)observer, endVertexToPack);
    }

    default public boolean lineOfSightEndVertex(FramePoint2DReadOnly observer, FixedFramePoint2DBasics endVertexToPack) {
        this.checkReferenceFrameMatch(observer, endVertexToPack);
        return super.lineOfSightEndVertex((Point2DReadOnly)observer, (Point2DBasics)endVertexToPack);
    }

    default public boolean lineOfSightEndVertex(FramePoint2DReadOnly observer, FramePoint2DBasics endVertexToPack) {
        this.checkReferenceFrameMatch(observer);
        endVertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.lineOfSightEndVertex((Point2DReadOnly)observer, (Point2DBasics)endVertexToPack);
    }

    default public FramePoint2DBasics lineOfSightStartVertexCopy(Point2DReadOnly observer) {
        Point2DBasics lineOfSightStartVertex = super.lineOfSightStartVertexCopy(observer);
        if (lineOfSightStartVertex == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)lineOfSightStartVertex);
    }

    default public FramePoint2DBasics lineOfSightStartVertexCopy(FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return this.lineOfSightStartVertexCopy((Point2DReadOnly)observer);
    }

    default public FramePoint2DBasics lineOfSightEndVertexCopy(Point2DReadOnly observer) {
        Point2DBasics lineOfSightEndVertex = super.lineOfSightEndVertexCopy(observer);
        if (lineOfSightEndVertex == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)lineOfSightEndVertex);
    }

    default public FramePoint2DBasics lineOfSightEndVertexCopy(FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return this.lineOfSightEndVertexCopy((Point2DReadOnly)observer);
    }

    default public FramePoint2DBasics[] lineOfSightVertices(Point2DReadOnly observer) {
        Point2DBasics[] lineOfSightVertices = super.lineOfSightVertices(observer);
        if (lineOfSightVertices == null) {
            return null;
        }
        return new FramePoint2DBasics[]{new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)lineOfSightVertices[0]), new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)lineOfSightVertices[1])};
    }

    default public FramePoint2DBasics[] lineOfSightVertices(FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return this.lineOfSightVertices((Point2DReadOnly)observer);
    }

    default public boolean canObserverSeeEdge(int edgeIndex, FramePoint2DReadOnly observer) {
        this.checkReferenceFrameMatch(observer);
        return super.canObserverSeeEdge(edgeIndex, (Point2DReadOnly)observer);
    }

    default public boolean pointIsOnPerimeter(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.pointIsOnPerimeter((Point2DReadOnly)point);
    }

    default public int intersectionWith(Line2DReadOnly line, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(secondIntersectionToPack);
        return super.intersectionWith(line, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(Line2DReadOnly line, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack);
        return super.intersectionWith(line, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(Line2DReadOnly line, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith(line, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(Line2DReadOnly line, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(line, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine2DReadOnly line, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line);
        return super.intersectionWith((Line2DReadOnly)line, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine2DReadOnly line, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line, secondIntersectionToPack);
        return super.intersectionWith((Line2DReadOnly)line, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine2DReadOnly line, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line, firstIntersectionToPack);
        return super.intersectionWith((Line2DReadOnly)line, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine2DReadOnly line, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line, firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith((Line2DReadOnly)line, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLine2DReadOnly line, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(line);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((Line2DReadOnly)line, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public FramePoint2DBasics[] intersectionWith(Line2DReadOnly line) {
        Point2DBasics[] intersections = super.intersectionWith(line);
        if (intersections == null) {
            return null;
        }
        FramePoint2DBasics[] result = new FramePoint2DBasics[intersections.length];
        for (int i = 0; i < intersections.length; ++i) {
            result[i] = new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersections[i]);
        }
        return result;
    }

    default public FramePoint2DBasics[] intersectionWith(FrameLine2DReadOnly line) {
        this.checkReferenceFrameMatch(line);
        return this.intersectionWith((Line2DReadOnly)line);
    }

    default public int intersectionWithRay(Line2DReadOnly ray, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(secondIntersectionToPack);
        return super.intersectionWithRay(ray, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay(Line2DReadOnly ray, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack);
        return super.intersectionWithRay(ray, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay(Line2DReadOnly ray, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWithRay(ray, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay(Line2DReadOnly ray, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWithRay(ray, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay(FrameLine2DReadOnly ray, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(ray);
        return super.intersectionWithRay((Line2DReadOnly)ray, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay(FrameLine2DReadOnly ray, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(ray, secondIntersectionToPack);
        return super.intersectionWithRay((Line2DReadOnly)ray, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay(FrameLine2DReadOnly ray, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(ray, firstIntersectionToPack);
        return super.intersectionWithRay((Line2DReadOnly)ray, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWithRay(FrameLine2DReadOnly ray, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(ray, firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWithRay((Line2DReadOnly)ray, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWithRay(FrameLine2DReadOnly ray, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(ray);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWithRay((Line2DReadOnly)ray, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public FramePoint2DBasics[] intersectionWithRay(Line2DReadOnly ray) {
        Point2DBasics[] intersections = super.intersectionWithRay(ray);
        if (intersections == null) {
            return null;
        }
        FramePoint2DBasics[] result = new FramePoint2DBasics[intersections.length];
        for (int i = 0; i < intersections.length; ++i) {
            result[i] = new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersections[i]);
        }
        return result;
    }

    default public FramePoint2DBasics[] intersectionWithRay(FrameLine2DReadOnly ray) {
        this.checkReferenceFrameMatch(ray);
        return this.intersectionWithRay((Line2DReadOnly)ray);
    }

    default public int intersectionWith(LineSegment2DReadOnly lineSegment2D, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(secondIntersectionToPack);
        return super.intersectionWith(lineSegment2D, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(LineSegment2DReadOnly lineSegment2D, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack);
        return super.intersectionWith(lineSegment2D, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(LineSegment2DReadOnly lineSegment2D, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith(lineSegment2D, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(LineSegment2DReadOnly lineSegment2D, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith(lineSegment2D, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLineSegment2DReadOnly lineSegment2D, Point2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment2D);
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment2D, firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLineSegment2DReadOnly lineSegment2D, Point2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment2D, secondIntersectionToPack);
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment2D, firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLineSegment2DReadOnly lineSegment2D, FixedFramePoint2DBasics firstIntersectionToPack, Point2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment2D, firstIntersectionToPack);
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment2D, (Point2DBasics)firstIntersectionToPack, secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLineSegment2DReadOnly lineSegment2D, FixedFramePoint2DBasics firstIntersectionToPack, FixedFramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment2D, firstIntersectionToPack, secondIntersectionToPack);
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment2D, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public int intersectionWith(FrameLineSegment2DReadOnly lineSegment2D, FramePoint2DBasics firstIntersectionToPack, FramePoint2DBasics secondIntersectionToPack) {
        this.checkReferenceFrameMatch(lineSegment2D);
        firstIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        secondIntersectionToPack.setReferenceFrame(this.getReferenceFrame());
        return super.intersectionWith((LineSegment2DReadOnly)lineSegment2D, (Point2DBasics)firstIntersectionToPack, (Point2DBasics)secondIntersectionToPack);
    }

    default public FramePoint2DBasics[] intersectionWith(LineSegment2DReadOnly lineSegment2D) {
        Point2DBasics[] intersections = super.intersectionWith(lineSegment2D);
        if (intersections == null) {
            return null;
        }
        FramePoint2DBasics[] result = new FramePoint2DBasics[intersections.length];
        for (int i = 0; i < intersections.length; ++i) {
            result[i] = new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)intersections[i]);
        }
        return result;
    }

    default public FramePoint2DBasics[] intersectionWith(FrameLineSegment2DReadOnly lineSegment2D) {
        this.checkReferenceFrameMatch(lineSegment2D);
        return this.intersectionWith((LineSegment2DReadOnly)lineSegment2D);
    }

    default public int getClosestEdgeIndex(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.getClosestEdgeIndex((Point2DReadOnly)point);
    }

    default public boolean getClosestEdge(FramePoint2DReadOnly point, LineSegment2DBasics closestEdgeToPack) {
        this.checkReferenceFrameMatch(point);
        return super.getClosestEdge((Point2DReadOnly)point, closestEdgeToPack);
    }

    default public boolean getClosestEdge(FramePoint2DReadOnly point, FixedFrameLineSegment2DBasics closestEdgeToPack) {
        this.checkReferenceFrameMatch(point, closestEdgeToPack);
        return super.getClosestEdge((Point2DReadOnly)point, (LineSegment2DBasics)closestEdgeToPack);
    }

    default public boolean getClosestEdge(FramePoint2DReadOnly point, FrameLineSegment2DBasics closestEdgeToPack) {
        this.checkReferenceFrameMatch(point);
        closestEdgeToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestEdge((Point2DReadOnly)point, (LineSegment2DBasics)closestEdgeToPack);
    }

    default public boolean getClosestEdge(Point2DReadOnly point, FixedFrameLineSegment2DBasics closestEdgeToPack) {
        this.checkReferenceFrameMatch(closestEdgeToPack);
        return super.getClosestEdge(point, (LineSegment2DBasics)closestEdgeToPack);
    }

    default public boolean getClosestEdge(Point2DReadOnly point, FrameLineSegment2DBasics closestEdgeToPack) {
        closestEdgeToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestEdge(point, (LineSegment2DBasics)closestEdgeToPack);
    }

    default public FrameLineSegment2DBasics getClosestEdgeCopy(Point2DReadOnly point) {
        LineSegment2DBasics closestEdge = super.getClosestEdgeCopy(point);
        if (closestEdge == null) {
            return null;
        }
        return new FrameLineSegment2D(this.getReferenceFrame(), (LineSegment2DReadOnly)closestEdge);
    }

    default public FrameLineSegment2DBasics getClosestEdgeCopy(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return this.getClosestEdgeCopy((Point2DReadOnly)point);
    }

    default public int getClosestVertexIndex(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return super.getClosestVertexIndex((Point2DReadOnly)point);
    }

    default public boolean getClosestVertex(Point2DReadOnly point, FixedFramePoint2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(vertexToPack);
        return super.getClosestVertex(point, (Point2DBasics)vertexToPack);
    }

    default public boolean getClosestVertex(Point2DReadOnly point, FramePoint2DBasics vertexToPack) {
        vertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestVertex(point, (Point2DBasics)vertexToPack);
    }

    default public boolean getClosestVertex(FramePoint2DReadOnly point, Point2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(point);
        return super.getClosestVertex((Point2DReadOnly)point, vertexToPack);
    }

    default public boolean getClosestVertex(FramePoint2DReadOnly point, FixedFramePoint2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(point, vertexToPack);
        return super.getClosestVertex((Point2DReadOnly)point, (Point2DBasics)vertexToPack);
    }

    default public boolean getClosestVertex(FramePoint2DReadOnly point, FramePoint2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(point);
        vertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestVertex((Point2DReadOnly)point, (Point2DBasics)vertexToPack);
    }

    default public FramePoint2DBasics getClosestVertexCopy(Point2DReadOnly point) {
        Point2DBasics closestVertex = super.getClosestVertexCopy(point);
        if (closestVertex == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)closestVertex);
    }

    default public FramePoint2DBasics getClosestVertexCopy(FramePoint2DReadOnly point) {
        this.checkReferenceFrameMatch(point);
        return this.getClosestVertexCopy((Point2DReadOnly)point);
    }

    default public int getClosestVertexIndex(FrameLine2DReadOnly line) {
        this.checkReferenceFrameMatch(line);
        return super.getClosestVertexIndex((Line2DReadOnly)line);
    }

    default public boolean getClosestVertex(Line2DReadOnly line, FixedFramePoint2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(vertexToPack);
        return super.getClosestVertex(line, (Point2DBasics)vertexToPack);
    }

    default public boolean getClosestVertex(Line2DReadOnly line, FramePoint2DBasics vertexToPack) {
        vertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestVertex(line, (Point2DBasics)vertexToPack);
    }

    default public boolean getClosestVertex(FrameLine2DReadOnly line, Point2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(line);
        return super.getClosestVertex((Line2DReadOnly)line, vertexToPack);
    }

    default public boolean getClosestVertex(FrameLine2DReadOnly line, FixedFramePoint2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(line, vertexToPack);
        return super.getClosestVertex((Line2DReadOnly)line, (Point2DBasics)vertexToPack);
    }

    default public boolean getClosestVertex(FrameLine2DReadOnly line, FramePoint2DBasics vertexToPack) {
        this.checkReferenceFrameMatch(line);
        vertexToPack.setReferenceFrame(this.getReferenceFrame());
        return super.getClosestVertex((Line2DReadOnly)line, (Point2DBasics)vertexToPack);
    }

    default public FramePoint2DBasics getClosestVertexCopy(Line2DReadOnly line) {
        Point2DBasics closestVertex = super.getClosestVertexCopy(line);
        if (closestVertex == null) {
            return null;
        }
        return new FramePoint2D(this.getReferenceFrame(), (Tuple2DReadOnly)closestVertex);
    }

    default public FramePoint2DBasics getClosestVertexCopy(FrameLine2DReadOnly line) {
        this.checkReferenceFrameMatch(line);
        return this.getClosestVertexCopy((Line2DReadOnly)line);
    }

    default public void getEdge(int edgeIndex, FixedFrameLineSegment2DBasics edgeToPack) {
        this.checkReferenceFrameMatch(edgeToPack);
        super.getEdge(edgeIndex, (LineSegment2DBasics)edgeToPack);
    }

    default public void getEdge(int edgeIndex, FrameLineSegment2DBasics edgeToPack) {
        edgeToPack.setReferenceFrame(this.getReferenceFrame());
        super.getEdge(edgeIndex, (LineSegment2DBasics)edgeToPack);
    }

    default public FrameConvexPolygon2DBasics translateCopy(Tuple2DReadOnly translation) {
        FrameConvexPolygon2D copy = new FrameConvexPolygon2D(this);
        copy.translate(translation);
        return copy;
    }

    default public FrameConvexPolygon2DBasics translateCopy(FrameTuple2DReadOnly translation) {
        this.checkReferenceFrameMatch(translation);
        return this.translateCopy((Tuple2DReadOnly)translation);
    }

    @Override
    default public String toString(String format) {
        return EuclidFrameIOTools.getFrameConvexPolygon2DString(format, this);
    }
}

